/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.parser.OBaseParser;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerCSVAbstract;
import com.orientechnologies.orient.core.sql.OCommandParameters;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemAbstract;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemParameter;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemVariable;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSQLHelper {
    public static final String NAME = "sql";
    public static final String VALUE_NOT_PARSED = "_NOT_PARSED_";
    public static final String NOT_NULL = "_NOT_NULL_";
    public static final String DEFINED = "_DEFINED_";
    private static ClassLoader orientClassLoader = OSQLFilterItemAbstract.class.getClassLoader();

    public static Object parseDefaultValue(ODocument iRecord, String iWord) {
        Object v = OSQLHelper.parseValue(iWord, null);
        if (v != VALUE_NOT_PARSED) {
            return v;
        }
        OSQLFunctionRuntime func = OSQLHelper.getFunction(null, iWord);
        if (func != null) {
            return func.execute(iRecord, iRecord, null, null);
        }
        return iWord;
    }

    public static Object parseValue(String iValue, OCommandContext iContext) {
        return OSQLHelper.parseValue(iValue, iContext, false);
    }

    public static Object parseValue(String iValue, OCommandContext iContext, boolean resolveContextVariables) {
        if (iValue == null) {
            return null;
        }
        iValue = iValue.trim();
        Object fieldValue = VALUE_NOT_PARSED;
        if (iValue.length() == 0) {
            return iValue;
        }
        if (iValue.startsWith("'") && iValue.endsWith("'") || iValue.startsWith("\"") && iValue.endsWith("\"")) {
            fieldValue = OIOUtils.getStringContent(iValue);
        } else if (iValue.charAt(0) == '[' && iValue.charAt(iValue.length() - 1) == ']') {
            List<String> items = OStringSerializerHelper.smartSplit(iValue.substring(1, iValue.length() - 1), ',', new char[0]);
            ArrayList<Object> coll = new ArrayList<Object>();
            for (String item : items) {
                coll.add(OSQLHelper.parseValue(item, iContext, resolveContextVariables));
            }
            fieldValue = coll;
        } else if (iValue.charAt(0) == '{' && iValue.charAt(iValue.length() - 1) == '}') {
            List<String> items = OStringSerializerHelper.smartSplit(iValue.substring(1, iValue.length() - 1), ',', new char[0]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String item : items) {
                List<String> parts = OStringSerializerHelper.smartSplit(item, ':', new char[0]);
                if (parts == null || parts.size() != 2) {
                    throw new OCommandSQLParsingException("Map found but entries are not defined as <key>:<value>");
                }
                String key = OStringSerializerHelper.decode(OSQLHelper.parseValue(parts.get(0), iContext).toString());
                Object value = OSQLHelper.parseValue(parts.get(1), iContext);
                if (VALUE_NOT_PARSED == value) {
                    value = new OSQLPredicate(parts.get(1)).evaluate(iContext);
                }
                if (value instanceof String) {
                    value = OStringSerializerHelper.decode(value.toString());
                }
                map.put(key, value);
            }
            fieldValue = map.containsKey("@type") ? new ODocument().fromJSON(iValue) : map;
        } else if (iValue.charAt(0) == '(' && iValue.charAt(iValue.length() - 1) == ')') {
            fieldValue = new OCommandSQL(iValue.substring(1, iValue.length() - 1));
            ((OCommandSQL)fieldValue).getContext().setParent(iContext);
        } else if (ORecordId.isA(iValue)) {
            fieldValue = new ORecordId(iValue.trim());
        } else if (iValue.equalsIgnoreCase("null")) {
            fieldValue = null;
        } else if (iValue.equalsIgnoreCase("not null")) {
            fieldValue = NOT_NULL;
        } else if (iValue.equalsIgnoreCase("defined")) {
            fieldValue = DEFINED;
        } else if (iValue.equalsIgnoreCase("true")) {
            fieldValue = Boolean.TRUE;
        } else if (iValue.equalsIgnoreCase("false")) {
            fieldValue = Boolean.FALSE;
        } else if (iValue.startsWith("date(")) {
            OSQLFunctionRuntime func = OSQLHelper.getFunction(null, iValue);
            if (func != null) {
                fieldValue = func.execute(null, null, null, iContext);
            }
        } else if (resolveContextVariables && iValue.startsWith("$") && iContext != null) {
            fieldValue = iContext.getVariable(iValue);
        } else {
            Object v = OSQLHelper.parseStringNumber(iValue);
            if (v != null) {
                fieldValue = v;
            }
        }
        return fieldValue;
    }

    public static Object parseStringNumber(String iValue) {
        OType t = ORecordSerializerCSVAbstract.getType(iValue);
        if (t == OType.INTEGER) {
            return Integer.parseInt(iValue);
        }
        if (t == OType.LONG) {
            return Long.parseLong(iValue);
        }
        if (t == OType.FLOAT) {
            return Float.valueOf(Float.parseFloat(iValue));
        }
        if (t == OType.SHORT) {
            return Short.parseShort(iValue);
        }
        if (t == OType.BYTE) {
            return Byte.parseByte(iValue);
        }
        if (t == OType.DOUBLE) {
            return Double.parseDouble(iValue);
        }
        if (t == OType.DECIMAL) {
            return new BigDecimal(iValue);
        }
        if (t == OType.DATE || t == OType.DATETIME) {
            return new Date(Long.parseLong(iValue));
        }
        return null;
    }

    public static Object parseValue(OSQLPredicate iSQLFilter, OBaseParser iCommand, String iWord, OCommandContext iContext) {
        if (iWord.charAt(0) == '?' || iWord.charAt(0) == ':') {
            if (iSQLFilter != null) {
                return iSQLFilter.addParameter(iWord);
            }
            return new OSQLFilterItemParameter(iWord);
        }
        return OSQLHelper.parseValue(iCommand, iWord, iContext);
    }

    public static Object parseValue(OBaseParser iCommand, String iWord, OCommandContext iContext) {
        return OSQLHelper.parseValue(iCommand, iWord, iContext, false);
    }

    public static Object parseValue(OBaseParser iCommand, String iWord, OCommandContext iContext, boolean resolveContextVariables) {
        OSQLFunctionRuntime func;
        if (iWord.equals("*")) {
            return "*";
        }
        Object v = OSQLHelper.parseValue(iWord, iContext, resolveContextVariables);
        if (v != VALUE_NOT_PARSED) {
            return v;
        }
        if (!iWord.equalsIgnoreCase("any()") && !iWord.equalsIgnoreCase("all()") && (func = OSQLHelper.getFunction(iCommand, iWord)) != null) {
            return func;
        }
        if (iWord.startsWith("$")) {
            return new OSQLFilterItemVariable(iCommand, iWord);
        }
        return new OSQLFilterItemField(iCommand, iWord, null);
    }

    public static OSQLFunctionRuntime getFunction(OBaseParser iCommand, String iWord) {
        int separator = iWord.indexOf(46);
        int beginParenthesis = iWord.indexOf(40);
        if (beginParenthesis > -1 && (separator == -1 || separator > beginParenthesis)) {
            int endParenthesis = iWord.indexOf(41, beginParenthesis);
            char firstChar = iWord.charAt(0);
            if (endParenthesis > -1 && (firstChar == '_' || Character.isLetter(firstChar))) {
                return new OSQLFunctionRuntime(iCommand, iWord);
            }
        }
        return null;
    }

    public static Object getValue(Object iObject) {
        if (iObject == null) {
            return null;
        }
        if (iObject instanceof OSQLFilterItem) {
            return ((OSQLFilterItem)iObject).getValue(null, null, null);
        }
        return iObject;
    }

    public static Object getValue(Object iObject, ORecord iRecord, OCommandContext iContext) {
        String s;
        if (iObject == null) {
            return null;
        }
        if (iObject instanceof OSQLFilterItem) {
            return ((OSQLFilterItem)iObject).getValue(iRecord, null, iContext);
        }
        if (iObject instanceof String && iRecord != null & !(s = ((String)iObject).trim()).isEmpty() && !OIOUtils.isStringContent(iObject) && !Character.isDigit(s.charAt(0))) {
            return ODocumentHelper.getFieldValue(iRecord, s, iContext);
        }
        return iObject;
    }

    public static Object resolveFieldValue(ODocument iDocument, String iFieldName, Object iFieldValue, OCommandParameters iArguments, OCommandContext iContext) {
        if (iFieldValue instanceof OSQLFilterItemField) {
            OSQLFilterItemField f = (OSQLFilterItemField)iFieldValue;
            if (f.getRoot().equals("?")) {
                return iArguments.getNext();
            }
            if (f.getRoot().startsWith(":")) {
                return iArguments.getByName(f.getRoot().substring(1));
            }
        }
        if (iFieldValue instanceof ODocument && !((ODocument)iFieldValue).getIdentity().isValid()) {
            ODocumentInternal.addOwner((ODocument)iFieldValue, iDocument);
        }
        if (iFieldValue == null) {
            return null;
        }
        if (iFieldValue instanceof OSQLFilterItem) {
            return ((OSQLFilterItem)iFieldValue).getValue(iDocument, null, iContext);
        }
        return iFieldValue;
    }

    public static ODocument bindParameters(ODocument iDocument, Map<String, Object> iFields, OCommandParameters iArguments, OCommandContext iContext) {
        if (iFields == null) {
            return null;
        }
        ArrayList<OPair<String, Object>> fields = new ArrayList<OPair<String, Object>>(iFields.size());
        for (Map.Entry<String, Object> entry : iFields.entrySet()) {
            fields.add(new OPair<Comparable, Object>((Comparable)((Object)entry.getKey()), entry.getValue()));
        }
        return OSQLHelper.bindParameters(iDocument, fields, iArguments, iContext);
    }

    public static ODocument bindParameters(ODocument iDocument, List<OPair<String, Object>> iFields, OCommandParameters iArguments, OCommandContext iContext) {
        if (iFields == null) {
            return null;
        }
        for (OPair<String, Object> field : iFields) {
            String fieldName = (String)field.getKey();
            Object fieldValue = field.getValue();
            if (fieldValue != null && fieldValue instanceof OCommandSQL) {
                OCommandSQL cmd = (OCommandSQL)fieldValue;
                cmd.getContext().setParent(iContext);
                fieldValue = ODatabaseRecordThreadLocal.instance().get().command(cmd).execute(new Object[0]);
                OImmutableClass immutableClass = ODocumentInternal.getImmutableSchemaClass(iDocument);
                if (immutableClass != null) {
                    List lst;
                    OProperty prop = immutableClass.getProperty(fieldName);
                    if (prop != null) {
                        if (prop.getType() == OType.LINK && OMultiValue.isMultiValue(fieldValue)) {
                            int size = OMultiValue.getSize(fieldValue);
                            if (size == 1) {
                                fieldValue = OMultiValue.getFirstValue(fieldValue);
                            } else if (size == 0) {
                                fieldValue = null;
                            }
                        }
                    } else if (immutableClass.isEdgeType() && ("out".equals(fieldName) || "in".equals(fieldName)) && fieldValue instanceof List && (lst = (List)fieldValue).size() == 1) {
                        fieldValue = lst.get(0);
                    }
                }
                if (OMultiValue.isMultiValue(fieldValue)) {
                    ArrayList<Object> tempColl = new ArrayList<Object>(OMultiValue.getSize(fieldValue));
                    String singleFieldName = null;
                    for (Object o : OMultiValue.getMultiValueIterable(fieldValue, false)) {
                        if (o instanceof OIdentifiable && !((OIdentifiable)o).getIdentity().isPersistent()) {
                            Object rec = ((OIdentifiable)o).getRecord();
                            if (rec == null || !(rec instanceof ODocument)) continue;
                            ODocument doc = (ODocument)rec;
                            if (doc.fields() == 1) {
                                singleFieldName = doc.fieldNames()[0];
                                tempColl.add(doc.field(singleFieldName));
                                continue;
                            }
                            doc.getIdentity().reset();
                            ODocumentInternal.addOwner(doc, iDocument);
                            ODocumentInternal.addOwner(doc, iDocument);
                            tempColl.add(doc);
                            continue;
                        }
                        tempColl.add(o);
                    }
                    fieldValue = tempColl;
                }
            }
            iDocument.field(fieldName, OSQLHelper.resolveFieldValue(iDocument, fieldName, fieldValue, iArguments, iContext));
        }
        return iDocument;
    }
}

