/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OUpdatableResult;
import java.util.Map;
import java.util.Optional;

public class ConvertToResultInternalStep
extends AbstractExecutionStep {
    private long cost = 0L;
    OResultSet prevResult = null;

    public ConvertToResultInternalStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        if (!this.prev.isPresent()) {
            throw new IllegalStateException("filter step requires a previous step");
        }
        final OExecutionStepInternal prevStep = (OExecutionStepInternal)this.prev.get();
        return new OResultSet(){
            public boolean finished = false;
            OResult nextItem = null;
            int fetched = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fetchNextItem() {
                this.nextItem = null;
                if (this.finished) {
                    return;
                }
                if (ConvertToResultInternalStep.this.prevResult == null) {
                    ConvertToResultInternalStep.this.prevResult = prevStep.syncPull(ctx, nRecords);
                    if (!ConvertToResultInternalStep.this.prevResult.hasNext()) {
                        this.finished = true;
                        return;
                    }
                }
                while (!this.finished) {
                    while (!ConvertToResultInternalStep.this.prevResult.hasNext()) {
                        ConvertToResultInternalStep.this.prevResult = prevStep.syncPull(ctx, nRecords);
                        if (ConvertToResultInternalStep.this.prevResult.hasNext()) continue;
                        this.finished = true;
                        return;
                    }
                    this.nextItem = ConvertToResultInternalStep.this.prevResult.next();
                    long begin = ConvertToResultInternalStep.this.profilingEnabled ? System.nanoTime() : 0L;
                    try {
                        if (this.nextItem instanceof OUpdatableResult) {
                            Object element = this.nextItem.getElement().get().getRecord();
                            if (element == null || !(element instanceof ODocument)) break;
                            this.nextItem = new OResultInternal();
                            ((OResultInternal)this.nextItem).setElement((OIdentifiable)element);
                            break;
                        }
                    }
                    finally {
                        if (ConvertToResultInternalStep.this.profilingEnabled) {
                            ConvertToResultInternalStep.this.cost = ConvertToResultInternalStep.this.cost + (System.nanoTime() - begin);
                        }
                    }
                    this.nextItem = null;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.fetched >= nRecords || this.finished) {
                    return false;
                }
                if (this.nextItem == null) {
                    this.fetchNextItem();
                }
                return this.nextItem != null;
            }

            @Override
            public OResult next() {
                if (this.fetched >= nRecords || this.finished) {
                    throw new IllegalStateException();
                }
                if (this.nextItem == null) {
                    this.fetchNextItem();
                }
                if (this.nextItem == null) {
                    throw new IllegalStateException();
                }
                OResult result = this.nextItem;
                this.nextItem = null;
                ++this.fetched;
                return result;
            }

            @Override
            public void close() {
                ConvertToResultInternalStep.this.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String result = OExecutionStepInternal.getIndent(depth, indent) + "+ CONVERT TO REGULAR RESULT ITEM";
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

