/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.sql.executor.FetchFromIndexStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;

public class FetchFromIndexValuesStep
extends FetchFromIndexStep {
    private boolean asc;

    public FetchFromIndexValuesStep(OIndex<?> index, boolean asc, OCommandContext ctx, boolean profilingEnabled) {
        super(index, null, null, ctx, profilingEnabled);
        this.asc = asc;
    }

    @Override
    protected boolean isOrderAsc() {
        return this.asc;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        if (this.isOrderAsc()) {
            return OExecutionStepInternal.getIndent(depth, indent) + "+ FETCH FROM INDEX VAUES ASC " + this.index.getName();
        }
        return OExecutionStepInternal.getIndent(depth, indent) + "+ FETCH FROM INDEX VAUES DESC " + this.index.getName();
    }

    @Override
    public OResult serialize() {
        OResultInternal result = (OResultInternal)super.serialize();
        result.setProperty("asc", this.asc);
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        try {
            super.deserialize(fromResult);
            this.asc = (Boolean)fromResult.getProperty("asc");
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
    }

    @Override
    public boolean canBeCached() {
        return false;
    }
}

