/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.CartesianProductStep;
import com.orientechnologies.orient.core.sql.executor.DistinctExecutionStep;
import com.orientechnologies.orient.core.sql.executor.EdgeTraversal;
import com.orientechnologies.orient.core.sql.executor.EmptyStep;
import com.orientechnologies.orient.core.sql.executor.FilterNotMatchPatternStep;
import com.orientechnologies.orient.core.sql.executor.LimitExecutionStep;
import com.orientechnologies.orient.core.sql.executor.MatchFirstStep;
import com.orientechnologies.orient.core.sql.executor.MatchPrefetchStep;
import com.orientechnologies.orient.core.sql.executor.MatchStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OSelectExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OSelectExecutionPlanner;
import com.orientechnologies.orient.core.sql.executor.OptionalMatchStep;
import com.orientechnologies.orient.core.sql.executor.OrderByStep;
import com.orientechnologies.orient.core.sql.executor.PatternEdge;
import com.orientechnologies.orient.core.sql.executor.PatternNode;
import com.orientechnologies.orient.core.sql.executor.ProjectionCalculationStep;
import com.orientechnologies.orient.core.sql.executor.QueryPlanningInfo;
import com.orientechnologies.orient.core.sql.executor.RemoveEmptyOptionalsStep;
import com.orientechnologies.orient.core.sql.executor.ReturnMatchElementsStep;
import com.orientechnologies.orient.core.sql.executor.ReturnMatchPathElementsStep;
import com.orientechnologies.orient.core.sql.executor.ReturnMatchPathsStep;
import com.orientechnologies.orient.core.sql.executor.ReturnMatchPatternsStep;
import com.orientechnologies.orient.core.sql.executor.SkipExecutionStep;
import com.orientechnologies.orient.core.sql.executor.UnwindStep;
import com.orientechnologies.orient.core.sql.parser.OAndBlock;
import com.orientechnologies.orient.core.sql.parser.OCluster;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OFromItem;
import com.orientechnologies.orient.core.sql.parser.OGroupBy;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OMatchExpression;
import com.orientechnologies.orient.core.sql.parser.OMatchFilter;
import com.orientechnologies.orient.core.sql.parser.OMatchPathItem;
import com.orientechnologies.orient.core.sql.parser.OMatchStatement;
import com.orientechnologies.orient.core.sql.parser.OMultiMatchPathItem;
import com.orientechnologies.orient.core.sql.parser.ONestedProjection;
import com.orientechnologies.orient.core.sql.parser.OOrderBy;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import com.orientechnologies.orient.core.sql.parser.OProjectionItem;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OSkip;
import com.orientechnologies.orient.core.sql.parser.OUnwind;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.Pattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OMatchExecutionPlanner {
    static final String DEFAULT_ALIAS_PREFIX = "$ORIENT_DEFAULT_ALIAS_";
    protected List<OMatchExpression> matchExpressions;
    protected List<OMatchExpression> notMatchExpressions;
    protected List<OExpression> returnItems;
    protected List<OIdentifier> returnAliases;
    protected List<ONestedProjection> returnNestedProjections;
    boolean returnElements = false;
    boolean returnPaths = false;
    boolean returnPatterns = false;
    boolean returnPathElements = false;
    boolean returnDistinct = false;
    protected OSkip skip;
    private final OGroupBy groupBy;
    private final OOrderBy orderBy;
    private final OUnwind unwind;
    protected OLimit limit;
    private Pattern pattern;
    private List<Pattern> subPatterns;
    private Map<String, OWhereClause> aliasFilters;
    private Map<String, String> aliasClasses;
    private Map<String, String> aliasClusters;
    private Map<String, ORid> aliasRids;
    boolean foundOptional = false;
    private long threshold = 100L;

    public OMatchExecutionPlanner(OMatchStatement stm) {
        this.matchExpressions = stm.getMatchExpressions().stream().map(x -> x.copy()).collect(Collectors.toList());
        this.notMatchExpressions = stm.getNotMatchExpressions().stream().map(x -> x.copy()).collect(Collectors.toList());
        this.returnItems = stm.getReturnItems().stream().map(x -> x.copy()).collect(Collectors.toList());
        this.returnAliases = stm.getReturnAliases().stream().map(x -> x == null ? null : x.copy()).collect(Collectors.toList());
        this.returnNestedProjections = stm.getReturnNestedProjections().stream().map(x -> x == null ? null : x.copy()).collect(Collectors.toList());
        this.limit = stm.getLimit() == null ? null : stm.getLimit().copy();
        this.skip = stm.getSkip() == null ? null : stm.getSkip().copy();
        this.returnElements = stm.returnsElements();
        this.returnPaths = stm.returnsPaths();
        this.returnPatterns = stm.returnsPatterns();
        this.returnPathElements = stm.returnsPathElements();
        this.returnDistinct = stm.isReturnDistinct();
        this.groupBy = stm.getGroupBy() == null ? null : stm.getGroupBy().copy();
        this.orderBy = stm.getOrderBy() == null ? null : stm.getOrderBy().copy();
        this.unwind = stm.getUnwind() == null ? null : stm.getUnwind().copy();
    }

    public OInternalExecutionPlan createExecutionPlan(OCommandContext context, boolean enableProfiling) {
        this.buildPatterns(context);
        this.splitDisjointPatterns(context);
        OSelectExecutionPlan result = new OSelectExecutionPlan(context);
        Map<String, Long> estimatedRootEntries = this.estimateRootEntries(this.aliasClasses, this.aliasClusters, this.aliasRids, this.aliasFilters, context);
        Set<String> aliasesToPrefetch = estimatedRootEntries.entrySet().stream().filter(x -> (Long)x.getValue() < this.threshold).filter(x -> !this.dependsOnExecutionContext((String)x.getKey())).map(x -> (String)x.getKey()).collect(Collectors.toSet());
        for (Map.Entry<String, Long> entry : estimatedRootEntries.entrySet()) {
            if (entry.getValue() != 0L || this.isOptional(entry.getKey())) continue;
            result.chain(new EmptyStep(context, enableProfiling));
            return result;
        }
        this.addPrefetchSteps(result, aliasesToPrefetch, context, enableProfiling);
        if (this.subPatterns.size() > 1) {
            CartesianProductStep step = new CartesianProductStep(context, enableProfiling);
            for (Pattern subPattern : this.subPatterns) {
                step.addSubPlan(this.createPlanForPattern(subPattern, context, estimatedRootEntries, aliasesToPrefetch, enableProfiling));
            }
            result.chain(step);
        } else {
            OInternalExecutionPlan plan = this.createPlanForPattern(this.pattern, context, estimatedRootEntries, aliasesToPrefetch, enableProfiling);
            for (OExecutionStep step : plan.getSteps()) {
                result.chain((OExecutionStepInternal)step);
            }
        }
        this.manageNotPatterns(result, this.pattern, this.notMatchExpressions, context, enableProfiling);
        if (this.foundOptional) {
            result.chain(new RemoveEmptyOptionalsStep(context, enableProfiling));
        }
        if (this.returnElements || this.returnPaths || this.returnPatterns || this.returnPathElements) {
            this.addReturnStep(result, context, enableProfiling);
            if (this.returnDistinct) {
                result.chain(new DistinctExecutionStep(context, enableProfiling));
            }
            if (this.groupBy != null) {
                throw new OCommandExecutionException("Cannot execute GROUP BY in MATCH query with RETURN $elements, $pathElements, $patterns or $paths");
            }
            if (this.orderBy != null) {
                result.chain(new OrderByStep(this.orderBy, context, enableProfiling));
            }
            if (this.unwind != null) {
                result.chain(new UnwindStep(this.unwind, context, enableProfiling));
            }
            if (this.skip != null && this.skip.getValue(context) >= 0) {
                result.chain(new SkipExecutionStep(this.skip, context, enableProfiling));
            }
            if (this.limit != null && this.limit.getValue(context) >= 0) {
                result.chain(new LimitExecutionStep(this.limit, context, enableProfiling));
            }
        } else {
            QueryPlanningInfo info = new QueryPlanningInfo();
            ArrayList<OProjectionItem> arrayList = new ArrayList<OProjectionItem>();
            for (int i = 0; i < this.returnItems.size(); ++i) {
                OProjectionItem item = new OProjectionItem(this.returnItems.get(i), this.returnAliases.get(i), this.returnNestedProjections.get(i));
                arrayList.add(item);
            }
            info.projection = new OProjection(arrayList, this.returnDistinct);
            info.projection = OSelectExecutionPlanner.translateDistinct(info.projection);
            boolean bl = info.distinct = info.projection == null ? false : info.projection.isDistinct();
            if (info.projection != null) {
                info.projection.setDistinct(false);
            }
            info.groupBy = this.groupBy;
            info.orderBy = this.orderBy;
            info.unwind = this.unwind;
            info.skip = this.skip;
            info.limit = this.limit;
            OSelectExecutionPlanner.optimizeQuery(info, context);
            OSelectExecutionPlanner.handleProjectionsBlock(result, info, context, enableProfiling);
        }
        return result;
    }

    private boolean dependsOnExecutionContext(String key) {
        OWhereClause filter = this.aliasFilters.get(key);
        if (filter == null) {
            return false;
        }
        if (filter.refersToParent()) {
            return true;
        }
        return filter.toString().toLowerCase().contains("$matched.");
    }

    private boolean isOptional(String key) {
        PatternNode node = this.pattern.aliasToNode.get(key);
        return node != null && node.isOptionalNode();
    }

    private void manageNotPatterns(OSelectExecutionPlan result, Pattern pattern, List<OMatchExpression> notMatchExpressions, OCommandContext context, boolean enableProfiling) {
        for (OMatchExpression exp : notMatchExpressions) {
            if (pattern.aliasToNode.get(exp.getOrigin().getAlias()) == null) {
                throw new OCommandExecutionException("This kind of NOT expression is not supported (yet). The first alias in a NOT expression has to be present in the positive pattern");
            }
            if (exp.getOrigin().getFilter() != null) {
                throw new OCommandExecutionException("This kind of NOT expression is not supported (yet): WHERE condition on the initial alias");
            }
            OMatchFilter lastFilter = exp.getOrigin();
            ArrayList<AbstractExecutionStep> steps = new ArrayList<AbstractExecutionStep>();
            for (OMatchPathItem item : exp.getItems()) {
                if (item instanceof OMultiMatchPathItem) {
                    throw new OCommandExecutionException("This kind of NOT expression is not supported (yet): " + item.toString());
                }
                PatternEdge edge = new PatternEdge();
                edge.item = item;
                edge.out = new PatternNode();
                edge.out.alias = lastFilter.getAlias();
                edge.in = new PatternNode();
                edge.in.alias = item.getFilter().getAlias();
                EdgeTraversal traversal = new EdgeTraversal(edge, true);
                MatchStep step = new MatchStep(context, traversal, enableProfiling);
                steps.add(step);
                lastFilter = item.getFilter();
            }
            result.chain(new FilterNotMatchPatternStep(steps, context, enableProfiling));
        }
    }

    private void addReturnStep(OSelectExecutionPlan result, OCommandContext context, boolean profilingEnabled) {
        if (this.returnElements) {
            result.chain(new ReturnMatchElementsStep(context, profilingEnabled));
        } else if (this.returnPaths) {
            result.chain(new ReturnMatchPathsStep(context, profilingEnabled));
        } else if (this.returnPatterns) {
            result.chain(new ReturnMatchPatternsStep(context, profilingEnabled));
        } else if (this.returnPathElements) {
            result.chain(new ReturnMatchPathElementsStep(context, profilingEnabled));
        } else {
            OProjection projection = new OProjection(-1);
            projection.setItems(new ArrayList<OProjectionItem>());
            for (int i = 0; i < this.returnAliases.size(); ++i) {
                OProjectionItem item = new OProjectionItem(-1);
                item.setExpression(this.returnItems.get(i));
                item.setAlias(this.returnAliases.get(i));
                item.setNestedProjection(this.returnNestedProjections.get(i));
                projection.getItems().add(item);
            }
            result.chain(new ProjectionCalculationStep(projection, context, profilingEnabled));
        }
    }

    private OInternalExecutionPlan createPlanForPattern(Pattern pattern, OCommandContext context, Map<String, Long> estimatedRootEntries, Set<String> prefetchedAliases, boolean profilingEnabled) {
        OSelectExecutionPlan plan = new OSelectExecutionPlan(context);
        List<EdgeTraversal> sortedEdges = this.getTopologicalSortedSchedule(estimatedRootEntries, pattern);
        boolean first = true;
        if (sortedEdges.size() > 0) {
            for (EdgeTraversal edge : sortedEdges) {
                if (edge.edge.out.alias != null) {
                    edge.setLeftClass(this.aliasClasses.get(edge.edge.out.alias));
                    edge.setLeftCluster(this.aliasClusters.get(edge.edge.out.alias));
                    edge.setLeftRid(this.aliasRids.get(edge.edge.out.alias));
                    edge.setLeftClass(this.aliasClasses.get(edge.edge.out.alias));
                    edge.setLeftFilter(this.aliasFilters.get(edge.edge.out.alias));
                }
                this.addStepsFor(plan, edge, context, first, profilingEnabled);
                first = false;
            }
        } else {
            PatternNode node = pattern.getAliasToNode().values().iterator().next();
            if (prefetchedAliases.contains(node.alias)) {
                plan.chain(new MatchFirstStep(context, node, profilingEnabled));
            } else {
                String clazz = this.aliasClasses.get(node.alias);
                String cluster = this.aliasClusters.get(node.alias);
                ORid rid = this.aliasRids.get(node.alias);
                OWhereClause filter = this.aliasFilters.get(node.alias);
                OSelectStatement select = this.createSelectStatement(clazz, cluster, rid, filter);
                plan.chain(new MatchFirstStep(context, node, select.createExecutionPlan(context, profilingEnabled), profilingEnabled));
            }
        }
        return plan;
    }

    /*
     * WARNING - void declaration
     */
    private List<EdgeTraversal> getTopologicalSortedSchedule(Map<String, Long> estimatedRootEntries, Pattern pattern) {
        ArrayList<EdgeTraversal> resultingSchedule = new ArrayList<EdgeTraversal>();
        Map<String, Set<String>> remainingDependencies = this.getDependencies(pattern);
        HashSet<PatternNode> visitedNodes = new HashSet<PatternNode>();
        HashSet<PatternEdge> visitedEdges = new HashSet<PatternEdge>();
        ArrayList<OPair<Comparable, String>> rootWeights = new ArrayList<OPair<Comparable, String>>();
        for (Map.Entry<String, Long> entry : estimatedRootEntries.entrySet()) {
            rootWeights.add(new OPair<Comparable, String>(entry.getValue(), entry.getKey()));
        }
        Collections.sort(rootWeights);
        LinkedHashSet<Object> remainingStarts = new LinkedHashSet<Object>();
        for (OPair oPair : rootWeights) {
            remainingStarts.add(oPair.getValue());
        }
        for (String string : pattern.aliasToNode.keySet()) {
            if (remainingStarts.contains(string)) continue;
            remainingStarts.add(string);
        }
        while (resultingSchedule.size() < pattern.numOfEdges) {
            void var9_15;
            Object var9_13 = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : remainingStarts) {
                PatternNode currentNode = pattern.aliasToNode.get(string);
                if (visitedNodes.contains(currentNode)) {
                    arrayList.add(string);
                    continue;
                }
                if (remainingDependencies.get(string) != null && !remainingDependencies.get(string).isEmpty()) continue;
                arrayList.add(string);
                PatternNode patternNode = currentNode;
                break;
            }
            remainingStarts.removeAll(arrayList);
            if (var9_15 == null) {
                throw new OCommandExecutionException("This query contains MATCH conditions that cannot be evaluated, like an undefined alias or a circular dependency on a $matched condition.");
            }
            this.updateScheduleStartingAt((PatternNode)var9_15, visitedNodes, visitedEdges, remainingDependencies, resultingSchedule);
        }
        if (resultingSchedule.size() != pattern.numOfEdges) {
            throw new AssertionError((Object)("Incorrect number of edges: " + resultingSchedule.size() + " vs " + pattern.numOfEdges));
        }
        return resultingSchedule;
    }

    private void updateScheduleStartingAt(PatternNode startNode, Set<PatternNode> visitedNodes, Set<PatternEdge> visitedEdges, Map<String, Set<String>> remainingDependencies, List<EdgeTraversal> resultingSchedule) {
        visitedNodes.add(startNode);
        for (Set<String> dependencies : remainingDependencies.values()) {
            dependencies.remove(startNode.alias);
        }
        LinkedHashMap<PatternEdge, Boolean> edges = new LinkedHashMap<PatternEdge, Boolean>();
        for (PatternEdge patternEdge : startNode.out) {
            edges.put(patternEdge, true);
        }
        for (PatternEdge patternEdge : startNode.in) {
            if (!patternEdge.item.isBidirectional()) continue;
            edges.put(patternEdge, false);
        }
        for (Map.Entry entry : edges.entrySet()) {
            PatternNode neighboringNode;
            PatternEdge edge = (PatternEdge)entry.getKey();
            boolean isOutbound = (Boolean)entry.getValue();
            PatternNode patternNode = neighboringNode = isOutbound ? edge.in : edge.out;
            if (!remainingDependencies.get(neighboringNode.alias).isEmpty()) continue;
            if (visitedNodes.contains(neighboringNode)) {
                if (visitedEdges.contains(edge)) continue;
                boolean traversalDirection = startNode.optional || edge.item.isBidirectional() ? !isOutbound : isOutbound;
                visitedEdges.add(edge);
                resultingSchedule.add(new EdgeTraversal(edge, traversalDirection));
                continue;
            }
            if (startNode.optional) continue;
            if (visitedEdges.contains(edge)) {
                throw new AssertionError((Object)("The edge was visited, but the neighboring vertex was not: " + edge + " " + neighboringNode));
            }
            visitedEdges.add(edge);
            resultingSchedule.add(new EdgeTraversal(edge, isOutbound));
            this.updateScheduleStartingAt(neighboringNode, visitedNodes, visitedEdges, remainingDependencies, resultingSchedule);
        }
    }

    private Map<String, Set<String>> getDependencies(Pattern pattern) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (PatternNode node : pattern.aliasToNode.values()) {
            List<String> involvedAliases;
            HashSet<String> currentDependencies = new HashSet<String>();
            OWhereClause filter = this.aliasFilters.get(node.alias);
            if (filter != null && filter.getBaseExpression() != null && (involvedAliases = filter.getBaseExpression().getMatchPatternInvolvedAliases()) != null) {
                currentDependencies.addAll(involvedAliases);
            }
            result.put(node.alias, currentDependencies);
        }
        return result;
    }

    private void splitDisjointPatterns(OCommandContext context) {
        if (this.subPatterns != null) {
            return;
        }
        this.subPatterns = this.pattern.getDisjointPatterns();
    }

    private void addStepsFor(OSelectExecutionPlan plan, EdgeTraversal edge, OCommandContext context, boolean first, boolean profilingEnabled) {
        if (first) {
            PatternNode patternNode = edge.out ? edge.edge.out : edge.edge.in;
            String clazz = this.aliasClasses.get(patternNode.alias);
            String cluster = this.aliasClusters.get(patternNode.alias);
            ORid rid = this.aliasRids.get(patternNode.alias);
            OWhereClause where = this.aliasFilters.get(patternNode.alias);
            OSelectStatement select = new OSelectStatement(-1);
            select.setTarget(new OFromClause(-1));
            select.getTarget().setItem(new OFromItem(-1));
            if (clazz != null) {
                select.getTarget().getItem().setIdentifier(new OIdentifier(clazz));
            } else if (cluster != null) {
                select.getTarget().getItem().setCluster(new OCluster(cluster));
            } else if (rid != null) {
                select.getTarget().getItem().setRids(Collections.singletonList(rid));
            }
            select.setWhereClause(where == null ? null : where.copy());
            OBasicCommandContext subContxt = new OBasicCommandContext();
            subContxt.setParentWithoutOverridingChild(context);
            plan.chain(new MatchFirstStep(context, patternNode, select.createExecutionPlan(subContxt, profilingEnabled), profilingEnabled));
        }
        if (edge.edge.in.isOptionalNode()) {
            this.foundOptional = true;
            plan.chain(new OptionalMatchStep(context, edge, profilingEnabled));
        } else {
            plan.chain(new MatchStep(context, edge, profilingEnabled));
        }
    }

    private void addPrefetchSteps(OSelectExecutionPlan result, Set<String> aliasesToPrefetch, OCommandContext context, boolean profilingEnabled) {
        for (String alias : aliasesToPrefetch) {
            String targetClass = this.aliasClasses.get(alias);
            String targetCluster = this.aliasClusters.get(alias);
            ORid targetRid = this.aliasRids.get(alias);
            OWhereClause filter = this.aliasFilters.get(alias);
            OSelectStatement prefetchStm = this.createSelectStatement(targetClass, targetCluster, targetRid, filter);
            MatchPrefetchStep step = new MatchPrefetchStep(context, prefetchStm.createExecutionPlan(context, profilingEnabled), alias, profilingEnabled);
            result.chain(step);
        }
    }

    private OSelectStatement createSelectStatement(String targetClass, String targetCluster, ORid targetRid, OWhereClause filter) {
        OSelectStatement prefetchStm = new OSelectStatement(-1);
        prefetchStm.setWhereClause(filter);
        OFromClause from = new OFromClause(-1);
        OFromItem fromItem = new OFromItem(-1);
        if (targetRid != null) {
            fromItem.setRids(Collections.singletonList(targetRid));
        } else if (targetClass != null) {
            fromItem.setIdentifier(new OIdentifier(targetClass));
        } else if (targetCluster != null) {
            fromItem.setCluster(new OCluster(targetCluster));
        }
        from.setItem(fromItem);
        prefetchStm.setTarget(from);
        return prefetchStm;
    }

    private void buildPatterns(OCommandContext ctx) {
        if (this.pattern != null) {
            return;
        }
        ArrayList<OMatchExpression> allPatterns = new ArrayList<OMatchExpression>();
        allPatterns.addAll(this.matchExpressions);
        allPatterns.addAll(this.notMatchExpressions);
        this.assignDefaultAliases(allPatterns);
        this.pattern = new Pattern();
        for (OMatchExpression expr : this.matchExpressions) {
            this.pattern.addExpression(expr);
        }
        LinkedHashMap<String, OWhereClause> aliasFilters = new LinkedHashMap<String, OWhereClause>();
        LinkedHashMap<String, String> aliasClasses = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> aliasClusters = new LinkedHashMap<String, String>();
        LinkedHashMap<String, ORid> aliasRids = new LinkedHashMap<String, ORid>();
        for (OMatchExpression expr : this.matchExpressions) {
            this.addAliases(expr, aliasFilters, aliasClasses, aliasClusters, aliasRids, ctx);
        }
        this.aliasFilters = aliasFilters;
        this.aliasClasses = aliasClasses;
        this.aliasClusters = aliasClusters;
        this.aliasRids = aliasRids;
        this.rebindFilters(aliasFilters);
    }

    private void rebindFilters(Map<String, OWhereClause> aliasFilters) {
        for (OMatchExpression expression : this.matchExpressions) {
            OWhereClause newFilter = aliasFilters.get(expression.getOrigin().getAlias());
            expression.getOrigin().setFilter(newFilter);
            for (OMatchPathItem item : expression.getItems()) {
                newFilter = aliasFilters.get(item.getFilter().getAlias());
                item.getFilter().setFilter(newFilter);
            }
        }
    }

    private void addAliases(OMatchExpression expr, Map<String, OWhereClause> aliasFilters, Map<String, String> aliasClasses, Map<String, String> aliasClusters, Map<String, ORid> aliasRids, OCommandContext context) {
        this.addAliases(expr.getOrigin(), aliasFilters, aliasClasses, aliasClusters, aliasRids, context);
        for (OMatchPathItem item : expr.getItems()) {
            if (item.getFilter() == null) continue;
            this.addAliases(item.getFilter(), aliasFilters, aliasClasses, aliasClusters, aliasRids, context);
        }
    }

    private void addAliases(OMatchFilter matchFilter, Map<String, OWhereClause> aliasFilters, Map<String, String> aliasClasses, Map<String, String> aliasClusters, Map<String, ORid> aliasRids, OCommandContext context) {
        String alias = matchFilter.getAlias();
        OWhereClause filter = matchFilter.getFilter();
        if (alias != null) {
            ORid rid;
            String clusterName;
            String clazz;
            if (filter != null && filter.getBaseExpression() != null) {
                OWhereClause previousFilter = aliasFilters.get(alias);
                if (previousFilter == null) {
                    previousFilter = new OWhereClause(-1);
                    previousFilter.setBaseExpression(new OAndBlock(-1));
                    aliasFilters.put(alias, previousFilter);
                }
                OAndBlock filterBlock = (OAndBlock)previousFilter.getBaseExpression();
                if (filter != null && filter.getBaseExpression() != null) {
                    filterBlock.getSubBlocks().add(filter.getBaseExpression());
                }
            }
            if ((clazz = matchFilter.getClassName(context)) != null) {
                String previousClass = aliasClasses.get(alias);
                if (previousClass == null) {
                    aliasClasses.put(alias, clazz);
                } else {
                    String lower = this.getLowerSubclass(context.getDatabase(), clazz, previousClass);
                    if (lower == null) {
                        throw new OCommandExecutionException("classes defined for alias " + alias + " (" + clazz + ", " + previousClass + ") are not in the same hierarchy");
                    }
                    aliasClasses.put(alias, lower);
                }
            }
            if ((clusterName = matchFilter.getClusterName(context)) != null) {
                String previousCluster = aliasClusters.get(alias);
                if (previousCluster == null) {
                    aliasClusters.put(alias, clusterName);
                } else if (!previousCluster.equalsIgnoreCase(clusterName)) {
                    throw new OCommandExecutionException("Invalid expression for alias " + alias + " cannot be of both clusters " + previousCluster + " and " + clusterName);
                }
            }
            if ((rid = matchFilter.getRid(context)) != null) {
                ORid previousRid = aliasRids.get(alias);
                if (previousRid == null) {
                    aliasRids.put(alias, rid);
                } else if (!previousRid.equals(rid)) {
                    throw new OCommandExecutionException("Invalid expression for alias " + alias + " cannot be of both RIDs " + previousRid + " and " + rid);
                }
            }
        }
    }

    private String getLowerSubclass(ODatabase db, String className1, String className2) {
        OClass class2;
        OSchema schema = db.getMetadata().getSchema();
        OClass class1 = schema.getClass(className1);
        if (class1.isSubClassOf(class2 = schema.getClass(className2))) {
            return class1.getName();
        }
        if (class2.isSubClassOf(class1)) {
            return class2.getName();
        }
        return null;
    }

    private void assignDefaultAliases(List<OMatchExpression> matchExpressions) {
        int counter = 0;
        for (OMatchExpression expression : matchExpressions) {
            if (expression.getOrigin().getAlias() == null) {
                expression.getOrigin().setAlias(DEFAULT_ALIAS_PREFIX + counter++);
            }
            for (OMatchPathItem item : expression.getItems()) {
                if (item.getFilter() == null) {
                    item.setFilter(new OMatchFilter(-1));
                }
                if (item.getFilter().getAlias() != null) continue;
                item.getFilter().setAlias(DEFAULT_ALIAS_PREFIX + counter++);
            }
        }
    }

    private Map<String, Long> estimateRootEntries(Map<String, String> aliasClasses, Map<String, String> aliasClusters, Map<String, ORid> aliasRids, Map<String, OWhereClause> aliasFilters, OCommandContext ctx) {
        LinkedHashSet<String> allAliases = new LinkedHashSet<String>();
        allAliases.addAll(aliasClasses.keySet());
        allAliases.addAll(aliasFilters.keySet());
        allAliases.addAll(aliasClusters.keySet());
        allAliases.addAll(aliasRids.keySet());
        OSchema schema = ctx.getDatabase().getMetadata().getSchema();
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        for (String alias : allAliases) {
            String className = aliasClasses.get(alias);
            String clusterName = aliasClusters.get(alias);
            ORid rid = aliasRids.get(alias);
            if (className == null && clusterName == null) continue;
            if (className != null) {
                if (!schema.existsClass(className)) {
                    throw new OCommandExecutionException("class not defined: " + className);
                }
                OClass oClass = schema.getClass(className);
                OWhereClause filter = aliasFilters.get(alias);
                long upperBound = filter != null ? filter.estimate(oClass, this.threshold, ctx) : oClass.count();
                result.put(alias, upperBound);
                continue;
            }
            if (clusterName != null) {
                ODatabase db = ctx.getDatabase();
                if (!db.existsCluster(clusterName)) {
                    throw new OCommandExecutionException("cluster not defined: " + clusterName);
                }
                int clusterId = db.getClusterIdByName(clusterName);
                OClass oClass = db.getMetadata().getSchema().getClassByClusterId(clusterId);
                if (oClass != null) {
                    OWhereClause filter = aliasFilters.get(alias);
                    long upperBound = filter != null ? Math.min(db.countClusterElements(clusterName), filter.estimate(oClass, this.threshold, ctx)) : db.countClusterElements(clusterName);
                    result.put(alias, upperBound);
                    continue;
                }
                result.put(alias, db.countClusterElements(clusterName));
                continue;
            }
            if (rid == null) continue;
            result.put(alias, 1L);
        }
        return result;
    }
}

