/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.geo;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;

public class OSQLFunctionDistance
extends OSQLFunctionAbstract {
    public static final String NAME = "distance";
    private static final double EARTH_RADIUS = 6371.0;

    public OSQLFunctionDistance() {
        super(NAME, 4, 5);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        String unit;
        double[] values = new double[4];
        for (int i = 0; i < iParams.length && i < 4; ++i) {
            if (iParams[i] == null) {
                return null;
            }
            values[i] = (Double)OType.convert(iParams[i], Double.class);
        }
        double deltaLat = Math.toRadians(values[2] - values[0]);
        double deltaLon = Math.toRadians(values[3] - values[1]);
        double a = Math.pow(Math.sin(deltaLat / 2.0), 2.0) + Math.cos(Math.toRadians(values[0])) * Math.cos(Math.toRadians(values[2])) * Math.pow(Math.sin(deltaLon / 2.0), 2.0);
        double distance = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a)) * 6371.0;
        if (iParams.length > 4 && !(unit = iParams[4].toString()).equalsIgnoreCase("km")) {
            if (unit.equalsIgnoreCase("mi")) {
                distance *= 0.621371192;
            } else if (unit.equalsIgnoreCase("nmi")) {
                distance *= 0.539956803;
            } else {
                throw new IllegalArgumentException("Unsupported unit '" + unit + "'. Use km, mi and nmi. Default is km.");
            }
        }
        return distance;
    }

    @Override
    public String getSyntax() {
        return "distance(<field-x>,<field-y>,<x-value>,<y-value>[,<unit>])";
    }
}

