/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator.math;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializer;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.math.OQueryOperatorMultiply;
import java.math.BigDecimal;
import java.util.Date;

public class OQueryOperatorDivide
extends OQueryOperator {
    public OQueryOperatorDivide() {
        super("/", 10, false);
    }

    @Override
    public Object evaluateRecord(OIdentifiable iRecord, ODocument iCurrentResult, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext, ODocumentSerializer serializer) {
        if (iRight == null || iLeft == null) {
            return null;
        }
        if (iLeft instanceof Date) {
            iLeft = ((Date)iLeft).getTime();
        }
        if (iRight instanceof Date) {
            iRight = ((Date)iRight).getTime();
        }
        if (iLeft instanceof Number && iRight instanceof Number) {
            Number l = (Number)iLeft;
            Number r = (Number)iRight;
            Class maxPrecisionClass = OQueryOperatorMultiply.getMaxPrecisionClass(l, r);
            if (Integer.class.equals((Object)maxPrecisionClass)) {
                return l.intValue() / r.intValue();
            }
            if (Long.class.equals((Object)maxPrecisionClass)) {
                return l.longValue() / r.longValue();
            }
            if (Short.class.equals((Object)maxPrecisionClass)) {
                return l.shortValue() / r.shortValue();
            }
            if (Float.class.equals((Object)maxPrecisionClass)) {
                return Float.valueOf(l.floatValue() / r.floatValue());
            }
            if (Double.class.equals((Object)maxPrecisionClass)) {
                return l.doubleValue() / r.doubleValue();
            }
            if (BigDecimal.class.equals((Object)maxPrecisionClass)) {
                return OQueryOperatorMultiply.toBigDecimal(l).divide(OQueryOperatorMultiply.toBigDecimal(r));
            }
        }
        return null;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.NO_INDEX;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

