/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Map;

public class OBatch
extends SimpleNode {
    protected OInteger num;
    protected OInputParameter inputParam;

    public OBatch(int id) {
        super(id);
    }

    public OBatch(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Integer evaluate(OCommandContext ctx) {
        if (this.num != null) {
            return this.num.getValue().intValue();
        }
        if (this.inputParam != null) {
            Object obj = this.inputParam.getValue(ctx.getInputParameters());
            if (obj == null || !(obj instanceof Number)) {
                throw new OCommandExecutionException("" + obj + " is not a number (BATCH)");
            }
            return ((Number)obj).intValue();
        }
        return -1;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.num == null && this.inputParam == null) {
            return;
        }
        builder.append(" BATCH ");
        if (this.num != null) {
            this.num.toString(params, builder);
        } else {
            this.inputParam.toString(params, builder);
        }
    }

    @Override
    public OBatch copy() {
        OBatch result = new OBatch(-1);
        result.inputParam = this.inputParam == null ? null : this.inputParam.copy();
        result.num = this.num == null ? null : this.num.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBatch oBatch = (OBatch)o;
        if (this.num != null ? !this.num.equals(oBatch.num) : oBatch.num != null) {
            return false;
        }
        return !(this.inputParam != null ? !this.inputParam.equals(oBatch.inputParam) : oBatch.inputParam != null);
    }

    public int hashCode() {
        int result = this.num != null ? this.num.hashCode() : 0;
        result = 31 * result + (this.inputParam != null ? this.inputParam.hashCode() : 0);
        return result;
    }
}

