/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OAndBlock;
import com.orientechnologies.orient.core.sql.parser.OBinaryCondition;
import com.orientechnologies.orient.core.sql.parser.OUpdateItem;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class OBooleanExpression
extends SimpleNode {
    public static final OBooleanExpression TRUE = new OBooleanExpression(0){

        @Override
        public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
            return true;
        }

        @Override
        public boolean evaluate(OResult currentRecord, OCommandContext ctx) {
            return true;
        }

        @Override
        protected boolean supportsBasicCalculation() {
            return true;
        }

        @Override
        protected int getNumberOfExternalCalculations() {
            return 0;
        }

        @Override
        protected List<Object> getExternalCalculationConditions() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public boolean needsAliases(Set<String> aliases) {
            return false;
        }

        @Override
        public OBooleanExpression copy() {
            return TRUE;
        }

        @Override
        public List<String> getMatchPatternInvolvedAliases() {
            return null;
        }

        @Override
        public void translateLuceneOperator() {
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public String toString() {
            return "true";
        }

        @Override
        public void toString(Map<Object, Object> params, StringBuilder builder) {
            builder.append("true");
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void extractSubQueries(SubQueryCollector collector) {
        }

        @Override
        public boolean refersToParent() {
            return false;
        }
    };
    public static final OBooleanExpression FALSE = new OBooleanExpression(0){

        @Override
        public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
            return false;
        }

        @Override
        public boolean evaluate(OResult currentRecord, OCommandContext ctx) {
            return false;
        }

        @Override
        protected boolean supportsBasicCalculation() {
            return true;
        }

        @Override
        protected int getNumberOfExternalCalculations() {
            return 0;
        }

        @Override
        protected List<Object> getExternalCalculationConditions() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public boolean needsAliases(Set<String> aliases) {
            return false;
        }

        @Override
        public OBooleanExpression copy() {
            return FALSE;
        }

        @Override
        public List<String> getMatchPatternInvolvedAliases() {
            return null;
        }

        @Override
        public void translateLuceneOperator() {
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public String toString() {
            return "false";
        }

        @Override
        public void toString(Map<Object, Object> params, StringBuilder builder) {
            builder.append("false");
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void extractSubQueries(SubQueryCollector collector) {
        }

        @Override
        public boolean refersToParent() {
            return false;
        }
    };

    public OBooleanExpression(int id) {
        super(id);
    }

    public OBooleanExpression(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public abstract boolean evaluate(OIdentifiable var1, OCommandContext var2);

    public abstract boolean evaluate(OResult var1, OCommandContext var2);

    protected abstract boolean supportsBasicCalculation();

    protected abstract int getNumberOfExternalCalculations();

    protected abstract List<Object> getExternalCalculationConditions();

    public List<OBinaryCondition> getIndexedFunctionConditions(OClass iSchemaClass, ODatabaseDocumentInternal database) {
        return null;
    }

    public List<OAndBlock> flatten() {
        return Collections.singletonList(this.encapsulateInAndBlock(this));
    }

    protected OAndBlock encapsulateInAndBlock(OBooleanExpression item) {
        if (item instanceof OAndBlock) {
            return (OAndBlock)item;
        }
        OAndBlock result = new OAndBlock(-1);
        result.subBlocks.add(item);
        return result;
    }

    public abstract boolean needsAliases(Set<String> var1);

    @Override
    public abstract OBooleanExpression copy();

    public boolean isEmpty() {
        return false;
    }

    public abstract void extractSubQueries(SubQueryCollector var1);

    public abstract boolean refersToParent();

    public Optional<OUpdateItem> transformToUpdateItem() {
        return Optional.empty();
    }

    public abstract List<String> getMatchPatternInvolvedAliases();

    public void translateLuceneOperator() {
    }

    public static OBooleanExpression deserializeFromOResult(OResult doc) {
        try {
            OBooleanExpression result = (OBooleanExpression)Class.forName((String)doc.getProperty("__class")).getConstructor(Integer.class).newInstance(-1);
            result.deserialize(doc);
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
        return null;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("__class", this.getClass().getName());
        return result;
    }

    public void deserialize(OResult fromResult) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean isCacheable();

    public OBooleanExpression rewriteIndexChainsAsSubqueries(OCommandContext ctx, OClass clazz) {
        return this;
    }
}

