/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OContainsTextCondition
extends OBooleanExpression {
    protected OExpression left;
    protected OExpression right;

    public OContainsTextCondition(int id) {
        super(id);
    }

    public OContainsTextCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        Object leftValue = this.left.execute(currentRecord, ctx);
        if (leftValue == null || !(leftValue instanceof String)) {
            return false;
        }
        Object rightValue = this.right.execute(currentRecord, ctx);
        if (rightValue == null || !(rightValue instanceof String)) {
            return false;
        }
        return ((String)leftValue).indexOf((String)rightValue) > -1;
    }

    @Override
    public boolean evaluate(OResult currentRecord, OCommandContext ctx) {
        Object leftValue = this.left.execute(currentRecord, ctx);
        if (leftValue == null || !(leftValue instanceof String)) {
            return false;
        }
        Object rightValue = this.right.execute(currentRecord, ctx);
        if (rightValue == null || !(rightValue instanceof String)) {
            return false;
        }
        return ((String)leftValue).indexOf((String)rightValue) > -1;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.left.toString(params, builder);
        builder.append(" CONTAINSTEXT ");
        this.right.toString(params, builder);
    }

    @Override
    public boolean supportsBasicCalculation() {
        return true;
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int total = 0;
        if (!this.left.supportsBasicCalculation()) {
            ++total;
        }
        if (!this.right.supportsBasicCalculation()) {
            ++total;
        }
        return total;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (!this.left.supportsBasicCalculation()) {
            result.add(this.left);
        }
        if (!this.right.supportsBasicCalculation()) {
            result.add(this.right);
        }
        return result;
    }

    @Override
    public boolean needsAliases(Set<String> aliases) {
        if (!this.left.needsAliases(aliases)) {
            return true;
        }
        return !this.right.needsAliases(aliases);
    }

    @Override
    public OContainsTextCondition copy() {
        OContainsTextCondition result = new OContainsTextCondition(-1);
        result.left = this.left.copy();
        result.right = this.right.copy();
        return result;
    }

    @Override
    public void extractSubQueries(SubQueryCollector collector) {
        this.left.extractSubQueries(collector);
        this.right.extractSubQueries(collector);
    }

    @Override
    public boolean refersToParent() {
        return this.left.refersToParent() || this.right.refersToParent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OContainsTextCondition that = (OContainsTextCondition)o;
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        return !(this.right != null ? !this.right.equals(that.right) : that.right != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        List<String> leftX = this.left == null ? null : this.left.getMatchPatternInvolvedAliases();
        List<String> rightX = this.right == null ? null : this.right.getMatchPatternInvolvedAliases();
        ArrayList<String> result = new ArrayList<String>();
        if (leftX != null) {
            result.addAll(leftX);
        }
        if (rightX != null) {
            result.addAll(rightX);
        }
        return result.size() == 0 ? null : result;
    }

    @Override
    public boolean isCacheable() {
        if (this.left != null && !this.left.isCacheable()) {
            return false;
        }
        return this.right == null || this.right.isCacheable();
    }

    public void setLeft(OExpression left) {
        this.left = left;
    }

    public void setRight(OExpression right) {
        this.right = right;
    }

    public OExpression getLeft() {
        return this.left;
    }

    public OExpression getRight() {
        return this.right;
    }
}

