/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OCreateFunctionStatement
extends OSimpleExecStatement {
    protected OIdentifier name;
    protected String codeQuoted;
    protected String code;
    protected List<OIdentifier> parameters;
    protected Boolean idempotent;
    protected OIdentifier language;

    public OCreateFunctionStatement(int id) {
        super(id);
    }

    public OCreateFunctionStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        ODatabase database = ctx.getDatabase();
        OFunction f = database.getMetadata().getFunctionLibrary().createFunction(this.name.getStringValue());
        f.setCode(this.code);
        f.setIdempotent(Boolean.TRUE.equals(this.idempotent));
        if (this.parameters != null) {
            f.setParameters(this.parameters.stream().map(x -> x.getStringValue()).collect(Collectors.toList()));
        }
        if (this.language != null) {
            f.setLanguage(this.language.getStringValue());
        }
        f.save();
        ORID functionId = f.getId();
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "create function");
        result.setProperty("functionName", this.name.getStringValue());
        result.setProperty("finalId", functionId);
        OInternalResultSet rs = new OInternalResultSet();
        rs.add(result);
        return rs;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("CREATE FUNCTION ");
        this.name.toString(params, builder);
        builder.append(" ");
        builder.append(this.codeQuoted);
        if (this.parameters != null) {
            boolean first = true;
            builder.append(" PARAMETERS [");
            for (OIdentifier param : this.parameters) {
                if (!first) {
                    builder.append(", ");
                }
                param.toString(params, builder);
                first = false;
            }
            builder.append("]");
        }
        if (this.idempotent != null) {
            builder.append(" IDEMPOTENT ");
            builder.append(this.idempotent != false ? "true" : "false");
        }
        if (this.language != null) {
            builder.append(" LANGUAGE ");
            this.language.toString(params, builder);
        }
    }

    @Override
    public OCreateFunctionStatement copy() {
        OCreateFunctionStatement result = new OCreateFunctionStatement(-1);
        result.name = this.name == null ? null : this.name.copy();
        result.codeQuoted = this.codeQuoted;
        result.code = this.code;
        result.parameters = this.parameters == null ? null : this.parameters.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.idempotent = this.idempotent;
        result.language = this.language == null ? null : this.language.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCreateFunctionStatement that = (OCreateFunctionStatement)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.codeQuoted != null ? !this.codeQuoted.equals(that.codeQuoted) : that.codeQuoted != null) {
            return false;
        }
        if (this.code != null ? !this.code.equals(that.code) : that.code != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        if (this.idempotent != null ? !this.idempotent.equals(that.idempotent) : that.idempotent != null) {
            return false;
        }
        return !(this.language != null ? !this.language.equals(that.language) : that.language != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.codeQuoted != null ? this.codeQuoted.hashCode() : 0);
        result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        result = 31 * result + (this.idempotent != null ? this.idempotent.hashCode() : 0);
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        return result;
    }
}

