/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.chm.readbuffer;

import com.orientechnologies.orient.core.storage.cache.chm.readbuffer.Buffer;
import com.orientechnologies.orient.core.storage.cache.chm.readbuffer.StripedBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;

public final class BoundedBuffer<E>
extends StripedBuffer<E> {
    private static final int BUFFER_SIZE = 128;
    private static final int SPACED_SIZE = 2048;
    private static final int SPACED_MASK = 2047;
    private static final int OFFSET = 16;

    @Override
    protected Buffer<E> create(E e) {
        return new RingBuffer(e);
    }

    static final class RingBuffer<E>
    implements Buffer<E> {
        private final AtomicReferenceArray<E> buffer;
        private final AtomicLong readCounter = new AtomicLong();
        private final AtomicLong writeCounter = new AtomicLong();

        private RingBuffer(E e) {
            this.buffer = new AtomicReferenceArray(2048);
            this.buffer.lazySet(0, e);
        }

        @Override
        public int offer(E e) {
            long head = this.readCounter.get();
            long tail = this.writeCounter.get();
            long size = tail - head;
            if (size >= 2048L) {
                return 1;
            }
            if (this.writeCounter.compareAndSet(tail, tail + 16L)) {
                int index = (int)(tail & 0x7FFL);
                this.buffer.lazySet(index, e);
                return 0;
            }
            return -1;
        }

        @Override
        public void drainTo(Consumer<E> consumer) {
            int index;
            E e;
            long head = this.readCounter.get();
            long tail = this.writeCounter.get();
            long size = tail - head;
            if (size == 0L) {
                return;
            }
            while ((e = this.buffer.get(index = (int)(head & 0x7FFL))) != null) {
                this.buffer.lazySet(index, null);
                consumer.accept(e);
                if ((head += 16L) != tail) continue;
            }
            this.readCounter.lazySet(head);
        }

        @Override
        public int reads() {
            return (int)this.readCounter.get() / 16;
        }

        @Override
        public int writes() {
            return (int)this.writeCounter.get() / 16;
        }
    }
}

