/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.local;

import com.orientechnologies.common.collection.closabledictionary.OClosableEntry;
import com.orientechnologies.common.collection.closabledictionary.OClosableLinkedContainer;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.concur.lock.OPartitionedLockManager;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.directmemory.OPointer;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.thread.OScheduledThreadPoolExecutorWithLogging;
import com.orientechnologies.common.thread.OThreadPoolExecutorWithLogging;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.common.util.OQuarto;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OWriteCacheException;
import com.orientechnologies.orient.core.storage.OChecksumMode;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.cache.OAbstractWriteCache;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.local.OBackgroundExceptionListener;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceInformation;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.OPageIsBrokenListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.zip.CRC32;

public final class OWOWCache
extends OAbstractWriteCache
implements OWriteCache,
OCachePointer.WritersListener {
    private static final String NAME_ID_MAP_EXTENSION = ".cm";
    private static final String NAME_ID_MAP_V1 = "name_id_map.cm";
    private static final String NAME_ID_MAP_V2 = "name_id_map_v2.cm";
    private static final String NAME_ID_MAP_V2_T = "name_id_map_v2_t.cm";
    public static final long MAGIC_NUMBER_WITH_CHECKSUM = 4207608830L;
    private static final long MAGIC_NUMBER_WITHOUT_CHECKSUM = 4012948655L;
    private static final int MAGIC_NUMBER_OFFSET = 0;
    private static final int CHECKSUM_OFFSET = 8;
    private static final int PAGE_OFFSET_TO_CHECKSUM_FROM = 12;
    private static final int CHUNK_SIZE = 0x2000000;
    private static final OScheduledThreadPoolExecutorWithLogging commitExecutor;
    private static final ExecutorService cacheEventsPublisher;
    private final long freeSpaceLimit = OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getValueAsLong() * 1024L * 1024L;
    private final int diskSizeCheckInterval = OGlobalConfiguration.DISC_CACHE_FREE_SPACE_CHECK_INTERVAL_IN_PAGES.getValueAsInteger();
    private final List<WeakReference<OLowDiskSpaceListener>> lowDiskSpaceListeners = new CopyOnWriteArrayList<WeakReference<OLowDiskSpaceListener>>();
    private final List<WeakReference<OPageIsBrokenListener>> pageIsBrokenListeners = new CopyOnWriteArrayList<WeakReference<OPageIsBrokenListener>>();
    private final AtomicLong lastDiskSpaceCheck = new AtomicLong(0L);
    private final Path storagePath;
    private final FileStore fileStore;
    private final OClosableLinkedContainer<Long, OFileClassic> files;
    private final ConcurrentHashMap<PageKey, OCachePointer> writeCachePages = new ConcurrentHashMap();
    private final ConcurrentSkipListSet<PageKey> exclusiveWritePages = new ConcurrentSkipListSet();
    private final OReadersWriterSpinLock dirtyPagesLock = new OReadersWriterSpinLock();
    private final ConcurrentHashMap<PageKey, OLogSequenceNumber> dirtyPages = new ConcurrentHashMap();
    private final HashMap<PageKey, OLogSequenceNumber> localDirtyPages = new HashMap();
    private final TreeMap<Long, TreeSet<PageKey>> localDirtyPagesBySegment = new TreeMap();
    private final AtomicLong amountOfNewPagesAdded = new AtomicLong();
    private final AtomicLong writeCacheSize = new AtomicLong();
    private final AtomicLong exclusiveWriteCacheSize = new AtomicLong();
    private final LongAdder cacheOverflowCountSum = new LongAdder();
    private final OBinarySerializer<String> stringSerializer;
    private final int pageSize;
    private final OWriteAheadLog writeAheadLog;
    private final OLockManager<PageKey> lockManager = new OPartitionedLockManager<PageKey>();
    private final OReadersWriterSpinLock filesLock = new OReadersWriterSpinLock();
    private final ConcurrentMap<String, Integer> nameIdMap = new ConcurrentHashMap<String, Integer>();
    private final ConcurrentMap<Integer, String> idNameMap = new ConcurrentHashMap<Integer, String>();
    private FileChannel nameIdMapHolder;
    private final Random fileIdGen = new Random();
    private Path nameIdMapHolderPath;
    private final int id;
    private final OByteBufferPool bufferPool;
    private final String storageName;
    private volatile OChecksumMode checksumMode;
    private Throwable flushError;
    private long flushedPagesSum;
    private long flushedPagesTime;
    private long walFlushTime;
    private long walFlushCount;
    private long chunkSizeSum;
    private long chunkSizeTimeSum;
    private long chunkSizeCountSum;
    private final LongAdder loadedPagesSum = new LongAdder();
    private final LongAdder loadedPagesTimeSum = new LongAdder();
    private final LongAdder cacheOverflowTimeSum = new LongAdder();
    private long exclusivePagesSum;
    private long lsnPagesSum;
    private long lsnFlushIntervalSum;
    private long lsnFlushIntervalCount;
    private long statisticTs = -1L;
    private long lastTsLSNFlush = -1L;
    private long lsnFlushIntervalBoundary = -1L;
    private int lastSegmentCount = 1;
    private final int exclusiveWriteCacheMaxSize;
    private final boolean callFsync;
    private final boolean printCacheStatistics;
    private final int statisticsPrintInterval;
    private long lastFlushTs = -1L;
    private long backgroundExclusiveFlushBoundary = -1L;
    private long lsnPagesFlushIntervalSum;
    private int lsnPagesFlushIntervalCount;
    private final int chunkSize;
    private final long pagesFlushInterval;
    private volatile boolean stopFlush;
    private volatile Future<?> flushFuture;
    private final ConcurrentHashMap<ExclusiveFlushTask, CountDownLatch> triggeredTasks = new ConcurrentHashMap();
    private final int shutdownTimeout;
    private final List<WeakReference<OBackgroundExceptionListener>> backgroundExceptionListeners = new CopyOnWriteArrayList<WeakReference<OBackgroundExceptionListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWOWCache(int pageSize, OByteBufferPool bufferPool, OWriteAheadLog writeAheadLog, long pagesFlushInterval, int shutdownTimeout, long exclusiveWriteCacheMaxSize, Path storagePath, String storageName, OBinarySerializer<String> stringSerializer, OClosableLinkedContainer<Long, OFileClassic> files, int id, OChecksumMode checksumMode, boolean callFsync, boolean printCacheStatistics, int statisticsPrintInterval) {
        this.shutdownTimeout = shutdownTimeout;
        this.pagesFlushInterval = pagesFlushInterval;
        this.callFsync = callFsync;
        this.printCacheStatistics = printCacheStatistics;
        this.statisticsPrintInterval = statisticsPrintInterval;
        this.filesLock.acquireWriteLock();
        try {
            this.id = id;
            this.files = files;
            this.chunkSize = 0x2000000 / pageSize;
            this.pageSize = pageSize;
            this.writeAheadLog = writeAheadLog;
            this.bufferPool = bufferPool;
            this.checksumMode = checksumMode;
            this.exclusiveWriteCacheMaxSize = OWOWCache.normalizeMemory(exclusiveWriteCacheMaxSize, pageSize);
            this.storagePath = storagePath;
            try {
                this.fileStore = Files.getFileStore(this.storagePath);
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error during retrieving of file store"), e);
            }
            this.stringSerializer = stringSerializer;
            this.storageName = storageName;
            if (pagesFlushInterval > 0L) {
                this.flushFuture = commitExecutor.schedule(new PeriodicFlushTask(), pagesFlushInterval, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    public void loadRegisteredFiles() throws IOException, InterruptedException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public void addBackgroundExceptionListener(OBackgroundExceptionListener listener) {
        this.backgroundExceptionListeners.add(new WeakReference<OBackgroundExceptionListener>(listener));
    }

    @Override
    public void removeBackgroundExceptionListener(OBackgroundExceptionListener listener) {
        ArrayList<WeakReference<OBackgroundExceptionListener>> itemsToRemove = new ArrayList<WeakReference<OBackgroundExceptionListener>>(1);
        for (WeakReference<OBackgroundExceptionListener> ref : this.backgroundExceptionListeners) {
            OBackgroundExceptionListener l = (OBackgroundExceptionListener)ref.get();
            if (l == null || !l.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        this.backgroundExceptionListeners.removeAll(itemsToRemove);
    }

    private void fireBackgroundDataFlushExceptionEvent(Throwable e) {
        for (WeakReference<OBackgroundExceptionListener> ref : this.backgroundExceptionListeners) {
            OBackgroundExceptionListener listener = (OBackgroundExceptionListener)ref.get();
            if (listener == null) continue;
            listener.onException(e);
        }
    }

    private static int normalizeMemory(long maxSize, int pageSize) {
        long tmpMaxSize = maxSize / (long)pageSize;
        if (tmpMaxSize >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)tmpMaxSize;
    }

    @Override
    public Path getRootDirectory() {
        return this.storagePath;
    }

    @Override
    public void addLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        this.lowDiskSpaceListeners.add(new WeakReference<OLowDiskSpaceListener>(listener));
    }

    @Override
    public void addPageIsBrokenListener(OPageIsBrokenListener listener) {
        this.pageIsBrokenListeners.add(new WeakReference<OPageIsBrokenListener>(listener));
    }

    @Override
    public void removePageIsBrokenListener(OPageIsBrokenListener listener) {
        ArrayList<WeakReference<OPageIsBrokenListener>> itemsToRemove = new ArrayList<WeakReference<OPageIsBrokenListener>>(1);
        for (WeakReference<OPageIsBrokenListener> ref : this.pageIsBrokenListeners) {
            OPageIsBrokenListener pageIsBrokenListener = (OPageIsBrokenListener)ref.get();
            if (pageIsBrokenListener != null && !pageIsBrokenListener.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        this.pageIsBrokenListeners.removeAll(itemsToRemove);
    }

    @Override
    public void removeLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        ArrayList<WeakReference<OLowDiskSpaceListener>> itemsToRemove = new ArrayList<WeakReference<OLowDiskSpaceListener>>(1);
        for (WeakReference<OLowDiskSpaceListener> ref : this.lowDiskSpaceListeners) {
            OLowDiskSpaceListener lowDiskSpaceListener = (OLowDiskSpaceListener)ref.get();
            if (lowDiskSpaceListener != null && !lowDiskSpaceListener.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        this.lowDiskSpaceListeners.removeAll(itemsToRemove);
    }

    private void freeSpaceCheckAfterNewPageAdd() throws IOException {
        long lastSpaceCheck;
        long newPagesAdded = this.amountOfNewPagesAdded.addAndGet(1L);
        if (newPagesAdded - (lastSpaceCheck = this.lastDiskSpaceCheck.get()) > (long)this.diskSizeCheckInterval || lastSpaceCheck == 0L) {
            long freeSpace = Files.getFileStore(this.storagePath).getUsableSpace();
            if (freeSpace < this.freeSpaceLimit) {
                this.callLowSpaceListeners(new OLowDiskSpaceInformation(freeSpace, this.freeSpaceLimit));
            }
            this.lastDiskSpaceCheck.lazySet(newPagesAdded);
        }
    }

    private void callLowSpaceListeners(final OLowDiskSpaceInformation information) {
        cacheEventsPublisher.execute(new Runnable(){

            @Override
            public void run() {
                for (WeakReference lowDiskSpaceListenerWeakReference : OWOWCache.this.lowDiskSpaceListeners) {
                    OLowDiskSpaceListener listener = (OLowDiskSpaceListener)lowDiskSpaceListenerWeakReference.get();
                    if (listener == null) continue;
                    try {
                        listener.lowDiskSpace(information);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error during notification of low disk space for storage " + OWOWCache.this.storageName, e, new Object[0]);
                    }
                }
            }
        });
    }

    private void callPageIsBrokenListeners(final String fileName, final long pageIndex) {
        cacheEventsPublisher.execute(new Runnable(){

            @Override
            public void run() {
                for (WeakReference pageIsBrokenListenerWeakReference : OWOWCache.this.pageIsBrokenListeners) {
                    OPageIsBrokenListener listener = (OPageIsBrokenListener)pageIsBrokenListenerWeakReference.get();
                    if (listener == null) continue;
                    try {
                        listener.pageIsBroken(fileName, pageIndex);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error during notification of page is broken for storage " + OWOWCache.this.storageName, e, new Object[0]);
                    }
                }
            }
        });
    }

    @Override
    public long bookFileId(String fileName) {
        this.filesLock.acquireWriteLock();
        try {
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null) {
                if (fileId < 0) {
                    long l = OWOWCache.composeFileId(this.id, -fileId.intValue());
                    return l;
                }
                throw new OStorageException("File " + fileName + " has already been added to the storage");
            }
            while (true) {
                int nextId;
                if (this.idNameMap.containsKey(nextId = this.fileIdGen.nextInt(0x7FFFFFFE) + 1) || this.idNameMap.containsKey(-nextId)) continue;
                this.nameIdMap.put(fileName, -nextId);
                this.idNameMap.put(-nextId, fileName);
                long l = OWOWCache.composeFileId(this.id, nextId);
                return l;
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public boolean fileIdsAreEqual(long firsId, long secondId) {
        int secondIntId;
        int firstIntId = OWOWCache.extractFileId(firsId);
        return firstIntId == (secondIntId = OWOWCache.extractFileId(secondId));
    }

    @Override
    public long loadFile(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null && fileId >= 0) {
                long externalId = OWOWCache.composeFileId(this.id, fileId);
                OFileClassic fileClassic = this.files.get(externalId);
                if (fileClassic != null) {
                    long l = externalId;
                    return l;
                }
                throw new OStorageException("File with given name " + fileName + " only partially registered in storage");
            }
            if (fileId == null) {
                int nextId;
                while (this.idNameMap.containsKey(nextId = this.fileIdGen.nextInt(0x7FFFFFFE) + 1) || this.idNameMap.containsKey(-nextId)) {
                }
                fileId = nextId;
            } else {
                this.idNameMap.remove(fileId);
                fileId = -fileId.intValue();
            }
            OFileClassic fileClassic = this.createFileInstance(fileName, fileId);
            if (!fileClassic.exists()) {
                throw new OStorageException("File with name " + fileName + " does not exist in storage " + this.storageName);
            }
            OLogManager.instance().debug((Object)this, "File '" + fileName + "' is not registered in 'file name - id' map, but exists in file system. Registering it", new Object[0]);
            OWOWCache.openFile(fileClassic);
            long externalId = OWOWCache.composeFileId(this.id, fileId);
            this.files.add(externalId, fileClassic);
            this.nameIdMap.put(fileName, fileId);
            this.idNameMap.put(fileId, fileName);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId, fileClassic.getName()), true);
            long l = externalId;
            return l;
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Load file was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public long addFile(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null && fileId >= 0) {
                throw new OStorageException("File with name " + fileName + " already exists in storage " + this.storageName);
            }
            if (fileId == null) {
                int nextId;
                while (this.idNameMap.containsKey(nextId = this.fileIdGen.nextInt(0x7FFFFFFE) + 1) || this.idNameMap.containsKey(-nextId)) {
                }
                fileId = nextId;
            } else {
                this.idNameMap.remove(fileId);
                fileId = -fileId.intValue();
            }
            OFileClassic fileClassic = this.createFileInstance(fileName, fileId);
            OWOWCache.createFile(fileClassic, this.callFsync);
            long externalId = OWOWCache.composeFileId(this.id, fileId);
            this.files.add(externalId, fileClassic);
            this.nameIdMap.put(fileName, fileId);
            this.idNameMap.put(fileId, fileName);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId, fileClassic.getName()), true);
            long l = externalId;
            return l;
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("File add was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public long fileIdByName(String fileName) {
        Integer intId = (Integer)this.nameIdMap.get(fileName);
        if (intId == null || intId < 0) {
            return -1L;
        }
        return OWOWCache.composeFileId(this.id, intId);
    }

    @Override
    public int internalFileId(long fileId) {
        return OWOWCache.extractFileId(fileId);
    }

    @Override
    public long externalFileId(int fileId) {
        return OWOWCache.composeFileId(this.id, fileId);
    }

    @Override
    public Long getMinimalNotFlushedSegment() {
        Future<Long> future = commitExecutor.submit(new FindMinDirtySegment());
        try {
            return future.get();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDirtyPagesTable(OCachePointer pointer, OLogSequenceNumber startLSN) {
        if (this.writeAheadLog == null) {
            return;
        }
        long fileId = pointer.getFileId();
        long pageIndex = pointer.getPageIndex();
        PageKey pageKey = new PageKey(this.internalFileId(fileId), pageIndex);
        OLogSequenceNumber dirtyLSN = startLSN != null ? startLSN : this.writeAheadLog.end();
        if (dirtyLSN == null) {
            dirtyLSN = new OLogSequenceNumber(0L, 0L);
        }
        this.dirtyPagesLock.acquireReadLock();
        try {
            this.dirtyPages.putIfAbsent(pageKey, dirtyLSN);
        }
        finally {
            this.dirtyPagesLock.releaseReadLock();
        }
    }

    @Override
    public long addFile(String fileName, long fileId) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer existingFileId = (Integer)this.nameIdMap.get(fileName);
            int intId = OWOWCache.extractFileId(fileId);
            if (existingFileId != null && existingFileId >= 0) {
                if (existingFileId == intId) {
                    throw new OStorageException("File with name '" + fileName + "'' already exists in storage '" + this.storageName + "'");
                }
                throw new OStorageException("File with given name '" + fileName + "' already exists but has different id " + existingFileId + " vs. proposed " + fileId);
            }
            fileId = OWOWCache.composeFileId(this.id, intId);
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic != null) {
                if (!fileClassic.getName().equals(OWOWCache.createInternalFileName(fileName, intId))) {
                    throw new OStorageException("File with given id exists but has different name " + fileClassic.getName() + " vs. proposed " + fileName);
                }
                fileClassic.shrink(0L);
                if (this.callFsync) {
                    fileClassic.synch();
                }
            } else {
                fileClassic = this.createFileInstance(fileName, intId);
                OWOWCache.createFile(fileClassic, this.callFsync);
                this.files.add(fileId, fileClassic);
            }
            this.idNameMap.remove(-intId);
            this.nameIdMap.put(fileName, intId);
            this.idNameMap.put(intId, fileName);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, intId, fileClassic.getName()), true);
            long l = fileId;
            return l;
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("File add was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public boolean checkLowDiskSpace() throws IOException {
        long freeSpace = this.fileStore.getUsableSpace();
        return freeSpace < this.freeSpaceLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeFuzzyCheckpoint(long segmentId) throws IOException {
        if (this.writeAheadLog != null) {
            this.filesLock.acquireReadLock();
            try {
                OLogSequenceNumber startLSN = this.writeAheadLog.begin(segmentId);
                if (startLSN == null) {
                    return;
                }
                this.writeAheadLog.logFuzzyCheckPointStart(startLSN);
                for (Integer intId : this.nameIdMap.values()) {
                    if (intId < 0 || !this.callFsync) continue;
                    long fileId = OWOWCache.composeFileId(this.id, intId);
                    OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
                    try {
                        OFileClassic fileClassic = entry.get();
                        fileClassic.synch();
                    }
                    finally {
                        this.files.release(entry);
                    }
                }
                this.writeAheadLog.logFuzzyCheckPointEnd();
                this.writeAheadLog.flush();
                this.writeAheadLog.cutAllSegmentsSmallerThan(segmentId);
            }
            catch (InterruptedException e) {
                throw OException.wrapException(new OStorageException("Fuzzy checkpoint was interrupted"), e);
            }
            finally {
                this.filesLock.releaseReadLock();
            }
        }
    }

    @Override
    public void flushTillSegment(long segmentId) {
        Future<Void> future = commitExecutor.submit(new FlushTillSegmentTask(segmentId));
        try {
            future.get();
        }
        catch (Exception e) {
            throw ODatabaseException.wrapException(new OStorageException("Error during data flush"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String fileName) {
        this.filesLock.acquireReadLock();
        try {
            Integer intId = (Integer)this.nameIdMap.get(fileName);
            if (intId != null && intId >= 0) {
                OFileClassic fileClassic = this.files.get(this.externalFileId(intId));
                if (fileClassic == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = fileClassic.exists();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(long fileId) {
        this.filesLock.acquireReadLock();
        try {
            int intId = OWOWCache.extractFileId(fileId);
            fileId = OWOWCache.composeFileId(this.id, intId);
            OFileClassic file = this.files.get(fileId);
            if (file == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = file.exists();
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public void checkCacheOverflow() throws InterruptedException {
        while (this.exclusiveWriteCacheSize.get() > (long)this.exclusiveWriteCacheMaxSize) {
            CountDownLatch cacheBoundaryLatch = new CountDownLatch(1);
            CountDownLatch completionLatch = new CountDownLatch(1);
            ExclusiveFlushTask exclusiveFlushTask = new ExclusiveFlushTask(cacheBoundaryLatch, completionLatch);
            this.triggeredTasks.put(exclusiveFlushTask, completionLatch);
            commitExecutor.submit(exclusiveFlushTask);
            long startTs = 0L;
            if (this.printCacheStatistics) {
                startTs = System.nanoTime();
            }
            cacheBoundaryLatch.await();
            if (!this.printCacheStatistics) continue;
            long endTs = System.nanoTime();
            this.cacheOverflowCountSum.increment();
            this.cacheOverflowTimeSum.add(endTs - startTs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(long fileId, long pageIndex, OCachePointer dataPointer) {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireReadLock();
        try {
            PageKey pageKey = new PageKey(intId, pageIndex);
            Lock groupLock = this.lockManager.acquireExclusiveLock(pageKey);
            try {
                OCachePointer pagePointer = this.writeCachePages.get(pageKey);
                if (pagePointer == null) {
                    this.doPutInCache(dataPointer, pageKey);
                } else assert (pagePointer.equals(dataPointer));
            }
            finally {
                groupLock.unlock();
            }
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    private void doPutInCache(OCachePointer dataPointer, PageKey pageKey) {
        this.writeCachePages.put(pageKey, dataPointer);
        this.writeCacheSize.incrementAndGet();
        dataPointer.setWritersListener(this);
        dataPointer.incrementWritersReferrer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Long> files() {
        this.filesLock.acquireReadLock();
        try {
            HashMap result = new HashMap(1000);
            for (Map.Entry entry : this.nameIdMap.entrySet()) {
                if ((Integer)entry.getValue() <= 0) continue;
                result.put(entry.getKey(), OWOWCache.composeFileId(this.id, (Integer)entry.getValue()));
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCachePointer[] load(long fileId, long startPageIndex, int pageCount, OModifiableBoolean cacheHit, boolean verifyChecksums) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        if (pageCount < 1) {
            throw new IllegalArgumentException("Amount of pages to load should be not less than 1 but provided value is " + pageCount);
        }
        this.filesLock.acquireReadLock();
        try {
            PageKey startPageKey = new PageKey(intId, startPageIndex);
            Lock startPageLock = this.lockManager.acquireSharedLock(startPageKey);
            OCachePointer startPagePointer = this.writeCachePages.get(startPageKey);
            if (startPagePointer == null) {
                Lock[] pageLocks;
                PageKey[] pageKeys;
                if (pageCount > 1) {
                    startPageLock.unlock();
                    pageKeys = new PageKey[pageCount];
                    for (int i = 0; i < pageCount; ++i) {
                        pageKeys[i] = new PageKey(intId, startPageIndex + (long)i);
                    }
                    pageLocks = this.lockManager.acquireSharedLocksInBatch((PageKey[])pageKeys);
                } else {
                    pageLocks = new Lock[]{startPageLock};
                    pageKeys = new PageKey[]{startPageKey};
                }
                try {
                    OCachePointer[] pagePointers = this.loadFileContent(intId, startPageIndex, pageCount, verifyChecksums);
                    if (pagePointers != null) {
                        if (pagePointers.length == 0) {
                            OCachePointer[] oCachePointerArray = pagePointers;
                            return oCachePointerArray;
                        }
                        for (int n = 0; n < pagePointers.length; ++n) {
                            pagePointers[n].incrementReadersReferrer();
                            if (n <= 0) continue;
                            OCachePointer pagePointer = this.writeCachePages.get(pageKeys[n]);
                            assert (pageKeys[n].pageIndex == pagePointers[n].getPageIndex());
                            if (pagePointer == null) continue;
                            pagePointers[n].decrementReadersReferrer();
                            pagePointers[n] = pagePointer;
                            pagePointers[n].incrementReadersReferrer();
                        }
                        OCachePointer[] oCachePointerArray = pagePointers;
                        return oCachePointerArray;
                    }
                }
                finally {
                    for (Lock pageLock : pageLocks) {
                        pageLock.unlock();
                    }
                }
                Object[] objectArray = new OCachePointer[]{};
                return objectArray;
            }
            startPagePointer.incrementReadersReferrer();
            startPageLock.unlock();
            cacheHit.setValue(true);
            OCachePointer[] oCachePointerArray = new OCachePointer[]{startPagePointer};
            return oCachePointerArray;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public int allocateNewPage(long fileId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 13[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void addOnlyWriters(long fileId, long pageIndex) {
        this.exclusiveWriteCacheSize.incrementAndGet();
        this.exclusiveWritePages.add(new PageKey(OWOWCache.extractFileId(fileId), pageIndex));
    }

    @Override
    public void removeOnlyWriters(long fileId, long pageIndex) {
        this.exclusiveWriteCacheSize.decrementAndGet();
        this.exclusiveWritePages.remove(new PageKey(OWOWCache.extractFileId(fileId), pageIndex));
    }

    @Override
    public void flush(long fileId) {
        Future<Void> future = commitExecutor.submit(new FileFlushTask(Collections.singleton(OWOWCache.extractFileId(fileId))));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw OException.wrapException(new OInterruptedException("File flush was interrupted"), e);
        }
        catch (Exception e) {
            throw OException.wrapException(new OWriteCacheException("File flush was abnormally terminated"), e);
        }
    }

    @Override
    public void flush() {
        Future<Void> future = commitExecutor.submit(new FileFlushTask(this.nameIdMap.values()));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw OException.wrapException(new OInterruptedException("File flush was interrupted"), e);
        }
        catch (Exception e) {
            throw OException.wrapException(new OWriteCacheException("File flush was abnormally terminated"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilledUpTo(long fileId) {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireReadLock();
        try {
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            try {
                long l = entry.get().getFileSize() / (long)this.pageSize;
                this.files.release(entry);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.files.release(entry);
                    throw throwable;
                }
                catch (InterruptedException e) {
                    throw OException.wrapException(new OStorageException("Calculation of file size was interrupted"), e);
                }
            }
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public long getExclusiveWriteCachePagesSize() {
        return this.exclusiveWriteCacheSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            String fileName = this.doDeleteFile(intId);
            if (fileName != null) {
                String name = (String)this.idNameMap.get(intId);
                this.idNameMap.remove(intId);
                this.nameIdMap.put(name, -intId);
                this.idNameMap.put(-intId, name);
                this.writeNameIdEntry(new NameFileIdEntry(name, -intId, fileName), true);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            this.removeCachedPages(intId);
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            try {
                entry.get().shrink(0L);
            }
            finally {
                this.files.release(entry);
            }
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("File truncation was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceFileContentWith(long fileId, Path newContentFile) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            this.removeCachedPages(intId);
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            try {
                entry.get().replaceContentWith(newContentFile);
            }
            finally {
                this.files.release(entry);
            }
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("File content replacement was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(long fileId, String newFileName) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            String oldOsFileName;
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            if (entry == null) {
                return;
            }
            String newOsFileName = OWOWCache.createInternalFileName(newFileName, intId);
            try {
                OFileClassic file = entry.get();
                oldOsFileName = file.getName();
                Path newFile = this.storagePath.resolve(newOsFileName);
                file.renameTo(newFile);
            }
            finally {
                this.files.release(entry);
            }
            String oldFileName = (String)this.idNameMap.get(intId);
            this.nameIdMap.remove(oldFileName);
            this.nameIdMap.put(newFileName, intId);
            this.idNameMap.put(intId, newFileName);
            this.writeNameIdEntry(new NameFileIdEntry(oldFileName, -1, oldOsFileName), false);
            this.writeNameIdEntry(new NameFileIdEntry(newFileName, intId, newOsFileName), true);
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Rename of file was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    private void stopFlush() {
        this.stopFlush = true;
        for (CountDownLatch completionLatch : this.triggeredTasks.values()) {
            try {
                if (completionLatch.await(this.shutdownTimeout, TimeUnit.MINUTES)) continue;
                throw new OWriteCacheException("Can not shutdown data flush for storage " + this.storageName);
            }
            catch (InterruptedException e) {
                throw OException.wrapException(new OWriteCacheException("Flush of the data for storage " + this.storageName + " has been interrupted"), e);
            }
        }
        if (this.flushFuture != null) {
            try {
                this.flushFuture.get(this.shutdownTimeout, TimeUnit.MINUTES);
            }
            catch (InterruptedException | CancellationException e) {
            }
            catch (ExecutionException e) {
                throw OException.wrapException(new OWriteCacheException("Error in execution of data flush for storage " + this.storageName), e);
            }
            catch (TimeoutException e) {
                throw OException.wrapException(new OWriteCacheException("Can not shutdown data flush for storage " + this.storageName), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public long[] close() throws IOException {
        this.flush();
        this.stopFlush();
        this.filesLock.acquireWriteLock();
        try {
            Collection fileIds = this.nameIdMap.values();
            ArrayList<Long> closedIds = new ArrayList<Long>(1000);
            HashMap<Integer, String> idFileNameMap = new HashMap<Integer, String>(1000);
            for (Integer n : fileIds) {
                if (n < 0) continue;
                long extId = OWOWCache.composeFileId(this.id, n);
                OFileClassic fileClassic = this.files.remove(extId);
                idFileNameMap.put(n, fileClassic.getName());
                fileClassic.close();
                closedIds.add(extId);
            }
            if (this.nameIdMapHolder != null) {
                this.nameIdMapHolder.truncate(0L);
                for (Map.Entry entry : this.nameIdMap.entrySet()) {
                    String fileName = (Integer)entry.getValue() >= 0 ? (String)idFileNameMap.get(entry.getValue()) : (String)entry.getKey();
                    this.writeNameIdEntry(new NameFileIdEntry((String)entry.getKey(), (Integer)entry.getValue(), fileName), false);
                }
                this.nameIdMapHolder.force(true);
                this.nameIdMapHolder.close();
            }
            this.nameIdMap.clear();
            this.idNameMap.clear();
            long[] ids = new long[closedIds.size()];
            boolean bl = false;
            Object object = closedIds.iterator();
            while (object.hasNext()) {
                void var5_9;
                long id;
                ids[var5_9] = id = ((Long)object.next()).longValue();
                ++var5_9;
            }
            object = ids;
            return object;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(long fileId, boolean flush) {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            if (flush) {
                this.flush(intId);
            } else {
                this.removeCachedPages(intId);
            }
            if (!this.files.close(fileId)) {
                throw new OStorageException("Can not close file with id " + this.internalFileId(fileId) + " because it is still in use");
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String restoreFileById(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            for (Map.Entry entry : this.nameIdMap.entrySet()) {
                if ((Integer)entry.getValue() != -intId) continue;
                this.addFile((String)entry.getKey(), fileId);
                String string = (String)entry.getKey();
                return string;
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
        return null;
    }

    @Override
    public OPageDataVerificationError[] checkStoredPages(OCommandOutputListener commandOutputListener) {
        int notificationTimeOut = 5000;
        ArrayList<OPageDataVerificationError> errors = new ArrayList<OPageDataVerificationError>(0);
        this.filesLock.acquireWriteLock();
        try {
            for (Integer intId : this.nameIdMap.values()) {
                if (intId < 0) continue;
                this.checkFileStoredPages(commandOutputListener, 5000, errors, intId);
            }
            OPageDataVerificationError[] oPageDataVerificationErrorArray = errors.toArray(new OPageDataVerificationError[0]);
            return oPageDataVerificationErrorArray;
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Thread was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileStoredPages(OCommandOutputListener commandOutputListener, int notificationTimeOut, List<OPageDataVerificationError> errors, Integer intId) throws InterruptedException {
        boolean fileIsCorrect;
        long externalId = OWOWCache.composeFileId(this.id, intId);
        OClosableEntry<Long, OFileClassic> entry = this.files.acquire(externalId);
        OFileClassic fileClassic = entry.get();
        String fileName = (String)this.idNameMap.get(intId);
        try {
            if (commandOutputListener != null) {
                commandOutputListener.onMessage("Flashing file " + fileName + "... ");
            }
            this.flush(intId.intValue());
            if (commandOutputListener != null) {
                commandOutputListener.onMessage("Start verification of content of " + fileName + "file ...\n");
            }
            long time = System.currentTimeMillis();
            long filledUpTo = fileClassic.getFileSize();
            fileIsCorrect = true;
            for (long pos = 0L; pos < filledUpTo; pos += (long)this.pageSize) {
                boolean checkSumIncorrect = false;
                boolean magicNumberIncorrect = false;
                byte[] data = new byte[this.pageSize];
                OPointer pointer = this.bufferPool.acquireDirect(true);
                try {
                    ByteBuffer byteBuffer = pointer.getNativeByteBuffer();
                    fileClassic.read(pos, byteBuffer, true);
                    byteBuffer.rewind();
                    byteBuffer.get(data);
                }
                finally {
                    this.bufferPool.release(pointer);
                }
                long magicNumber = OLongSerializer.INSTANCE.deserializeNative(data, 0);
                if (magicNumber != 4207608830L && magicNumber != 4012948655L) {
                    magicNumberIncorrect = true;
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Error: Magic number for page " + pos / (long)this.pageSize + " in file '" + fileName + "' does not match!\n");
                    }
                    fileIsCorrect = false;
                }
                if (magicNumber != 4012948655L) {
                    int storedCRC32 = OIntegerSerializer.INSTANCE.deserializeNative(data, 8);
                    CRC32 crc32 = new CRC32();
                    crc32.update(data, 12, data.length - 12);
                    int calculatedCRC32 = (int)crc32.getValue();
                    if (storedCRC32 != calculatedCRC32) {
                        checkSumIncorrect = true;
                        if (commandOutputListener != null) {
                            commandOutputListener.onMessage("Error: Checksum for page " + pos / (long)this.pageSize + " in file '" + fileName + "' is incorrect!\n");
                        }
                        fileIsCorrect = false;
                    }
                }
                if (magicNumberIncorrect || checkSumIncorrect) {
                    errors.add(new OPageDataVerificationError(magicNumberIncorrect, checkSumIncorrect, pos / (long)this.pageSize, fileName));
                }
                if (commandOutputListener == null || System.currentTimeMillis() - time <= (long)notificationTimeOut) continue;
                time = notificationTimeOut;
                commandOutputListener.onMessage(pos / (long)this.pageSize + " pages were processed...\n");
            }
        }
        catch (IOException ioe) {
            if (commandOutputListener != null) {
                commandOutputListener.onMessage("Error: Error during processing of file '" + fileName + "'. " + ioe.getMessage() + "\n");
            }
            fileIsCorrect = false;
        }
        finally {
            this.files.release(entry);
        }
        if (!fileIsCorrect) {
            if (commandOutputListener != null) {
                commandOutputListener.onMessage("Verification of file '" + fileName + "' is finished with errors.\n");
            }
        } else if (commandOutputListener != null) {
            commandOutputListener.onMessage("Verification of file '" + fileName + "' is successfully finished.\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] delete() throws IOException {
        ArrayList<Long> result = new ArrayList<Long>(1000);
        this.filesLock.acquireWriteLock();
        try {
            Iterator iterator = this.nameIdMap.values().iterator();
            while (iterator.hasNext()) {
                int intId = (Integer)iterator.next();
                if (intId < 0) continue;
                long externalId = OWOWCache.composeFileId(this.id, intId);
                this.doDeleteFile(externalId);
                result.add(externalId);
            }
            if (this.nameIdMapHolderPath != null) {
                if (Files.exists(this.nameIdMapHolderPath, new LinkOption[0])) {
                    this.nameIdMapHolder.close();
                    Files.delete(this.nameIdMapHolderPath);
                }
                this.nameIdMapHolder = null;
                this.nameIdMapHolderPath = null;
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
        this.stopFlush();
        long[] fIds = new long[result.size()];
        int n = 0;
        for (Long fid : result) {
            fIds[n] = fid;
            ++n;
        }
        return fIds;
    }

    @Override
    public String fileNameById(long fileId) {
        int intId = OWOWCache.extractFileId(fileId);
        return (String)this.idNameMap.get(intId);
    }

    @Override
    public String nativeFileNameById(long fileId) {
        OFileClassic fileClassic = this.files.get(fileId);
        if (fileClassic != null) {
            return fileClassic.getName();
        }
        return null;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public long getCacheOverflowCount() {
        return this.cacheOverflowCountSum.sum();
    }

    public long getWriteCacheSize() {
        return this.writeCacheSize.get();
    }

    public long getExclusiveWriteCacheSize() {
        return this.exclusiveWriteCacheSize.get();
    }

    private static void openFile(OFileClassic fileClassic) {
        if (fileClassic.exists()) {
            if (!fileClassic.isOpen()) {
                fileClassic.open();
            }
        } else {
            throw new OStorageException("File " + fileClassic + " does not exist.");
        }
    }

    private static void createFile(OFileClassic fileClassic, boolean callFsync) throws IOException {
        if (!fileClassic.exists()) {
            fileClassic.create();
            if (callFsync) {
                fileClassic.synch();
            }
        } else {
            if (!fileClassic.isOpen()) {
                fileClassic.open();
            }
            fileClassic.shrink(0L);
            if (callFsync) {
                fileClassic.synch();
            }
        }
    }

    private void initNameIdMapping() throws IOException, InterruptedException {
        if (this.nameIdMapHolder == null) {
            if (!Files.exists(this.storagePath, new LinkOption[0])) {
                Files.createDirectories(this.storagePath, new FileAttribute[0]);
            }
            Path nameIdMapHolderV1 = this.storagePath.resolve(NAME_ID_MAP_V1);
            Path nameIdMapHolderV2 = this.storagePath.resolve(NAME_ID_MAP_V2);
            if (Files.exists(nameIdMapHolderV1, new LinkOption[0])) {
                if (Files.exists(nameIdMapHolderV2, new LinkOption[0])) {
                    Files.delete(nameIdMapHolderV2);
                }
                this.nameIdMapHolderPath = nameIdMapHolderV1;
                this.nameIdMapHolder = FileChannel.open(this.nameIdMapHolderPath, StandardOpenOption.READ);
                this.readNameIdMapV1();
                this.convertNameIdMapFromV1ToV2();
                this.nameIdMapHolder.close();
                this.nameIdMapHolderPath = this.storagePath.resolve(NAME_ID_MAP_V2);
                Files.delete(nameIdMapHolderV1);
                this.nameIdMapHolder = FileChannel.open(this.nameIdMapHolderPath, StandardOpenOption.READ, StandardOpenOption.WRITE);
            } else {
                this.nameIdMapHolderPath = this.storagePath.resolve(NAME_ID_MAP_V2);
                this.nameIdMapHolder = FileChannel.open(this.nameIdMapHolderPath, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE);
                this.readNameIdMapV2();
            }
        }
    }

    private void convertNameIdMapFromV1ToV2() throws IOException {
        Path nameIdMapHolderFileV2T = this.storagePath.resolve(NAME_ID_MAP_V2_T);
        if (Files.exists(nameIdMapHolderFileV2T, new LinkOption[0])) {
            Files.delete(nameIdMapHolderFileV2T);
        }
        FileChannel v2NameIdMapHolder = FileChannel.open(nameIdMapHolderFileV2T, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);
        for (Map.Entry nameIdEntry : this.nameIdMap.entrySet()) {
            if ((Integer)nameIdEntry.getValue() >= 0) {
                OFileClassic fileClassic = this.files.get(this.externalFileId((Integer)nameIdEntry.getValue()));
                String fileSystemName = fileClassic.getName();
                NameFileIdEntry nameFileIdEntry = new NameFileIdEntry((String)nameIdEntry.getKey(), (Integer)nameIdEntry.getValue(), fileSystemName);
                this.writeNameIdEntry(v2NameIdMapHolder, nameFileIdEntry, false);
                continue;
            }
            NameFileIdEntry nameFileIdEntry = new NameFileIdEntry((String)nameIdEntry.getKey(), (Integer)nameIdEntry.getValue(), "");
            this.writeNameIdEntry(v2NameIdMapHolder, nameFileIdEntry, false);
        }
        v2NameIdMapHolder.force(true);
        v2NameIdMapHolder.close();
        Files.move(nameIdMapHolderFileV2T, this.storagePath.resolve(NAME_ID_MAP_V2), new CopyOption[0]);
    }

    private OFileClassic createFileInstance(String fileName, int fileId) {
        String internalFileName = OWOWCache.createInternalFileName(fileName, fileId);
        return new OFileClassic(this.storagePath.resolve(internalFileName));
    }

    private static String createInternalFileName(String fileName, int fileId) {
        int extSeparator = fileName.lastIndexOf(46);
        String prefix = extSeparator < 0 ? fileName : (extSeparator == 0 ? "" : fileName.substring(0, extSeparator));
        String suffix = extSeparator < 0 || extSeparator == fileName.length() - 1 ? "" : fileName.substring(extSeparator + 1);
        prefix = prefix + "_" + fileId;
        if (extSeparator >= 0) {
            return prefix + "." + suffix;
        }
        return prefix;
    }

    private void readNameIdMapV2() throws IOException, InterruptedException {
        NameFileIdEntry nameFileIdEntry;
        this.nameIdMap.clear();
        long localFileCounter = -1L;
        this.nameIdMapHolder.position(0L);
        HashMap<Integer, String> idFileNameMap = new HashMap<Integer, String>(1000);
        while ((nameFileIdEntry = this.readNextNameIdEntryV2()) != null) {
            long absFileId = Math.abs(nameFileIdEntry.fileId);
            if (localFileCounter < absFileId) {
                localFileCounter = absFileId;
            }
            this.nameIdMap.put(nameFileIdEntry.name, nameFileIdEntry.fileId);
            this.idNameMap.put(nameFileIdEntry.fileId, nameFileIdEntry.name);
            idFileNameMap.put(nameFileIdEntry.fileId, nameFileIdEntry.fileSystemName);
        }
        for (Map.Entry nameIdEntry : this.nameIdMap.entrySet()) {
            long externalId;
            int fileId = (Integer)nameIdEntry.getValue();
            if (fileId < 0 || this.files.get(externalId = OWOWCache.composeFileId(this.id, (Integer)nameIdEntry.getValue())) != null) continue;
            Path path = this.storagePath.resolve((String)idFileNameMap.get(nameIdEntry.getValue()));
            OFileClassic fileClassic = new OFileClassic(path);
            if (fileClassic.exists()) {
                fileClassic.open();
                this.files.add(externalId, fileClassic);
                continue;
            }
            this.idNameMap.remove(fileId);
            this.nameIdMap.put((String)nameIdEntry.getKey(), -fileId);
            this.idNameMap.put(-fileId, (String)nameIdEntry.getKey());
        }
    }

    private void readNameIdMapV1() throws IOException, InterruptedException {
        Set<String> files;
        NameFileIdEntry nameFileIdEntry;
        HashMap<Integer, HashSet<String>> filesWithNegativeIds = new HashMap<Integer, HashSet<String>>(1000);
        this.nameIdMap.clear();
        long localFileCounter = -1L;
        this.nameIdMapHolder.position(0L);
        while ((nameFileIdEntry = this.readNextNameIdEntryV1()) != null) {
            Integer existingId;
            long absFileId = Math.abs(nameFileIdEntry.fileId);
            if (localFileCounter < absFileId) {
                localFileCounter = absFileId;
            }
            if ((existingId = (Integer)this.nameIdMap.get(nameFileIdEntry.name)) != null && existingId < 0 && (files = (HashSet<String>)filesWithNegativeIds.get(existingId)) != null) {
                files.remove(nameFileIdEntry.name);
                if (files.isEmpty()) {
                    filesWithNegativeIds.remove(existingId);
                }
            }
            if (nameFileIdEntry.fileId < 0) {
                files = (Set)filesWithNegativeIds.get(nameFileIdEntry.fileId);
                if (files == null) {
                    files = new HashSet<String>(8);
                    files.add(nameFileIdEntry.name);
                    filesWithNegativeIds.put(nameFileIdEntry.fileId, (HashSet<String>)files);
                } else {
                    files.add(nameFileIdEntry.name);
                }
            }
            this.nameIdMap.put(nameFileIdEntry.name, nameFileIdEntry.fileId);
            this.idNameMap.put(nameFileIdEntry.fileId, nameFileIdEntry.name);
        }
        for (Map.Entry nameIdEntry : this.nameIdMap.entrySet()) {
            long externalId;
            if ((Integer)nameIdEntry.getValue() < 0 || this.files.get(externalId = OWOWCache.composeFileId(this.id, (Integer)nameIdEntry.getValue())) != null) continue;
            OFileClassic fileClassic = new OFileClassic(this.storagePath.resolve((String)nameIdEntry.getKey()));
            if (fileClassic.exists()) {
                fileClassic.open();
                this.files.add(externalId, fileClassic);
                continue;
            }
            Integer fileId = (Integer)this.nameIdMap.get(nameIdEntry.getKey());
            if (fileId == null || fileId <= 0) continue;
            this.nameIdMap.put((String)nameIdEntry.getKey(), -fileId.intValue());
            this.idNameMap.remove(fileId);
            this.idNameMap.put(-fileId.intValue(), (String)nameIdEntry.getKey());
        }
        HashSet<String> fixedFiles = new HashSet<String>(8);
        for (Map.Entry entry : filesWithNegativeIds.entrySet()) {
            files = (Set)entry.getValue();
            if (files.size() <= 1) continue;
            this.idNameMap.remove(entry.getKey());
            for (String fileName : files) {
                int nextId;
                while (this.idNameMap.containsKey(nextId = this.fileIdGen.nextInt(0x7FFFFFFE) + 1) || this.idNameMap.containsKey(-nextId)) {
                }
                int fileId = nextId;
                this.nameIdMap.put(fileName, -fileId);
                this.idNameMap.put(-fileId, fileName);
                fixedFiles.add(fileName);
            }
        }
        if (!fixedFiles.isEmpty()) {
            OLogManager.instance().warn((Object)this, "Removed files " + fixedFiles + " had duplicated ids. Problem is fixed automatically.", new Object[0]);
        }
    }

    private NameFileIdEntry readNextNameIdEntryV1() throws IOException {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            OIOUtils.readByteBuffer(buffer, this.nameIdMapHolder);
            buffer.rewind();
            int nameSize = buffer.getInt();
            buffer = ByteBuffer.allocate(nameSize + 8);
            OIOUtils.readByteBuffer(buffer, this.nameIdMapHolder);
            buffer.rewind();
            String name = this.stringSerializer.deserializeFromByteBufferObject(buffer);
            int fileId = (int)buffer.getLong();
            return new NameFileIdEntry(name, fileId);
        }
        catch (EOFException ignore) {
            return null;
        }
    }

    private NameFileIdEntry readNextNameIdEntryV2() throws IOException {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            OIOUtils.readByteBuffer(buffer, this.nameIdMapHolder);
            buffer.rewind();
            int fileId = buffer.getInt();
            int nameSize = buffer.getInt();
            buffer = ByteBuffer.allocate(nameSize);
            OIOUtils.readByteBuffer(buffer, this.nameIdMapHolder);
            buffer.rewind();
            String name = this.stringSerializer.deserializeFromByteBufferObject(buffer);
            buffer = ByteBuffer.allocate(4);
            OIOUtils.readByteBuffer(buffer, this.nameIdMapHolder);
            buffer.rewind();
            int fileNameSize = buffer.getInt();
            buffer = ByteBuffer.allocate(fileNameSize);
            OIOUtils.readByteBuffer(buffer, this.nameIdMapHolder);
            buffer.rewind();
            String fileName = this.stringSerializer.deserializeFromByteBufferObject(buffer);
            return new NameFileIdEntry(name, fileId, fileName);
        }
        catch (EOFException ignore) {
            return null;
        }
    }

    private void writeNameIdEntry(NameFileIdEntry nameFileIdEntry, boolean sync) throws IOException {
        this.writeNameIdEntry(this.nameIdMapHolder, nameFileIdEntry, sync);
    }

    private void writeNameIdEntry(FileChannel nameIdMapHolder, NameFileIdEntry nameFileIdEntry, boolean sync) throws IOException {
        int nameSize = this.stringSerializer.getObjectSize(nameFileIdEntry.name, new Object[0]);
        int fileNameSize = this.stringSerializer.getObjectSize(nameFileIdEntry.fileSystemName, new Object[0]);
        ByteBuffer serializedRecord = ByteBuffer.allocate(12 + nameSize + fileNameSize);
        OIntegerSerializer.INSTANCE.serializeInByteBufferObject(nameFileIdEntry.fileId, serializedRecord, new Object[]{0});
        OIntegerSerializer.INSTANCE.serializeInByteBufferObject(nameSize, serializedRecord, new Object[]{4});
        this.stringSerializer.serializeInByteBufferObject(nameFileIdEntry.name, serializedRecord, 8);
        OIntegerSerializer.INSTANCE.serializeInByteBufferObject(fileNameSize, serializedRecord, new Object[]{8 + nameSize});
        this.stringSerializer.serializeInByteBufferObject(nameFileIdEntry.fileSystemName, serializedRecord, 12 + nameSize);
        serializedRecord.position(0);
        OIOUtils.writeByteBuffer(serializedRecord, nameIdMapHolder, nameIdMapHolder.size());
        nameIdMapHolder.write(serializedRecord);
        if (sync) {
            nameIdMapHolder.force(true);
        }
    }

    private String doDeleteFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.removeCachedPages(intId);
        OFileClassic fileClassic = this.files.remove(fileId);
        String name = null;
        if (fileClassic != null) {
            name = fileClassic.getName();
            if (fileClassic.exists()) {
                fileClassic.delete();
            }
        }
        return name;
    }

    private void removeCachedPages(int fileId) {
        Future<Void> future = commitExecutor.submit(new RemoveFilePagesTask(fileId));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OInterruptedException("File data removal was interrupted"), e);
        }
        catch (Exception e) {
            throw OException.wrapException(new OWriteCacheException("File data removal was abnormally terminated"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OCachePointer[] loadFileContent(int intId, long startPageIndex, int pageCount, boolean verifyChecksums) throws IOException {
        long fileId = OWOWCache.composeFileId(this.id, intId);
        try {
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            try {
                OFileClassic fileClassic = entry.get();
                if (fileClassic == null) {
                    throw new IllegalArgumentException("File with id " + intId + " not found in WOW Cache");
                }
                long firstPageStartPosition = startPageIndex * (long)this.pageSize;
                long firstPageEndPosition = firstPageStartPosition + (long)this.pageSize;
                if (fileClassic.getFileSize() >= firstPageEndPosition) {
                    long startTs = 0L;
                    int pagesRead = 0;
                    if (this.printCacheStatistics) {
                        startTs = System.nanoTime();
                    }
                    try {
                        int i;
                        if (pageCount == 1) {
                            OPointer pointer = this.bufferPool.acquireDirect(false);
                            ByteBuffer buffer = pointer.getNativeByteBuffer();
                            assert (buffer.position() == 0);
                            fileClassic.read(firstPageStartPosition, buffer, false);
                            if (verifyChecksums && (this.checksumMode == OChecksumMode.StoreAndVerify || this.checksumMode == OChecksumMode.StoreAndThrow || this.checksumMode == OChecksumMode.StoreAndSwitchReadOnlyMode)) {
                                this.verifyMagicAndChecksum(buffer, pointer, fileId, startPageIndex, null);
                            }
                            buffer.position(0);
                            OCachePointer dataPointer = new OCachePointer(pointer, this.bufferPool, fileId, startPageIndex);
                            pagesRead = 1;
                            OCachePointer[] oCachePointerArray = new OCachePointer[]{dataPointer};
                            return oCachePointerArray;
                        }
                        long maxPageCount = (fileClassic.getFileSize() - firstPageStartPosition) / (long)this.pageSize;
                        int realPageCount = Math.min((int)maxPageCount, pageCount);
                        OPointer[] pointers = new OPointer[realPageCount];
                        ByteBuffer[] buffers = new ByteBuffer[realPageCount];
                        for (i = 0; i < pointers.length; ++i) {
                            OPointer pointer;
                            pointers[i] = pointer = this.bufferPool.acquireDirect(false);
                            buffers[i] = pointer.getNativeByteBuffer();
                        }
                        fileClassic.read(firstPageStartPosition, buffers, false);
                        if (verifyChecksums && (this.checksumMode == OChecksumMode.StoreAndVerify || this.checksumMode == OChecksumMode.StoreAndThrow || this.checksumMode == OChecksumMode.StoreAndSwitchReadOnlyMode)) {
                            for (i = 0; i < pointers.length; ++i) {
                                this.verifyMagicAndChecksum(buffers[i], pointers[i], fileId, startPageIndex + (long)i, pointers);
                            }
                        }
                        OCachePointer[] dataPointers = new OCachePointer[pointers.length];
                        for (int n = 0; n < pointers.length; ++n) {
                            buffers[n].position(0);
                            dataPointers[n] = new OCachePointer(pointers[n], this.bufferPool, fileId, startPageIndex + (long)n);
                        }
                        pagesRead = dataPointers.length;
                        OCachePointer[] oCachePointerArray = dataPointers;
                        return oCachePointerArray;
                    }
                    finally {
                        if (this.printCacheStatistics) {
                            long endTs = System.nanoTime();
                            long loadTime = endTs - startTs;
                            this.loadedPagesSum.add(pagesRead);
                            this.loadedPagesTimeSum.add(loadTime);
                        }
                    }
                }
                OCachePointer[] oCachePointerArray = null;
                return oCachePointerArray;
            }
            finally {
                this.files.release(entry);
            }
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Data load was interrupted"), e);
        }
    }

    private void addMagicAndChecksum(ByteBuffer buffer) {
        assert (buffer.order() == ByteOrder.nativeOrder());
        buffer.position(0);
        OLongSerializer.INSTANCE.serializeInByteBufferObject(this.checksumMode == OChecksumMode.Off ? 4012948655L : 4207608830L, buffer, new Object[0]);
        if (this.checksumMode != OChecksumMode.Off) {
            buffer.position(12);
            CRC32 crc32 = new CRC32();
            crc32.update(buffer);
            int computedChecksum = (int)crc32.getValue();
            buffer.position(8);
            OIntegerSerializer.INSTANCE.serializeInByteBufferObject(computedChecksum, buffer, new Object[0]);
        }
    }

    private void verifyMagicAndChecksum(ByteBuffer buffer, OPointer pointer, long fileId, long pageIndex, OPointer[] pointersToRelease) {
        assert (buffer.order() == ByteOrder.nativeOrder());
        buffer.position(0);
        long magicNumber = OLongSerializer.INSTANCE.deserializeFromByteBufferObject(buffer);
        if (magicNumber != 4207608830L) {
            if (magicNumber != 4012948655L) {
                String message = "Magic number verification failed for page `" + pageIndex + "` of `" + this.fileNameById(fileId) + "`.";
                OLogManager.instance().error(this, "%s", null, message);
                if (this.checksumMode == OChecksumMode.StoreAndThrow) {
                    if (pointersToRelease == null) {
                        this.bufferPool.release(pointer);
                    } else {
                        for (OPointer bufferToRelease : pointersToRelease) {
                            this.bufferPool.release(bufferToRelease);
                        }
                    }
                    throw new OStorageException(message);
                }
                if (this.checksumMode == OChecksumMode.StoreAndSwitchReadOnlyMode) {
                    this.dumpStackTrace(message);
                    this.callPageIsBrokenListeners(this.fileNameById(fileId), pageIndex);
                }
            }
            return;
        }
        buffer.position(8);
        int storedChecksum = OIntegerSerializer.INSTANCE.deserializeFromByteBufferObject(buffer);
        buffer.position(12);
        CRC32 crc32 = new CRC32();
        crc32.update(buffer);
        int computedChecksum = (int)crc32.getValue();
        if (computedChecksum != storedChecksum) {
            String message = "Checksum verification failed for page `" + pageIndex + "` of `" + this.fileNameById(fileId) + "`.";
            OLogManager.instance().error(this, "%s", null, message);
            if (this.checksumMode == OChecksumMode.StoreAndThrow) {
                if (pointersToRelease == null) {
                    this.bufferPool.release(pointer);
                } else {
                    for (OPointer pointerToRelease : pointersToRelease) {
                        this.bufferPool.release(pointerToRelease);
                    }
                }
                throw new OStorageException(message);
            }
            if (this.checksumMode == OChecksumMode.StoreAndSwitchReadOnlyMode) {
                this.dumpStackTrace(message);
                this.callPageIsBrokenListeners(this.fileNameById(fileId), pageIndex);
            }
        }
    }

    private void dumpStackTrace(String message) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(message);
        Exception exception = new Exception();
        exception.printStackTrace(printWriter);
        printWriter.flush();
        OLogManager.instance().error(this, stringWriter.toString(), null, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPage(int fileId, long pageIndex, ByteBuffer buffer, OLogSequenceNumber endLSN) throws InterruptedException, IOException {
        long startTs = 0L;
        if (this.printCacheStatistics) {
            startTs = System.nanoTime();
        }
        boolean waitedForWALFlush = false;
        if (endLSN != null && this.writeAheadLog != null) {
            OLogSequenceNumber flushedLSN = this.writeAheadLog.getFlushedLsn();
            while (flushedLSN == null || flushedLSN.compareTo(endLSN) < 0) {
                this.writeAheadLog.flush();
                flushedLSN = this.writeAheadLog.getFlushedLsn();
                waitedForWALFlush = true;
            }
        }
        long walTs = startTs;
        if (this.printCacheStatistics && waitedForWALFlush) {
            walTs = System.nanoTime();
        }
        long flushTs = 0L;
        if (this.printCacheStatistics) {
            flushTs = System.nanoTime();
        }
        long externalId = OWOWCache.composeFileId(this.id, fileId);
        OClosableEntry<Long, OFileClassic> entry = this.files.acquire(externalId);
        try {
            OFileClassic fileClassic = entry.get();
            this.addMagicAndChecksum(buffer);
            buffer.position(0);
            fileClassic.write(pageIndex * (long)this.pageSize, buffer);
        }
        finally {
            this.files.release(entry);
        }
        if (this.printCacheStatistics) {
            ++this.flushedPagesSum;
            long endTs = System.nanoTime();
            this.flushedPagesTime += endTs - flushTs;
            if (waitedForWALFlush) {
                this.walFlushTime += walTs - startTs;
                ++this.walFlushCount;
            }
        }
    }

    private void printReport() {
        if (this.statisticTs == -1L) {
            this.statisticTs = System.nanoTime();
        } else {
            long ts = System.nanoTime();
            if (ts - this.statisticTs > (long)this.statisticsPrintInterval * 1000000000L) {
                OLogSequenceNumber walEnd;
                OLogSequenceNumber walBegin;
                if (this.lsnFlushIntervalCount == 0L) {
                    this.lsnFlushIntervalCount = 1L;
                }
                if (this.flushedPagesTime == 0L) {
                    this.flushedPagesTime = 1L;
                }
                if (this.chunkSizeCountSum == 0L) {
                    this.chunkSizeCountSum = 1L;
                }
                Map.Entry<Long, TreeSet<PageKey>> entry = this.localDirtyPagesBySegment.firstEntry();
                long loadedPages = this.loadedPagesSum.sum();
                long loadedPagesTime = this.loadedPagesTimeSum.sum();
                if (loadedPagesTime == 0L) {
                    loadedPagesTime = 1L;
                }
                long cacheOverflowTime = this.cacheOverflowTimeSum.sum();
                long cacheOverflowCount = this.cacheOverflowCountSum.sum();
                if (this.writeAheadLog != null) {
                    walBegin = this.writeAheadLog.begin();
                    walEnd = this.writeAheadLog.end();
                } else {
                    walBegin = null;
                    walEnd = null;
                }
                OLogManager.instance().infoNoDb(this, "Write cache stat:%s:Amount of flushed lsn pages %d, amount of flushed of exclusive pages %d, avg.  first dirty pages segment index %d, first dirty pages segment size %d, avg. LSN flush interval %d, total amount of flushed pages %d, write speed %d page/s, write speed is %d KB/s, %d times cache was waiting for WAL flush, avg %d ms. cache was waiting for WAL flush, %d pages were read from the disk, read speed is %d pages/s (%d KB/s), data threads were waiting because of cache overflow %d times, avg. wait time is %d ms., avg. chunk size %d, avg, chunk flush time %d ms., WAL begin %s, WAL end %s, %d percent of exclusive write cache is filled, LSN flush interval boundary %d ms", this.storageName, this.lsnPagesSum, this.exclusivePagesSum, entry == null ? -1 : entry.getKey().intValue(), entry == null ? -1 : entry.getValue().size(), this.lsnFlushIntervalSum / this.lsnFlushIntervalCount / 1000000L, this.flushedPagesSum, 1000000000L * this.flushedPagesSum / this.flushedPagesTime, 1000000000L * this.flushedPagesSum / this.flushedPagesTime * (long)this.pageSize / 1024L, this.walFlushCount, this.walFlushCount > 0L ? this.walFlushTime / this.walFlushCount / 1000000L : 0L, loadedPages, 1000000000L * loadedPages / loadedPagesTime, 1000000000L * loadedPages / loadedPagesTime * (long)this.pageSize / 1024L, cacheOverflowCount, cacheOverflowCount > 0L ? cacheOverflowTime / cacheOverflowCount / 1000000L : 0L, this.chunkSizeSum / this.chunkSizeCountSum, this.chunkSizeTimeSum / this.chunkSizeCountSum / 1000000L, walBegin, walEnd, 100L * this.exclusiveWriteCacheSize.get() / (long)this.exclusiveWriteCacheMaxSize, this.lsnFlushIntervalBoundary / 1000000L);
                this.statisticTs = ts;
                this.lsnPagesSum = 0L;
                this.exclusivePagesSum = 0L;
                this.lsnFlushIntervalCount = 0L;
                this.lsnFlushIntervalSum = 0L;
                this.flushedPagesSum = 0L;
                this.flushedPagesTime = 0L;
                this.walFlushCount = 0L;
                this.walFlushTime = 0L;
                this.loadedPagesSum.add(-loadedPages);
                this.loadedPagesTimeSum.add(-loadedPagesTime);
                this.cacheOverflowTimeSum.add(-cacheOverflowTime);
                this.cacheOverflowCountSum.add(-cacheOverflowCount);
                this.chunkSizeSum = 0L;
                this.chunkSizeTimeSum = 0L;
                this.chunkSizeCountSum = 0L;
            }
        }
    }

    public void setChecksumMode(OChecksumMode checksumMode) {
        this.checksumMode = checksumMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertSharedDirtyPagesToLocal() {
        this.dirtyPagesLock.acquireWriteLock();
        try {
            for (Map.Entry<PageKey, OLogSequenceNumber> entry : this.dirtyPages.entrySet()) {
                OLogSequenceNumber localLSN = this.localDirtyPages.get(entry.getKey());
                if (localLSN != null && localLSN.compareTo(entry.getValue()) <= 0) continue;
                this.localDirtyPages.put(entry.getKey(), entry.getValue());
                long segment = entry.getValue().getSegment();
                TreeSet<PageKey> pages = this.localDirtyPagesBySegment.get(segment);
                if (pages == null) {
                    pages = new TreeSet();
                    pages.add(entry.getKey());
                    this.localDirtyPagesBySegment.put(segment, pages);
                    continue;
                }
                pages.add(entry.getKey());
            }
            this.dirtyPages.clear();
        }
        finally {
            this.dirtyPagesLock.releaseWriteLock();
        }
    }

    private void removeFromDirtyPages(PageKey pageKey) {
        this.dirtyPages.remove(pageKey);
        OLogSequenceNumber lsn = this.localDirtyPages.remove(pageKey);
        if (lsn != null) {
            long segment = lsn.getSegment();
            TreeSet<PageKey> pages = this.localDirtyPagesBySegment.get(segment);
            assert (pages != null);
            boolean removed = pages.remove(pageKey);
            if (pages.isEmpty()) {
                this.localDirtyPagesBySegment.remove(segment);
            }
            assert (removed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int flushWriteCacheFromMinLSN(long segStart, long segEnd, int pagesFlushLimit) throws InterruptedException, IOException {
        this.convertSharedDirtyPagesToLocal();
        int flushedPages = 0;
        int copiedPages = 0;
        ArrayList<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>> chunk = new ArrayList<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>>(pagesFlushLimit);
        long currentSegment = segStart;
        block3: while (flushedPages < pagesFlushLimit) {
            if (!chunk.isEmpty()) {
                throw new IllegalStateException("Chunk is not empty !");
            }
            TreeSet<PageKey> segmentPages = this.localDirtyPagesBySegment.get(currentSegment);
            if (segmentPages == null) {
                if (++currentSegment < segEnd) continue;
                break;
            }
            Iterator<PageKey> lsnPagesIterator = segmentPages.iterator();
            ArrayList<PageKey> pageKeysToFlush = new ArrayList<PageKey>(pagesFlushLimit);
            while (lsnPagesIterator.hasNext() && pageKeysToFlush.size() < pagesFlushLimit - flushedPages) {
                PageKey pageKey = lsnPagesIterator.next();
                pageKeysToFlush.add(pageKey);
            }
            long lastPageIndex = -1L;
            long lastFileId = -1L;
            OLogSequenceNumber maxFullLogLSN = null;
            for (PageKey pageKey : pageKeysToFlush) {
                OCachePointer pointer;
                if (lastFileId == -1L) {
                    if (!chunk.isEmpty()) {
                        throw new IllegalStateException("Chunk is not empty !");
                    }
                } else {
                    if (lastPageIndex == -1L) {
                        throw new IllegalStateException("Last page index is -1");
                    }
                    if (lastFileId != (long)pageKey.fileId || lastPageIndex != pageKey.pageIndex - 1L) {
                        if (!chunk.isEmpty()) {
                            flushedPages += this.flushPagesChunk(chunk, maxFullLogLSN);
                        }
                        maxFullLogLSN = null;
                    }
                }
                if ((pointer = this.writeCachePages.get(pageKey)) == null) {
                    if (chunk.isEmpty()) break block3;
                    flushedPages += this.flushPagesChunk(chunk, maxFullLogLSN);
                    break block3;
                }
                if (pointer.tryAcquireSharedLock()) {
                    OLogSequenceNumber fullLogLSN;
                    long version;
                    OPointer directPointer = this.bufferPool.acquireDirect(false);
                    ByteBuffer copy = directPointer.getNativeByteBuffer();
                    try {
                        version = pointer.getVersion();
                        ByteBuffer buffer = pointer.getBufferDuplicate();
                        fullLogLSN = pointer.getEndLSN();
                        assert (buffer != null);
                        buffer.position(0);
                        copy.position(0);
                        copy.put(buffer);
                        this.removeFromDirtyPages(pageKey);
                        ++copiedPages;
                    }
                    finally {
                        pointer.releaseSharedLock();
                    }
                    if (fullLogLSN != null && (maxFullLogLSN == null || fullLogLSN.compareTo(maxFullLogLSN) > 0)) {
                        maxFullLogLSN = fullLogLSN;
                    }
                    copy.position(0);
                    chunk.add(new OQuarto<Long, ByteBuffer, OPointer, OCachePointer>(version, copy, directPointer, pointer));
                    if (chunk.size() >= pagesFlushLimit || chunk.size() >= this.chunkSize) {
                        flushedPages += this.flushPagesChunk(chunk, maxFullLogLSN);
                        maxFullLogLSN = null;
                        lastPageIndex = -1L;
                        lastFileId = -1L;
                        continue;
                    }
                    lastPageIndex = pageKey.pageIndex;
                    lastFileId = pageKey.fileId;
                    continue;
                }
                if (!chunk.isEmpty()) {
                    flushedPages += this.flushPagesChunk(chunk, maxFullLogLSN);
                }
                maxFullLogLSN = null;
                lastPageIndex = -1L;
                lastFileId = -1L;
            }
            if (chunk.isEmpty()) continue;
            flushedPages += this.flushPagesChunk(chunk, maxFullLogLSN);
        }
        if (!chunk.isEmpty()) {
            throw new IllegalStateException("Chunk is not empty !");
        }
        if (copiedPages != flushedPages) {
            throw new IllegalStateException("Copied pages (" + copiedPages + " ) != flushed pages (" + flushedPages + ")");
        }
        this.lsnPagesSum += (long)flushedPages;
        return flushedPages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int flushPagesChunk(ArrayList<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>> chunk, OLogSequenceNumber fullLogLSN) throws InterruptedException, IOException {
        if (chunk.isEmpty()) {
            return 0;
        }
        long startTs = 0L;
        if (this.printCacheStatistics) {
            startTs = System.nanoTime();
        }
        boolean wasWaitingForWAL = false;
        if (fullLogLSN != null && this.writeAheadLog != null) {
            OLogSequenceNumber flushedLSN = this.writeAheadLog.getFlushedLsn();
            while (flushedLSN == null || flushedLSN.compareTo(fullLogLSN) < 0) {
                this.writeAheadLog.flush();
                flushedLSN = this.writeAheadLog.getFlushedLsn();
                wasWaitingForWAL = true;
            }
        }
        long walTs = startTs;
        if (this.printCacheStatistics && wasWaitingForWAL) {
            walTs = System.nanoTime();
        }
        long flushTs = 0L;
        if (this.printCacheStatistics) {
            flushTs = System.nanoTime();
        }
        ByteBuffer[] buffers = new ByteBuffer[chunk.size()];
        OPointer[] directPointers = new OPointer[chunk.size()];
        for (int i = 0; i < buffers.length; ++i) {
            OQuarto<Long, ByteBuffer, OPointer, OCachePointer> quarto = chunk.get(i);
            ByteBuffer buffer = (ByteBuffer)quarto.two;
            this.addMagicAndChecksum(buffer);
            buffer.position(0);
            buffers[i] = buffer;
            directPointers[i] = (OPointer)quarto.three;
        }
        OQuarto<Long, ByteBuffer, OPointer, OCachePointer> firstChunk = chunk.get(0);
        OCachePointer firstCachePointer = (OCachePointer)firstChunk.four;
        long firstFileId = firstCachePointer.getFileId();
        long firstPageIndex = firstCachePointer.getPageIndex();
        OClosableEntry<Long, OFileClassic> fileEntry = this.files.acquire(firstFileId);
        try {
            OPointer[] file = fileEntry.get();
            file.write(firstPageIndex * (long)this.pageSize, buffers);
        }
        finally {
            this.files.release(fileEntry);
        }
        for (OPointer directPointer : directPointers) {
            this.bufferPool.release(directPointer);
        }
        for (OQuarto oQuarto : chunk) {
            OCachePointer pointer = (OCachePointer)oQuarto.four;
            PageKey pageKey = new PageKey(this.internalFileId(pointer.getFileId()), pointer.getPageIndex());
            long version = (Long)oQuarto.one;
            Lock lock = this.lockManager.acquireExclusiveLock(pageKey);
            try {
                if (!pointer.tryAcquireSharedLock()) continue;
                try {
                    if (version != pointer.getVersion()) continue;
                    this.writeCachePages.remove(pageKey);
                    this.writeCacheSize.decrementAndGet();
                    pointer.decrementWritersReferrer();
                    pointer.setWritersListener(null);
                }
                finally {
                    pointer.releaseSharedLock();
                }
            }
            finally {
                lock.unlock();
            }
        }
        int flushedPages = chunk.size();
        chunk.clear();
        if (this.printCacheStatistics) {
            long l = System.nanoTime();
            this.flushedPagesSum += (long)flushedPages;
            this.flushedPagesTime += l - flushTs;
            this.chunkSizeSum += (long)flushedPages;
            ++this.chunkSizeCountSum;
            this.chunkSizeTimeSum += l - flushTs;
            if (wasWaitingForWAL) {
                ++this.walFlushCount;
                this.walFlushTime += walTs - startTs;
            }
        }
        return flushedPages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int flushExclusiveWriteCache(CountDownLatch latch, long pagesToFlush) throws InterruptedException, IOException {
        Iterator<PageKey> iterator = this.exclusiveWritePages.iterator();
        int flushedPages = 0;
        int copiedPages = 0;
        long ewcSize = this.exclusiveWriteCacheSize.get();
        pagesToFlush = Math.min(Math.max(pagesToFlush, (long)this.chunkSize), ewcSize);
        ArrayList<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>> chunk = new ArrayList<OQuarto<Long, ByteBuffer, OPointer, OCachePointer>>(this.chunkSize);
        if (latch != null && ewcSize <= (long)this.exclusiveWriteCacheMaxSize) {
            latch.countDown();
        }
        block3: while ((long)flushedPages < pagesToFlush) {
            long lastFileId = -1L;
            long lastPageIndex = -1L;
            OLogSequenceNumber maxFullLogLSN = null;
            while (chunk.size() < this.chunkSize && (long)(flushedPages + chunk.size()) < pagesToFlush) {
                if (!iterator.hasNext()) {
                    if (chunk.isEmpty()) break block3;
                    flushedPages += this.flushPagesChunk(chunk, maxFullLogLSN);
                    if (latch == null || this.exclusiveWriteCacheSize.get() > (long)this.exclusiveWriteCacheMaxSize) break block3;
                    latch.countDown();
                    break block3;
                }
                PageKey pageKey = iterator.next();
                OCachePointer pointer = this.writeCachePages.get(pageKey);
                if (pointer == null) {
                    iterator.remove();
                    continue;
                }
                if (pointer.tryAcquireSharedLock()) {
                    OLogSequenceNumber fullLSN;
                    long version;
                    OPointer directPointer = this.bufferPool.acquireDirect(false);
                    ByteBuffer copy = directPointer.getNativeByteBuffer();
                    try {
                        version = pointer.getVersion();
                        ByteBuffer buffer = pointer.getBufferDuplicate();
                        fullLSN = pointer.getEndLSN();
                        assert (buffer != null);
                        buffer.position(0);
                        copy.position(0);
                        copy.put(buffer);
                        this.removeFromDirtyPages(pageKey);
                        ++copiedPages;
                    }
                    finally {
                        pointer.releaseSharedLock();
                    }
                    if (fullLSN != null && (maxFullLogLSN == null || maxFullLogLSN.compareTo(fullLSN) < 0)) {
                        maxFullLogLSN = fullLSN;
                    }
                    copy.position(0);
                    if (chunk.isEmpty()) {
                        chunk.add(new OQuarto<Long, ByteBuffer, OPointer, OCachePointer>(version, copy, directPointer, pointer));
                    } else if (lastFileId != pointer.getFileId() || lastPageIndex != pointer.getPageIndex() - 1L) {
                        flushedPages += this.flushPagesChunk(chunk, maxFullLogLSN);
                        if (latch != null && this.exclusiveWriteCacheSize.get() <= (long)this.exclusiveWriteCacheMaxSize) {
                            latch.countDown();
                        }
                        maxFullLogLSN = null;
                        chunk.add(new OQuarto<Long, ByteBuffer, OPointer, OCachePointer>(version, copy, directPointer, pointer));
                    } else {
                        chunk.add(new OQuarto<Long, ByteBuffer, OPointer, OCachePointer>(version, copy, directPointer, pointer));
                    }
                    lastFileId = pointer.getFileId();
                    lastPageIndex = pointer.getPageIndex();
                    continue;
                }
                if (!chunk.isEmpty()) {
                    flushedPages += this.flushPagesChunk(chunk, maxFullLogLSN);
                    if (latch != null && this.exclusiveWriteCacheSize.get() <= (long)this.exclusiveWriteCacheMaxSize) {
                        latch.countDown();
                    }
                }
                maxFullLogLSN = null;
                lastFileId = -1L;
                lastPageIndex = -1L;
            }
            if (chunk.isEmpty()) continue;
            flushedPages += this.flushPagesChunk(chunk, maxFullLogLSN);
            if (latch == null || this.exclusiveWriteCacheSize.get() > (long)this.exclusiveWriteCacheMaxSize) continue;
            latch.countDown();
        }
        if (!chunk.isEmpty()) {
            throw new IllegalStateException("Chunk is not empty !");
        }
        if (copiedPages != flushedPages) {
            throw new IllegalStateException("Copied pages (" + copiedPages + " ) != flushed pages (" + flushedPages + ")");
        }
        this.exclusivePagesSum += (long)flushedPages;
        return flushedPages;
    }

    static {
        cacheEventsPublisher = new OThreadPoolExecutorWithLogging(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new CacheEventsPublisherFactory());
        commitExecutor = new OScheduledThreadPoolExecutorWithLogging(1, new FlushThreadFactory());
        commitExecutor.setMaximumPoolSize(1);
    }

    private static final class CacheEventsPublisherFactory
    implements ThreadFactory {
        private CacheEventsPublisherFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setName("OrientDB Write Cache Event Publisher");
            thread.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
            return thread;
        }
    }

    private static final class FlushThreadFactory
    implements ThreadFactory {
        private FlushThreadFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setName("OrientDB Write Cache Flush Task");
            thread.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
            return thread;
        }
    }

    private final class RemoveFilePagesTask
    implements Callable<Void> {
        private final int fileId;

        private RemoveFilePagesTask(int fileId) {
            this.fileId = fileId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            Iterator entryIterator = OWOWCache.this.writeCachePages.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                PageKey pageKey = (PageKey)entry.getKey();
                if (pageKey.fileId != this.fileId) continue;
                OCachePointer pagePointer = (OCachePointer)entry.getValue();
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(pageKey);
                try {
                    pagePointer.acquireExclusiveLock();
                    try {
                        pagePointer.decrementWritersReferrer();
                        pagePointer.setWritersListener(null);
                        OWOWCache.this.writeCacheSize.decrementAndGet();
                        OWOWCache.this.removeFromDirtyPages(pageKey);
                    }
                    finally {
                        pagePointer.releaseExclusiveLock();
                    }
                    entryIterator.remove();
                }
                finally {
                    groupLock.unlock();
                }
            }
            return null;
        }
    }

    private final class FileFlushTask
    implements Callable<Void> {
        private final Set<Integer> fileIdSet;

        private FileFlushTask(Collection<Integer> fileIds) {
            this.fileIdSet = new HashSet<Integer>(fileIds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            if (OWOWCache.this.flushError != null) {
                OLogManager.instance().errorNoDb(this, "Can not flush file data because of issue during data write, %s", null, OWOWCache.this.flushError.getMessage());
                return null;
            }
            Iterator entryIterator = OWOWCache.this.writeCachePages.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                PageKey pageKey = (PageKey)entry.getKey();
                if (!this.fileIdSet.contains(pageKey.fileId)) continue;
                OCachePointer pagePointer = (OCachePointer)entry.getValue();
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(pageKey);
                try {
                    if (!pagePointer.tryAcquireSharedLock()) continue;
                    try {
                        ByteBuffer buffer = pagePointer.getBufferDuplicate();
                        OPointer directPointer = OWOWCache.this.bufferPool.acquireDirect(false);
                        try {
                            ByteBuffer copy = directPointer.getNativeByteBuffer();
                            assert (buffer != null);
                            buffer.position(0);
                            copy.put(buffer);
                            OLogSequenceNumber endLSN = pagePointer.getEndLSN();
                            OWOWCache.this.flushPage(pageKey.fileId, pageKey.pageIndex, copy, endLSN);
                        }
                        finally {
                            OWOWCache.this.bufferPool.release(directPointer);
                        }
                        OWOWCache.this.removeFromDirtyPages(pageKey);
                    }
                    finally {
                        pagePointer.releaseSharedLock();
                    }
                    pagePointer.decrementWritersReferrer();
                    pagePointer.setWritersListener(null);
                    entryIterator.remove();
                }
                finally {
                    groupLock.unlock();
                    continue;
                }
                OWOWCache.this.writeCacheSize.decrementAndGet();
            }
            if (OWOWCache.this.callFsync) {
                for (int iFileId : this.fileIdSet) {
                    long finalId = OAbstractWriteCache.composeFileId(OWOWCache.this.id, iFileId);
                    OClosableEntry entry = OWOWCache.this.files.acquire(finalId);
                    if (entry == null) continue;
                    try {
                        ((OFileClassic)entry.get()).synch();
                    }
                    finally {
                        OWOWCache.this.files.release(entry);
                    }
                }
            }
            return null;
        }
    }

    final class FindMinDirtySegment
    implements Callable<Long> {
        FindMinDirtySegment() {
        }

        @Override
        public Long call() {
            if (OWOWCache.this.flushError != null) {
                OLogManager.instance().errorNoDb(this, "Can not calculate minimum LSN because of issue during data write, %s", null, OWOWCache.this.flushError.getMessage());
                return null;
            }
            OWOWCache.this.convertSharedDirtyPagesToLocal();
            if (OWOWCache.this.localDirtyPagesBySegment.isEmpty()) {
                return null;
            }
            return (Long)OWOWCache.this.localDirtyPagesBySegment.firstKey();
        }
    }

    private final class PeriodicFlushTask
    implements Runnable {
        private PeriodicFlushTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block39: {
                block38: {
                    block37: {
                        if (OWOWCache.this.stopFlush) {
                            return;
                        }
                        if (OWOWCache.this.printCacheStatistics) {
                            OWOWCache.this.printReport();
                        }
                        if (OWOWCache.this.flushError == null) break block37;
                        OLogManager.instance().errorNoDb(this, "Can not flush data because of issue during data write, %s", null, OWOWCache.this.flushError.getMessage());
                        if (OWOWCache.this.pagesFlushInterval > 0L && !OWOWCache.this.stopFlush) {
                            OWOWCache.this.flushFuture = commitExecutor.schedule(this, OWOWCache.this.pagesFlushInterval, TimeUnit.MILLISECONDS);
                        }
                        return;
                    }
                    if (!OWOWCache.this.writeCachePages.isEmpty()) break block38;
                    if (OWOWCache.this.pagesFlushInterval > 0L && !OWOWCache.this.stopFlush) {
                        OWOWCache.this.flushFuture = commitExecutor.schedule(this, OWOWCache.this.pagesFlushInterval, TimeUnit.MILLISECONDS);
                    }
                    return;
                }
                try {
                    try {
                        long lsnFlushInterval;
                        long startTs = System.nanoTime();
                        long ewcSize = OWOWCache.this.exclusiveWriteCacheSize.get();
                        int exclusivePages = 0;
                        if ((double)ewcSize >= 0.8 * (double)OWOWCache.this.exclusiveWriteCacheMaxSize) {
                            exclusivePages = OWOWCache.this.flushExclusiveWriteCache(null, ewcSize);
                        }
                        if (OWOWCache.this.lastTsLSNFlush == -1L) {
                            OWOWCache.this.lastTsLSNFlush = startTs;
                            lsnFlushInterval = 0L;
                        } else {
                            lsnFlushInterval = startTs - OWOWCache.this.lastTsLSNFlush;
                        }
                        int lsnPages = 0;
                        if (OWOWCache.this.writeAheadLog != null) {
                            OWOWCache.this.convertSharedDirtyPagesToLocal();
                            long startSegment = OWOWCache.this.writeAheadLog.begin().getSegment();
                            long endSegment = OWOWCache.this.writeAheadLog.end().getSegment();
                            int segmentCount = OWOWCache.this.localDirtyPagesBySegment.size();
                            if (lsnFlushInterval >= OWOWCache.this.lsnFlushIntervalBoundary || segmentCount > OWOWCache.this.lastSegmentCount) {
                                OWOWCache.this.lastTsLSNFlush = startTs;
                                Map.Entry lsnEntry = OWOWCache.this.localDirtyPagesBySegment.firstEntry();
                                if (lsnEntry != null && segmentCount > 0 && (Long)lsnEntry.getKey() < endSegment) {
                                    long lsnTs = System.nanoTime();
                                    lsnPages = OWOWCache.this.flushWriteCacheFromMinLSN(startSegment, endSegment, 8 * OWOWCache.this.chunkSize);
                                    OWOWCache.this.lsnFlushIntervalSum = OWOWCache.this.lsnFlushIntervalSum + lsnFlushInterval;
                                    OWOWCache.this.lsnFlushIntervalCount++;
                                    if (lsnPages > 0) {
                                        long avgFlushInterval;
                                        long endTs = System.nanoTime();
                                        int segments = OWOWCache.this.localDirtyPagesBySegment.size();
                                        long flushInterval = endTs - lsnTs;
                                        if (OWOWCache.this.lsnPagesFlushIntervalCount == 10) {
                                            avgFlushInterval = OWOWCache.this.lsnPagesFlushIntervalSum / (long)OWOWCache.this.lsnPagesFlushIntervalCount;
                                            OWOWCache.this.lsnPagesFlushIntervalSum = avgFlushInterval;
                                            OWOWCache.this.lsnPagesFlushIntervalCount = 1;
                                        }
                                        OWOWCache.this.lsnPagesFlushIntervalSum = OWOWCache.this.lsnPagesFlushIntervalSum + flushInterval;
                                        OWOWCache.this.lsnPagesFlushIntervalCount++;
                                        avgFlushInterval = OWOWCache.this.lsnPagesFlushIntervalSum / (long)OWOWCache.this.lsnPagesFlushIntervalCount;
                                        if (segments <= 2) {
                                            OWOWCache.this.lsnFlushIntervalBoundary = 8L * avgFlushInterval;
                                        } else if (segments <= 3) {
                                            OWOWCache.this.lsnFlushIntervalBoundary = 4L * avgFlushInterval;
                                        } else if (segments <= 4) {
                                            OWOWCache.this.lsnFlushIntervalBoundary = 2L * avgFlushInterval;
                                        } else if (segments <= 5) {
                                            OWOWCache.this.lsnFlushIntervalBoundary = avgFlushInterval;
                                        } else if (segments <= 6) {
                                            OWOWCache.this.lsnFlushIntervalBoundary = avgFlushInterval / 2L;
                                        } else if (segments <= 7) {
                                            OWOWCache.this.lsnFlushIntervalBoundary = avgFlushInterval / 4L;
                                        } else if (segments <= 8) {
                                            OWOWCache.this.lsnFlushIntervalBoundary = avgFlushInterval / 8L;
                                        } else {
                                            OWOWCache.this.lsnFlushIntervalBoundary = 0L;
                                        }
                                    }
                                }
                            }
                            OWOWCache.this.lastSegmentCount = segmentCount;
                        }
                        if (lsnPages + exclusivePages == 0) {
                            long backgroundExclusiveInterval = OWOWCache.this.lastFlushTs == -1L ? 0L : startTs - OWOWCache.this.lastFlushTs;
                            ewcSize = OWOWCache.this.exclusiveWriteCacheSize.get();
                            if (ewcSize >= (long)OWOWCache.this.chunkSize && backgroundExclusiveInterval >= OWOWCache.this.backgroundExclusiveFlushBoundary) {
                                long backgroundTs = System.nanoTime();
                                int backgroundPages = OWOWCache.this.flushExclusiveWriteCache(null, (long)(0.1 * (double)OWOWCache.this.exclusiveWriteCacheMaxSize));
                                if (backgroundPages > 0) {
                                    long endTs = System.nanoTime();
                                    OWOWCache.this.backgroundExclusiveFlushBoundary = 9L * (endTs - backgroundTs);
                                }
                                OWOWCache.this.lastFlushTs = startTs;
                            }
                            break block39;
                        }
                        OWOWCache.this.lastFlushTs = startTs;
                    }
                    catch (Error | Exception t) {
                        OLogManager.instance().error(this, "Exception during data flush", t, new Object[0]);
                        OWOWCache.this.fireBackgroundDataFlushExceptionEvent(t);
                        OWOWCache.this.flushError = t;
                    }
                }
                finally {
                    if (OWOWCache.this.pagesFlushInterval > 0L && !OWOWCache.this.stopFlush) {
                        OWOWCache.this.flushFuture = commitExecutor.schedule(this, OWOWCache.this.pagesFlushInterval, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }
    }

    private final class ExclusiveFlushTask
    implements Runnable {
        private final CountDownLatch cacheBoundaryLatch;
        private final CountDownLatch completionLatch;

        private ExclusiveFlushTask(CountDownLatch cacheBoundaryLatch, CountDownLatch completionLatch) {
            this.cacheBoundaryLatch = cacheBoundaryLatch;
            this.completionLatch = completionLatch;
        }

        @Override
        public void run() {
            if (OWOWCache.this.stopFlush) {
                return;
            }
            try {
                if (OWOWCache.this.flushError != null) {
                    OLogManager.instance().errorNoDb(this, "Can not flush data because of issue during data write, %s", null, OWOWCache.this.flushError.getMessage());
                    return;
                }
                if (OWOWCache.this.writeCachePages.isEmpty()) {
                    return;
                }
                long ewcSize = OWOWCache.this.exclusiveWriteCacheSize.get();
                assert (ewcSize >= 0L);
                if (this.cacheBoundaryLatch != null && ewcSize <= (long)OWOWCache.this.exclusiveWriteCacheMaxSize) {
                    this.cacheBoundaryLatch.countDown();
                }
                if (ewcSize > (long)OWOWCache.this.exclusiveWriteCacheMaxSize) {
                    OWOWCache.this.flushExclusiveWriteCache(this.cacheBoundaryLatch, OWOWCache.this.chunkSize);
                }
            }
            catch (Error | Exception t) {
                OLogManager.instance().error(this, "Exception during data flush", t, new Object[0]);
                OWOWCache.this.fireBackgroundDataFlushExceptionEvent(t);
                OWOWCache.this.flushError = t;
            }
            finally {
                if (this.cacheBoundaryLatch != null) {
                    this.cacheBoundaryLatch.countDown();
                }
                if (this.completionLatch != null) {
                    this.completionLatch.countDown();
                }
            }
        }
    }

    private final class FlushTillSegmentTask
    implements Callable<Void> {
        private final long segmentId;

        private FlushTillSegmentTask(long segmentId) {
            this.segmentId = segmentId;
        }

        @Override
        public Void call() throws Exception {
            if (OWOWCache.this.flushError != null) {
                OLogManager.instance().errorNoDb(this, "Can not flush data till provided segment because of issue during data write, %s", null, OWOWCache.this.flushError.getMessage());
                return null;
            }
            if (OWOWCache.this.writeAheadLog == null) {
                return null;
            }
            OWOWCache.this.convertSharedDirtyPagesToLocal();
            Map.Entry firstEntry = OWOWCache.this.localDirtyPagesBySegment.firstEntry();
            if (firstEntry == null) {
                return null;
            }
            long minDirtySegment = (Long)firstEntry.getKey();
            while (minDirtySegment < this.segmentId) {
                this.flushExclusivePagesIfNeeded();
                OWOWCache.this.flushWriteCacheFromMinLSN(OWOWCache.this.writeAheadLog.begin().getSegment(), this.segmentId, OWOWCache.this.chunkSize);
                firstEntry = OWOWCache.this.localDirtyPagesBySegment.firstEntry();
                if (firstEntry == null) {
                    return null;
                }
                minDirtySegment = (Long)firstEntry.getKey();
            }
            return null;
        }

        private void flushExclusivePagesIfNeeded() throws InterruptedException, IOException {
            long ewcSize = OWOWCache.this.exclusiveWriteCacheSize.get();
            assert (ewcSize >= 0L);
            if ((double)ewcSize >= 0.8 * (double)OWOWCache.this.exclusiveWriteCacheMaxSize) {
                OWOWCache.this.flushExclusiveWriteCache(null, ewcSize);
            }
        }
    }

    private static final class PageKey
    implements Comparable<PageKey> {
        private final int fileId;
        private final long pageIndex;

        private PageKey(int fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        @Override
        public int compareTo(PageKey other) {
            if (this.fileId > other.fileId) {
                return 1;
            }
            if (this.fileId < other.fileId) {
                return -1;
            }
            return Long.compare(this.pageIndex, other.pageIndex);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageKey pageKey = (PageKey)o;
            if (this.fileId != pageKey.fileId) {
                return false;
            }
            return this.pageIndex == pageKey.pageIndex;
        }

        public int hashCode() {
            int result = this.fileId;
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }

        public String toString() {
            return "PageKey{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + '}';
        }

        public PageKey previous() {
            return this.pageIndex == -1L ? this : new PageKey(this.fileId, this.pageIndex - 1L);
        }
    }

    private static final class NameFileIdEntry {
        private final String name;
        private final int fileId;
        private final String fileSystemName;

        private NameFileIdEntry(String name, int fileId) {
            this.name = name;
            this.fileId = fileId;
            this.fileSystemName = name;
        }

        private NameFileIdEntry(String name, int fileId, String fileSystemName) {
            this.name = name;
            this.fileId = fileId;
            this.fileSystemName = fileSystemName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameFileIdEntry that = (NameFileIdEntry)o;
            if (this.fileId != that.fileId) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.fileSystemName.equals(that.fileSystemName);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.fileId;
            result = 31 * result + this.fileSystemName.hashCode();
            return result;
        }
    }
}

