/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations;

import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.concur.lock.OOneEntryPerKeyLockManager;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OStorageTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsMangerMXBean;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ONonTxOperationPerformedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.LockSupport;

public class OAtomicOperationsManager
implements OAtomicOperationsMangerMXBean {
    private volatile boolean trackAtomicOperations = OGlobalConfiguration.TX_TRACK_ATOMIC_OPERATIONS.getValueAsBoolean();
    private final LongAdder atomicOperationsCount = new LongAdder();
    private final AtomicInteger freezeRequests = new AtomicInteger();
    private final ConcurrentMap<Long, FreezeParameters> freezeParametersIdMap = new ConcurrentHashMap<Long, FreezeParameters>();
    private final AtomicLong freezeIdGen = new AtomicLong();
    private final AtomicReference<WaitingListNode> waitingHead = new AtomicReference();
    private final AtomicReference<WaitingListNode> waitingTail = new AtomicReference();
    private static volatile ThreadLocal<OAtomicOperation> currentOperation = new ThreadLocal();
    private final OAbstractPaginatedStorage storage;
    private final OWriteAheadLog writeAheadLog;
    private final OOneEntryPerKeyLockManager<String> lockManager = new OOneEntryPerKeyLockManager(true, -1, OGlobalConfiguration.COMPONENTS_LOCK_CACHE.getValueAsInteger());
    private final OReadCache readCache;
    private final OWriteCache writeCache;
    private final Map<OOperationUnitId, OPair<String, StackTraceElement[]>> activeAtomicOperations = new ConcurrentHashMap<OOperationUnitId, OPair<String, StackTraceElement[]>>();

    public OAtomicOperationsManager(OAbstractPaginatedStorage storage) {
        this.storage = storage;
        this.writeAheadLog = storage.getWALInstance();
        this.readCache = storage.getReadCache();
        this.writeCache = storage.getWriteCache();
    }

    public OAtomicOperation startAtomicOperation(ODurableComponent durableComponent, boolean trackNonTxOperations) throws IOException {
        if (durableComponent != null) {
            return this.startAtomicOperation(durableComponent.getLockName(), trackNonTxOperations, false);
        }
        return this.startAtomicOperation(null, trackNonTxOperations, false);
    }

    public OAtomicOperation tryStartAtomicOperation(ODurableComponent durableComponent, boolean trackNonTxOperations) throws IOException {
        if (durableComponent != null) {
            return this.startAtomicOperation(durableComponent.getLockName(), trackNonTxOperations, true);
        }
        return this.startAtomicOperation(null, trackNonTxOperations, true);
    }

    public OAtomicOperation startAtomicOperation(String lockName, boolean trackNonTxOperations, boolean tryLock) throws IOException {
        OAtomicOperation operation = currentOperation.get();
        if (operation != null) {
            operation.incrementCounter();
            if (lockName != null) {
                if (!tryLock) {
                    this.acquireExclusiveLockTillOperationComplete(operation, lockName);
                } else {
                    boolean locked = this.tryAcquireExclusiveLockTillOperationComplete(operation, lockName);
                    if (!locked) {
                        operation.decrementCounter();
                        return null;
                    }
                }
            }
            return operation;
        }
        this.atomicOperationsCount.increment();
        while (this.freezeRequests.get() > 0) {
            assert (this.freezeRequests.get() >= 0);
            this.atomicOperationsCount.decrement();
            this.throwFreezeExceptionIfNeeded();
            Thread thread = Thread.currentThread();
            this.addThreadInWaitingList(thread);
            if (this.freezeRequests.get() > 0) {
                LockSupport.park(this);
            }
            this.atomicOperationsCount.increment();
        }
        assert (this.freezeRequests.get() >= 0);
        boolean useWal = this.useWal();
        OOperationUnitId unitId = OOperationUnitId.generateId();
        OLogSequenceNumber lsn = useWal ? this.writeAheadLog.logAtomicOperationStartRecord(true, unitId) : null;
        operation = new OAtomicOperation(lsn, unitId, this.readCache, this.writeCache, this.storage.getId());
        currentOperation.set(operation);
        if (this.trackAtomicOperations) {
            Thread thread = Thread.currentThread();
            this.activeAtomicOperations.put(unitId, new OPair<String, StackTraceElement[]>(thread.getName(), thread.getStackTrace()));
        }
        if (useWal && trackNonTxOperations && this.storage.getStorageTransaction() == null) {
            this.writeAheadLog.log(new ONonTxOperationPerformedWALRecord());
        }
        if (lockName != null) {
            if (!tryLock) {
                this.acquireExclusiveLockTillOperationComplete(operation, lockName);
            } else {
                boolean locked = this.tryAcquireExclusiveLockTillOperationComplete(operation, lockName);
                if (!locked) {
                    operation.commitChanges(useWal ? this.writeAheadLog : null);
                    operation.decrementCounter();
                    this.atomicOperationsCount.decrement();
                    currentOperation.set(null);
                    return null;
                }
            }
        }
        try {
            this.storage.checkReadOnlyConditions();
        }
        catch (Error | RuntimeException e) {
            Iterator<String> lockedObjectIterator = operation.lockedObjects().iterator();
            while (lockedObjectIterator.hasNext()) {
                String lockedObject = lockedObjectIterator.next();
                lockedObjectIterator.remove();
                this.lockManager.releaseLock(this, lockedObject, OOneEntryPerKeyLockManager.LOCK.EXCLUSIVE);
            }
            throw e;
        }
        return operation;
    }

    public static void alarmClearOfAtomicOperation() {
        OAtomicOperation current = currentOperation.get();
        if (current != null) {
            currentOperation.set(null);
        }
    }

    private void addThreadInWaitingList(Thread thread) {
        WaitingListNode last;
        WaitingListNode node = new WaitingListNode(thread);
        while (!this.waitingTail.compareAndSet(last = this.waitingTail.get(), node)) {
        }
        if (last == null) {
            this.waitingHead.set(node);
        } else {
            last.next = node;
            last.linkLatch.countDown();
        }
    }

    private WaitingListNode cutWaitingList() {
        WaitingListNode head;
        WaitingListNode tail;
        while (true) {
            tail = this.waitingTail.get();
            head = this.waitingHead.get();
            if (tail == null) {
                return null;
            }
            if (head == null) {
                Thread.yield();
                continue;
            }
            if (head == tail) {
                return new WaitingListNode(head.item);
            }
            if (this.waitingHead.compareAndSet(head, tail)) break;
        }
        WaitingListNode node = head;
        node.waitTillAllLinksWillBeCreated();
        while (node.next != tail) {
            node = node.next;
            node.waitTillAllLinksWillBeCreated();
        }
        node.next = new WaitingListNode(tail.item);
        return head;
    }

    public long freezeAtomicOperations(Class<? extends OException> exceptionClass, String message) {
        long id = this.freezeIdGen.incrementAndGet();
        this.freezeRequests.incrementAndGet();
        this.freezeParametersIdMap.put(id, new FreezeParameters(message, exceptionClass));
        while (this.atomicOperationsCount.sum() > 0L) {
            Thread.yield();
        }
        return id;
    }

    public boolean isFrozen() {
        return this.freezeRequests.get() > 0;
    }

    public void releaseAtomicOperations(long id) {
        FreezeParameters freezeParameters;
        if (id >= 0L && (freezeParameters = (FreezeParameters)this.freezeParametersIdMap.remove(id)) == null) {
            throw new IllegalStateException("Invalid value for freeze id " + id);
        }
        HashMap<Long, FreezeParameters> freezeParametersMap = new HashMap<Long, FreezeParameters>(this.freezeParametersIdMap);
        long requests = this.freezeRequests.decrementAndGet();
        if (requests == 0L) {
            for (Long freezeId : freezeParametersMap.keySet()) {
                this.freezeParametersIdMap.remove(freezeId);
            }
            WaitingListNode node = this.cutWaitingList();
            while (node != null) {
                LockSupport.unpark(node.item);
                node = node.next;
            }
        }
    }

    private void throwFreezeExceptionIfNeeded() {
        for (FreezeParameters freezeParameters : this.freezeParametersIdMap.values()) {
            if (freezeParameters.exceptionClass == null) continue;
            if (freezeParameters.message != null) {
                try {
                    Constructor mConstructor = freezeParameters.exceptionClass.getConstructor(String.class);
                    throw (OException)mConstructor.newInstance(freezeParameters.message);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ie) {
                    OLogManager.instance().error(this, "Can not create instance of exception " + freezeParameters.exceptionClass + " with message will try empty constructor instead", ie, new Object[0]);
                    this.throwFreezeExceptionWithoutMessage(freezeParameters);
                    continue;
                }
            }
            this.throwFreezeExceptionWithoutMessage(freezeParameters);
        }
    }

    private void throwFreezeExceptionWithoutMessage(FreezeParameters freezeParameters) {
        try {
            throw (OException)freezeParameters.exceptionClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ie) {
            OLogManager.instance().error(this, "Can not create instance of exception " + freezeParameters.exceptionClass + " will park thread instead of throwing of exception", ie, new Object[0]);
            return;
        }
    }

    public static OAtomicOperation getCurrentOperation() {
        return currentOperation.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber endAtomicOperation(boolean rollback) throws IOException {
        OLogSequenceNumber lsn;
        block16: {
            OAtomicOperation operation = currentOperation.get();
            if (operation == null) {
                OLogManager.instance().error(this, "There is no atomic operation active", null, new Object[0]);
                throw new ODatabaseException("There is no atomic operation active");
            }
            int counter = operation.getCounter();
            operation.decrementCounter();
            assert (counter > 0);
            try {
                if (rollback) {
                    operation.rollback();
                }
                if (counter == 1) {
                    try {
                        boolean useWal = this.useWal();
                        lsn = !operation.isRollback() ? operation.commitChanges(useWal ? this.writeAheadLog : null) : null;
                        if (this.trackAtomicOperations) {
                            this.activeAtomicOperations.remove(operation.getOperationUnitId());
                        }
                        break block16;
                    }
                    finally {
                        Iterator<String> lockedObjectIterator = operation.lockedObjects().iterator();
                        while (lockedObjectIterator.hasNext()) {
                            String lockedObject = lockedObjectIterator.next();
                            lockedObjectIterator.remove();
                            this.lockManager.releaseLock(this, lockedObject, OOneEntryPerKeyLockManager.LOCK.EXCLUSIVE);
                        }
                        currentOperation.set(null);
                    }
                }
                lsn = null;
            }
            catch (Error e) {
                OAbstractPaginatedStorage st = this.storage;
                if (st != null) {
                    st.handleJVMError(e);
                }
                counter = 1;
                throw e;
            }
            finally {
                if (counter == 1) {
                    this.atomicOperationsCount.decrement();
                }
            }
        }
        return lsn;
    }

    public void ensureThatComponentsUnlocked() {
        OAtomicOperation operation = currentOperation.get();
        if (operation != null) {
            Iterator<String> lockedObjectIterator = operation.lockedObjects().iterator();
            while (lockedObjectIterator.hasNext()) {
                String lockedObject = lockedObjectIterator.next();
                lockedObjectIterator.remove();
                this.lockManager.releaseLock(this, lockedObject, OOneEntryPerKeyLockManager.LOCK.EXCLUSIVE);
            }
        }
    }

    public void acquireExclusiveLockTillOperationComplete(OAtomicOperation operation, String lockName) {
        if (operation.containsInLockedObjects(lockName)) {
            return;
        }
        this.lockManager.acquireLock(lockName, OOneEntryPerKeyLockManager.LOCK.EXCLUSIVE);
        operation.addLockedObject(lockName);
    }

    public boolean tryAcquireExclusiveLockTillOperationComplete(OAtomicOperation operation, String lockName) {
        if (operation.containsInLockedObjects(lockName)) {
            return true;
        }
        try {
            this.lockManager.acquireLock(lockName, OOneEntryPerKeyLockManager.LOCK.EXCLUSIVE, 1L);
        }
        catch (OLockException e) {
            return false;
        }
        operation.addLockedObject(lockName);
        return true;
    }

    public void acquireExclusiveLockTillOperationComplete(ODurableComponent durableComponent) {
        OAtomicOperation operation = currentOperation.get();
        assert (operation != null);
        this.acquireExclusiveLockTillOperationComplete(operation, durableComponent.getLockName());
    }

    public void acquireReadLock(ODurableComponent durableComponent) {
        assert (durableComponent.getLockName() != null);
        this.lockManager.acquireLock(durableComponent.getLockName(), OOneEntryPerKeyLockManager.LOCK.SHARED);
    }

    public void releaseReadLock(ODurableComponent durableComponent) {
        assert (durableComponent.getName() != null);
        assert (durableComponent.getLockName() != null);
        this.lockManager.releaseLock(this, durableComponent.getLockName(), OOneEntryPerKeyLockManager.LOCK.SHARED);
    }

    @Override
    public void trackAtomicOperations() {
        this.activeAtomicOperations.clear();
        this.trackAtomicOperations = true;
    }

    @Override
    public void doNotTrackAtomicOperations() {
        this.trackAtomicOperations = false;
        this.activeAtomicOperations.clear();
    }

    @Override
    public String dumpActiveAtomicOperations() {
        if (!this.trackAtomicOperations) {
            this.activeAtomicOperations.clear();
        }
        StringWriter writer = new StringWriter();
        writer.append("List of active atomic operations: \r\n");
        writer.append("------------------------------------------------------------------------------------------------\r\n");
        for (Map.Entry<OOperationUnitId, OPair<String, StackTraceElement[]>> entry : this.activeAtomicOperations.entrySet()) {
            writer.append("Operation unit id :").append(entry.getKey().toString()).append("\r\n");
            writer.append("Started at thread : ").append((CharSequence)entry.getValue().getKey()).append("\r\n");
            writer.append("Stack trace of method which started this operation : \r\n");
            StackTraceElement[] stackTraceElements = entry.getValue().getValue();
            for (int i = 1; i < stackTraceElements.length; ++i) {
                writer.append("\tat ").append(stackTraceElements[i].toString()).append("\r\n");
            }
            writer.append("\r\n\r\n");
        }
        writer.append("-------------------------------------------------------------------------------------------------\r\n");
        return writer.toString();
    }

    private boolean useWal() {
        if (this.writeAheadLog == null) {
            return false;
        }
        OStorageTransaction storageTransaction = this.storage.getStorageTransaction();
        if (storageTransaction == null) {
            return true;
        }
        OTransactionInternal clientTx = storageTransaction.getClientTx();
        return clientTx == null || clientTx.isUsingLog();
    }

    static {
        Orient.instance().registerListener(new OOrientListenerAbstract(){

            @Override
            public void onStartup() {
                if (currentOperation == null) {
                    currentOperation = new ThreadLocal();
                }
            }

            @Override
            public void onShutdown() {
                currentOperation = null;
            }
        });
    }

    private static final class WaitingListNode {
        private final CountDownLatch linkLatch = new CountDownLatch(1);
        private final Thread item;
        private volatile WaitingListNode next;

        WaitingListNode(Thread item) {
            this.item = item;
        }

        void waitTillAllLinksWillBeCreated() {
            try {
                this.linkLatch.await();
            }
            catch (InterruptedException e) {
                throw OException.wrapException(new OInterruptedException("Thread was interrupted while was waiting for completion of 'waiting linked list' operation"), e);
            }
        }
    }

    private static final class FreezeParameters {
        private final String message;
        private final Class<? extends OException> exceptionClass;

        FreezeParameters(String message, Class<? extends OException> exceptionClass) {
            this.message = message;
            this.exceptionClass = exceptionClass;
        }
    }
}

