/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.base;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import java.io.IOException;

public abstract class ODurableComponent
extends OSharedResourceAdaptive {
    protected final OAtomicOperationsManager atomicOperationsManager;
    protected final OAbstractPaginatedStorage storage;
    protected final OReadCache readCache;
    protected final OWriteCache writeCache;
    private volatile String name;
    private volatile String fullName;
    private final String extension;
    private final String lockName;

    public ODurableComponent(OAbstractPaginatedStorage storage, String name, String extension, String lockName) {
        super(true);
        assert (name != null);
        this.extension = extension;
        this.storage = storage;
        this.fullName = name + extension;
        this.name = name;
        this.atomicOperationsManager = storage.getAtomicOperationsManager();
        this.readCache = storage.getReadCache();
        this.writeCache = storage.getWriteCache();
        this.lockName = lockName;
    }

    public String getLockName() {
        return this.lockName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fullName = name + this.extension;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getExtension() {
        return this.extension;
    }

    protected void endAtomicOperation(boolean rollback) throws IOException {
        this.atomicOperationsManager.endAtomicOperation(rollback);
    }

    protected OAtomicOperation startAtomicOperation(boolean trackNonTxOperations) throws IOException {
        return this.atomicOperationsManager.startAtomicOperation(this, trackNonTxOperations);
    }

    protected OAtomicOperation tryStartAtomicOperation(boolean trackNonTxOperations) throws IOException {
        return this.atomicOperationsManager.tryStartAtomicOperation(this, trackNonTxOperations);
    }

    protected long getFilledUpTo(OAtomicOperation atomicOperation, long fileId) {
        if (atomicOperation == null) {
            return this.writeCache.getFilledUpTo(fileId);
        }
        return atomicOperation.filledUpTo(fileId);
    }

    protected OCacheEntry loadPageForWrite(OAtomicOperation atomicOperation, long fileId, long pageIndex, boolean checkPinnedPages, boolean verifyCheckSum) throws IOException {
        if (atomicOperation == null) {
            return this.readCache.loadForWrite(fileId, pageIndex, checkPinnedPages, this.writeCache, 1, true, null);
        }
        return atomicOperation.loadPageForWrite(fileId, pageIndex, checkPinnedPages, 1, verifyCheckSum);
    }

    protected OCacheEntry loadPageForRead(OAtomicOperation atomicOperation, long fileId, long pageIndex, boolean checkPinnedPages) throws IOException {
        return this.loadPageForRead(atomicOperation, fileId, pageIndex, checkPinnedPages, 1);
    }

    protected OCacheEntry loadPageForRead(OAtomicOperation atomicOperation, long fileId, long pageIndex, boolean checkPinnedPages, int pageCount) throws IOException {
        if (atomicOperation == null) {
            return this.readCache.loadForRead(fileId, pageIndex, checkPinnedPages, this.writeCache, pageCount, true);
        }
        return atomicOperation.loadPageForRead(fileId, pageIndex, checkPinnedPages, pageCount);
    }

    protected void pinPage(OAtomicOperation atomicOperation, OCacheEntry cacheEntry) {
        if (atomicOperation == null) {
            this.readCache.pinPage(cacheEntry, this.writeCache);
        } else {
            atomicOperation.pinPage(cacheEntry);
        }
    }

    protected OCacheEntry addPage(OAtomicOperation atomicOperation, long fileId) throws IOException {
        if (atomicOperation == null) {
            return this.readCache.allocateNewPage(fileId, this.writeCache, null);
        }
        return atomicOperation.addPage(fileId);
    }

    protected void releasePageFromWrite(OAtomicOperation atomicOperation, OCacheEntry cacheEntry) {
        if (atomicOperation == null) {
            this.readCache.releaseFromWrite(cacheEntry, this.writeCache);
        } else {
            atomicOperation.releasePageFromWrite(cacheEntry);
        }
    }

    protected void releasePageFromRead(OAtomicOperation atomicOperation, OCacheEntry cacheEntry) {
        if (atomicOperation == null) {
            this.readCache.releaseFromRead(cacheEntry, this.writeCache);
        } else {
            atomicOperation.releasePageFromRead(cacheEntry);
        }
    }

    protected long addFile(OAtomicOperation atomicOperation, String fileName) throws IOException {
        if (atomicOperation == null) {
            return this.readCache.addFile(fileName, this.writeCache);
        }
        return atomicOperation.addFile(fileName);
    }

    protected long openFile(OAtomicOperation atomicOperation, String fileName) throws IOException {
        if (atomicOperation == null) {
            return this.writeCache.loadFile(fileName);
        }
        return atomicOperation.loadFile(fileName);
    }

    protected void deleteFile(OAtomicOperation atomicOperation, long fileId) throws IOException {
        if (atomicOperation == null) {
            this.readCache.deleteFile(fileId, this.writeCache);
        } else {
            atomicOperation.deleteFile(fileId);
        }
    }

    protected boolean isFileExists(OAtomicOperation atomicOperation, String fileName) {
        if (atomicOperation == null) {
            return this.writeCache.exists(fileName);
        }
        return atomicOperation.isFileExists(fileName);
    }

    protected void truncateFile(OAtomicOperation atomicOperation, long filedId) throws IOException {
        if (atomicOperation == null) {
            this.readCache.truncateFile(filedId, this.writeCache);
        } else {
            atomicOperation.truncateFile(filedId);
        }
    }
}

