/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.deque;

import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.deque.Cursor;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.cas.deque.Node;
import java.util.concurrent.atomic.AtomicReference;

public final class MPSCFAAArrayDequeue<T>
extends AtomicReference<Node<T>> {
    private volatile Node<T> head;
    private static final Object taken = new Object();

    public MPSCFAAArrayDequeue() {
        Node dummyNode = new Node();
        dummyNode.enqidx.set(0);
        this.set(dummyNode);
        this.head = dummyNode;
    }

    public void offer(T record) {
        while (true) {
            Node tail = (Node)this.get();
            int idx = tail.enqidx.getAndIncrement();
            if (idx > 1023) {
                if (tail != this.get()) continue;
                Node next = tail.getNext();
                if (next == null) {
                    Node<T> newNode = new Node<T>(record, tail);
                    if (!tail.casNext(null, newNode)) continue;
                    this.compareAndSet(tail, newNode);
                    return;
                }
                this.compareAndSet(tail, next);
                continue;
            }
            if (tail.items.compareAndSet(idx, null, record)) break;
        }
    }

    public T poll() {
        Object item;
        while (true) {
            int idx;
            Node<T> head = this.head;
            int deqidx = head.deqidx;
            int enqidx = head.enqidx.get();
            if ((deqidx >= enqidx || deqidx >= 1024) && head.getNext() == null) {
                return null;
            }
            if (deqidx >= 1024) {
                this.head = head.getNext();
                head.clearPrev();
                continue;
            }
            ++head.deqidx;
            item = head.items.getAndSet(idx, taken);
            if (item != null) break;
        }
        return (T)item;
    }

    public T peek() {
        Object item;
        Node<T> head = this.head;
        while (true) {
            int enqidx;
            int deqidx;
            if ((deqidx = head.deqidx) >= (enqidx = head.enqidx.get()) || deqidx >= 1024) {
                if (head.getNext() == null) {
                    return null;
                }
                head = head.getNext();
                continue;
            }
            int idx = deqidx;
            item = head.items.get(idx);
            if (item != null && item != taken) break;
        }
        return item;
    }

    public Cursor<T> peekFirst() {
        Object item;
        int idx;
        Node<T> head = this.head;
        while (true) {
            int enqidx;
            int deqidx;
            if ((deqidx = head.deqidx) >= (enqidx = head.enqidx.get()) || deqidx >= 1024) {
                if (head.getNext() == null) {
                    return null;
                }
                head = head.getNext();
                continue;
            }
            idx = deqidx;
            item = head.items.get(idx);
            if (item != null && item != taken) break;
        }
        return new Cursor<T>(head, idx, item);
    }

    public static <T> Cursor<T> next(Cursor<T> cursor) {
        if (cursor == null) {
            return null;
        }
        Node node = cursor.node;
        int idx = cursor.itemIndex + 1;
        while (node != null) {
            int enqidx = node.enqidx.get();
            if (idx >= enqidx || idx >= 1024) {
                if (enqidx < 1024) {
                    return null;
                }
                node = node.getNext();
                idx = 0;
                continue;
            }
            Object item = node.items.get(idx);
            if (item == null) continue;
            if (item == taken) {
                return null;
            }
            return new Cursor(node, idx, item);
        }
        return null;
    }

    public Cursor<T> peekLast() {
        int idx;
        Node tail;
        Object item;
        do {
            tail = (Node)this.get();
            int deqidx = tail.deqidx;
            int enqidx = tail.enqidx.get();
            if (deqidx >= enqidx || deqidx >= 1024) {
                return null;
            }
            idx = enqidx;
            if (idx >= 1024) {
                idx = 1024;
            }
            if (idx > 0) continue;
            return null;
        } while ((item = tail.items.get(idx - 1)) == null || item == taken);
        return new Cursor(tail, idx - 1, item);
    }

    public static <T> Cursor<T> prev(Cursor<T> cursor) {
        if (cursor == null) {
            return null;
        }
        Node node = cursor.node;
        int idx = cursor.itemIndex - 1;
        while (node != null) {
            int deqidx = node.deqidx;
            if (deqidx > idx || deqidx >= 1024) {
                if (deqidx > 0) {
                    return null;
                }
                node = node.getPrev();
                idx = 1023;
                continue;
            }
            Object item = node.items.get(idx);
            if (item == null) continue;
            if (item == taken) {
                return null;
            }
            return new Cursor(node, idx, item);
        }
        return null;
    }
}

