/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.singlevalue;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

final class OSBTreeBucketSingleValue<K>
extends ODurablePage {
    private static final int RID_SIZE = 10;
    private static final int FREE_POINTER_OFFSET = 28;
    private static final int SIZE_OFFSET = 32;
    private static final int IS_LEAF_OFFSET = 36;
    private static final int LEFT_SIBLING_OFFSET = 37;
    private static final int RIGHT_SIBLING_OFFSET = 45;
    private static final int POSITIONS_ARRAY_OFFSET = 53;
    private final boolean isLeaf;
    private final OBinarySerializer<K> keySerializer;
    private final OType[] keyTypes;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private final OEncryption encryption;

    OSBTreeBucketSingleValue(OCacheEntry cacheEntry, boolean isLeaf, OBinarySerializer<K> keySerializer, OType[] keyTypes, OEncryption encryption) {
        super(cacheEntry);
        this.isLeaf = isLeaf;
        this.keySerializer = keySerializer;
        this.keyTypes = keyTypes;
        this.encryption = encryption;
        this.setIntValue(28, MAX_PAGE_SIZE_BYTES);
        this.setIntValue(32, 0);
        this.setByteValue(36, (byte)(isLeaf ? 1 : 0));
        this.setLongValue(37, -1L);
        this.setLongValue(45, -1L);
    }

    OSBTreeBucketSingleValue(OCacheEntry cacheEntry, OBinarySerializer<K> keySerializer, OType[] keyTypes, OEncryption encryption) {
        super(cacheEntry);
        this.keyTypes = keyTypes;
        this.encryption = encryption;
        this.isLeaf = this.getByteValue(36) > 0;
        this.keySerializer = keySerializer;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int find(K key) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            K midVal = this.getKey(mid);
            int cmp = this.comparator.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void remove(int entryIndex, byte[] oldRawKey) {
        int keySize;
        int entryPosition = this.getIntValue(53 + entryIndex * 4);
        if (oldRawKey == null) {
            if (this.encryption == null) {
                keySize = this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
            } else {
                int encryptionSize = this.getIntValue(entryPosition);
                keySize = 4 + encryptionSize;
            }
        } else {
            keySize = oldRawKey.length;
        }
        if (!this.isLeaf) {
            throw new IllegalStateException("Remove is applies to leaf buckets only");
        }
        int entrySize = keySize + 10;
        int size = this.getIntValue(32);
        if (entryIndex < size - 1) {
            this.moveData(53 + (entryIndex + 1) * 4, 53 + entryIndex * 4, (size - entryIndex - 1) * 4);
        }
        this.setIntValue(32, --size);
        int freePointer = this.getIntValue(28);
        if (size > 0 && entryPosition > freePointer) {
            this.moveData(freePointer, freePointer + entrySize, entryPosition - freePointer);
        }
        this.setIntValue(28, freePointer + entrySize);
        int currentPositionOffset = 53;
        for (int i = 0; i < size; ++i) {
            int currentEntryPosition = this.getIntValue(currentPositionOffset);
            if (currentEntryPosition < entryPosition) {
                this.setIntValue(currentPositionOffset, currentEntryPosition + entrySize);
            }
            currentPositionOffset += 4;
        }
    }

    public int size() {
        return this.getIntValue(32);
    }

    public SBTreeEntry<K> getEntry(int entryIndex) {
        K key;
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        if (this.isLeaf) {
            K key2;
            if (this.encryption == null) {
                key2 = this.deserializeFromDirectMemory(this.keySerializer, entryPosition);
                entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
            } else {
                int encryptionSize = this.getIntValue(entryPosition);
                byte[] encryptedKey = this.getBinaryValue(entryPosition += 4, encryptionSize);
                entryPosition += encryptedKey.length;
                byte[] serializedKey = this.encryption.decrypt(encryptedKey);
                key2 = this.keySerializer.deserializeNativeObject(serializedKey, 0);
            }
            short clusterId = this.getShortValue(entryPosition);
            long clusterPosition = this.getLongValue(entryPosition + 2);
            return new SBTreeEntry<K>(-1, -1, key2, new ORecordId(clusterId, clusterPosition));
        }
        int leftChild = this.getIntValue(entryPosition);
        int rightChild = this.getIntValue(entryPosition += 4);
        entryPosition += 4;
        if (this.encryption == null) {
            key = this.deserializeFromDirectMemory(this.keySerializer, entryPosition);
        } else {
            int encryptionSize = this.getIntValue(entryPosition);
            byte[] encryptedKey = this.getBinaryValue(entryPosition += 4, encryptionSize);
            byte[] serializedKey = this.encryption.decrypt(encryptedKey);
            key = this.keySerializer.deserializeNativeObject(serializedKey, 0);
        }
        return new SBTreeEntry<K>(leftChild, rightChild, key, null);
    }

    int getLeft(int entryIndex) {
        assert (!this.isLeaf);
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        return this.getIntValue(entryPosition);
    }

    int getRight(int entryIndex) {
        assert (!this.isLeaf);
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        return this.getIntValue(entryPosition + 4);
    }

    byte[] getRawEntry(int entryIndex) {
        int keySize;
        int entryPosition;
        int startEntryPosition = entryPosition = this.getIntValue(entryIndex * 4 + 53);
        if (this.isLeaf) {
            int keySize2;
            if (this.encryption == null) {
                keySize2 = this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
            } else {
                int encryptedSize = this.getIntValue(entryPosition);
                keySize2 = 4 + encryptedSize;
            }
            return this.getBinaryValue(startEntryPosition, keySize2 + 10);
        }
        entryPosition += 8;
        if (this.encryption == null) {
            keySize = this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
        } else {
            int encryptedSize = this.getIntValue(entryPosition);
            keySize = 4 + encryptedSize;
        }
        return this.getBinaryValue(startEntryPosition, keySize + 8);
    }

    public ORID getValue(int entryIndex) {
        assert (this.isLeaf);
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        if (this.encryption == null) {
            entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
        } else {
            int encryptedSize = this.getIntValue(entryPosition);
            entryPosition += 4 + encryptedSize;
        }
        short clusterId = this.getShortValue(entryPosition);
        long clusterPosition = this.getLongValue(entryPosition + 2);
        return new ORecordId(clusterId, clusterPosition);
    }

    byte[] getRawValue(int entryIndex) {
        assert (this.isLeaf);
        int entryPosition = this.getIntValue(entryIndex * 4 + 53);
        if (this.encryption == null) {
            entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
        } else {
            int encryptedSize = this.getIntValue(entryPosition);
            entryPosition += 4 + encryptedSize;
        }
        return this.getBinaryValue(entryPosition, 10);
    }

    public K getKey(int index) {
        int entryPosition = this.getIntValue(index * 4 + 53);
        if (!this.isLeaf) {
            entryPosition += 8;
        }
        if (this.encryption == null) {
            return this.deserializeFromDirectMemory(this.keySerializer, entryPosition);
        }
        int encryptedSize = this.getIntValue(entryPosition);
        byte[] encryptedKey = this.getBinaryValue(entryPosition += 4, encryptedSize);
        byte[] serializedKey = this.encryption.decrypt(encryptedKey);
        return this.keySerializer.deserializeNativeObject(serializedKey, 0);
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void addAll(List<byte[]> rawEntries) {
        for (int i = 0; i < rawEntries.size(); ++i) {
            this.appendRawEntry(i, rawEntries.get(i));
        }
        this.setIntValue(32, rawEntries.size());
    }

    public void shrink(int newSize) {
        ArrayList<byte[]> rawEntries = new ArrayList<byte[]>(newSize);
        for (int i = 0; i < newSize; ++i) {
            rawEntries.add(this.getRawEntry(i));
        }
        this.setIntValue(28, MAX_PAGE_SIZE_BYTES);
        int index = 0;
        for (byte[] entry : rawEntries) {
            this.appendRawEntry(index, entry);
            ++index;
        }
        this.setIntValue(32, newSize);
    }

    boolean addLeafEntry(int index, byte[] serializedKey, byte[] serializedValue) {
        int entrySize = serializedKey.length + serializedValue.length;
        assert (this.isLeaf);
        int size = this.getIntValue(32);
        int freePointer = this.getIntValue(28);
        if (freePointer - entrySize < (size + 1) * 4 + 53) {
            return false;
        }
        if (index <= size - 1) {
            this.moveData(53 + index * 4, 53 + (index + 1) * 4, (size - index) * 4);
        }
        this.setIntValue(28, freePointer -= entrySize);
        this.setIntValue(53 + index * 4, freePointer);
        this.setIntValue(32, size + 1);
        this.setBinaryValue(freePointer, serializedKey);
        this.setBinaryValue(freePointer + serializedKey.length, serializedValue);
        return true;
    }

    private void appendRawEntry(int index, byte[] rawEntry) {
        int freePointer = this.getIntValue(28);
        this.setIntValue(28, freePointer -= rawEntry.length);
        this.setIntValue(53 + index * 4, freePointer);
        this.setBinaryValue(freePointer, rawEntry);
    }

    public boolean addEntry(int index, SBTreeEntry<K> treeEntry, boolean updateNeighbors) {
        int keySize;
        byte[] serializedKey = this.keySerializer.serializeNativeAsWhole(treeEntry.key, (Object[])this.keyTypes);
        byte[] encryptedKey = null;
        if (this.encryption == null) {
            keySize = this.keySerializer.getObjectSize(treeEntry.key, (Object[])this.keyTypes);
        } else {
            encryptedKey = this.encryption.encrypt(serializedKey);
            keySize = encryptedKey.length + 4;
        }
        int entrySize = keySize;
        entrySize = this.isLeaf ? (entrySize += 10) : (entrySize += 8);
        int size = this.size();
        int freePointer = this.getIntValue(28);
        if (freePointer - entrySize < (size + 1) * 4 + 53) {
            return false;
        }
        if (index <= size - 1) {
            this.moveData(53 + index * 4, 53 + (index + 1) * 4, (size - index) * 4);
        }
        this.setIntValue(28, freePointer -= entrySize);
        this.setIntValue(53 + index * 4, freePointer);
        this.setIntValue(32, size + 1);
        if (this.isLeaf) {
            if (this.encryption == null) {
                freePointer += this.setBinaryValue(freePointer, serializedKey);
            } else {
                this.setIntValue(freePointer, encryptedKey.length);
                freePointer += 4;
                freePointer += this.setBinaryValue(freePointer, encryptedKey);
            }
            freePointer += this.setShortValue(freePointer, (short)treeEntry.value.getClusterId());
            this.setLongValue(freePointer, treeEntry.value.getClusterPosition());
        } else {
            freePointer += this.setIntValue(freePointer, treeEntry.leftChild);
            freePointer += this.setIntValue(freePointer, treeEntry.rightChild);
            if (this.encryption == null) {
                this.setBinaryValue(freePointer, serializedKey);
            } else {
                this.setIntValue(freePointer, encryptedKey.length);
                this.setBinaryValue(freePointer += 4, encryptedKey);
            }
            if (updateNeighbors && ++size > 1) {
                if (index < size - 1) {
                    int nextEntryPosition = this.getIntValue(53 + (index + 1) * 4);
                    this.setIntValue(nextEntryPosition, treeEntry.rightChild);
                }
                if (index > 0) {
                    int prevEntryPosition = this.getIntValue(53 + (index - 1) * 4);
                    this.setIntValue(prevEntryPosition + 4, treeEntry.leftChild);
                }
            }
        }
        return true;
    }

    void updateValue(int index, byte[] value) {
        int entryPosition = this.getIntValue(index * 4 + 53);
        if (this.encryption == null) {
            entryPosition += this.getObjectSizeInDirectMemory(this.keySerializer, entryPosition);
        } else {
            int encryptedValue = this.getIntValue(entryPosition);
            entryPosition += 4 + encryptedValue;
        }
        this.setBinaryValue(entryPosition, value);
    }

    void setLeftSibling(long pageIndex) {
        this.setLongValue(37, pageIndex);
    }

    public long getLeftSibling() {
        return this.getLongValue(37);
    }

    void setRightSibling(long pageIndex) {
        this.setLongValue(45, pageIndex);
    }

    public long getRightSibling() {
        return this.getLongValue(45);
    }

    public static final class SBTreeEntry<K>
    implements Comparable<SBTreeEntry<K>> {
        private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
        final int leftChild;
        final int rightChild;
        public final K key;
        public final ORID value;

        public SBTreeEntry(int leftChild, int rightChild, K key, ORID value) {
            this.leftChild = leftChild;
            this.rightChild = rightChild;
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SBTreeEntry that = (SBTreeEntry)o;
            return this.leftChild == that.leftChild && this.rightChild == that.rightChild && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.leftChild, this.rightChild, this.key, this.value);
        }

        public String toString() {
            return "SBTreeEntry{leftChild=" + this.leftChild + ", rightChild=" + this.rightChild + ", key=" + this.key + ", value=" + this.value + '}';
        }

        @Override
        public int compareTo(SBTreeEntry<K> other) {
            return this.comparator.compare(this.key, other.key);
        }
    }
}

