/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.LatestVersionRecordReader;
import com.orientechnologies.orient.core.db.document.RecordReader;
import com.orientechnologies.orient.core.db.document.SimpleRecordReader;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODirtyManager;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.storage.OBasicTransaction;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.tx.ORollbackException;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class OTransactionOptimistic
extends OTransactionRealAbstract {
    private static AtomicInteger txSerial = new AtomicInteger();
    protected boolean changed = true;
    private boolean alreadyCleared = false;
    private boolean usingLog = true;
    private int txStartCounter;
    private boolean sentToServer = false;

    public OTransactionOptimistic(ODatabaseDocumentInternal iDatabase) {
        super(iDatabase, txSerial.incrementAndGet());
    }

    @Override
    public void begin() {
        if (this.txStartCounter < 0) {
            throw new OTransactionException("Invalid value of TX counter.");
        }
        if (this.txStartCounter == 0) {
            this.status = OTransaction.TXSTATUS.BEGUN;
        }
        ++this.txStartCounter;
        if (this.txStartCounter > 1) {
            OLogManager.instance().debug((Object)this, "Transaction was already started and will be reused.", new Object[0]);
        }
    }

    @Override
    public void commit() {
        this.commit(false);
    }

    @Override
    public void commit(boolean force) {
        this.checkTransaction();
        if (this.txStartCounter < 0) {
            throw new OStorageException("Invalid value of tx counter");
        }
        this.txStartCounter = force ? 0 : --this.txStartCounter;
        if (this.txStartCounter == 0) {
            this.doCommit();
        } else if (this.txStartCounter > 0) {
            OLogManager.instance().debug((Object)this, "Nested transaction was closed but transaction itself was not committed.", new Object[0]);
        } else {
            throw new OTransactionException("Transaction was committed more times than it is started.");
        }
    }

    @Override
    public int amountOfNestedTxs() {
        return this.txStartCounter;
    }

    @Override
    public void rollback() {
        this.rollback(false, -1);
    }

    @Override
    public void internalRollback() {
        this.status = OTransaction.TXSTATUS.ROLLBACKING;
        this.database.getLocalCache().clear();
        for (ORecordOperation v : this.allEntries.values()) {
            ORecord rec = v.getRecord();
            rec.unload();
        }
        this.close();
        this.status = OTransaction.TXSTATUS.ROLLED_BACK;
    }

    @Override
    public void rollback(boolean force, int commitLevelDiff) {
        if (this.txStartCounter < 0) {
            throw new OStorageException("Invalid value of TX counter");
        }
        this.checkTransaction();
        this.txStartCounter += commitLevelDiff;
        this.status = OTransaction.TXSTATUS.ROLLBACKING;
        if (!force && this.txStartCounter > 0) {
            OLogManager.instance().debug((Object)this, "Nested transaction was closed but transaction itself was scheduled for rollback.", new Object[0]);
            return;
        }
        if (this.txStartCounter < 0) {
            throw new OTransactionException("Transaction was rolled back more times than it was started.");
        }
        OStorage storage = this.database.getStorage();
        if (storage instanceof OStorageProxy) {
            storage.rollback(this);
        }
        this.internalRollback();
    }

    @Override
    public ORecord loadRecord(ORID rid, ORecord iRecord, String fetchPlan, boolean ignoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY lockingStrategy) {
        return this.loadRecord(rid, iRecord, fetchPlan, ignoreCache, true, loadTombstone, lockingStrategy);
    }

    @Override
    public ORecord loadRecord(ORID rid, ORecord iRecord, String fetchPlan, boolean ignoreCache, boolean iUpdateCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY lockingStrategy) {
        this.checkTransaction();
        ORecord txRecord = this.getRecord(rid);
        if (txRecord == OBasicTransaction.DELETED_RECORD) {
            return null;
        }
        if (txRecord != null) {
            if (iRecord != null && txRecord != iRecord) {
                OLogManager.instance().warn((Object)this, "Found record in transaction with the same RID %s but different instance. Probably the record has been loaded from another transaction and reused on the current one: reload it from current transaction before to update or delete it", iRecord.getIdentity());
            }
            return txRecord;
        }
        if (rid.isTemporary()) {
            return null;
        }
        Object record = this.database.executeReadRecord((ORecordId)rid, iRecord, -1, fetchPlan, ignoreCache, iUpdateCache, loadTombstone, lockingStrategy, new SimpleRecordReader(this.database.isPrefetchRecords()));
        if (record != null && this.isolationLevel == OTransaction.ISOLATION_LEVEL.REPEATABLE_READ) {
            this.addRecord((ORecord)record, (byte)0, null);
        }
        return record;
    }

    @Override
    public ORecord loadRecordIfVersionIsNotLatest(ORID rid, int recordVersion, String fetchPlan, boolean ignoreCache) throws ORecordNotFoundException {
        this.checkTransaction();
        ORecord txRecord = this.getRecord(rid);
        if (txRecord == OBasicTransaction.DELETED_RECORD) {
            throw new ORecordNotFoundException(rid);
        }
        if (txRecord != null) {
            if (txRecord.getVersion() > recordVersion) {
                return txRecord;
            }
            return null;
        }
        if (rid.isTemporary()) {
            throw new ORecordNotFoundException(rid);
        }
        Object record = this.database.executeReadRecord((ORecordId)rid, null, recordVersion, fetchPlan, ignoreCache, !ignoreCache, false, OStorage.LOCKING_STRATEGY.NONE, new SimpleRecordReader(this.database.isPrefetchRecords()));
        if (record != null && this.isolationLevel == OTransaction.ISOLATION_LEVEL.REPEATABLE_READ) {
            this.addRecord((ORecord)record, (byte)0, null);
        }
        return record;
    }

    @Override
    public ORecord reloadRecord(ORID rid, ORecord iRecord, String fetchPlan, boolean ignoreCache) {
        return this.reloadRecord(rid, iRecord, fetchPlan, ignoreCache, true);
    }

    @Override
    public ORecord reloadRecord(ORID rid, ORecord passedRecord, String fetchPlan, boolean ignoreCache, boolean force) {
        Object record;
        this.checkTransaction();
        ORecord txRecord = this.getRecord(rid);
        if (txRecord == OBasicTransaction.DELETED_RECORD) {
            return null;
        }
        if (txRecord != null) {
            if (passedRecord != null && txRecord != passedRecord) {
                OLogManager.instance().warn((Object)this, "Found record in transaction with the same RID %s but different instance. Probably the record has been loaded from another transaction and reused on the current one: reload it from current transaction before to update or delete it", passedRecord.getIdentity());
            }
            return txRecord;
        }
        if (rid.isTemporary()) {
            return null;
        }
        try {
            RecordReader recordReader = force ? new SimpleRecordReader(this.database.isPrefetchRecords()) : new LatestVersionRecordReader();
            Object loadedRecord = this.database.executeReadRecord((ORecordId)rid, passedRecord, -1, fetchPlan, ignoreCache, !ignoreCache, false, OStorage.LOCKING_STRATEGY.NONE, recordReader);
            record = force ? loadedRecord : (loadedRecord == null ? passedRecord : loadedRecord);
        }
        catch (ORecordNotFoundException ignore) {
            return null;
        }
        if (record != null && this.isolationLevel == OTransaction.ISOLATION_LEVEL.REPEATABLE_READ) {
            this.addRecord((ORecord)record, (byte)0, null);
        }
        return record;
    }

    @Override
    public ORecord loadRecord(ORID rid, ORecord record, String fetchPlan, boolean ignoreCache) {
        return this.loadRecord(rid, record, fetchPlan, ignoreCache, false, OStorage.LOCKING_STRATEGY.NONE);
    }

    @Override
    public void deleteRecord(ORecord iRecord, ODatabase.OPERATION_MODE iMode) {
        if (!iRecord.getIdentity().isValid()) {
            return;
        }
        this.addRecord(iRecord, (byte)2, null);
    }

    @Override
    public ORecord saveRecord(ORecord iRecord, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<Integer> iRecordUpdatedCallback) {
        if (iRecord == null) {
            return null;
        }
        ORecordOperation recordOperation = null;
        boolean originalSaved = false;
        ODirtyManager dirtyManager = ORecordInternal.getDirtyManager(iRecord);
        do {
            Set<ORecord> newRecord = dirtyManager.getNewRecords();
            Set<ORecord> updatedRecord = dirtyManager.getUpdateRecords();
            dirtyManager.clear();
            if (newRecord != null) {
                for (ORecord rec : newRecord) {
                    if (rec instanceof ODocument) {
                        ODocumentInternal.convertAllMultiValuesToTrackedVersions((ODocument)rec);
                    }
                    if (rec == iRecord) {
                        recordOperation = this.addRecord(rec, (byte)3, iClusterName);
                        originalSaved = true;
                        continue;
                    }
                    this.addRecord(rec, (byte)3, this.getClusterName(rec));
                }
            }
            if (updatedRecord == null) continue;
            for (ORecord rec : updatedRecord) {
                if (rec instanceof ODocument) {
                    ODocumentInternal.convertAllMultiValuesToTrackedVersions((ODocument)rec);
                }
                if (rec == iRecord) {
                    byte operation = iForceCreate ? (byte)3 : (iRecord.getIdentity().isValid() ? (byte)1 : 3);
                    recordOperation = this.addRecord(rec, operation, iClusterName);
                    originalSaved = true;
                    continue;
                }
                this.addRecord(rec, (byte)1, this.getClusterName(rec));
            }
        } while (dirtyManager.getNewRecords() != null || dirtyManager.getUpdateRecords() != null);
        if (!originalSaved && iRecord.isDirty()) {
            byte operation = iForceCreate ? (byte)3 : (iRecord.getIdentity().isValid() ? (byte)1 : 3);
            recordOperation = this.addRecord(iRecord, operation, iClusterName);
        }
        if (recordOperation != null) {
            if (iRecordCreatedCallback != null) {
                recordOperation.createdCallback = iRecordCreatedCallback;
            }
            if (iRecordUpdatedCallback != null) {
                recordOperation.updatedCallback = iRecordUpdatedCallback;
            }
        }
        return iRecord;
    }

    public String toString() {
        return "OTransactionOptimistic [id=" + this.id + ", status=" + (Object)((Object)this.status) + ", recEntries=" + this.allEntries.size() + ", idxEntries=" + this.indexEntries.size() + ']';
    }

    @Override
    public boolean isUsingLog() {
        return this.usingLog;
    }

    @Override
    public void setUsingLog(boolean useLog) {
        this.usingLog = useLog;
    }

    @Override
    public void setStatus(OTransaction.TXSTATUS iStatus) {
        this.status = iStatus;
    }

    public ORecordOperation addRecord(ORecord iRecord, byte iStatus, String iClusterName) {
        this.changed = true;
        this.checkTransaction();
        if (iClusterName == null) {
            iClusterName = this.database.getClusterNameById(iRecord.getIdentity().getClusterId());
        }
        if (iStatus != 0) {
            this.changedDocuments.remove(iRecord);
        }
        try {
            Comparable<OIdentifiable> res;
            ORecordId rid = (ORecordId)iRecord.getIdentity();
            ORecordOperation txEntry = this.getRecordEntry(rid);
            if (iStatus == 3 && txEntry != null) {
                iStatus = 1;
            }
            switch (iStatus) {
                case 3: {
                    res = this.database.beforeCreateOperations(iRecord, iClusterName);
                    if (res == null) break;
                    iRecord = (ORecord)res;
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    res = this.database.beforeUpdateOperations(iRecord, iClusterName);
                    if (res == null) break;
                    iRecord = (ORecord)res;
                    break;
                }
                case 2: {
                    this.database.beforeDeleteOperations(iRecord, iClusterName);
                }
            }
            try {
                if (!rid.isValid()) {
                    ORecordInternal.onBeforeIdentityChanged(iRecord);
                    this.database.assignAndCheckCluster(iRecord, iClusterName);
                    rid.setClusterPosition(this.newObjectCounter--);
                    ORecordInternal.onAfterIdentityChanged(iRecord);
                }
                if (txEntry == null) {
                    if (!rid.isTemporary() || iStatus == 3) {
                        txEntry = new ORecordOperation(iRecord, iStatus);
                        this.allEntries.put(rid.copy(), txEntry);
                    }
                } else {
                    txEntry.record = iRecord;
                    switch (txEntry.type) {
                        case 0: {
                            switch (iStatus) {
                                case 1: {
                                    txEntry.type = 1;
                                    break;
                                }
                                case 2: {
                                    txEntry.type = (byte)2;
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (iStatus) {
                                case 2: {
                                    txEntry.type = (byte)2;
                                }
                            }
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            switch (iStatus) {
                                case 2: {
                                    this.allEntries.remove(rid);
                                }
                            }
                        }
                    }
                }
                switch (iStatus) {
                    case 3: {
                        this.database.afterCreateOperations(iRecord);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.database.afterUpdateOperations(iRecord);
                        break;
                    }
                    case 2: {
                        this.database.afterDeleteOperations(iRecord);
                    }
                }
                if (iRecord instanceof ODocument && ((ODocument)iRecord).isTrackingChanges()) {
                    ODocumentInternal.clearTrackData((ODocument)iRecord);
                }
                res = txEntry;
                return res;
            }
            catch (Exception e) {
                switch (iStatus) {
                    case 3: {
                        this.database.callbackHooks(ORecordHook.TYPE.CREATE_FAILED, iRecord);
                        break;
                    }
                    case 1: {
                        this.database.callbackHooks(ORecordHook.TYPE.UPDATE_FAILED, iRecord);
                        break;
                    }
                    case 2: {
                        this.database.callbackHooks(ORecordHook.TYPE.DELETE_FAILED, iRecord);
                    }
                }
                throw OException.wrapException(new ODatabaseException("Error on saving record " + iRecord.getIdentity()), e);
            }
        }
        finally {
            switch (iStatus) {
                case 3: {
                    this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_CREATION, iRecord);
                    break;
                }
                case 1: {
                    this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_UPDATE, iRecord);
                    break;
                }
                case 2: {
                    this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_DELETION, iRecord);
                }
            }
        }
    }

    private void doCommit() {
        if (this.status == OTransaction.TXSTATUS.ROLLED_BACK || this.status == OTransaction.TXSTATUS.ROLLBACKING) {
            throw new ORollbackException("Given transaction was rolled back and cannot be used.");
        }
        this.status = OTransaction.TXSTATUS.COMMITTING;
        if (this.sentToServer || !this.allEntries.isEmpty() || !this.indexEntries.isEmpty()) {
            this.database.internalCommit(this);
        }
        this.invokeCallbacks();
        this.close();
        this.status = OTransaction.TXSTATUS.COMPLETED;
    }

    private void invokeCallbacks() {
        for (ORecordOperation recordOperation : this.allEntries.values()) {
            ORecord record = recordOperation.getRecord();
            ORID identity = record.getIdentity();
            if (recordOperation.type == 3 && recordOperation.createdCallback != null) {
                recordOperation.createdCallback.call(new ORecordId(identity), identity.getClusterPosition());
                continue;
            }
            if (recordOperation.type != 1 || recordOperation.updatedCallback == null) continue;
            recordOperation.updatedCallback.call(new ORecordId(identity), record.getVersion());
        }
    }

    @Override
    public void addIndexEntry(OIndex<?> delegate, String iIndexName, OTransactionIndexChanges.OPERATION iOperation, Object key, OIdentifiable iValue, boolean clientTrackOnly) {
        this.changed = true;
        super.addIndexEntry(delegate, iIndexName, iOperation, key, iValue, clientTrackOnly);
    }

    public void resetChangesTracking() {
        this.alreadyCleared = true;
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isAlreadyCleared() {
        return this.alreadyCleared;
    }

    public void setSentToServer(boolean sentToServer) {
        this.sentToServer = sentToServer;
    }

    public boolean getSentToServer() {
        return this.sentToServer;
    }
}

