/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.orient.core.serialization.OStreamableHelper;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponseManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class ODistributedResponse {
    private ODistributedResponseManager distributedResponseManager;
    private ODistributedRequestId requestId;
    private String executorNodeName;
    private String senderNodeName;
    private Object payload;

    public ODistributedResponse() {
    }

    public ODistributedResponse(ODistributedResponseManager msg, ODistributedRequestId iRequestId, String executorNodeName, String senderNodeName, Object payload) {
        this.distributedResponseManager = msg;
        this.requestId = iRequestId;
        this.executorNodeName = executorNodeName;
        this.senderNodeName = senderNodeName;
        this.payload = payload;
    }

    public ODistributedRequestId getRequestId() {
        return this.requestId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ODistributedResponse && ((ODistributedResponse)obj).payload != null) {
            return ((ODistributedResponse)obj).payload.equals(this.payload);
        }
        return false;
    }

    public String getExecutorNodeName() {
        return this.executorNodeName;
    }

    public String getSenderNodeName() {
        return this.senderNodeName;
    }

    public Object getPayload() {
        return this.payload;
    }

    public ODistributedResponse setPayload(Object payload) {
        this.payload = payload;
        return this;
    }

    public ODistributedResponse setExecutorNodeName(String executorNodeName) {
        this.executorNodeName = executorNodeName;
        return this;
    }

    public void toStream(DataOutput out) throws IOException {
        this.requestId.toStream(out);
        out.writeUTF(this.executorNodeName);
        out.writeUTF(this.senderNodeName);
        OStreamableHelper.toStream(out, this.payload);
    }

    public void fromStream(DataInput in) throws IOException {
        this.requestId = new ODistributedRequestId();
        this.requestId.fromStream(in);
        this.executorNodeName = in.readUTF();
        this.senderNodeName = in.readUTF();
        this.payload = OStreamableHelper.fromStream(in);
    }

    public ODistributedResponseManager getDistributedResponseManager() {
        return this.distributedResponseManager;
    }

    public String toString() {
        if (this.payload == null) {
            return "null";
        }
        if (this.payload.getClass().isArray()) {
            return Arrays.toString((Object[])this.payload);
        }
        return this.payload.toString();
    }

    public void setDistributedResponseManager(ODistributedResponseManager distributedResponseManager) {
        this.distributedResponseManager = distributedResponseManager;
    }
}

