/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostImportDatabase;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostUploadSingleFile;
import java.io.IOException;
import java.net.Socket;

public class ONetworkProtocolHttpDb
extends ONetworkProtocolHttpAbstract {
    private static final int CURRENT_PROTOCOL_VERSION = 10;

    public ONetworkProtocolHttpDb(OServer server) {
        super(server);
    }

    @Override
    public void config(OServerNetworkListener iListener, OServer iServer, Socket iSocket, OContextConfiguration iConfiguration) throws IOException {
        this.server = iServer;
        this.setName("OrientDB HTTP Connection " + iSocket.getLocalAddress() + ":" + iSocket.getLocalPort() + "<-" + iSocket.getRemoteSocketAddress());
        super.config(iListener, this.server, iSocket, iConfiguration);
        this.cmdManager.registerCommand(new OServerCommandPostImportDatabase());
        this.cmdManager.registerCommand(new OServerCommandPostUploadSingleFile());
        this.connection.getData().serverInfo = iConfiguration.getValueAsString(OGlobalConfiguration.NETWORK_HTTP_SERVER_INFO);
    }

    @Override
    public int getVersion() {
        return 10;
    }

    @Override
    public String getType() {
        return "http";
    }

    @Override
    protected void afterExecution() throws InterruptedException {
        ODatabaseRecordThreadLocal.instance().remove();
    }

    @Override
    public OBinaryRequestExecutor executor(OClientConnection connection) {
        return null;
    }
}

