/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;

public class OServerCommandPostDocument
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"POST|document/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        this.checkSyntax(iRequest.url, 2, "Syntax error: document/<database>");
        iRequest.data.commandInfo = "Create document";
        try (ODatabaseDocumentInternal db = null;){
            db = this.getProfiledDatabaseInstance(iRequest);
            ODocument doc = new ODocument().fromJSON(iRequest.content);
            ORecordInternal.setVersion(doc, 0);
            ((ORecordId)doc.getIdentity()).setClusterPosition(-1L);
            doc.save();
            iResponse.send(201, "Created", "application/json", doc.toJSON(), "ETag: " + doc.getVersion());
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

