/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.security.authenticator;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerConfigurationManager;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.security.OSecurityAuthenticatorAbstract;

public class OServerConfigAuthenticator
extends OSecurityAuthenticatorAbstract {
    @Override
    public void active() {
        OLogManager.instance().info((Object)this, "OServerConfigAuthenticator is active", new Object[0]);
    }

    @Override
    public String authenticate(String username, String password) {
        String principal = null;
        try {
            if (this.getServerConfig() != null) {
                OServerUserConfiguration userCfg = null;
                if (username != null && !username.isEmpty()) {
                    userCfg = this.getServerConfig().getUser(username);
                }
                if (userCfg != null && userCfg.password != null && OSecurityManager.instance().checkPassword(password, userCfg.password)) {
                    principal = userCfg.name;
                }
            } else {
                OLogManager.instance().error(this, "OServerConfigAuthenticator.authenticate() ServerConfig is null", null, new Object[0]);
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error(this, "OServerConfigAuthenticator.authenticate()", ex, new Object[0]);
        }
        return principal;
    }

    @Override
    public void config(OServer oServer, OServerConfigurationManager serverCfg, ODocument jsonConfig) {
        super.config(oServer, serverCfg, jsonConfig);
    }

    @Override
    public OServerUserConfiguration getUser(String username) {
        OServerUserConfiguration userCfg = null;
        if (this.getServerConfig() != null) {
            userCfg = this.getServerConfig().getUser(username);
        }
        return userCfg;
    }

    @Override
    public boolean isAuthorized(String username, String resource) {
        if (username == null || resource == null) {
            return false;
        }
        if (this.getServerConfig() != null) {
            OServerUserConfiguration userCfg;
            if (!username.isEmpty() && (userCfg = this.getServerConfig().getUser(username)) != null) {
                String[] resourceParts;
                if (userCfg.resources.equals("*")) {
                    return true;
                }
                for (String r : resourceParts = userCfg.resources.split(",")) {
                    if (!r.equalsIgnoreCase(resource)) continue;
                    return true;
                }
            }
        } else {
            OLogManager.instance().error(this, "OServerConfigAuthenticator.isAuthorized() ServerConfig is null", null, new Object[0]);
        }
        return false;
    }

    @Override
    protected boolean isCaseSensitive() {
        return false;
    }
}

