/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyAbstractDelegate;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElementType;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;

public class OrientVertexType
extends OrientElementType {
    public static final String CLASS_NAME = "V";

    public OrientVertexType(OrientBaseGraph graph, OClass delegate) {
        super(graph, delegate);
    }

    protected static void checkType(OClass iType) {
        if (iType == null) {
            throw new IllegalArgumentException("Vertex class is null");
        }
        if (iType instanceof OImmutableClass && !((OImmutableClass)iType).isVertexType() || !iType.isSubClassOf(CLASS_NAME)) {
            throw new IllegalArgumentException("Type error. The class '" + iType + "' does not extend class '" + CLASS_NAME + "' and therefore cannot be considered a Vertex");
        }
    }

    public OrientVertexProperty createEdgeProperty(Direction iDirection, String iEdgeClassName) {
        return this.createEdgeProperty(iDirection, iEdgeClassName, OType.ANY);
    }

    public OrientVertexProperty createEdgeProperty(final Direction iDirection, final String iEdgeClassName, final OType iType) {
        return this.graph.executeOutsideTx(new OCallable<OrientVertexProperty, OrientBaseGraph>(){

            @Override
            public OrientVertexProperty call(OrientBaseGraph iArgument) {
                String clsName = OrientBaseGraph.encodeClassName(iEdgeClassName);
                boolean useVertexFieldsForEdgeLabels = OrientVertexType.this.graph.isUseVertexFieldsForEdgeLabels();
                String fieldName = OrientVertex.getConnectionFieldName(iDirection, clsName, useVertexFieldsForEdgeLabels);
                return new OrientVertexProperty(OrientVertexType.this.graph, OrientVertexType.this.delegate.createProperty(fieldName, iType));
            }
        }, new String[0]);
    }

    @Override
    public OrientVertexType getSuperClass() {
        return new OrientVertexType(this.graph, super.getSuperClass());
    }

    @Override
    public OrientVertexType addCluster(String iClusterName) {
        this.delegate.addCluster(iClusterName);
        return this;
    }

    @Override
    public boolean isEdgeType() {
        return false;
    }

    @Override
    public boolean isVertexType() {
        return true;
    }

    @Override
    public OrientVertexProperty createProperty(String iPropertyName, OType iType, OClass iLinkedClass) {
        return new OrientVertexProperty(this.graph, super.createProperty(iPropertyName, iType, iLinkedClass));
    }

    @Override
    public OrientVertexProperty createProperty(String iPropertyName, OType iType, OType iLinkedType) {
        return new OrientVertexProperty(this.graph, super.createProperty(iPropertyName, iType, iLinkedType));
    }

    @Override
    public OrientVertexProperty createProperty(String iPropertyName, OType iType) {
        return new OrientVertexProperty(this.graph, super.createProperty(iPropertyName, iType));
    }

    @Override
    protected String getTypeName() {
        return "vertex";
    }

    public class OrientVertexProperty
    extends OPropertyAbstractDelegate {
        public static final String ORDERED = "ordered";
        protected final OrientBaseGraph graph;

        public OrientVertexProperty(OrientBaseGraph iGraph, OProperty iProperty) {
            super(iProperty);
            this.graph = iGraph;
        }

        public boolean isOrdered() {
            String value = this.delegate.getCustom(ORDERED);
            return Boolean.parseBoolean(value);
        }

        public OrientVertexProperty setOrdered(boolean iOrdered) {
            this.delegate.setCustom(ORDERED, Boolean.toString(iOrdered));
            return this;
        }
    }
}

