/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.dataprovider;

import com.arcadeanalytics.provider.CytoData;
import com.arcadeanalytics.provider.Data;
import com.arcadeanalytics.provider.GraphData;
import com.arcadeanalytics.provider.Position;
import com.arcadeanalytics.provider.rdbms.dataprovider.RDBMSDataProvider;
import com.arcadeanalytics.provider.rdbms.mapper.rdbms.ER2GraphMapper;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Attribute;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Entity;
import com.arcadeanalytics.provider.rdbms.model.dbschema.PrimaryKey;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Relationship;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.ModelProperty;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.VertexType;
import com.arcadeanalytics.provider.rdbms.persistence.util.QueryResult;
import com.arcadeanalytics.provider.rdbms.persistence.util.RelationshipQueryResult;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFetcher {
    private final Logger log = LoggerFactory.getLogger(RDBMSDataProvider.class);
    private ER2GraphMapper mapper;

    public ER2GraphMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ER2GraphMapper mapper) {
        this.mapper = mapper;
    }

    public GraphData mapResultSet(QueryResult queryResult, Entity entity, List<RelationshipQueryResult> outCountResult, List<RelationshipQueryResult> inCountResult) throws SQLException {
        LinkedHashSet<CytoData> cytoNodes = new LinkedHashSet<CytoData>();
        LinkedHashSet cytoEdges = new LinkedHashSet();
        LinkedHashMap nodeClasses = new LinkedHashMap();
        LinkedHashMap edgeClasses = new LinkedHashMap();
        ResultSet scanningRecords = queryResult.getResult();
        String vertexClassName = this.mapper.getVertexTypeByEntity(entity).getName();
        VertexType vertexType = this.mapper.getVertexTypeByEntity(entity);
        Set<ModelProperty> vertexTypeProperties = vertexType.getAllProperties();
        LinkedHashMap<String, String> property2type = new LinkedHashMap<String, String>();
        for (ModelProperty currProperty : vertexTypeProperties) {
            property2type.put(currProperty.getName(), currProperty.getOrientdbType());
        }
        nodeClasses.put(vertexClassName, property2type);
        while (scanningRecords.next()) {
            String relationshipName;
            int cardinality;
            ResultSet currentCountRecord;
            this.log.debug("current record:: {} ", (Object)scanningRecords);
            LinkedHashMap<String, Integer> outRelationshipName2cardinality = new LinkedHashMap<String, Integer>();
            LinkedHashMap<String, Integer> inRelationshipName2cardinality = new LinkedHashMap<String, Integer>();
            int totalEdgeCount = 0;
            for (RelationshipQueryResult currentOutRelationshipsCount : outCountResult) {
                ResultSet currentOutRelationshipsCursor = currentOutRelationshipsCount.getResult();
                if (!currentOutRelationshipsCursor.next()) continue;
                currentCountRecord = currentOutRelationshipsCursor;
                cardinality = currentCountRecord.getInt("connectionsCount");
                totalEdgeCount += cardinality;
                relationshipName = currentOutRelationshipsCount.getRelationshipName();
                if (outRelationshipName2cardinality.get(relationshipName) != null) {
                    cardinality += ((Integer)outRelationshipName2cardinality.get(relationshipName)).intValue();
                }
                outRelationshipName2cardinality.put(relationshipName, cardinality);
            }
            for (RelationshipQueryResult currentInRelationshipsCount : inCountResult) {
                ResultSet currentInRelationshipsCursor = currentInRelationshipsCount.getResult();
                if (!currentInRelationshipsCursor.next()) continue;
                currentCountRecord = currentInRelationshipsCursor;
                cardinality = currentCountRecord.getInt("connectionsCount");
                totalEdgeCount += cardinality;
                relationshipName = currentInRelationshipsCount.getRelationshipName();
                if (inRelationshipName2cardinality.get(relationshipName) != null) {
                    cardinality += ((Integer)inRelationshipName2cardinality.get(relationshipName)).intValue();
                }
                inRelationshipName2cardinality.put(currentInRelationshipsCount.getRelationshipName(), cardinality);
            }
            CytoData currentConvertedData = this.toData(scanningRecords, entity, vertexClassName, totalEdgeCount, outRelationshipName2cardinality, inRelationshipName2cardinality);
            cytoNodes.add(currentConvertedData);
        }
        GraphData data = new GraphData(nodeClasses, edgeClasses, cytoNodes, cytoEdges, false);
        return data;
    }

    private CytoData toData(ResultSet sourceRecord, Entity entity, String vertexClassName, int edgeCount, Map<String, Integer> outRelationshipName2cardinality, Map<String, Integer> inRelationshipName2cardinality) throws SQLException {
        String id = this.getCytoIdFromPrimaryKey(sourceRecord, entity);
        LinkedHashMap<String, Object> targetRecord = new LinkedHashMap<String, Object>();
        for (Attribute attribute : entity.getAllAttributes()) {
            String propertyName = this.mapper.getPropertyNameByEntityAndAttribute(entity, attribute.getName());
            if (attribute.getDataType().equals("_text")) {
                Object[] arrayValues = (String[])sourceRecord.getArray(attribute.getName()).getArray();
                String stringifiedArray = Arrays.toString(arrayValues);
                targetRecord.put(propertyName, stringifiedArray);
                continue;
            }
            targetRecord.put(propertyName, sourceRecord.getObject(attribute.getName()));
        }
        targetRecord.put("@out", outRelationshipName2cardinality);
        targetRecord.put("@in", inRelationshipName2cardinality);
        targetRecord.put("@edgeCount", edgeCount);
        Data data = new Data(id, "", "", "", targetRecord);
        CytoData cyto = new CytoData(vertexClassName, "nodes", data, new Position(0.0, 0.0), "", "", "", "");
        return cyto;
    }

    @NotNull
    private String getCytoIdFromPrimaryKey(ResultSet sourceRecord, Entity entity) throws SQLException {
        PrimaryKey primaryKey = entity.getPrimaryKey();
        String id = entity.getSchemaPosition() + "_";
        for (Attribute attribute : primaryKey.getInvolvedAttributes()) {
            id = id + sourceRecord.getString(attribute.getName()) + "_";
        }
        id = id.substring(0, id.lastIndexOf("_"));
        return id;
    }

    public GraphData buildEdgesFromJoinResultAndRelationship(QueryResult queryResult, Relationship relationship, String direction) throws SQLException {
        ResultSet scanningRecords = queryResult.getResult();
        scanningRecords.beforeFirst();
        LinkedHashSet cytoNodes = new LinkedHashSet();
        LinkedHashSet<CytoData> cytoEdges = new LinkedHashSet<CytoData>();
        LinkedHashMap nodeClasses = new LinkedHashMap();
        LinkedHashMap edgeClasses = new LinkedHashMap();
        String edgeClassName = this.mapper.getRelationship2edgeType().get(relationship).getName();
        LinkedHashMap edgeClassInfo = new LinkedHashMap();
        edgeClasses.put(edgeClassName, edgeClassInfo);
        while (scanningRecords.next()) {
            String sourceId = null;
            String targetId = null;
            Entity foreignEntity = relationship.getForeignEntity();
            Entity parentEntity = relationship.getParentEntity();
            if (direction.equals("in")) {
                sourceId = this.getCytoIdFromPrimaryKey(scanningRecords, foreignEntity);
                targetId = parentEntity.getSchemaPosition() + "";
                for (Attribute currColumn : parentEntity.getPrimaryKey().getInvolvedAttributes()) {
                    targetId = targetId + "_" + scanningRecords.getString(currColumn.getName());
                }
            } else if (direction.equals("out")) {
                sourceId = foreignEntity.getSchemaPosition() + "";
                for (Attribute currColumn : foreignEntity.getPrimaryKey().getInvolvedAttributes()) {
                    sourceId = sourceId + "_" + scanningRecords.getString(currColumn.getName());
                }
                targetId = this.getCytoIdFromPrimaryKey(scanningRecords, parentEntity);
            }
            String edgeId = sourceId.replaceAll("_", "") + "_" + targetId.replaceAll("_", "");
            LinkedHashMap targetEdgeRecord = new LinkedHashMap();
            Data data = new Data(edgeId, "", sourceId, targetId, targetEdgeRecord);
            CytoData cyto = new CytoData(edgeClassName, "edges", data, new Position(0.0, 0.0), "", "", "", "");
            cytoEdges.add(cyto);
        }
        GraphData graphData = new GraphData(nodeClasses, edgeClasses, cytoNodes, cytoEdges, false);
        return graphData;
    }

    public GraphData buildEdgesFromJoinTableRecords(QueryResult queryResult, String edgeClassName, Entity firstExternalEntity, Entity joinTable, Entity secondExternalEntity, String direction) throws SQLException {
        ResultSet scanningRecords = queryResult.getResult();
        scanningRecords.beforeFirst();
        LinkedHashSet cytoNodes = new LinkedHashSet();
        LinkedHashSet<CytoData> cytoEdges = new LinkedHashSet<CytoData>();
        LinkedHashMap nodeClasses = new LinkedHashMap();
        LinkedHashMap edgeClasses = new LinkedHashMap();
        LinkedHashMap edgeClassInfo = new LinkedHashMap();
        edgeClasses.put(edgeClassName, edgeClassInfo);
        while (scanningRecords.next()) {
            String sourceId = null;
            String targetId = null;
            if (direction.equals("in")) {
                sourceId = this.getCytoIdFromPrimaryKey(scanningRecords, secondExternalEntity);
                targetId = this.getCytoIdFromPrimaryKey(scanningRecords, firstExternalEntity);
            } else if (direction.equals("out")) {
                sourceId = this.getCytoIdFromPrimaryKey(scanningRecords, firstExternalEntity);
                targetId = this.getCytoIdFromPrimaryKey(scanningRecords, secondExternalEntity);
            }
            String edgeId = this.getCytoIdFromPrimaryKey(scanningRecords, joinTable);
            LinkedHashMap<String, Object> targetEdgeRecord = new LinkedHashMap<String, Object>();
            for (Attribute a : joinTable.getAllAttributes()) {
                if (joinTable.getPrimaryKey().getInvolvedAttributes().contains(a)) continue;
                String fieldName = a.getName();
                Object fieldValue = scanningRecords.getObject(fieldName);
                targetEdgeRecord.put(fieldName, fieldValue);
            }
            Data data = new Data(edgeId, "", sourceId, targetId, targetEdgeRecord);
            CytoData cyto = new CytoData(edgeClassName, "edges", data, new Position(0.0, 0.0), "", "", "", "");
            cytoEdges.add(cyto);
        }
        GraphData graphData = new GraphData(nodeClasses, edgeClasses, cytoNodes, cytoEdges, false);
        return graphData;
    }
}

