/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.dataprovider;

import com.arcadeanalytics.data.Sprite;
import com.arcadeanalytics.data.SpritePlayer;
import com.arcadeanalytics.provider.DataSourceGraphProvider;
import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.rdbms.context.Statistics;
import com.arcadeanalytics.provider.rdbms.dbengine.DBQueryEngine;
import com.arcadeanalytics.provider.rdbms.exception.RDBMSProviderIOException;
import com.arcadeanalytics.provider.rdbms.exception.RDBMSProviderRuntimeException;
import com.arcadeanalytics.provider.rdbms.factory.DataTypeHandlerFactory;
import com.arcadeanalytics.provider.rdbms.factory.NameResolverFactory;
import com.arcadeanalytics.provider.rdbms.factory.StrategyFactory;
import com.arcadeanalytics.provider.rdbms.mapper.rdbms.ER2GraphMapper;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Attribute;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Entity;
import com.arcadeanalytics.provider.rdbms.model.dbschema.PrimaryKey;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.VertexType;
import com.arcadeanalytics.provider.rdbms.nameresolver.NameResolver;
import com.arcadeanalytics.provider.rdbms.persistence.handler.DBMSDataTypeHandler;
import com.arcadeanalytics.provider.rdbms.persistence.util.DBSourceConnection;
import com.arcadeanalytics.provider.rdbms.persistence.util.QueryResult;
import com.arcadeanalytics.provider.rdbms.strategy.rdbms.AbstractDBMSModelBuildingStrategy;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBMSGraphProvider
implements DataSourceGraphProvider {
    private final Logger log = LoggerFactory.getLogger(RDBMSGraphProvider.class);

    public void provideTo(DataSourceInfo datasource, SpritePlayer player) {
        Statistics statistics = new Statistics();
        String connectionUrl = DBSourceConnection.createConnectionUrl(datasource);
        try {
            String query;
            ER2GraphMapper mapper = this.prepareMapperAndDataFetcher(datasource, statistics);
            DBQueryEngine dbQueryEngine = new DBQueryEngine(datasource, 300);
            Map<Entity, Integer> entity2count = this.countEntities(datasource, mapper);
            for (Map.Entry<Entity, Integer> entry : entity2count.entrySet()) {
                Entity currentEntity = entry.getKey();
                String tableName = entry.getKey().getName();
                query = "select * from " + tableName;
                if (datasource.getType().equals("RDBMS_DATA_WORLD")) {
                    query = "select " + tableName + ".*, row_index from " + tableName;
                }
                int count = entry.getValue();
                this.log.info("fetching data from source'{}', table '{}' with query '{}' - total records '{}' ", new Object[]{connectionUrl, tableName, query, count});
                QueryResult queryResult = dbQueryEngine.executeQuery(query, datasource);
                ResultSet result = queryResult.getResult();
                while (result.next()) {
                    ResultSet currentRecord = result;
                    ResultSetMetaData rsmd = currentRecord.getMetaData();
                    int columnCount = rsmd.getColumnCount();
                    String id = this.getCytoIdFromPrimaryKey(currentRecord, currentEntity);
                    String vertexClassName = mapper.getVertexTypeByEntity(currentEntity).getName();
                    Sprite document = new Sprite().add("@class", vertexClassName).add("_a_id", id).add("_a_type", "node");
                    for (int i = 1; i <= columnCount; ++i) {
                        document.add(rsmd.getColumnName(i), currentRecord.getObject(i));
                    }
                    player.play(document);
                }
                player.end();
                queryResult.close();
            }
            player.end();
            if (datasource.isAggregationEnabled()) {
                Map<Entity, Integer> jointTable2count = this.countJoinTables(datasource, mapper);
                for (Map.Entry<Entity, Integer> entry : jointTable2count.entrySet()) {
                    Entity currentEntity = entry.getKey();
                    if (!currentEntity.isAggregableJoinTable()) continue;
                    query = "select * from " + entry.getKey().getName();
                    String tableName = query.substring(query.lastIndexOf("from ") + 5);
                    int count = entry.getValue();
                    this.log.info("fetching data from source'{}', table '{}' with query '{}' - total records '{}' ", new Object[]{connectionUrl, tableName, query, count});
                    QueryResult queryResult = dbQueryEngine.executeQuery(query, datasource);
                    ResultSet result = queryResult.getResult();
                    while (result.next()) {
                        ResultSet currentRecord = result;
                        ResultSetMetaData rsmd = currentRecord.getMetaData();
                        int columnCount = rsmd.getColumnCount();
                        String id = this.getCytoIdFromPrimaryKey(currentRecord, currentEntity);
                        VertexType vertextype = mapper.getVertexTypeByEntity(currentEntity);
                        String edgeClassName = mapper.getAggregatorEdgeByJoinVertexTypeName(vertextype.getName()).getEdgeType().getName();
                        Sprite document = new Sprite().add("@class", edgeClassName).add("_a_id", id).add("_a_type", "edge");
                        List pkColumnsNames = currentEntity.getPrimaryKey().getInvolvedAttributes().stream().map(attribute -> attribute.getName()).collect(Collectors.toList());
                        for (int i = 1; i <= columnCount; ++i) {
                            if (pkColumnsNames.contains(rsmd.getColumnName(i))) continue;
                            document.add(rsmd.getColumnName(i), currentRecord.getObject(i));
                        }
                        player.play(document);
                    }
                    player.end();
                    queryResult.close();
                }
            }
            player.end();
            dbQueryEngine.close();
        }
        catch (Exception e) {
            this.log.error("error while connecting to  " + datasource, (Throwable)e);
        }
    }

    public ER2GraphMapper prepareMapperAndDataFetcher(DataSourceInfo datasource, Statistics statistics) {
        DBQueryEngine dbQueryEngine = new DBQueryEngine(datasource, 300);
        Boolean aggregate = datasource.isAggregationEnabled();
        String chosenStrategy = aggregate != false ? "interactive-aggr" : "interactive";
        DataTypeHandlerFactory dataTypeHandlerFactory = new DataTypeHandlerFactory();
        DBMSDataTypeHandler handler = dataTypeHandlerFactory.buildDataTypeHandler(datasource.getType());
        NameResolverFactory nameResolverFactory = new NameResolverFactory();
        NameResolver nameResolver = nameResolverFactory.buildNameResolver("original");
        StrategyFactory strategyFactory = new StrategyFactory();
        try {
            ER2GraphMapper mapper = ((AbstractDBMSModelBuildingStrategy)strategyFactory.buildStrategy(chosenStrategy)).createSchemaMapper(datasource, null, "basicDBMapper", null, nameResolver, handler, null, null, chosenStrategy, dbQueryEngine, statistics);
            return mapper;
        }
        catch (RDBMSProviderIOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<Entity, Integer> countEntities(DataSourceInfo datasource, ER2GraphMapper mapper) throws Exception {
        try (Connection connection = DBSourceConnection.getConnection(datasource);){
            LinkedHashMap<Entity, Integer> entity2count = new LinkedHashMap<Entity, Integer>();
            List<Entity> entities = mapper.getDataBaseSchema().getEntities();
            if (datasource.isAggregationEnabled()) {
                entities = entities.stream().filter(entity -> !entity.isAggregableJoinTable()).collect(Collectors.toList());
            }
            for (Entity currEntity : entities) {
                String tableName = currEntity.getName();
                String countQuery = "select count(*) from " + tableName;
                Statement countStatement = connection.createStatement(1003, 1007);
                ResultSet resultCount = countStatement.executeQuery(countQuery);
                resultCount.next();
                int count = resultCount.getInt(1);
                entity2count.put(currEntity, count);
                resultCount.close();
                countStatement.close();
            }
            LinkedHashMap<Entity, Integer> linkedHashMap = entity2count;
            return linkedHashMap;
        }
        catch (SQLException e) {
            throw new RDBMSProviderRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<Entity, Integer> countJoinTables(DataSourceInfo datasource, ER2GraphMapper mapper) throws Exception {
        try (Connection connection = DBSourceConnection.getConnection(datasource);){
            LinkedHashMap<Entity, Integer> jointTable2count = new LinkedHashMap<Entity, Integer>();
            Statement countStatement = connection.createStatement(1003, 1007);
            Set<VertexType> joinVertices = mapper.getJoinVertex2aggregatorEdges().keySet();
            for (VertexType currJoinVertexType : joinVertices) {
                Entity currEntity = mapper.getEntityByVertexType(currJoinVertexType);
                String tableName = currEntity.getName();
                String countQuery = "select count(*) from " + tableName;
                ResultSet resultCount = countStatement.executeQuery(countQuery);
                resultCount.next();
                int count = resultCount.getInt(1);
                resultCount.close();
                jointTable2count.put(currEntity, count);
            }
            LinkedHashMap<Entity, Integer> linkedHashMap = jointTable2count;
            return linkedHashMap;
        }
        catch (SQLException e) {
            throw new RDBMSProviderRuntimeException(e);
        }
    }

    private String getCytoIdFromPrimaryKey(ResultSet sourceRecord, Entity entity) throws SQLException {
        PrimaryKey primaryKey = entity.getPrimaryKey();
        String id = entity.getSchemaPosition() + "_";
        for (Attribute attribute : primaryKey.getInvolvedAttributes()) {
            id = id + sourceRecord.getString(attribute.getName()) + "_";
        }
        id = id.substring(0, id.lastIndexOf("_"));
        return id;
    }

    @NotNull
    public Set<String> supportedDataSourceTypes() {
        return Sets.newHashSet((Object[])new String[]{"RDBMS_POSTGRESQL", "RDBMS_MYSQL", "RDBMS_MSSQLSERVER", "RDBMS_HSQL", "RDBMS_ORACLE", "RDBMS_DATA_WORLD"});
    }
}

