/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.dbengine;

import com.arcadeanalytics.provider.rdbms.dbengine.QueryBuilder;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Attribute;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Entity;
import com.arcadeanalytics.provider.rdbms.model.dbschema.HierarchicalBag;
import java.util.Iterator;
import java.util.List;

public class CommonQueryBuilder
implements QueryBuilder {
    protected String quote = "\"";

    @Override
    public String countTableRecords(String currentTableName, String currentTableSchema) {
        String query = currentTableSchema != null ? "select count(*) from " + currentTableSchema + "." + this.quote + currentTableName + this.quote : "select count(*) from " + this.quote + currentTableName + this.quote;
        return query;
    }

    @Override
    public String getRecordById(Entity entity, String[] propertyOfKey, String[] valueOfKey) {
        String entityName = entity.getName();
        String entitySchema = entity.getSchemaName();
        String query = entitySchema != null ? "select * from " + entitySchema + "." + this.quote + entityName + this.quote + " where " : "select * from " + this.quote + entityName + this.quote + " where ";
        query = query + this.quote + propertyOfKey[0] + this.quote + " = '" + valueOfKey[0] + "'";
        if (propertyOfKey.length > 1) {
            for (int i = 1; i < propertyOfKey.length; ++i) {
                query = query + " and " + this.quote + propertyOfKey[i] + this.quote + " = '" + valueOfKey[i] + "'";
            }
        }
        return query;
    }

    @Override
    public String getRecordsByEntity(Entity entity) {
        String entityName = entity.getName();
        String entitySchema = entity.getSchemaName();
        String query = entitySchema != null ? "select * from " + entitySchema + "." + this.quote + entityName + this.quote : "select * from " + this.quote + entityName + this.quote;
        return query;
    }

    @Override
    public String getRecordsFromMultipleEntities(List<Entity> mappedEntities, String[][] columns) {
        Entity first = mappedEntities.get(0);
        String query = first.getSchemaName() != null ? "select * from " + first.getSchemaName() + "." + this.quote + first.getName() + this.quote + " as t0\n" : "select * from " + this.quote + first.getName() + this.quote + " as t0\n";
        for (int i = 1; i < mappedEntities.size(); ++i) {
            Entity currentEntity = mappedEntities.get(i);
            query = query + " full outer join " + currentEntity.getSchemaName() + "." + this.quote + currentEntity.getName() + this.quote + " as t" + i;
            query = query + " on t" + (i - 1) + "." + this.quote + columns[i - 1][0] + this.quote + " = t" + i + "." + this.quote + columns[i][0] + this.quote;
            for (int k = 1; k < columns[i].length; ++k) {
                query = query + " and t" + (i - 1) + "." + this.quote + columns[i - 1][k] + this.quote + " = t" + i + "." + this.quote + columns[i][k] + this.quote;
            }
            query = query + "\n";
        }
        return query;
    }

    @Override
    public String getRecordsFromSingleTableByDiscriminatorValue(String discriminatorColumn, String currentDiscriminatorValue, Entity entity) {
        String entityName = entity.getName();
        String entitySchema = entity.getSchemaName();
        String query = entitySchema != null ? "select * from " + entitySchema + "." + this.quote + entityName + this.quote : "select * from " + this.quote + entityName + this.quote;
        query = query + " where " + this.quote + discriminatorColumn + this.quote + "='" + currentDiscriminatorValue + "'";
        return query;
    }

    @Override
    public String getEntityTypeFromSingleTable(String discriminatorColumn, Entity physicalEntity, String[] propertyOfKey, String[] valueOfKey) {
        String physicalEntityName = physicalEntity.getName();
        String entitySchema = physicalEntity.getSchemaName();
        String query = entitySchema != null ? "select " + discriminatorColumn + " from " + entitySchema + "." + this.quote + physicalEntityName + this.quote + " where " : "select " + discriminatorColumn + " from " + this.quote + physicalEntityName + this.quote + " where ";
        query = query + this.quote + propertyOfKey[0] + this.quote + " = '" + valueOfKey[0] + "'";
        if (propertyOfKey.length > 1) {
            for (int i = 1; i < propertyOfKey.length; ++i) {
                query = query + " and " + this.quote + propertyOfKey[i] + this.quote + " = '" + valueOfKey[i] + "'";
            }
        }
        return query;
    }

    @Override
    public String buildAggregateTableFromHierarchicalBag(HierarchicalBag bag) {
        Iterator<Entity> it = bag.getDepth2entities().get(0).iterator();
        Entity rootEntity = it.next();
        String query = rootEntity.getSchemaName() != null ? "select * from " + rootEntity.getSchemaName() + "." + this.quote + rootEntity.getName() + this.quote + " as t0\n" : "select * from " + this.quote + rootEntity.getName() + this.quote + " as t0\n";
        String[] rootEntityPropertyOfKey = new String[rootEntity.getPrimaryKey().getInvolvedAttributes().size()];
        for (int j = 0; j < rootEntity.getPrimaryKey().getInvolvedAttributes().size(); ++j) {
            rootEntityPropertyOfKey[j] = rootEntity.getPrimaryKey().getInvolvedAttributes().get(j).getName();
        }
        String[] currentEntityPropertyOfKey = new String[rootEntity.getPrimaryKey().getInvolvedAttributes().size()];
        int thTable = 1;
        for (int i = 1; i < bag.getDepth2entities().size(); ++i) {
            for (Entity currentEntity : bag.getDepth2entities().get(i)) {
                int index = 0;
                for (Attribute attribute : currentEntity.getPrimaryKey().getInvolvedAttributes()) {
                    currentEntityPropertyOfKey[index] = attribute.getName();
                    ++index;
                }
                query = currentEntity.getSchemaName() != null ? query + "left join " + currentEntity.getSchemaName() + "." + this.quote + currentEntity.getName() + this.quote : query + "left join " + this.quote + currentEntity.getName() + this.quote;
                query = query + " as t" + thTable + " on t0." + this.quote + rootEntityPropertyOfKey[0] + this.quote + " = t" + thTable + "." + this.quote + currentEntityPropertyOfKey[0] + this.quote;
                for (int k = 1; k < currentEntityPropertyOfKey.length; ++k) {
                    query = query + " and " + this.quote + rootEntityPropertyOfKey[k] + this.quote + " = t" + thTable + "." + this.quote + currentEntityPropertyOfKey[0] + this.quote;
                }
                query = query + "\n";
                ++thTable;
            }
        }
        return query;
    }
}

