/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.mapper.rdbms;

import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.TypeMapperKt;
import com.arcadeanalytics.provider.rdbms.context.Statistics;
import com.arcadeanalytics.provider.rdbms.dbengine.DBQueryEngine;
import com.arcadeanalytics.provider.rdbms.exception.RDBMSProviderRuntimeException;
import com.arcadeanalytics.provider.rdbms.mapper.rdbms.AggregatorEdge;
import com.arcadeanalytics.provider.rdbms.mapper.rdbms.classmapper.EEClassMapper;
import com.arcadeanalytics.provider.rdbms.mapper.rdbms.classmapper.EVClassMapper;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Attribute;
import com.arcadeanalytics.provider.rdbms.model.dbschema.CanonicalRelationship;
import com.arcadeanalytics.provider.rdbms.model.dbschema.DataBaseSchema;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Entity;
import com.arcadeanalytics.provider.rdbms.model.dbschema.ForeignKey;
import com.arcadeanalytics.provider.rdbms.model.dbschema.PrimaryKey;
import com.arcadeanalytics.provider.rdbms.model.dbschema.Relationship;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.EdgeType;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.GraphModel;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.ModelProperty;
import com.arcadeanalytics.provider.rdbms.model.graphmodel.VertexType;
import com.arcadeanalytics.provider.rdbms.nameresolver.NameResolver;
import com.arcadeanalytics.provider.rdbms.persistence.handler.DBMSDataTypeHandler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ER2GraphMapper {
    public final int DEFAULT_CLASS_MAPPER_INDEX = 0;
    protected final Map<Entity, List<EVClassMapper>> entity2EVClassMappers;
    protected final Map<VertexType, List<EVClassMapper>> vertexType2EVClassMappers;
    protected final Map<String, List<EEClassMapper>> entity2EEClassMappers;
    protected final Map<String, List<EEClassMapper>> edgeType2EEClassMappers;
    protected final Map<Relationship, EdgeType> relationship2edgeType;
    protected final Map<EdgeType, LinkedList<Relationship>> edgeType2relationships;
    protected final Map<String, Integer> edgeTypeName2count;
    protected final Map<VertexType, AggregatorEdge> joinVertex2aggregatorEdges;
    protected final DataSourceInfo dataSource;
    private final DBQueryEngine queryEngine;
    private final String executionStrategy;
    private final DBMSDataTypeHandler dataTypeHandler;
    private final NameResolver nameResolver;
    private final Statistics statistics;
    private final Logger log = LoggerFactory.getLogger(ER2GraphMapper.class);
    protected GraphModel graphModel;
    protected DataBaseSchema dataBaseSchema;
    protected List<String> includedTables;
    protected List<String> excludedTables;

    public ER2GraphMapper(DataSourceInfo dataSource, List<String> includedTables, List<String> excludedTables, DBQueryEngine queryEngine, DBMSDataTypeHandler dataTypeHandler, String executionStrategy, NameResolver nameResolver, Statistics statistics) {
        this.dataSource = dataSource;
        this.queryEngine = queryEngine;
        this.executionStrategy = executionStrategy;
        this.dataTypeHandler = dataTypeHandler;
        this.nameResolver = nameResolver;
        this.statistics = statistics;
        this.entity2EVClassMappers = new IdentityHashMap<Entity, List<EVClassMapper>>();
        this.vertexType2EVClassMappers = new IdentityHashMap<VertexType, List<EVClassMapper>>();
        this.relationship2edgeType = new IdentityHashMap<Relationship, EdgeType>();
        this.edgeType2relationships = new IdentityHashMap<EdgeType, LinkedList<Relationship>>();
        this.edgeTypeName2count = new TreeMap<String, Integer>();
        this.joinVertex2aggregatorEdges = new LinkedHashMap<VertexType, AggregatorEdge>();
        this.entity2EEClassMappers = new LinkedHashMap<String, List<EEClassMapper>>();
        this.edgeType2EEClassMappers = new LinkedHashMap<String, List<EEClassMapper>>();
        this.includedTables = includedTables != null ? includedTables : new ArrayList<String>();
        this.excludedTables = excludedTables != null ? excludedTables : new ArrayList<String>();
        this.dataBaseSchema = new DataBaseSchema();
        this.graphModel = new GraphModel();
    }

    public GraphModel getGraphModel() {
        return this.graphModel;
    }

    public void upsertRelationshipEdgeRules(Relationship currentRelationship, EdgeType currentEdgeType) {
        this.relationship2edgeType.put(currentRelationship, currentEdgeType);
        LinkedList<Relationship> representedRelationships = this.edgeType2relationships.get(currentEdgeType);
        if (representedRelationships == null) {
            representedRelationships = new LinkedList();
        }
        representedRelationships.add(currentRelationship);
        this.edgeType2relationships.put(currentEdgeType, representedRelationships);
    }

    public void upsertEVClassMappingRules(Entity currentEntity, VertexType currentVertexType, EVClassMapper classMapper) {
        List<EVClassMapper> classMappings = this.entity2EVClassMappers.get(currentEntity);
        if (classMappings == null) {
            classMappings = new LinkedList<EVClassMapper>();
        }
        classMappings.add(classMapper);
        this.entity2EVClassMappers.put(currentEntity, classMappings);
        classMappings = this.vertexType2EVClassMappers.get(currentVertexType);
        if (classMappings == null) {
            classMappings = new LinkedList<EVClassMapper>();
        }
        classMappings.add(classMapper);
        this.vertexType2EVClassMappers.put(currentVertexType, classMappings);
    }

    public void upsertEEClassMappingRules(Entity currentEntity, EdgeType currentEdgeType, EEClassMapper classMapper) {
        List<EEClassMapper> classMappings = this.entity2EEClassMappers.get(currentEntity.getName());
        if (classMappings == null) {
            classMappings = new LinkedList<EEClassMapper>();
        }
        classMappings.add(classMapper);
        this.entity2EEClassMappers.put(currentEntity.getName(), classMappings);
        classMappings = this.edgeType2EEClassMappers.get(currentEdgeType.getName());
        if (classMappings == null) {
            classMappings = new LinkedList<EEClassMapper>();
        }
        classMappings.add(classMapper);
        this.edgeType2EEClassMappers.put(currentEdgeType.getName(), classMappings);
    }

    public List<EVClassMapper> getEVClassMappersByVertex(VertexType vertexType) {
        return this.vertexType2EVClassMappers.get(vertexType);
    }

    public List<EVClassMapper> getEVClassMappersByEntity(Entity entity) {
        return this.entity2EVClassMappers.get(entity);
    }

    public List<EEClassMapper> getEEClassMappersByEntity(Entity entity) {
        return this.entity2EEClassMappers.get(entity.getName());
    }

    public List<EEClassMapper> getEEClassMappersByEdge(EdgeType edgeType) {
        return this.edgeType2EEClassMappers.get(edgeType.getName());
    }

    public Map<Entity, List<EVClassMapper>> getEntity2EVClassMappers() {
        return this.entity2EVClassMappers;
    }

    public Map<VertexType, List<EVClassMapper>> getVertexType2EVClassMappers() {
        return this.vertexType2EVClassMappers;
    }

    public Map<String, List<EEClassMapper>> getEntity2EEClassMappers() {
        return this.entity2EEClassMappers;
    }

    public Map<String, List<EEClassMapper>> getEdgeType2EEClassMappers() {
        return this.edgeType2EEClassMappers;
    }

    public String getAttributeByPropertyAboveMappers(String propertyName, List<EVClassMapper> classMappers) {
        for (EVClassMapper currClassMapper : classMappers) {
            String attributeName = currClassMapper.getAttributeByProperty(propertyName);
            if (attributeName == null) continue;
            return attributeName;
        }
        return null;
    }

    public void buildSourceDatabaseSchema() {
        this.statistics.startWork1Time = new Date();
        this.statistics.runningStepNumber = 1;
        try {
            Connection connection = this.queryEngine.getDbConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            this.log.debug("databaseMetaData:: {} ", (Object)databaseMetaData);
            this.dataBaseSchema.setMajorVersion(databaseMetaData.getDatabaseMajorVersion());
            this.dataBaseSchema.setMinorVersion(databaseMetaData.getDatabaseMinorVersion());
            this.dataBaseSchema.setDriverMajorVersion(databaseMetaData.getDriverMajorVersion());
            this.dataBaseSchema.setDriverMinorVersion(databaseMetaData.getDriverMinorVersion());
            this.dataBaseSchema.setProductName(databaseMetaData.getDatabaseProductName());
            this.dataBaseSchema.setProductVersion(databaseMetaData.getDatabaseProductVersion());
            int numberOfTables = this.buildEntities(databaseMetaData, connection);
            this.buildOutRelationships(databaseMetaData, numberOfTables);
            this.buildInRelationships();
        }
        catch (SQLException e) {
            throw new RDBMSProviderRuntimeException(e);
        }
        this.statistics.runningStepNumber = -1;
    }

    private int buildEntities(DatabaseMetaData databaseMetaData, Connection sourceDBConnection) throws SQLException {
        int numberOfTables;
        LinkedHashMap<String, String> tablesName2schema = new LinkedHashMap<String, String>();
        String tableCatalog = null;
        String tableSchemaPattern = null;
        String tableNamePattern = null;
        String[] tableTypes = new String[]{"TABLE"};
        if (this.dataSource.getType().equals("RDBMS_ORACLE")) {
            ResultSet schemas = databaseMetaData.getSchemas();
            while (schemas.next()) {
                if (!schemas.getString(1).equalsIgnoreCase(this.dataSource.getUsername())) continue;
                tableSchemaPattern = schemas.getString(1);
                break;
            }
        }
        if (this.dataSource.getType().equals("RDBMS_MYSQL")) {
            tableCatalog = this.dataSource.getDatabase();
            if (tableSchemaPattern == null) {
                tableSchemaPattern = this.dataSource.getDatabase();
            }
        }
        ResultSet resultTable = databaseMetaData.getTables(tableCatalog, tableSchemaPattern, tableNamePattern, tableTypes);
        while (resultTable.next()) {
            String tableSchema = resultTable.getString("TABLE_SCHEM");
            String tableName = resultTable.getString("TABLE_NAME");
            if (!this.isTableAllowed(tableName)) continue;
            tablesName2schema.put(tableName, tableSchema);
        }
        this.statistics.totalNumberOfEntities = numberOfTables = tablesName2schema.size();
        this.closeCursor(resultTable);
        this.log.debug("{} tables found:: {} ", (Object)numberOfTables, tablesName2schema);
        Statement statement = sourceDBConnection.createStatement();
        int totalNumberOfRecord = 0;
        int iteration = 1;
        for (String currentTableName : tablesName2schema.keySet()) {
            String currentTableSchema = (String)tablesName2schema.get(currentTableName);
            this.log.debug("Building '{}' entity on schema {} ({}/{})...", new Object[]{currentTableName, currentTableSchema, iteration, numberOfTables});
            Entity currentEntity = new Entity(currentTableName, currentTableSchema, this.dataSource);
            currentEntity.setSchemaPosition(iteration);
            PrimaryKey pKey = new PrimaryKey(currentEntity, new ArrayList<Attribute>());
            String columnCatalog = null;
            String columnSchemaPattern = null;
            String columnNamePattern = null;
            String primaryKeyCatalog = null;
            String primaryKeySchema = currentTableSchema;
            if (this.dataSource.getType().equals("RDBMS_MYSQL")) {
                primaryKeyCatalog = this.dataSource.getDatabase();
                if (primaryKeySchema == null) {
                    primaryKeySchema = this.dataSource.getDatabase();
                }
            }
            ResultSet resultColumns = databaseMetaData.getColumns(columnCatalog, columnSchemaPattern, currentTableName, columnNamePattern);
            this.log.debug("primaryKeyCatalog ::: {} ", (Object)primaryKeySchema);
            ResultSet resultPrimaryKeys = databaseMetaData.getPrimaryKeys(primaryKeyCatalog, primaryKeySchema, currentTableName);
            List<String> currentPrimaryKeys = this.getPrimaryKeysFromResulset(resultPrimaryKeys);
            while (resultColumns.next()) {
                Attribute currentAttribute = new Attribute(resultColumns.getString("COLUMN_NAME"), resultColumns.getInt("ORDINAL_POSITION"), resultColumns.getString("TYPE_NAME"), currentEntity);
                currentEntity.addAttribute(currentAttribute);
                if (!currentPrimaryKeys.contains(currentAttribute.getName())) continue;
                pKey.addAttribute(currentAttribute);
            }
            if (this.dataSource.getType().equals("RDBMS_DATA_WORLD")) {
                currentPrimaryKeys.add("row_index");
                OptionalInt maxOrdinal = currentEntity.getAttributes().stream().mapToInt(a -> a.getOrdinalPosition()).max();
                Attribute currentAttribute = new Attribute("row_index", maxOrdinal.getAsInt() + 1, " http://www.w3.org/2001/XMLSchema#integer", currentEntity);
                currentEntity.addAttribute(currentAttribute);
                pKey.addAttribute(currentAttribute);
            }
            this.closeCursor(resultColumns);
            this.closeCursor(resultPrimaryKeys);
            currentEntity.setPrimaryKey(pKey);
            if (pKey.getInvolvedAttributes().size() == 0) {
                this.log.warn("It's not declared a primary key for the Entity " + currentEntity.getName() + ", might lead to issues during the migration or the sync executions (the first importing is quite safe).");
            }
            this.dataBaseSchema.getEntities().add(currentEntity);
            ++iteration;
            this.log.debug("Entity {} built.", (Object)currentTableName);
            ++this.statistics.builtEntities;
            this.statistics.totalNumberOfRecords = totalNumberOfRecord;
        }
        statement.close();
        return numberOfTables;
    }

    private void buildOutRelationships(DatabaseMetaData databaseMetaData, int numberOfTables) throws SQLException {
        int iteration = 1;
        for (Entity currentForeignEntity : this.dataBaseSchema.getEntities()) {
            LinkedHashMap<String, String> currentExternalRow;
            String currentForeignEntityName = currentForeignEntity.getName();
            String foreignSchema = currentForeignEntity.getSchemaName();
            this.log.debug("Building OUT relationships starting from '{}' entity ({}/{})...", new Object[]{currentForeignEntityName, iteration, numberOfTables});
            String foreignCatalog = null;
            ResultSet resultForeignKeys = databaseMetaData.getImportedKeys(foreignCatalog, foreignSchema, currentForeignEntityName);
            List<LinkedHashMap<String, String>> currentEntityRelationships1 = this.fromResultSetToList(resultForeignKeys);
            LinkedList<LinkedHashMap<String, String>> currentEntityRelationships2 = new LinkedList<LinkedHashMap<String, String>>();
            for (LinkedHashMap<String, String> row : currentEntityRelationships1) {
                currentEntityRelationships2.add(row);
            }
            this.closeCursor(resultForeignKeys);
            Iterator<LinkedHashMap<String, String>> it1 = currentEntityRelationships1.iterator();
            Iterator it2 = currentEntityRelationships2.iterator();
            while (it1.hasNext() && !(currentExternalRow = it1.next()).get("key_seq").equals("2")) {
                String currentParentTableName = currentExternalRow.get("pktable_name");
                int currentKeySeq = Integer.parseInt(currentExternalRow.get("key_seq"));
                Entity currentParentTable = this.dataBaseSchema.getEntityByName(currentParentTableName);
                ForeignKey currentFk = new ForeignKey(currentForeignEntity, new ArrayList<Attribute>());
                while (it2.hasNext()) {
                    LinkedHashMap row = (LinkedHashMap)it2.next();
                    if (!((String)row.get("pktable_name")).equals(currentParentTableName) || Integer.parseInt((String)row.get("key_seq")) != currentKeySeq) continue;
                    currentFk.addAttribute(currentForeignEntity.getAttributeByName((String)row.get("fkcolumn_name")));
                    it2.remove();
                    ++currentKeySeq;
                }
                it2 = currentEntityRelationships2.iterator();
                PrimaryKey currentPk = this.dataBaseSchema.getEntityByName(currentParentTableName).getPrimaryKey();
                CanonicalRelationship currentRelationship = new CanonicalRelationship(currentForeignEntity, currentParentTable, currentFk, currentPk);
                currentForeignEntity.getForeignKeys().add(currentFk);
                this.dataBaseSchema.getCanonicalRelationships().add(currentRelationship);
                currentForeignEntity.getOutCanonicalRelationships().add(currentRelationship);
                ++this.statistics.builtRelationships;
            }
            ++iteration;
            this.log.debug("OUT Relationships from {} built.", (Object)currentForeignEntityName);
            ++this.statistics.entitiesAnalyzedForRelationship;
        }
        this.statistics.totalNumberOfRelationships = this.dataBaseSchema.getCanonicalRelationships().size();
    }

    private void buildInRelationships() {
        boolean iteration = true;
        this.log.debug("Connecting IN relationships...");
        for (Relationship relationship : this.dataBaseSchema.getCanonicalRelationships()) {
            Entity currentInEntity = this.getDataBaseSchema().getEntityByName(relationship.getParentEntity().getName());
            currentInEntity.getInCanonicalRelationships().add((CanonicalRelationship)relationship);
        }
        this.log.debug("IN relationships built.");
    }

    private List<String> getPrimaryKeysFromResulset(ResultSet resultPrimaryKeys) throws SQLException {
        LinkedList<String> currentPrimaryKeys = new LinkedList<String>();
        while (resultPrimaryKeys.next()) {
            currentPrimaryKeys.add(resultPrimaryKeys.getString(4));
        }
        return currentPrimaryKeys;
    }

    private void closeCursor(ResultSet result) {
        try {
            if (result != null) {
                result.close();
            }
        }
        catch (SQLException e) {
            this.log.error("", (Throwable)e);
        }
    }

    private List<LinkedHashMap<String, String>> fromResultSetToList(ResultSet resultForeignKeys) {
        LinkedList<LinkedHashMap<String, String>> rows = new LinkedList<LinkedHashMap<String, String>>();
        try {
            int columnsAmount = resultForeignKeys.getMetaData().getColumnCount();
            while (resultForeignKeys.next()) {
                if (!this.isTableAllowed(resultForeignKeys.getString("pktable_name")) || this.dataBaseSchema.getEntityByName(resultForeignKeys.getString("pktable_name")) == null) continue;
                LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                for (int i = 1; i <= columnsAmount; ++i) {
                    row.put(resultForeignKeys.getMetaData().getColumnName(i).toLowerCase(Locale.ENGLISH), resultForeignKeys.getString(i));
                }
                rows.add(row);
            }
        }
        catch (SQLException e) {
            throw new RDBMSProviderRuntimeException(e);
        }
        return rows;
    }

    public void buildGraphModel(NameResolver nameResolver) {
        this.statistics.startWork2Time = new Date();
        this.statistics.runningStepNumber = 2;
        this.buildVertexTypes(nameResolver);
        this.buildEdgeTypes(nameResolver);
        this.statistics.runningStepNumber = -1;
    }

    private void buildVertexTypes(NameResolver nameResolver) {
        int numberOfVertexType;
        this.statistics.totalNumberOfModelVertices = numberOfVertexType = this.dataBaseSchema.getEntities().size();
        int iteration = 1;
        for (Entity currentEntity : this.dataBaseSchema.getEntities()) {
            this.log.debug("Building '{}' vertex-type ({}/{})...", new Object[]{currentEntity.getName(), iteration, numberOfVertexType});
            String currentVertexTypeName = nameResolver.resolveVertexName(currentEntity.getName());
            boolean alreadyPresentInGraphModel = true;
            VertexType currentVertexType = this.graphModel.getVertexTypeByName(currentVertexTypeName);
            if (currentVertexType == null) {
                currentVertexType = new VertexType(currentVertexTypeName);
                alreadyPresentInGraphModel = false;
            }
            if (currentEntity.isAggregableJoinTable()) {
                currentVertexType.setIsFromJoinTable(true);
            } else {
                currentVertexType.setIsFromJoinTable(false);
            }
            LinkedHashMap<String, String> attribute2property = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> property2attribute = new LinkedHashMap<String, String>();
            for (Attribute attribute : currentEntity.getAttributes()) {
                String orientdbDataType = TypeMapperKt.mapType((String)attribute.getDataType().toLowerCase(Locale.ENGLISH));
                ModelProperty currentProperty2 = new ModelProperty(nameResolver.resolveVertexProperty(attribute.getName()), attribute.getOrdinalPosition(), attribute.getDataType(), currentEntity.getPrimaryKey().getInvolvedAttributes().contains(attribute), currentVertexType);
                currentProperty2.setOrientdbType(orientdbDataType);
                currentVertexType.getProperties().add(currentProperty2);
                attribute2property.put(attribute.getName(), currentProperty2.getName());
                property2attribute.put(currentProperty2.getName(), attribute.getName());
            }
            for (Attribute attribute : currentEntity.getInheritedAttributes()) {
                ModelProperty currentProperty = new ModelProperty(nameResolver.resolveVertexProperty(attribute.getName()), attribute.getOrdinalPosition(), attribute.getDataType(), currentEntity.getPrimaryKey().getInvolvedAttributes().contains(attribute), currentVertexType);
                currentVertexType.getInheritedProperties().add(currentProperty);
            }
            LinkedHashSet<String> externalKey = new LinkedHashSet<String>();
            for (ModelProperty currentProperty : currentVertexType.getAllProperties()) {
                if (!currentProperty.isFromPrimaryKey()) continue;
                externalKey.add(currentProperty.getName());
            }
            currentVertexType.setExternalKey(externalKey);
            if (currentEntity.getParentEntity() != null) {
                VertexType vertexType = this.graphModel.getVertexTypeByNameIgnoreCase(currentEntity.getParentEntity().getName());
                currentVertexType.setParentType(vertexType);
                currentVertexType.setInheritanceLevel(currentEntity.getInheritanceLevel());
            }
            if (!alreadyPresentInGraphModel) {
                this.graphModel.getVerticesType().add(currentVertexType);
            }
            EVClassMapper eVClassMapper = new EVClassMapper(currentEntity, currentVertexType, attribute2property, property2attribute);
            this.upsertEVClassMappingRules(currentEntity, currentVertexType, eVClassMapper);
            ++iteration;
            this.log.debug("Vertex-type {} built.", (Object)currentVertexTypeName);
            ++this.statistics.builtModelVertexTypes;
        }
        Collections.sort(this.graphModel.getVerticesType());
    }

    private void buildEdgeTypes(NameResolver nameResolver) {
        int numberOfEdgeType;
        this.statistics.totalNumberOfModelEdges = numberOfEdgeType = this.dataBaseSchema.getCanonicalRelationships().size();
        String edgeType = null;
        int iteration = 1;
        if (numberOfEdgeType > 0) {
            for (Entity currentEntity : this.dataBaseSchema.getEntities()) {
                EdgeType currentEdgeType;
                VertexType currentInVertex;
                VertexType currentOutVertex;
                for (CanonicalRelationship relationship : currentEntity.getOutCanonicalRelationships()) {
                    currentOutVertex = this.getVertexTypeByEntity(relationship.getForeignEntity());
                    currentInVertex = this.getVertexTypeByEntity(relationship.getParentEntity());
                    this.log.debug("Building edge-type from '{}' to '{}' ({}/{})...", new Object[]{currentOutVertex.getName(), currentInVertex.getName(), iteration, numberOfEdgeType});
                    if (currentOutVertex != null && currentInVertex != null) {
                        if (!(this.relationship2edgeType.containsKey(relationship) || currentEntity.getParentEntity() != null && currentEntity.getParentEntity().getName().equals(relationship.getParentEntity().getName()))) {
                            edgeType = nameResolver.resolveEdgeName(relationship);
                            currentEdgeType = this.graphModel.getEdgeTypeByName(edgeType);
                            if (currentEdgeType == null) {
                                currentEdgeType = new EdgeType(edgeType, null, currentInVertex);
                                this.graphModel.getEdgesType().add(currentEdgeType);
                                this.log.debug("Edge-type {} built.", (Object)currentEdgeType.getName());
                                ++this.statistics.builtModelEdgeTypes;
                            } else {
                                currentEdgeType.setNumberRelationshipsRepresented(currentEdgeType.getNumberRelationshipsRepresented() + 1);
                            }
                            if (!currentOutVertex.getOutEdgesType().contains(currentEdgeType)) {
                                currentOutVertex.getOutEdgesType().add(currentEdgeType);
                            }
                            if (!currentInVertex.getInEdgesType().contains(currentEdgeType)) {
                                currentInVertex.getInEdgesType().add(currentEdgeType);
                            }
                            this.upsertRelationshipEdgeRules(relationship, currentEdgeType);
                        }
                    } else {
                        this.log.error("Error during graph model building phase: information loss, relationship missed. Edge-type not built.\n");
                    }
                    ++iteration;
                }
                for (CanonicalRelationship relationship : currentEntity.getInheritedOutCanonicalRelationships()) {
                    currentOutVertex = this.getVertexTypeByEntity(currentEntity);
                    currentInVertex = this.getVertexTypeByEntity(relationship.getParentEntity());
                    this.log.debug("Building edge-type from '{}' to '{}' ({}/{})...", new Object[]{currentOutVertex.getName(), currentInVertex.getName(), iteration, numberOfEdgeType});
                    if (currentOutVertex != null && currentInVertex != null) {
                        currentEdgeType = this.graphModel.getEdgeTypeByName(edgeType);
                        currentOutVertex.getOutEdgesType().add(currentEdgeType);
                        currentInVertex.getInEdgesType().add(currentEdgeType);
                        this.log.debug("Edge-type built.");
                        continue;
                    }
                    this.log.error("Error during graph model building phase: information loss, relationship missed. Edge-type not built.\n");
                }
            }
            this.statistics.totalNumberOfModelEdges = this.statistics.builtModelEdgeTypes;
        }
    }

    public void performAggregations() {
        this.performMany2ManyAggregation();
    }

    public void performMany2ManyAggregation() {
        Iterator<VertexType> it = this.graphModel.getVerticesType().iterator();
        this.log.debug("Join Table aggregation phase...");
        while (it.hasNext()) {
            ModelProperty newProperty;
            VertexType inVertexType;
            VertexType outVertexType;
            VertexType currentVertexType = it.next();
            if (!currentVertexType.isFromJoinTable() || currentVertexType.getOutEdgesType().size() != 2) continue;
            EdgeType currentOutEdge1 = currentVertexType.getOutEdgesType().get(0);
            EdgeType currentOutEdge2 = currentVertexType.getOutEdgesType().get(1);
            String direction = this.getEntityByVertexType(currentVertexType).getDirectionOfN2NRepresentedRelationship();
            if (direction.equals("direct")) {
                outVertexType = currentOutEdge1.getInVertexType();
                inVertexType = currentOutEdge2.getInVertexType();
            } else {
                outVertexType = currentOutEdge2.getInVertexType();
                inVertexType = currentOutEdge1.getInVertexType();
            }
            Entity joinTable = this.getEntityByVertexType(currentVertexType);
            String nameOfRelationship = joinTable.getNameOfN2NRepresentedRelationship();
            String edgeType = nameOfRelationship != null ? nameOfRelationship : currentVertexType.getName();
            EdgeType newAggregatorEdge = new EdgeType(edgeType, outVertexType, inVertexType);
            newAggregatorEdge.setIsAggregatorEdge(true);
            int position = 1;
            for (ModelProperty currentProperty : currentVertexType.getProperties()) {
                if (currentProperty.isFromPrimaryKey()) continue;
                newProperty = new ModelProperty(currentProperty.getName(), position, currentProperty.getOriginalType(), currentProperty.isFromPrimaryKey(), newAggregatorEdge);
                newProperty.setOrientdbType(currentProperty.getOrientdbType());
                if (currentProperty.isMandatory() != null) {
                    newProperty.setMandatory(currentProperty.isMandatory());
                }
                if (currentProperty.isReadOnly() != null) {
                    newProperty.setReadOnly(currentProperty.isReadOnly());
                }
                if (currentProperty.isNotNull() != null) {
                    newProperty.setNotNull(currentProperty.isNotNull());
                }
                newAggregatorEdge.getProperties().add(newProperty);
                ++position;
            }
            for (ModelProperty currentProperty : currentOutEdge1.getProperties()) {
                if (newAggregatorEdge.getPropertyByName(currentProperty.getName()) != null) continue;
                newProperty = new ModelProperty(currentProperty.getName(), position, currentProperty.getOriginalType(), currentProperty.isFromPrimaryKey(), newAggregatorEdge);
                newProperty.setOrientdbType(currentProperty.getOrientdbType());
                if (currentProperty.isMandatory() != null) {
                    newProperty.setMandatory(currentProperty.isMandatory());
                }
                if (currentProperty.isReadOnly() != null) {
                    newProperty.setReadOnly(currentProperty.isReadOnly());
                }
                if (currentProperty.isNotNull() != null) {
                    newProperty.setNotNull(currentProperty.isNotNull());
                }
                newAggregatorEdge.getProperties().add(newProperty);
                ++position;
            }
            for (ModelProperty currentProperty : currentOutEdge2.getProperties()) {
                if (newAggregatorEdge.getPropertyByName(currentProperty.getName()) != null) continue;
                newProperty = new ModelProperty(currentProperty.getName(), position, currentProperty.getOriginalType(), currentProperty.isFromPrimaryKey(), newAggregatorEdge);
                newProperty.setOrientdbType(currentProperty.getOrientdbType());
                if (currentProperty.isMandatory() != null) {
                    newProperty.setMandatory(currentProperty.isMandatory());
                }
                if (currentProperty.isReadOnly() != null) {
                    newProperty.setReadOnly(currentProperty.isReadOnly());
                }
                if (currentProperty.isNotNull() != null) {
                    newProperty.setNotNull(currentProperty.isNotNull());
                }
                newAggregatorEdge.getProperties().add(newProperty);
                ++position;
            }
            currentOutEdge1.setNumberRelationshipsRepresented(currentOutEdge1.getNumberRelationshipsRepresented() - 1);
            currentOutEdge2.setNumberRelationshipsRepresented(currentOutEdge2.getNumberRelationshipsRepresented() - 1);
            if (currentOutEdge1.getNumberRelationshipsRepresented() == 0) {
                this.graphModel.getEdgesType().remove(currentOutEdge1);
                --this.statistics.builtModelEdgeTypes;
                --this.statistics.totalNumberOfModelEdges;
            }
            if (currentOutEdge2.getNumberRelationshipsRepresented() == 0) {
                this.graphModel.getEdgesType().remove(currentOutEdge2);
                --this.statistics.builtModelEdgeTypes;
                --this.statistics.totalNumberOfModelEdges;
            }
            if (direction.equals("direct")) {
                outVertexType.getInEdgesType().remove(currentOutEdge1);
                inVertexType.getInEdgesType().remove(currentOutEdge2);
            } else {
                outVertexType.getInEdgesType().remove(currentOutEdge2);
                inVertexType.getInEdgesType().remove(currentOutEdge1);
            }
            this.joinVertex2aggregatorEdges.put(currentVertexType, new AggregatorEdge(outVertexType.getName(), inVertexType.getName(), newAggregatorEdge));
            it.remove();
            --this.statistics.builtModelVertexTypes;
            --this.statistics.totalNumberOfModelVertices;
            this.graphModel.getEdgesType().add(newAggregatorEdge);
            ++this.statistics.builtModelEdgeTypes;
            ++this.statistics.totalNumberOfModelEdges;
            outVertexType.getOutEdgesType().add(newAggregatorEdge);
            inVertexType.getInEdgesType().add(newAggregatorEdge);
        }
        this.log.debug("Aggregation performed.");
    }

    public DataBaseSchema getDataBaseSchema() {
        return this.dataBaseSchema;
    }

    public void setDataBaseSchema(DataBaseSchema dataBaseSchema) {
    }

    public Entity getEntityByVertexType(VertexType vertexType) {
        return this.getEntityByVertexType(vertexType, 0);
    }

    public Entity getEntityByVertexType(VertexType vertexType, int classMapperIndex) {
        return this.getEVClassMappersByVertex(vertexType).get(classMapperIndex).getEntity();
    }

    public Entity getEntityByNameIgnoreCase(String entityName) {
        for (Entity currentEntity : this.entity2EVClassMappers.keySet()) {
            if (!entityName.equalsIgnoreCase(currentEntity.getName())) continue;
            return currentEntity;
        }
        return null;
    }

    public Entity getEntityBySchemaPosition(int schemaPosition) {
        for (Entity currentEntity : this.entity2EVClassMappers.keySet()) {
            if (schemaPosition != currentEntity.getSchemaPosition()) continue;
            return currentEntity;
        }
        return null;
    }

    public VertexType getVertexTypeByEntity(Entity entity) {
        return this.getVertexTypeByEntity(entity, 0);
    }

    public VertexType getVertexTypeByEntity(Entity entity, int classMapperIndex) {
        return this.getEVClassMappersByEntity(entity).get(classMapperIndex).getVertexType();
    }

    public VertexType getVertexTypeByEntityNameIgnoreCase(String entityName) {
        for (Entity currentEntity : this.entity2EVClassMappers.keySet()) {
            if (!entityName.equalsIgnoreCase(currentEntity.getName())) continue;
            return this.entity2EVClassMappers.get(currentEntity).get(0).getVertexType();
        }
        return null;
    }

    public VertexType getVertexTypeByEntityAndRelationship(Entity currentParentEntity, Relationship currentRelationship) {
        List<EVClassMapper> classMappers = this.getEVClassMappersByEntity(currentParentEntity);
        if (classMappers.size() == 1) {
            return this.getVertexTypeByEntity(currentParentEntity);
        }
        List<Attribute> toAttributes = currentRelationship.getToColumns();
        VertexType correspondentVertexType = null;
        for (EVClassMapper classMapper : classMappers) {
            boolean found = true;
            for (Attribute currAttribute : toAttributes) {
                if (classMapper.getAttribute2property().get(currAttribute.getName()) != null) continue;
                found = false;
                break;
            }
            if (!found) continue;
            correspondentVertexType = classMapper.getVertexType();
            break;
        }
        return correspondentVertexType;
    }

    public String getAttributeNameByVertexTypeAndProperty(VertexType vertexType, String propertyName) {
        VertexType parentType;
        EVClassMapper cm;
        String attributeName = null;
        Iterator<EVClassMapper> iterator = this.getEVClassMappersByVertex(vertexType).iterator();
        while (iterator.hasNext() && (attributeName = (cm = iterator.next()).getAttributeByProperty(propertyName)) == null) {
        }
        if (attributeName == null && (parentType = (VertexType)vertexType.getParentType()) != null) {
            return this.getAttributeNameByVertexTypeAndProperty(parentType, propertyName);
        }
        return attributeName;
    }

    public String getPropertyNameByVertexTypeAndAttribute(VertexType vertexType, String attributeName) {
        VertexType parentType;
        EVClassMapper currentClassMapper;
        List<EVClassMapper> classMappers = this.getEVClassMappersByVertex(vertexType);
        String propertyName = null;
        Iterator<EVClassMapper> iterator = classMappers.iterator();
        while (iterator.hasNext() && (propertyName = (currentClassMapper = iterator.next()).getPropertyByAttribute(attributeName)) == null) {
        }
        if (propertyName == null && (parentType = (VertexType)vertexType.getParentType()) != null) {
            return this.getPropertyNameByVertexTypeAndAttribute(parentType, attributeName);
        }
        return propertyName;
    }

    public String getAttributeNameByEdgeTypeAndProperty(EdgeType edgeType, String propertyName) {
        VertexType parentType;
        EEClassMapper cm;
        String attributeName = null;
        Iterator<EEClassMapper> iterator = this.getEEClassMappersByEdge(edgeType).iterator();
        while (iterator.hasNext() && (attributeName = (cm = iterator.next()).getAttributeByProperty(propertyName)) == null) {
        }
        if (attributeName == null && (parentType = (VertexType)edgeType.getParentType()) != null) {
            return this.getAttributeNameByVertexTypeAndProperty(parentType, propertyName);
        }
        return attributeName;
    }

    public String getPropertyNameByEntityAndAttribute(Entity entity, String attributeName) {
        Entity parentEntity;
        EVClassMapper currentClassMapper;
        List<EVClassMapper> classMappers = this.getEVClassMappersByEntity(entity);
        String propertyName = null;
        Iterator<EVClassMapper> iterator = classMappers.iterator();
        while (iterator.hasNext() && (propertyName = (currentClassMapper = iterator.next()).getPropertyByAttribute(attributeName)) == null) {
        }
        if (propertyName == null && (parentEntity = entity.getParentEntity()) != null) {
            return this.getPropertyNameByEntityAndAttribute(parentEntity, attributeName);
        }
        return propertyName;
    }

    public VertexType getJoinVertexTypeByAggregatorEdge(String edgeType) {
        for (Map.Entry<VertexType, AggregatorEdge> entry : this.joinVertex2aggregatorEdges.entrySet()) {
            if (!entry.getValue().getEdgeType().getName().equals(edgeType)) continue;
            VertexType joinVertexType = entry.getKey();
            return joinVertexType;
        }
        return null;
    }

    public AggregatorEdge getAggregatorEdgeByJoinVertexTypeName(String vertexTypeName) {
        for (VertexType currentVertexType : this.joinVertex2aggregatorEdges.keySet()) {
            if (!currentVertexType.getName().equals(vertexTypeName)) continue;
            return this.joinVertex2aggregatorEdges.get(currentVertexType);
        }
        return null;
    }

    public VertexType getJoinVertexTypeByAggregatorEdgeName(String aggregatorEdgeName) {
        for (VertexType currentVertexType : this.joinVertex2aggregatorEdges.keySet()) {
            if (!this.joinVertex2aggregatorEdges.get(currentVertexType).getEdgeType().getName().equals(aggregatorEdgeName)) continue;
            return currentVertexType;
        }
        return null;
    }

    public AggregatorEdge getAggregatorEdgeByEdgeTypeName(String edgeTypeName) {
        for (AggregatorEdge currAggregatorEdge : this.joinVertex2aggregatorEdges.values()) {
            if (!currAggregatorEdge.getEdgeType().getName().equals(edgeTypeName)) continue;
            return currAggregatorEdge;
        }
        return null;
    }

    public List<Relationship> getRelationshipsByForeignAndParentTables(String currentForeignEntity, String currentParentEntity) {
        LinkedList<Relationship> relationships = new LinkedList<Relationship>();
        for (Relationship relationship : this.dataBaseSchema.getCanonicalRelationships()) {
            if (!relationship.getForeignEntity().getName().equals(currentForeignEntity) || !relationship.getParentEntity().getName().equals(currentParentEntity)) continue;
            relationships.add(relationship);
        }
        return relationships;
    }

    public Map<Relationship, EdgeType> getRelationship2edgeType() {
        return this.relationship2edgeType;
    }

    public Map<EdgeType, LinkedList<Relationship>> getEdgeType2relationships() {
        return this.edgeType2relationships;
    }

    public Map<String, Integer> getEdgeTypeName2count() {
        return this.edgeTypeName2count;
    }

    public Map<VertexType, AggregatorEdge> getJoinVertex2aggregatorEdges() {
        return this.joinVertex2aggregatorEdges;
    }

    public List<String> getIncludedTables() {
        return this.includedTables;
    }

    public void setIncludedTables(List<String> includedTables) {
    }

    public List<String> getExcludedTables() {
        return this.excludedTables;
    }

    public void setExcludedTables(List<String> excludedTables) {
    }

    public boolean isTableAllowed(String tableName) {
        if (this.includedTables.size() > 0) {
            return this.includedTables.contains(tableName);
        }
        if (this.excludedTables.size() > 0) {
            return !this.excludedTables.contains(tableName);
        }
        return true;
    }

    public String toString() {
        String s = "\n\n\n------------------------------ MAPPER DESCRIPTION ------------------------------\n\n\n";
        s = s + "RULES\n\n";
        s = s + "- Class mappings:\n\n";
        for (List<EVClassMapper> classMappers : this.entity2EVClassMappers.values()) {
            for (EVClassMapper classMapper : classMappers) {
                s = s + classMapper.toString() + "\n";
            }
        }
        s = s + "\n\n- Relaionship2EdgeType Rules:\n\n";
        for (Relationship relationship : this.relationship2edgeType.keySet()) {
            s = s + relationship.getForeignEntity() + "2" + relationship.getParentEntity() + " --> " + this.relationship2edgeType.get(relationship).getName() + "\n";
        }
        s = s + "\n\n- EdgeTypeName2Count Rules:\n\n";
        for (String edgeName : this.edgeTypeName2count.keySet()) {
            s = s + edgeName + " --> " + this.edgeTypeName2count.get(edgeName) + "\n";
        }
        s = s + "\n";
        return s;
    }
}

