/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.nameresolver;

import com.arcadeanalytics.provider.rdbms.model.dbschema.CanonicalRelationship;
import com.arcadeanalytics.provider.rdbms.nameresolver.NameResolver;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class JavaConventionNameResolver
implements NameResolver {
    @Override
    public String resolveVertexName(String candidateName) {
        if (this.isCompliantToJavaClassConvention(candidateName)) {
            return candidateName;
        }
        candidateName = this.toJavaClassConvention(candidateName);
        return candidateName;
    }

    @Override
    public String resolveVertexProperty(String candidateName) {
        if (this.isCompliantToJavaVariableConvention(candidateName)) {
            return candidateName;
        }
        candidateName = this.toJavaVariableConvention(candidateName);
        return candidateName;
    }

    @Override
    public String resolveEdgeName(CanonicalRelationship relationship) {
        String finalName;
        if (relationship.getFromColumns().size() == 1) {
            String columnName = relationship.getFromColumns().get(0).getName();
            columnName = columnName.replace("_id", "");
            columnName = columnName.replace("_ID", "");
            columnName = columnName.replace("_oid", "");
            columnName = columnName.replace("_OID", "");
            columnName = columnName.replace("_eid", "");
            if (!this.isCompliantToJavaClassConvention(columnName = columnName.replace("_EID", ""))) {
                columnName = this.toJavaClassConvention(columnName);
            }
            finalName = "Has" + columnName;
        } else {
            finalName = this.toJavaClassConvention(relationship.getForeignEntity().getName()) + "2" + this.toJavaClassConvention(relationship.getParentEntity().getName());
        }
        return finalName;
    }

    public String toJavaClassConvention(String name) {
        int pos;
        boolean allUpperCase = true;
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isLowerCase(name.charAt(i))) continue;
            allUpperCase = false;
            break;
        }
        if (allUpperCase) {
            name = name.toLowerCase(Locale.ENGLISH);
        }
        if (name.contains(" ")) {
            while (name.contains(" ")) {
                pos = name.indexOf(" ");
                name = name.substring(0, pos) + (name.charAt(pos + 1) + "").toUpperCase(Locale.ENGLISH) + name.substring(pos + 2);
            }
        }
        if (name.contains("_")) {
            while (name.contains("_")) {
                pos = name.indexOf("_");
                if (pos < name.length() - 1) {
                    name = name.substring(0, pos) + (name.charAt(pos + 1) + "").toUpperCase(Locale.ENGLISH) + name.substring(pos + 2);
                    continue;
                }
                name = name.substring(0, name.length() - 1);
            }
        }
        if (name.contains("-")) {
            while (name.contains("-")) {
                pos = name.indexOf("-");
                name = name.substring(0, pos) + (name.charAt(pos + 1) + "").toUpperCase(Locale.ENGLISH) + name.substring(pos + 2);
            }
        }
        if (Character.isLowerCase(name.charAt(0))) {
            name = name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
        }
        return name;
    }

    public String toJavaVariableConvention(String name) {
        int pos;
        boolean allUpperCase = true;
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isLowerCase(name.charAt(i))) continue;
            allUpperCase = false;
            break;
        }
        if (allUpperCase) {
            name = name.toLowerCase(Locale.ENGLISH);
        }
        if (name.contains(" ")) {
            while (name.contains(" ")) {
                pos = name.indexOf(" ");
                name = name.substring(0, pos) + (name.charAt(pos + 1) + "").toUpperCase(Locale.ENGLISH) + name.substring(pos + 2);
            }
        }
        if (name.contains("_")) {
            while (name.contains("_")) {
                pos = name.indexOf("_");
                name = name.substring(0, pos) + (name.charAt(pos + 1) + "").toUpperCase(Locale.ENGLISH) + name.substring(pos + 2);
            }
        }
        if (name.contains("-")) {
            while (name.contains("-")) {
                pos = name.indexOf("-");
                name = name.substring(0, pos) + (name.charAt(pos + 1) + "").toUpperCase(Locale.ENGLISH) + name.substring(pos + 2);
            }
        }
        if (Character.isUpperCase(name.charAt(0))) {
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        }
        return name;
    }

    public boolean isCompliantToJavaClassConvention(String candidateName) {
        if (!candidateName.contains(" ") && !candidateName.contains("_") && !candidateName.contains("-") && Character.isUpperCase(candidateName.charAt(0))) {
            return !StringUtils.isAllUpperCase(candidateName);
        }
        return false;
    }

    public boolean isCompliantToJavaVariableConvention(String candidateName) {
        return !candidateName.contains(" ") && !candidateName.contains("_") && !candidateName.contains("-") && Character.isLowerCase(candidateName.charAt(0));
    }
}

