/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.rdbms.persistence.util;

import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.rdbms.exception.RDBMSProviderRuntimeException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSourceConnection {
    private static final Logger log = LoggerFactory.getLogger(DBSourceConnection.class);
    private static Map<String, String> type2template = new HashMap<String, String>(){
        {
            this.put("RDBMS_HSQL", "jdbc:hsqldb:{server}:{database}");
            this.put("RDBMS_DATA_WORLD", "jdbc:data:world:sql:{server}:{database}");
            this.put("RDBMS_POSTGRESQL", "jdbc:postgresql://{server}:{port}/{database}");
            this.put("RDBMS_MYSQL", "jdbc:mysql://{server}:{port}/{database}?nullNamePatternMatchesAll=true&autoReconnect=true&useSSL=false");
            this.put("RDBMS_MSSQLSERVER", "jdbc:sqlserver://{server}:{port};databaseName={database}");
            this.put("RDBMS_ORACLE", "jdbc:oracle:thin:@{server}:{port}:{database}");
        }
    };

    public static Connection getConnection(DataSourceInfo datasource) {
        String uri = DBSourceConnection.createConnectionUrl(datasource);
        log.debug("getting connection for:: {} ", (Object)uri);
        Properties props = new Properties();
        props.setProperty("user", datasource.getUsername());
        props.setProperty("password", datasource.getPassword());
        try {
            Map connectionAdditionalProperties = new ObjectMapper().readValue(Optional.ofNullable(datasource.getConnectionProperties()).orElse("{}"), HashMap.class);
            if (connectionAdditionalProperties.size() > 0) {
                for (String connectionProp : connectionAdditionalProperties.keySet()) {
                    props.setProperty(connectionProp, (String)connectionAdditionalProperties.get(connectionProp));
                }
            }
            Connection connection = DriverManager.getConnection(uri, props);
            return connection;
        }
        catch (Exception e) {
            throw new RDBMSProviderRuntimeException(e);
        }
    }

    public static String createConnectionUrl(DataSourceInfo datasource) {
        return type2template.get(datasource.getType()).replace("{server}", datasource.getServer()).replace("{port}", String.valueOf(datasource.getPort())).replace("{database}", datasource.getDatabase());
    }
}

