/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.thread;

import com.orientechnologies.common.log.OLogManager;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class OScheduledThreadPoolExecutorWithLogging
extends ScheduledThreadPoolExecutor {
    public OScheduledThreadPoolExecutorWithLogging(int corePoolSize) {
        super(corePoolSize);
    }

    public OScheduledThreadPoolExecutorWithLogging(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public OScheduledThreadPoolExecutorWithLogging(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public OScheduledThreadPoolExecutorWithLogging(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        Future future;
        super.afterExecute(r, t);
        if (r instanceof Future && (future = (Future)((Object)r)).isDone()) {
            try {
                future.get();
            }
            catch (CancellationException ce) {
            }
            catch (ExecutionException ee) {
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            Thread thread = Thread.currentThread();
            OLogManager.instance().errorNoDb(this, "Exception in thread '%s'", t, thread.getName());
        }
    }
}

