/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.thread;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OService;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;

public abstract class OSoftThread
extends Thread
implements OService {
    private volatile boolean shutdownFlag;
    private boolean dumpExceptions = true;

    public OSoftThread() {
        this.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
    }

    public OSoftThread(ThreadGroup group, String name) {
        super(group, name);
        this.setDaemon(true);
        this.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
    }

    protected abstract void execute() throws Exception;

    @Override
    public void startup() {
    }

    @Override
    public void shutdown() {
    }

    public void sendShutdown() {
        this.shutdownFlag = true;
    }

    public void softShutdown() {
        this.shutdownFlag = true;
    }

    public boolean isShutdownFlag() {
        return this.shutdownFlag;
    }

    @Override
    public void run() {
        this.startup();
        while (!this.shutdownFlag && !this.isInterrupted()) {
            try {
                this.beforeExecution();
                this.execute();
                this.afterExecution();
            }
            catch (Exception e) {
                if (!this.dumpExceptions) continue;
                OLogManager.instance().error(this, "Error during thread execution", e, new Object[0]);
            }
            catch (Error e) {
                if (this.dumpExceptions) {
                    OLogManager.instance().error(this, "Error during thread execution", e, new Object[0]);
                }
                throw e;
            }
        }
        this.shutdown();
    }

    public void setDumpExceptions(boolean dumpExceptions) {
        this.dumpExceptions = dumpExceptions;
    }

    protected void beforeExecution() throws InterruptedException {
    }

    protected void afterExecution() throws InterruptedException {
    }
}

