/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.ONestedValueChangeListener;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class OTrackedSet<T>
extends HashSet<T>
implements ORecordElement,
OTrackedMultiValue<T, T>,
Serializable {
    protected final ORecord sourceRecord;
    private final boolean embeddedCollection;
    protected Class<?> genericClass;
    private ORecordElement.STATUS status = ORecordElement.STATUS.NOT_LOADED;
    private List<OMultiValueChangeListener<T, T>> changeListeners;

    public OTrackedSet(ORecord iRecord, Collection<? extends T> iOrigin, Class<?> cls) {
        this(iRecord);
        this.genericClass = cls;
        if (iOrigin != null && !iOrigin.isEmpty()) {
            this.addAll(iOrigin);
        }
    }

    public OTrackedSet(ORecord iSourceRecord) {
        this.sourceRecord = iSourceRecord;
        this.embeddedCollection = this.getClass().equals(OTrackedSet.class);
    }

    @Override
    public ORecordElement getOwner() {
        return this.sourceRecord;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<T> underlying;
            {
                this.underlying = OTrackedSet.super.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.underlying.hasNext();
            }

            @Override
            public T next() {
                return this.underlying.next();
            }

            @Override
            public void remove() {
                this.underlying.remove();
                OTrackedSet.this.setDirty();
            }
        };
    }

    @Override
    public boolean add(T e) {
        if (super.add(e)) {
            this.addOwnerToEmbeddedDoc(e);
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<T, T>(OMultiValueChangeEvent.OChangeType.ADD, e, e));
            this.addNested(e);
            return true;
        }
        return false;
    }

    private void addNested(T element) {
        if (element instanceof OTrackedMultiValue) {
            ((OTrackedMultiValue)element).addChangeListener(new ONestedValueChangeListener((ODocument)this.sourceRecord, this, (OTrackedMultiValue)element));
        }
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            if (o instanceof ODocument) {
                ODocumentInternal.removeOwner((ODocument)o, this);
            }
            this.fireCollectionChangedEvent((OMultiValueChangeEvent<T, T>)new OMultiValueChangeEvent<Object, Object>(OMultiValueChangeEvent.OChangeType.REMOVE, o, null, o));
            this.removeNested(o);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        HashSet origValues = this.changeListeners == null ? null : new HashSet(this);
        if (origValues == null) {
            for (Object item : this) {
                if (!(item instanceof ODocument)) continue;
                ODocumentInternal.removeOwner((ODocument)item, this);
            }
        }
        super.clear();
        if (origValues != null) {
            for (Object item : origValues) {
                if (item instanceof ODocument) {
                    ODocumentInternal.removeOwner((ODocument)item, this);
                }
                this.fireCollectionChangedEvent((OMultiValueChangeEvent<T, T>)new OMultiValueChangeEvent<T, Object>(OMultiValueChangeEvent.OChangeType.REMOVE, item, null, item));
                this.removeNested(item);
            }
        } else {
            this.setDirty();
        }
    }

    private void removeNested(Object element) {
        if (element instanceof OTrackedMultiValue) {
            // empty if block
        }
    }

    public OTrackedSet<T> setDirty() {
        if (!(this.status == ORecordElement.STATUS.UNMARSHALLING || this.sourceRecord == null || this.sourceRecord.isDirty() && ORecordInternal.isContentChanged(this.sourceRecord))) {
            this.sourceRecord.setDirty();
        }
        return this;
    }

    @Override
    public void setDirtyNoChanged() {
        if (this.status != ORecordElement.STATUS.UNMARSHALLING && this.sourceRecord != null) {
            this.sourceRecord.setDirtyNoChanged();
        }
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this.status;
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this.status = iStatus;
    }

    @Override
    public void addChangeListener(OMultiValueChangeListener<T, T> changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new LinkedList<OMultiValueChangeListener<T, T>>();
        }
        this.changeListeners.add(changeListener);
    }

    @Override
    public void removeRecordChangeListener(OMultiValueChangeListener<T, T> changeListener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
        }
    }

    public Set<T> returnOriginalState(List<OMultiValueChangeEvent<T, T>> multiValueChangeEvents) {
        HashSet<T> reverted = new HashSet<T>(this);
        ListIterator<OMultiValueChangeEvent<T, T>> listIterator = multiValueChangeEvents.listIterator(multiValueChangeEvents.size());
        block4: while (listIterator.hasPrevious()) {
            OMultiValueChangeEvent<T, T> event = listIterator.previous();
            switch (event.getChangeType()) {
                case ADD: {
                    reverted.remove(event.getKey());
                    continue block4;
                }
                case REMOVE: {
                    reverted.add(event.getOldValue());
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
        }
        return reverted;
    }

    @Override
    public Class<?> getGenericClass() {
        return this.genericClass;
    }

    @Override
    public void fireCollectionChangedEvent(OMultiValueChangeEvent<T, T> event) {
        if (this.status == ORecordElement.STATUS.UNMARSHALLING) {
            return;
        }
        this.setDirty();
        if (this.changeListeners != null) {
            for (OMultiValueChangeListener<T, T> changeListener : this.changeListeners) {
                if (changeListener == null) continue;
                changeListener.onAfterRecordChanged(event);
            }
        }
    }

    private void addOwnerToEmbeddedDoc(T e) {
        if (this.embeddedCollection && e instanceof ODocument && !((ODocument)e).getIdentity().isValid()) {
            ODocumentInternal.addOwner((ODocument)e, this);
            ORecordInternal.track(this.sourceRecord, (ODocument)e);
        }
    }

    private Object writeReplace() {
        return new HashSet(this);
    }

    @Override
    public void replace(OMultiValueChangeEvent<Object, Object> event, Object newValue) {
        super.remove(event.getKey());
        super.add(newValue);
        this.addNested(newValue);
    }
}

