/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.index.OIndexOneValue;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;

public class OIndexDictionary
extends OIndexOneValue {
    public OIndexDictionary(String name, String typeId, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata, int binaryFormatVersion) {
        super(name, typeId, algorithm, version, storage, valueContainerAlgorithm, metadata, binaryFormatVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexOneValue put(Object key, OIdentifiable value) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        try {
            if (this.apiVersion == 0) {
                this.putV0(key, value);
            } else if (this.apiVersion == 1) {
                this.putV1(key, value.getIdentity());
            } else {
                throw new IllegalStateException("Invalid API version, " + this.apiVersion);
            }
            OIndexDictionary oIndexDictionary = this;
            return oIndexDictionary;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private void putV0(Object key, OIdentifiable value) {
        while (true) {
            try {
                this.storage.putIndexValue(this.indexId, key, value);
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    private void putV1(Object key, OIdentifiable value) {
        while (true) {
            try {
                this.storage.putRidIndexEntry(this.indexId, key, value.getIdentity());
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return true;
    }

    @Override
    public boolean supportsOrderedIterations() {
        return false;
    }

    @Override
    protected Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry> interpretTxKeyChanges(OTransactionIndexChangesPerKey changes) {
        return changes.interpret(OTransactionIndexChangesPerKey.Interpretation.Dictionary);
    }
}

