/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import java.util.Set;

public class ORestrictedAccessHook {
    public static boolean onRecordBeforeCreate(ODocument iDocument, ODatabaseDocumentInternal database) {
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(database, iDocument);
        if (cls != null && cls.isRestricted()) {
            String fieldNames = cls.getCustom("onCreate.fields");
            if (fieldNames == null) {
                fieldNames = ORestrictedOperation.ALLOW_ALL.getFieldName();
            }
            String[] fields = fieldNames.split(",");
            String identityType = cls.getCustom("onCreate.identityType");
            if (identityType == null) {
                identityType = "user";
            }
            OIdentifiable identity = null;
            if (identityType.equals("user")) {
                OSecurityUser user = database.getUser();
                if (user != null) {
                    identity = user.getIdentity();
                }
            } else if (identityType.equals("role")) {
                Set<? extends OSecurityRole> roles = database.getUser().getRoles();
                if (!roles.isEmpty()) {
                    identity = roles.iterator().next().getIdentity();
                }
            } else {
                throw new OConfigurationException("Wrong custom field 'onCreate.identityType' in class '" + cls.getName() + "' with value '" + identityType + "'. Supported ones are: 'user', 'role'");
            }
            if (identity != null) {
                for (String f : fields) {
                    database.getMetadata().getSecurity().allowIdentity(iDocument, f, identity);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isAllowed(ODatabaseDocumentInternal database, ODocument iDocument, ORestrictedOperation iAllowOperation, boolean iReadOriginal) {
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(database, iDocument);
        if (cls != null && cls.isRestricted()) {
            if (database.getUser() == null) {
                return true;
            }
            if (database.getUser().isRuleDefined(ORule.ResourceGeneric.BYPASS_RESTRICTED, null) && database.getUser().checkIfAllowed(ORule.ResourceGeneric.BYPASS_RESTRICTED, null, ORole.PERMISSION_READ) != null) {
                return true;
            }
            ODocument doc = iReadOriginal ? (ODocument)database.load(iDocument.getIdentity()) : iDocument;
            if (doc == null) {
                return false;
            }
            return database.getMetadata().getSecurity().isAllowed((Set)doc.field(ORestrictedOperation.ALLOW_ALL.getFieldName()), (Set)doc.field(iAllowOperation.getFieldName()));
        }
        return true;
    }
}

