/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.query.live;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.query.live.OLiveQueryHookV2;
import com.orientechnologies.orient.core.query.live.OLiveQueryListenerV2;

public class OLiveQueryQueueThreadV2
extends Thread {
    private final OLiveQueryHookV2.OLiveQueryOps ops;
    private boolean stopped = false;

    public OLiveQueryQueueThreadV2(OLiveQueryHookV2.OLiveQueryOps ops) {
        this.setName("LiveQueryQueueThreadV2");
        this.ops = ops;
        this.setDaemon(true);
    }

    @Override
    public OLiveQueryQueueThreadV2 clone() {
        return new OLiveQueryQueueThreadV2(this.ops);
    }

    @Override
    public void run() {
        while (!this.stopped) {
            OLiveQueryHookV2.OLiveQueryOp next = null;
            try {
                next = this.ops.getQueue().take();
            }
            catch (InterruptedException ignore) {
                break;
            }
            if (next == null) continue;
            for (OLiveQueryListenerV2 listener : this.ops.getSubscribers().values()) {
                try {
                    listener.onLiveResult(next);
                }
                catch (Exception e) {
                    OLogManager.instance().warn((Object)this, "Error executing live query subscriber.", e, new Object[0]);
                }
            }
        }
    }

    public void stopExecution() {
        this.stopped = true;
        this.interrupt();
    }
}

