/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.HashSet;
import java.util.Optional;

public interface OEdge
extends OElement {
    public static final String DIRECTION_OUT = "out";
    public static final String DIRECTION_IN = "in";
    @Deprecated
    public static final String DIRECITON_OUT = "out";
    @Deprecated
    public static final String DIRECITON_IN = "in";

    public OVertex getFrom();

    public OVertex getTo();

    public boolean isLightweight();

    default public OVertex getVertex(ODirection dir) {
        if (dir == ODirection.IN) {
            return this.getTo();
        }
        if (dir == ODirection.OUT) {
            return this.getFrom();
        }
        return null;
    }

    default public boolean isLabeled(String[] labels) {
        if (labels == null) {
            return true;
        }
        if (labels.length == 0) {
            return true;
        }
        HashSet<String> types = new HashSet<String>();
        Optional<OClass> typeClass = this.getSchemaType();
        if (typeClass.isPresent()) {
            types.add(typeClass.get().getName());
            typeClass.get().getAllSuperClasses().stream().map(x -> x.getName()).forEach(name -> types.add((String)name));
        } else {
            types.add("E");
        }
        for (String s : labels) {
            for (String type : types) {
                if (!type.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }
}

