/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Map;

public class OCommandExecutorSQLRebuildIndex
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_REBUILD = "REBUILD";
    public static final String KEYWORD_INDEX = "INDEX";
    private String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLRebuildIndex parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            this.init((OCommandRequestText)iRequest);
            StringBuilder word = new StringBuilder();
            int oldPos = 0;
            int pos = OCommandExecutorSQLRebuildIndex.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
            if (pos == -1 || !word.toString().equals(KEYWORD_REBUILD)) {
                throw new OCommandSQLParsingException("Keyword REBUILD not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLRebuildIndex.nextWord(this.parserText, this.parserTextUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_INDEX)) {
                throw new OCommandSQLParsingException("Keyword INDEX not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLRebuildIndex.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false)) == -1) {
                throw new OCommandSQLParsingException("Expected index name", this.parserText, oldPos);
            }
            this.name = word.toString();
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.name == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseDocumentInternal database = OCommandExecutorSQLRebuildIndex.getDatabase();
        if (this.name.equals("*")) {
            long totalIndexed = 0L;
            for (OIndex<?> idx : database.getMetadata().getIndexManager().getIndexes()) {
                if (!idx.isAutomatic()) continue;
                totalIndexed += idx.rebuild();
            }
            return totalIndexed;
        }
        OIndex<?> idx = database.getMetadata().getIndexManager().getIndex(this.name);
        if (idx == null) {
            throw new OCommandExecutionException("Index '" + this.name + "' not found");
        }
        if (!idx.isAutomatic()) {
            throw new OCommandExecutionException("Cannot rebuild index '" + this.name + "' because it's manual and there aren't indications of what to index");
        }
        return idx.rebuild();
    }

    @Override
    public String getSyntax() {
        return "REBUILD INDEX <index-name>";
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }
}

