/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.sql.executor.ORidSetIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ORidSet
implements Set<ORID> {
    protected static int INITIAL_BLOCK_SIZE = 4096;
    protected long[][][] content = new long[8][][];
    long size = 0L;
    protected int maxArraySize;

    public ORidSet() {
        this(0xCCCCCCC);
    }

    public ORidSet(int bucketSize) {
        this.maxArraySize = bucketSize;
    }

    @Override
    public int size() {
        return this.size <= Integer.MAX_VALUE ? (int)this.size : Integer.MAX_VALUE;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    @Override
    public boolean contains(Object o) {
        if (this.size == 0L) {
            return false;
        }
        if (!(o instanceof ORID)) {
            throw new IllegalArgumentException();
        }
        ORID identifiable = (ORID)o;
        if (identifiable == null) {
            throw new IllegalArgumentException();
        }
        int cluster = identifiable.getClusterId();
        long position = identifiable.getClusterPosition();
        if (cluster < 0 || position < 0L) {
            return false;
        }
        long positionByte = position / 63L;
        int positionBit = (int)(position % 63L);
        int block = (int)(positionByte / (long)this.maxArraySize);
        int blockPositionByteInt = (int)(positionByte % (long)this.maxArraySize);
        if (this.content.length <= cluster) {
            return false;
        }
        if (this.content[cluster] == null) {
            return false;
        }
        if (this.content[cluster].length <= block) {
            return false;
        }
        if (this.content[cluster][block] == null) {
            return false;
        }
        if (this.content[cluster][block].length <= blockPositionByteInt) {
            return false;
        }
        long currentMask = 1L << positionBit;
        long existed = this.content[cluster][block][blockPositionByteInt] & currentMask;
        return existed > 0L;
    }

    @Override
    public Iterator<ORID> iterator() {
        return new ORidSetIterator(this);
    }

    @Override
    public Object[] toArray() {
        return new Object[0];
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return null;
    }

    @Override
    public boolean add(ORID identifiable) {
        if (identifiable == null) {
            throw new IllegalArgumentException();
        }
        int cluster = identifiable.getClusterId();
        long position = identifiable.getClusterPosition();
        if (cluster < 0 || position < 0L) {
            throw new IllegalArgumentException("negative RID");
        }
        long positionByte = position / 63L;
        int positionBit = (int)(position % 63L);
        int block = (int)(positionByte / (long)this.maxArraySize);
        int blockPositionByteInt = (int)(positionByte % (long)this.maxArraySize);
        if (this.content.length <= cluster) {
            long[][][] oldContent = this.content;
            this.content = new long[cluster + 1][][];
            System.arraycopy(oldContent, 0, this.content, 0, oldContent.length);
        }
        if (this.content[cluster] == null) {
            this.content[cluster] = ORidSet.createClusterArray(block, blockPositionByteInt);
        }
        if (this.content[cluster].length <= block) {
            this.content[cluster] = ORidSet.expandClusterBlocks(this.content[cluster], block, blockPositionByteInt);
        }
        if (this.content[cluster][block] == null) {
            this.content[cluster][block] = ORidSet.expandClusterArray(new long[INITIAL_BLOCK_SIZE], blockPositionByteInt);
        }
        if (this.content[cluster][block].length <= blockPositionByteInt) {
            this.content[cluster][block] = ORidSet.expandClusterArray(this.content[cluster][block], blockPositionByteInt);
        }
        long original = this.content[cluster][block][blockPositionByteInt];
        long currentMask = 1L << positionBit;
        long existed = this.content[cluster][block][blockPositionByteInt] & currentMask;
        this.content[cluster][block][blockPositionByteInt] = original | currentMask;
        if (existed == 0L) {
            ++this.size;
        }
        return existed == 0L;
    }

    private static long[][] expandClusterBlocks(long[][] longs, int block, int blockPositionByteInt) {
        long[][] result = new long[block + 1][];
        System.arraycopy(longs, 0, result, 0, longs.length);
        result[block] = ORidSet.expandClusterArray(new long[INITIAL_BLOCK_SIZE], blockPositionByteInt);
        return result;
    }

    private static long[][] createClusterArray(int block, int positionByteInt) {
        int currentSize = INITIAL_BLOCK_SIZE;
        while (currentSize <= positionByteInt) {
            if ((currentSize *= 2) >= 0) continue;
            currentSize = positionByteInt + 1;
            break;
        }
        long[][] result = new long[block + 1][];
        result[block] = new long[currentSize];
        return result;
    }

    private static long[] expandClusterArray(long[] original, int positionByteInt) {
        int currentSize = original.length;
        while (currentSize <= positionByteInt) {
            if ((currentSize *= 2) >= 0) continue;
            currentSize = positionByteInt + 1;
            break;
        }
        long[] result = new long[currentSize];
        System.arraycopy(original, 0, result, 0, original.length);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof ORID)) {
            throw new IllegalArgumentException();
        }
        ORID identifiable = (ORID)o;
        if (identifiable == null) {
            throw new IllegalArgumentException();
        }
        int cluster = identifiable.getClusterId();
        long position = identifiable.getClusterPosition();
        if (cluster < 0 || position < 0L) {
            throw new IllegalArgumentException("negative RID");
        }
        long positionByte = position / 63L;
        int positionBit = (int)(position % 63L);
        int block = (int)(positionByte / (long)this.maxArraySize);
        int blockPositionByteInt = (int)(positionByte % (long)this.maxArraySize);
        if (this.content.length <= cluster) {
            return false;
        }
        if (this.content[cluster] == null) {
            return false;
        }
        if (this.content[cluster].length <= block) {
            return false;
        }
        if (this.content[cluster][block].length <= blockPositionByteInt) {
            return false;
        }
        long original = this.content[cluster][block][blockPositionByteInt];
        long currentMask = 1L << positionBit;
        long existed = this.content[cluster][block][blockPositionByteInt] & currentMask;
        this.content[cluster][block][blockPositionByteInt] = original & (currentMask ^= 0xFFFFFFFFFFFFFFFFL);
        if (existed > 0L) {
            --this.size;
        }
        return existed == 0L;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends ORID> c) {
        boolean added = false;
        for (ORID oRID : c) {
            added = added && this.add(oRID);
        }
        return added;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            this.remove(o);
        }
        return true;
    }

    @Override
    public void clear() {
        this.content = new long[8][][];
        this.size = 0L;
    }
}

