/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OJson;
import java.util.Map;
import java.util.Optional;

public class UpdateContentStep
extends AbstractExecutionStep {
    private OJson json;
    private OInputParameter inputParameter;

    public UpdateContentStep(OJson json, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.json = json;
    }

    public UpdateContentStep(OInputParameter inputParameter, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.inputParameter = inputParameter;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, int nRecords) throws OTimeoutException {
        final OResultSet upstream = this.getPrev().get().syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return upstream.hasNext();
            }

            @Override
            public OResult next() {
                OResult result = upstream.next();
                if (result instanceof OResultInternal) {
                    if (!(result.getElement().get() instanceof OElement)) {
                        ((OResultInternal)result).setElement((OIdentifiable)result.getElement().get().getRecord());
                    }
                    if (!(result.getElement().get() instanceof OElement)) {
                        return result;
                    }
                    UpdateContentStep.this.handleContent(result.getElement().get(), ctx);
                }
                return result;
            }

            @Override
            public void close() {
                upstream.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private boolean handleContent(OElement record, OCommandContext ctx) {
        OImmutableClass recordClass;
        boolean updated = false;
        ODocument fieldsToPreserve = new ODocument();
        OClass restricted = ctx.getDatabase().getMetadata().getSchema().getClass("ORestricted");
        if (restricted != null && restricted.isSuperClassOf(record.getSchemaType().orElse(null))) {
            for (OProperty oProperty : restricted.properties()) {
                fieldsToPreserve.field(oProperty.getName(), record.getProperty(oProperty.getName()));
            }
        }
        if ((recordClass = ODocumentInternal.getImmutableSchemaClass((ODatabaseDocumentInternal)ctx.getDatabase(), (ODocument)record.getRecord())) != null && recordClass.isSubClassOf("V")) {
            for (String fieldName : record.getPropertyNames()) {
                if (!fieldName.startsWith("in_") && !fieldName.startsWith("out_")) continue;
                fieldsToPreserve.field(fieldName, record.getProperty(fieldName));
            }
        } else if (recordClass != null && recordClass.isSubClassOf("E")) {
            for (String fieldName : record.getPropertyNames()) {
                if (!fieldName.equals("in") && !fieldName.equals("out")) continue;
                fieldsToPreserve.field(fieldName, record.getProperty(fieldName));
            }
        }
        ODocument oDocument = (ODocument)record.getRecord();
        if (this.json != null) {
            oDocument.merge(this.json.toDocument(record, ctx), false, false);
        } else if (this.inputParameter != null) {
            Object val = this.inputParameter.getValue(ctx.getInputParameters());
            if (val instanceof OElement) {
                oDocument.merge((ODocument)((OElement)val).getRecord(), false, false);
            } else if (val instanceof Map) {
                oDocument.merge(new ODocument().fromMap((Map)val), false, false);
            } else {
                throw new OCommandExecutionException("Invalid value for UPDATE CONTENT: " + val);
            }
        }
        oDocument.merge(fieldsToPreserve, true, false);
        updated = true;
        return updated;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ UPDATE CONTENT\n");
        result.append(spaces);
        result.append("  ");
        if (this.json != null) {
            result.append(this.json);
        } else {
            result.append(this.inputParameter);
        }
        return result.toString();
    }
}

