/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.executor.OCreateEdgeExecutionPlanner;
import com.orientechnologies.orient.core.sql.executor.OInsertExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OBatch;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInsertBody;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.HashMap;
import java.util.Map;

public class OCreateEdgeStatement
extends OStatement {
    protected OIdentifier targetClass;
    protected OIdentifier targetClusterName;
    protected boolean upsert = false;
    protected OExpression leftExpression;
    protected OExpression rightExpression;
    protected OInsertBody body;
    protected Number retry;
    protected Number wait;
    protected OBatch batch;

    public OCreateEdgeStatement(int id) {
        super(id);
    }

    public OCreateEdgeStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet execute(ODatabase db, Object[] args, OCommandContext parentCtx, boolean usePlanCache) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.put(i, args[i]);
            }
        }
        ctx.setInputParameters(params);
        OInsertExecutionPlan executionPlan = usePlanCache ? this.createExecutionPlan(ctx, false) : this.createExecutionPlanNoCache(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OResultSet execute(ODatabase db, Map params, OCommandContext parentCtx, boolean usePlanCache) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        ctx.setInputParameters(params);
        OInsertExecutionPlan executionPlan = usePlanCache ? this.createExecutionPlan(ctx, false) : this.createExecutionPlanNoCache(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OInsertExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        OCreateEdgeExecutionPlanner planner = new OCreateEdgeExecutionPlanner(this);
        OInsertExecutionPlan result = planner.createExecutionPlan(ctx, enableProfiling, true);
        result.setStatement(this.originalStatement);
        return result;
    }

    @Override
    public OInsertExecutionPlan createExecutionPlanNoCache(OCommandContext ctx, boolean enableProfiling) {
        OCreateEdgeExecutionPlanner planner = new OCreateEdgeExecutionPlanner(this);
        OInsertExecutionPlan result = planner.createExecutionPlan(ctx, enableProfiling, false);
        result.setStatement(this.originalStatement);
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("CREATE EDGE");
        if (this.targetClass != null) {
            builder.append(" ");
            this.targetClass.toString(params, builder);
            if (this.targetClusterName != null) {
                builder.append(" CLUSTER ");
                this.targetClusterName.toString(params, builder);
            }
        }
        if (this.upsert) {
            builder.append(" UPSERT");
        }
        builder.append(" FROM ");
        this.leftExpression.toString(params, builder);
        builder.append(" TO ");
        this.rightExpression.toString(params, builder);
        if (this.body != null) {
            builder.append(" ");
            this.body.toString(params, builder);
        }
        if (this.retry != null) {
            builder.append(" RETRY ");
            builder.append(this.retry);
        }
        if (this.wait != null) {
            builder.append(" WAIT ");
            builder.append(this.wait);
        }
        if (this.batch != null) {
            this.batch.toString(params, builder);
        }
    }

    @Override
    public boolean executinPlanCanBeCached() {
        if (this.leftExpression != null && !this.leftExpression.isCacheable()) {
            return false;
        }
        if (this.rightExpression != null && !this.rightExpression.isCacheable()) {
            return false;
        }
        return this.body == null || this.body.isCacheable();
    }

    @Override
    public OCreateEdgeStatement copy() {
        OCreateEdgeStatement result = null;
        try {
            result = (OCreateEdgeStatement)this.getClass().getConstructor(Integer.TYPE).newInstance(-1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        result.targetClass = this.targetClass == null ? null : this.targetClass.copy();
        result.targetClusterName = this.targetClusterName == null ? null : this.targetClusterName.copy();
        result.upsert = this.upsert;
        result.leftExpression = this.leftExpression == null ? null : this.leftExpression.copy();
        result.rightExpression = this.rightExpression == null ? null : this.rightExpression.copy();
        result.body = this.body == null ? null : this.body.copy();
        result.retry = this.retry;
        result.wait = this.wait;
        result.batch = this.batch == null ? null : this.batch.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCreateEdgeStatement that = (OCreateEdgeStatement)o;
        if (this.upsert != that.upsert) {
            return false;
        }
        if (this.targetClass != null ? !this.targetClass.equals(that.targetClass) : that.targetClass != null) {
            return false;
        }
        if (this.targetClusterName != null ? !this.targetClusterName.equals(that.targetClusterName) : that.targetClusterName != null) {
            return false;
        }
        if (this.leftExpression != null ? !this.leftExpression.equals(that.leftExpression) : that.leftExpression != null) {
            return false;
        }
        if (this.rightExpression != null ? !this.rightExpression.equals(that.rightExpression) : that.rightExpression != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        if (this.retry != null ? !this.retry.equals(that.retry) : that.retry != null) {
            return false;
        }
        if (this.wait != null ? !this.wait.equals(that.wait) : that.wait != null) {
            return false;
        }
        return this.batch != null ? this.batch.equals(that.batch) : that.batch == null;
    }

    public int hashCode() {
        int result = this.targetClass != null ? this.targetClass.hashCode() : 0;
        result = 31 * result + (this.targetClusterName != null ? this.targetClusterName.hashCode() : 0);
        result = 31 * result + (this.upsert ? 1 : 0);
        result = 31 * result + (this.leftExpression != null ? this.leftExpression.hashCode() : 0);
        result = 31 * result + (this.rightExpression != null ? this.rightExpression.hashCode() : 0);
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.retry != null ? this.retry.hashCode() : 0);
        result = 31 * result + (this.wait != null ? this.wait.hashCode() : 0);
        result = 31 * result + (this.batch != null ? this.batch.hashCode() : 0);
        return result;
    }

    public OIdentifier getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(OIdentifier targetClass) {
        this.targetClass = targetClass;
    }

    public OIdentifier getTargetClusterName() {
        return this.targetClusterName;
    }

    public void setTargetClusterName(OIdentifier targetClusterName) {
        this.targetClusterName = targetClusterName;
    }

    public OExpression getLeftExpression() {
        return this.leftExpression;
    }

    public void setLeftExpression(OExpression leftExpression) {
        this.leftExpression = leftExpression;
    }

    public OExpression getRightExpression() {
        return this.rightExpression;
    }

    public void setRightExpression(OExpression rightExpression) {
        this.rightExpression = rightExpression;
    }

    public OInsertBody getBody() {
        return this.body;
    }

    public void setBody(OInsertBody body) {
        this.body = body;
    }

    public Number getRetry() {
        return this.retry;
    }

    public void setRetry(Number retry) {
        this.retry = retry;
    }

    public Number getWait() {
        return this.wait;
    }

    public void setWait(Number wait) {
        this.wait = wait;
    }

    public OBatch getBatch() {
        return this.batch;
    }

    public void setBatch(OBatch batch) {
        this.batch = batch;
    }

    public boolean isUpsert() {
        return this.upsert;
    }
}

