/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionFactory;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OIndexName;
import com.orientechnologies.orient.core.sql.parser.OJson;
import com.orientechnologies.orient.core.sql.parser.ORecordAttribute;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class OCreateIndexStatement
extends ODDLStatement {
    protected OIndexName name;
    protected OIdentifier className;
    protected List<Property> propertyList = new ArrayList<Property>();
    protected OIdentifier type;
    protected OIdentifier engine;
    protected List<OIdentifier> keyTypes = new ArrayList<OIdentifier>();
    protected OJson metadata;
    protected boolean ifNotExists = false;

    public OCreateIndexStatement(int id) {
        super(id);
    }

    public OCreateIndexStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        Object execResult = this.execute(ctx);
        OInternalResultSet rs = new OInternalResultSet();
        if (execResult != null) {
            OResultInternal result = new OResultInternal();
            result.setProperty("operation", "create index");
            result.setProperty("name", this.name.getValue());
            rs.add(result);
        }
        return rs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object execute(OCommandContext ctx) {
        OIndex<?> idx;
        ODatabase database = ctx.getDatabase();
        if (database.getMetadata().getIndexManager().existsIndex(this.name.getValue())) {
            if (!this.ifNotExists) throw new OCommandExecutionException("Index " + this.name + " already exists");
            return null;
        }
        List<OCollate> collatesList = this.calculateCollates(ctx);
        String engine = this.engine == null ? null : this.engine.getStringValue().toUpperCase(Locale.ENGLISH);
        ODocument metadataDoc = this.calculateMetadata(ctx);
        if (this.propertyList == null || this.propertyList.size() == 0) {
            OIndexFactory factory = OIndexes.getFactory(this.type.getStringValue(), null);
            OType[] keyTypes = this.calculateKeyTypes(ctx);
            if (keyTypes != null && keyTypes.length > 0) {
                idx = database.getMetadata().getIndexManager().createIndex(this.name.getValue(), this.type.getStringValue(), new OSimpleKeyIndexDefinition(keyTypes, collatesList), null, null, metadataDoc, engine);
            } else if (keyTypes != null && keyTypes.length == 0 && "LUCENE_CROSS_CLASS".equalsIgnoreCase(engine)) {
                OSimpleKeyIndexDefinition keyDef = new OSimpleKeyIndexDefinition(new OType[]{OType.STRING}, collatesList);
                idx = database.getMetadata().getIndexManager().createIndex(this.name.getValue(), this.type.getStringValue(), keyDef, null, null, metadataDoc, engine);
            } else {
                if ((this.className != null || keyTypes != null) && keyTypes.length != 0) throw new ODatabaseException("Impossible to create an index without specify the key type or the associated property: " + this.toString());
                String[] split = this.name.getValue().split("\\.");
                if (split.length != 2) {
                    throw new ODatabaseException("Impossible to create an index without specify class and property name nor key types: " + this.toString());
                }
                OClass oClass = database.getClass(split[0]);
                if (oClass == null) {
                    throw new ODatabaseException("Impossible to create an index, class not found: " + split[0]);
                }
                if (oClass.getProperty(split[1]) == null) {
                    throw new ODatabaseException("Impossible to create an index, property not found: " + this.name.getValue());
                }
                String[] fields = new String[]{split[1]};
                idx = this.getoIndex(oClass, fields, engine, database, collatesList, metadataDoc);
            }
        } else {
            String[] fields = this.calculateProperties(ctx);
            OClass oClass = this.getIndexClass(ctx);
            idx = this.getoIndex(oClass, fields, engine, database, collatesList, metadataDoc);
        }
        if (idx == null) return null;
        return idx.getSize();
    }

    private OIndex<?> getoIndex(OClass oClass, String[] fields, String engine, ODatabase database, List<OCollate> collatesList, ODocument metadataDoc) {
        OIndex<?> idx;
        if ((this.keyTypes == null || this.keyTypes.size() == 0) && collatesList == null) {
            idx = oClass.createIndex(this.name.getValue(), this.type.getStringValue(), (OProgressListener)null, metadataDoc, engine, fields);
        } else {
            List<OType> fieldTypeList;
            if (this.keyTypes == null || this.keyTypes.size() == 0 && fields.length > 0) {
                for (String fieldName : fields) {
                    if (fieldName.equals("@rid") || oClass.existsProperty(fieldName)) continue;
                    throw new OIndexException("Index with name : '" + this.name.getValue() + "' cannot be created on class : '" + oClass.getName() + "' because field: '" + fieldName + "' is absent in class definition.");
                }
                fieldTypeList = ((OClassImpl)oClass).extractFieldTypes(fields);
            } else {
                fieldTypeList = this.keyTypes.stream().map(x -> OType.valueOf(x.getStringValue())).collect(Collectors.toList());
            }
            OIndexDefinition idxDef = OIndexDefinitionFactory.createIndexDefinition(oClass, Arrays.asList(fields), fieldTypeList, collatesList, this.type.getStringValue(), null);
            idx = database.getMetadata().getIndexManager().createIndex(this.name.getValue(), this.type.getStringValue(), idxDef, oClass.getPolymorphicClusterIds(), null, metadataDoc, engine);
        }
        return idx;
    }

    private String[] calculateProperties(OCommandContext ctx) {
        if (this.propertyList == null) {
            return null;
        }
        return this.propertyList.stream().map(x -> x.getCompleteKey()).collect(Collectors.toList()).toArray(new String[0]);
    }

    private OClass getIndexClass(OCommandContext ctx) {
        if (this.className == null) {
            return null;
        }
        OClass result = ctx.getDatabase().getMetadata().getSchema().getClass(this.className.getStringValue());
        if (result == null) {
            throw new OCommandExecutionException("Cannot find class " + this.className);
        }
        return result;
    }

    private ODocument calculateMetadata(OCommandContext ctx) {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.toDocument(null, ctx);
    }

    private OType[] calculateKeyTypes(OCommandContext ctx) {
        if (this.keyTypes == null) {
            return new OType[0];
        }
        return this.keyTypes.stream().map(x -> OType.valueOf(x.getStringValue())).collect(Collectors.toList()).toArray(new OType[0]);
    }

    private List<OCollate> calculateCollates(OCommandContext ctx) {
        ArrayList<OCollate> result = new ArrayList<OCollate>();
        boolean found = false;
        for (Property prop : this.propertyList) {
            String collate;
            String string = collate = prop.collate == null ? null : prop.collate.getStringValue();
            if (collate != null) {
                OCollate col = OSQLEngine.getCollate(collate);
                result.add(col);
                found = true;
                continue;
            }
            result.add(null);
        }
        if (!found) {
            return null;
        }
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        boolean first;
        builder.append("CREATE INDEX ");
        this.name.toString(params, builder);
        if (this.className != null) {
            builder.append(" ON ");
            this.className.toString(params, builder);
            builder.append(" (");
            first = true;
            for (Property prop : this.propertyList) {
                if (!first) {
                    builder.append(", ");
                }
                if (prop.name != null) {
                    prop.name.toString(params, builder);
                } else {
                    prop.recordAttribute.toString(params, builder);
                }
                if (prop.byKey) {
                    builder.append(" BY KEY");
                } else if (prop.byValue) {
                    builder.append(" BY VALUE");
                }
                if (prop.collate != null) {
                    builder.append(" COLLATE ");
                    prop.collate.toString(params, builder);
                }
                first = false;
            }
            builder.append(")");
        }
        builder.append(" ");
        this.type.toString(params, builder);
        if (this.engine != null) {
            builder.append(" ENGINE ");
            this.engine.toString(params, builder);
        }
        if (this.keyTypes != null && this.keyTypes.size() > 0) {
            first = true;
            builder.append(" ");
            for (OIdentifier keyType : this.keyTypes) {
                if (!first) {
                    builder.append(",");
                }
                keyType.toString(params, builder);
                first = false;
            }
        }
        if (this.metadata != null) {
            builder.append(" METADATA ");
            this.metadata.toString(params, builder);
        }
    }

    @Override
    public OCreateIndexStatement copy() {
        OCreateIndexStatement result = new OCreateIndexStatement(-1);
        result.name = this.name == null ? null : this.name.copy();
        result.className = this.className == null ? null : this.className.copy();
        result.propertyList = this.propertyList == null ? null : this.propertyList.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.type = this.type == null ? null : this.type.copy();
        result.engine = this.engine == null ? null : this.engine.copy();
        result.keyTypes = this.keyTypes == null ? null : this.keyTypes.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.metadata = this.metadata == null ? null : this.metadata.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCreateIndexStatement that = (OCreateIndexStatement)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.propertyList != null ? !this.propertyList.equals(that.propertyList) : that.propertyList != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.engine != null ? !this.engine.equals(that.engine) : that.engine != null) {
            return false;
        }
        if (this.keyTypes != null ? !this.keyTypes.equals(that.keyTypes) : that.keyTypes != null) {
            return false;
        }
        return this.metadata != null ? this.metadata.equals(that.metadata) : that.metadata == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 31 * result + (this.propertyList != null ? this.propertyList.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.engine != null ? this.engine.hashCode() : 0);
        result = 31 * result + (this.keyTypes != null ? this.keyTypes.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public static class Property {
        protected OIdentifier name;
        protected ORecordAttribute recordAttribute;
        protected boolean byKey = false;
        protected boolean byValue = false;
        protected OIdentifier collate;

        public Property copy() {
            Property result = new Property();
            result.name = this.name == null ? null : this.name.copy();
            result.recordAttribute = this.recordAttribute == null ? null : this.recordAttribute.copy();
            result.byKey = this.byKey;
            result.byValue = this.byValue;
            result.collate = this.collate == null ? null : this.collate.copy();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Property property = (Property)o;
            if (this.byKey != property.byKey) {
                return false;
            }
            if (this.byValue != property.byValue) {
                return false;
            }
            if (this.name != null ? !this.name.equals(property.name) : property.name != null) {
                return false;
            }
            if (this.recordAttribute != null ? !this.recordAttribute.equals(property.recordAttribute) : property.recordAttribute != null) {
                return false;
            }
            return this.collate != null ? this.collate.equals(property.collate) : property.collate == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.recordAttribute != null ? this.recordAttribute.hashCode() : 0);
            result = 31 * result + (this.byKey ? 1 : 0);
            result = 31 * result + (this.byValue ? 1 : 0);
            result = 31 * result + (this.collate != null ? this.collate.hashCode() : 0);
            return result;
        }

        public String getCompleteKey() {
            StringBuilder result = new StringBuilder();
            if (this.name != null) {
                result.append(this.name.getStringValue());
            } else if (this.recordAttribute != null) {
                result.append(this.recordAttribute.getName());
            }
            if (this.byKey) {
                result.append(" by key");
            }
            if (this.byValue) {
                result.append(" by value");
            }
            return result.toString();
        }
    }
}

