/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OMatchPathItem;
import com.orientechnologies.orient.core.sql.parser.OMatchStatement;
import com.orientechnologies.orient.core.sql.parser.OSuffixIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class OFieldMatchPathItem
extends OMatchPathItem {
    protected OIdentifier field;
    private OSuffixIdentifier exp;

    public OFieldMatchPathItem(int id) {
        super(id);
    }

    public OFieldMatchPathItem(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public boolean isBidirectional() {
        return false;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append(".");
        this.field.toString(params, builder);
        if (this.filter != null) {
            this.filter.toString(params, builder);
        }
    }

    @Override
    protected Iterable<OIdentifiable> traversePatternEdge(OMatchStatement.MatchContext matchContext, OIdentifiable startingPoint, OCommandContext iCommandContext) {
        Object qR;
        if (this.exp == null) {
            this.exp = new OSuffixIdentifier(this.field);
        }
        return (qR = this.exp.execute(startingPoint, iCommandContext)) instanceof Iterable && !(qR instanceof ODocument) ? (Iterable)qR : Collections.singleton((OIdentifiable)qR);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OFieldMatchPathItem that = (OFieldMatchPathItem)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.exp, that.exp);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.field, this.exp);
    }

    @Override
    public OMatchPathItem copy() {
        OFieldMatchPathItem result = null;
        try {
            result = (OFieldMatchPathItem)this.getClass().getConstructor(Integer.TYPE).newInstance(-1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        result.field = this.field == null ? null : this.field.copy();
        result.method = this.method == null ? null : this.method.copy();
        result.filter = this.filter == null ? null : this.filter.copy();
        return result;
    }

    public OIdentifier getField() {
        return this.field;
    }

    public OSuffixIdentifier getExp() {
        if (this.exp == null) {
            this.exp = new OSuffixIdentifier(this.field);
        }
        return this.exp;
    }
}

