/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionFiltered;
import com.orientechnologies.orient.core.sql.method.OSQLMethod;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OMethodCall
extends SimpleNode {
    static Set<String> graphMethods = new HashSet<String>(Arrays.asList("out", "in", "both", "outE", "inE", "bothE", "bothV", "outV", "inV"));
    static Set<String> bidirectionalMethods = new HashSet<String>(Arrays.asList("out", "in", "both", "oute", "ine", "inv", "outv", "bothe", "bothv"));
    protected OIdentifier methodName;
    protected List<OExpression> params = new ArrayList<OExpression>();
    private Boolean calculatedIsGraph = null;

    public OMethodCall(int id) {
        super(id);
    }

    public OMethodCall(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append(".");
        this.methodName.toString(params, builder);
        builder.append("(");
        boolean first = true;
        for (OExpression param : this.params) {
            if (!first) {
                builder.append(", ");
            }
            param.toString(params, builder);
            first = false;
        }
        builder.append(")");
    }

    public boolean isBidirectional() {
        return bidirectionalMethods.contains(this.methodName.getStringValue().toLowerCase(Locale.ENGLISH));
    }

    public Object execute(Object targetObjects, OCommandContext ctx) {
        return this.execute(targetObjects, ctx, this.methodName.getStringValue(), this.params, null);
    }

    public Object execute(Object targetObjects, Iterable<OIdentifiable> iPossibleResults, OCommandContext ctx) {
        return this.execute(targetObjects, ctx, this.methodName.getStringValue(), this.params, iPossibleResults);
    }

    private Object execute(Object targetObjects, OCommandContext ctx, String name, List<OExpression> iParams, Iterable<OIdentifiable> iPossibleResults) {
        ArrayList<Object> paramValues = new ArrayList<Object>();
        Object val = ctx.getVariable("$current");
        if (val == null && targetObjects == null) {
            return null;
        }
        for (OExpression expr : iParams) {
            if (val instanceof OIdentifiable) {
                paramValues.add(expr.execute((OIdentifiable)val, ctx));
                continue;
            }
            if (val instanceof OResult) {
                paramValues.add(expr.execute((OResult)val, ctx));
                continue;
            }
            if (targetObjects instanceof OIdentifiable) {
                paramValues.add(expr.execute((OIdentifiable)targetObjects, ctx));
                continue;
            }
            if (targetObjects instanceof OResult) {
                paramValues.add(expr.execute((OResult)targetObjects, ctx));
                continue;
            }
            throw new OCommandExecutionException("Invalild value for $current: " + val);
        }
        if (this.isGraphFunction()) {
            Object current;
            OSQLFunction function = OSQLEngine.getInstance().getFunction(name);
            if (function instanceof OSQLFunctionFiltered) {
                current = ctx.getVariable("$current");
                if (current instanceof OResult) {
                    current = ((OResult)current).getElement().orElse(null);
                }
                return ((OSQLFunctionFiltered)function).execute(targetObjects, (OIdentifiable)current, null, paramValues.toArray(), iPossibleResults, ctx);
            }
            current = ctx.getVariable("$current");
            if (current instanceof OIdentifiable) {
                return function.execute(targetObjects, (OIdentifiable)current, null, paramValues.toArray(), ctx);
            }
            if (current instanceof OResult) {
                return function.execute(targetObjects, ((OResult)current).getElement().orElse(null), null, paramValues.toArray(), ctx);
            }
            return function.execute(targetObjects, null, null, paramValues.toArray(), ctx);
        }
        OSQLMethod method = OSQLEngine.getMethod(name);
        if (method != null) {
            if (val instanceof OResult) {
                val = ((OResult)val).getElement().orElse(null);
            }
            return method.execute(targetObjects, (OIdentifiable)val, ctx, targetObjects, paramValues.toArray());
        }
        throw new UnsupportedOperationException("OMethod call, something missing in the implementation...?");
    }

    public Object executeReverse(Object targetObjects, OCommandContext ctx) {
        if (!this.isBidirectional()) {
            throw new UnsupportedOperationException();
        }
        String straightName = this.methodName.getStringValue();
        if (straightName.equalsIgnoreCase("out")) {
            return this.execute(targetObjects, ctx, "in", this.params, null);
        }
        if (straightName.equalsIgnoreCase("in")) {
            return this.execute(targetObjects, ctx, "out", this.params, null);
        }
        if (straightName.equalsIgnoreCase("both")) {
            return this.execute(targetObjects, ctx, "both", this.params, null);
        }
        if (straightName.equalsIgnoreCase("outE")) {
            return this.execute(targetObjects, ctx, "outV", this.params, null);
        }
        if (straightName.equalsIgnoreCase("outV")) {
            return this.execute(targetObjects, ctx, "outE", this.params, null);
        }
        if (straightName.equalsIgnoreCase("inE")) {
            return this.execute(targetObjects, ctx, "inV", this.params, null);
        }
        if (straightName.equalsIgnoreCase("inV")) {
            return this.execute(targetObjects, ctx, "inE", this.params, null);
        }
        if (straightName.equalsIgnoreCase("bothE")) {
            return this.execute(targetObjects, ctx, "bothV", this.params, null);
        }
        if (straightName.equalsIgnoreCase("bothV")) {
            return this.execute(targetObjects, ctx, "bothE", this.params, null);
        }
        throw new UnsupportedOperationException("Invalid reverse traversal: " + this.methodName);
    }

    public static ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }

    public boolean needsAliases(Set<String> aliases) {
        for (OExpression param : this.params) {
            if (!param.needsAliases(aliases)) continue;
            return true;
        }
        return false;
    }

    @Override
    public OMethodCall copy() {
        OMethodCall result = new OMethodCall(-1);
        result.methodName = this.methodName.copy();
        result.params = this.params.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OMethodCall that = (OMethodCall)o;
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        return !(this.params != null ? !this.params.equals(that.params) : that.params != null);
    }

    public int hashCode() {
        int result = this.methodName != null ? this.methodName.hashCode() : 0;
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        return result;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        if (this.params != null) {
            for (OExpression param : this.params) {
                param.extractSubQueries(collector);
            }
        }
    }

    public boolean refersToParent() {
        if (this.params != null) {
            for (OExpression exp : this.params) {
                if (!exp.refersToParent()) continue;
                return true;
            }
        }
        return false;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.methodName != null) {
            result.setProperty("methodName", this.methodName.serialize());
        }
        if (this.params != null) {
            result.setProperty("items", this.params.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("methodName") != null) {
            this.methodName = OIdentifier.deserialize((OResult)fromResult.getProperty("methodName"));
        }
        if (fromResult.getProperty("params") != null) {
            List ser = (List)fromResult.getProperty("params");
            this.params = new ArrayList<OExpression>();
            for (OResult r : ser) {
                OExpression exp = new OExpression(-1);
                exp.deserialize(r);
                this.params.add(exp);
            }
        }
    }

    public boolean isCacheable() {
        return this.isGraphFunction();
    }

    private boolean isGraphFunction() {
        if (this.calculatedIsGraph != null) {
            return this.calculatedIsGraph;
        }
        for (String graphMethod : graphMethods) {
            if (!graphMethod.equalsIgnoreCase(this.methodName.getStringValue())) continue;
            this.calculatedIsGraph = true;
            break;
        }
        if (this.calculatedIsGraph == null) {
            this.calculatedIsGraph = false;
        }
        return this.calculatedIsGraph;
    }
}

