/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OPermission;
import com.orientechnologies.orient.core.sql.parser.OResourcePathItem;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ORevokeStatement
extends OSimpleExecStatement {
    protected OPermission permission;
    protected List<OResourcePathItem> resourceChain = new ArrayList<OResourcePathItem>();
    protected OIdentifier actor;

    public ORevokeStatement(int id) {
        super(id);
    }

    public ORevokeStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        ORole role = ORevokeStatement.getDatabase().getMetadata().getSecurity().getRole(this.actor.getStringValue());
        if (role == null) {
            throw new OCommandExecutionException("Invalid role: " + this.actor.getStringValue());
        }
        String resourcePath = this.toResourcePath(this.resourceChain, ctx);
        role.revoke(resourcePath, this.toPrivilege(this.permission.permission));
        role.save();
        OInternalResultSet rs = new OInternalResultSet();
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "grant");
        result.setProperty("role", this.actor.getStringValue());
        result.setProperty("permission", this.permission.toString());
        result.setProperty("resource", resourcePath);
        rs.add(result);
        return rs;
    }

    private String toResourcePath(List<OResourcePathItem> resourceChain, OCommandContext ctx) {
        Map<Object, Object> params = ctx.getInputParameters();
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (OResourcePathItem res : resourceChain) {
            if (!first) {
                builder.append(".");
            }
            res.toString(params, builder);
            first = false;
        }
        return builder.toString();
    }

    protected int toPrivilege(String privilegeName) {
        int privilege;
        if ("CREATE".equals(privilegeName)) {
            privilege = ORole.PERMISSION_CREATE;
        } else if ("READ".equals(privilegeName)) {
            privilege = ORole.PERMISSION_READ;
        } else if ("UPDATE".equals(privilegeName)) {
            privilege = ORole.PERMISSION_UPDATE;
        } else if ("DELETE".equals(privilegeName)) {
            privilege = ORole.PERMISSION_DELETE;
        } else if ("EXECUTE".equals(privilegeName)) {
            privilege = ORole.PERMISSION_EXECUTE;
        } else if ("ALL".equals(privilegeName)) {
            privilege = ORole.PERMISSION_ALL;
        } else if ("NONE".equals(privilegeName)) {
            privilege = 0;
        } else {
            throw new OCommandExecutionException("Unrecognized privilege '" + privilegeName + "'");
        }
        return privilege;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("REVOKE ");
        this.permission.toString(params, builder);
        builder.append(" ON ");
        boolean first = true;
        for (OResourcePathItem res : this.resourceChain) {
            if (!first) {
                builder.append(".");
            }
            res.toString(params, builder);
            first = false;
        }
        builder.append(" FROM ");
        this.actor.toString(params, builder);
    }

    @Override
    public ORevokeStatement copy() {
        ORevokeStatement result = new ORevokeStatement(-1);
        result.permission = this.permission == null ? null : this.permission.copy();
        result.resourceChain = this.resourceChain == null ? null : this.resourceChain.stream().map(OResourcePathItem::copy).collect(Collectors.toList());
        result.actor = this.actor == null ? null : this.actor.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ORevokeStatement that = (ORevokeStatement)o;
        if (this.permission != null ? !this.permission.equals(that.permission) : that.permission != null) {
            return false;
        }
        if (this.resourceChain != null ? !this.resourceChain.equals(that.resourceChain) : that.resourceChain != null) {
            return false;
        }
        return !(this.actor != null ? !this.actor.equals(that.actor) : that.actor != null);
    }

    public int hashCode() {
        int result = this.permission != null ? this.permission.hashCode() : 0;
        result = 31 * result + (this.resourceChain != null ? this.resourceChain.hashCode() : 0);
        result = 31 * result + (this.actor != null ? this.actor.hashCode() : 0);
        return result;
    }
}

