/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.chm.readbuffer;

import com.orientechnologies.orient.core.storage.cache.chm.readbuffer.Buffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

abstract class StripedBuffer<E>
implements Buffer<E> {
    private static final int PROBE_INCREMENT = -1640531527;
    private static final AtomicInteger probeGenerator = new AtomicInteger();
    private final ThreadLocal<AtomicInteger> probe = ThreadLocal.withInitial(AtomicInteger::new);
    private final AtomicBoolean tableBusy = new AtomicBoolean();
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final int MAXIMUM_TABLE_SIZE = 4 * StripedBuffer.ceilingNextPowerOfTwo();
    private static final int ATTEMPTS = 3;
    private volatile transient Buffer<E>[] table;

    StripedBuffer() {
    }

    private int getProbe() {
        return this.probe.get().get();
    }

    private int advanceProbe(int probe) {
        probe ^= probe << 13;
        probe ^= probe >>> 17;
        probe ^= probe << 5;
        this.probe.get().set(probe);
        return probe;
    }

    private static int ceilingNextPowerOfTwo() {
        return 1 << 32 - Integer.numberOfLeadingZeros(NCPU - 1);
    }

    protected abstract Buffer<E> create(E var1);

    @Override
    public int offer(E e) {
        Buffer<E> buffer;
        int mask;
        int result = 0;
        boolean uncontended = true;
        Buffer<E>[] buffers = this.table;
        if (buffers == null || (mask = buffers.length - 1) < 0 || (buffer = buffers[this.getProbe() & mask]) == null || !(uncontended = (result = buffer.offer(e)) != -1)) {
            this.expandOrRetry(e, uncontended);
        }
        return result;
    }

    @Override
    public void drainTo(Consumer<E> consumer) {
        Buffer<E>[] buffers = this.table;
        if (buffers == null) {
            return;
        }
        for (Buffer<E> buffer : buffers) {
            if (buffer == null) continue;
            buffer.drainTo(consumer);
        }
    }

    @Override
    public int reads() {
        Buffer<E>[] buffers = this.table;
        if (buffers == null) {
            return 0;
        }
        int reads = 0;
        for (Buffer<E> buffer : buffers) {
            if (buffer == null) continue;
            reads += buffer.reads();
        }
        return reads;
    }

    @Override
    public int writes() {
        Buffer<E>[] buffers = this.table;
        if (buffers == null) {
            return 0;
        }
        int writes = 0;
        for (Buffer<E> buffer : buffers) {
            if (buffer == null) continue;
            writes += buffer.writes();
        }
        return writes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandOrRetry(E e, boolean wasUncontended) {
        int h = this.getProbe();
        if (h == 0) {
            this.initProbe();
            h = this.getProbe();
            wasUncontended = true;
        }
        boolean collide = false;
        for (int attempt = 0; attempt < 3; ++attempt) {
            Buffer[] rs;
            int n;
            Buffer<E>[] buffers = this.table;
            if (this.table != null && (n = buffers.length) > 0) {
                Buffer<E> buffer = buffers[n - 1 & h];
                if (buffer == null) {
                    if (!this.tableBusy.get() && this.tableBusy.compareAndSet(false, true)) {
                        boolean created = false;
                        try {
                            int j;
                            int mask;
                            rs = this.table;
                            if (this.table != null && (mask = rs.length) > 0 && rs[j = mask - 1 & h] == null) {
                                rs[j] = this.create(e);
                                created = true;
                            }
                        }
                        finally {
                            this.tableBusy.set(false);
                        }
                        if (!created) continue;
                        break;
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    if (buffer.offer(e) != -1) break;
                    if (n >= MAXIMUM_TABLE_SIZE || this.table != buffers) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (!this.tableBusy.get() && this.tableBusy.compareAndSet(false, true)) {
                        try {
                            if (this.table == buffers) {
                                this.table = Arrays.copyOf(buffers, n << 1);
                            }
                        }
                        finally {
                            this.tableBusy.set(false);
                        }
                        collide = false;
                        continue;
                    }
                }
                h = this.advanceProbe(h);
                continue;
            }
            if (this.tableBusy.get() || this.table != buffers || !this.tableBusy.compareAndSet(false, true)) continue;
            boolean init = false;
            try {
                if (this.table == buffers) {
                    rs = new Buffer[]{this.create(e)};
                    this.table = rs;
                    init = true;
                }
            }
            finally {
                this.tableBusy.set(false);
            }
            if (init) break;
        }
    }

    private void initProbe() {
        int p = probeGenerator.addAndGet(-1640531527);
        int probe = p == 0 ? 1 : p;
        this.probe.get().set(probe);
    }
}

