/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cluster.v1;

import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.exception.OClusterPositionMapException;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.OClusterPositionMap;
import com.orientechnologies.orient.core.storage.cluster.OClusterPositionMapBucket;
import com.orientechnologies.orient.core.storage.cluster.v1.MapEntryPoint;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import java.io.IOException;
import java.util.Arrays;

public final class OClusterPositionMapV1
extends OClusterPositionMap {
    private long fileId;

    OClusterPositionMapV1(OAbstractPaginatedStorage storage, String name, String lockName, String extension) {
        super(storage, name, extension, lockName);
    }

    public void open(OAtomicOperation atomicOperation) throws IOException {
        this.fileId = this.openFile(atomicOperation, this.getFullName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(OAtomicOperation atomicOperation) throws IOException {
        this.fileId = this.addFile(atomicOperation, this.getFullName());
        if (this.getFilledUpTo(atomicOperation, this.fileId) == 0L) {
            OCacheEntry cacheEntry = this.addPage(atomicOperation, this.fileId);
            try {
                MapEntryPoint mapEntryPoint = new MapEntryPoint(cacheEntry);
                mapEntryPoint.setFileSize(0);
            }
            finally {
                this.releasePageFromWrite(atomicOperation, cacheEntry);
            }
        }
        OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, false);
        try {
            MapEntryPoint mapEntryPoint = new MapEntryPoint(cacheEntry);
            mapEntryPoint.setFileSize(0);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        }
    }

    public void flush() {
        this.writeCache.flush(this.fileId);
    }

    public void close(boolean flush) {
        this.readCache.closeFile(this.fileId, flush, this.writeCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            MapEntryPoint mapEntryPoint = new MapEntryPoint(cacheEntry);
            mapEntryPoint.setFileSize(0);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        }
    }

    public void delete(OAtomicOperation atomicOperation) throws IOException {
        this.deleteFile(atomicOperation, this.fileId);
    }

    void rename(String newName) throws IOException {
        this.writeCache.renameFile(this.fileId, newName + this.getExtension());
        this.setName(newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(long pageIndex, int recordPosition, OAtomicOperation atomicOperation) throws IOException {
        boolean clear = false;
        OCacheEntry entryPointEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            long l;
            OCacheEntry cacheEntry;
            MapEntryPoint mapEntryPoint = new MapEntryPoint(entryPointEntry);
            int lastPage = mapEntryPoint.getFileSize();
            long filledUpTo = this.getFilledUpTo(atomicOperation, this.fileId);
            assert ((long)lastPage <= filledUpTo - 1L);
            if (lastPage == 0) {
                if ((long)lastPage == filledUpTo - 1L) {
                    cacheEntry = this.addPage(atomicOperation, this.fileId);
                    ++filledUpTo;
                } else {
                    cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, lastPage + 1, false, false);
                }
                mapEntryPoint.setFileSize(lastPage + 1);
                clear = true;
            } else {
                cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, lastPage, false, true);
            }
            try {
                OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, clear);
                if (bucket.isFull()) {
                    this.releasePageFromWrite(atomicOperation, cacheEntry);
                    assert ((long)lastPage <= filledUpTo - 1L);
                    cacheEntry = (long)lastPage == filledUpTo - 1L ? this.addPage(atomicOperation, this.fileId) : this.loadPageForWrite(atomicOperation, this.fileId, lastPage + 1, false, false);
                    mapEntryPoint.setFileSize(lastPage + 1);
                    bucket = new OClusterPositionMapBucket(cacheEntry, true);
                }
                long index = bucket.add(pageIndex, recordPosition);
                l = index + (cacheEntry.getPageIndex() - 1L) * (long)OClusterPositionMapBucket.MAX_ENTRIES;
            }
            catch (Throwable throwable) {
                this.releasePageFromWrite(atomicOperation, cacheEntry);
                throw throwable;
            }
            this.releasePageFromWrite(atomicOperation, cacheEntry);
            return l;
        }
        finally {
            this.releasePageFromWrite(atomicOperation, entryPointEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLastPage(OAtomicOperation atomicOperation) throws IOException {
        long lastPage;
        OCacheEntry entryPointEntry = this.loadPageForRead(atomicOperation, this.fileId, 0L, false);
        try {
            MapEntryPoint mapEntryPoint = new MapEntryPoint(entryPointEntry);
            lastPage = mapEntryPoint.getFileSize();
        }
        finally {
            this.releasePageFromRead(atomicOperation, entryPointEntry);
        }
        return lastPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long allocate(OAtomicOperation atomicOperation) throws IOException {
        boolean clear = false;
        OCacheEntry entryPointEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            long l;
            OCacheEntry cacheEntry;
            MapEntryPoint mapEntryPoint = new MapEntryPoint(entryPointEntry);
            int lastPage = mapEntryPoint.getFileSize();
            long filledUpTo = this.getFilledUpTo(atomicOperation, this.fileId);
            assert ((long)lastPage <= filledUpTo - 1L);
            if (lastPage == 0) {
                if ((long)lastPage == filledUpTo - 1L) {
                    cacheEntry = this.addPage(atomicOperation, this.fileId);
                    ++filledUpTo;
                } else {
                    cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, lastPage + 1, false, false);
                }
                mapEntryPoint.setFileSize(lastPage + 1);
                clear = true;
            } else {
                cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, lastPage, false, true);
            }
            try {
                OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, clear);
                if (bucket.isFull()) {
                    this.releasePageFromWrite(atomicOperation, cacheEntry);
                    assert ((long)lastPage <= filledUpTo - 1L);
                    cacheEntry = (long)lastPage == filledUpTo - 1L ? this.addPage(atomicOperation, this.fileId) : this.loadPageForWrite(atomicOperation, this.fileId, lastPage + 1, false, false);
                    mapEntryPoint.setFileSize(lastPage + 1);
                    bucket = new OClusterPositionMapBucket(cacheEntry, true);
                }
                long index = bucket.allocate();
                l = index + (cacheEntry.getPageIndex() - 1L) * (long)OClusterPositionMapBucket.MAX_ENTRIES;
            }
            catch (Throwable throwable) {
                this.releasePageFromWrite(atomicOperation, cacheEntry);
                throw throwable;
            }
            this.releasePageFromWrite(atomicOperation, cacheEntry);
            return l;
        }
        finally {
            this.releasePageFromWrite(atomicOperation, entryPointEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long clusterPosition, OClusterPositionMapBucket.PositionEntry entry, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = clusterPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES + 1L;
        int index = (int)(clusterPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
        long lastPage = this.getLastPage(atomicOperation);
        if (pageIndex > lastPage) {
            throw new OClusterPositionMapException("Passed in cluster position " + clusterPosition + " is outside of range of cluster-position map", this);
        }
        OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
        try {
            OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, false);
            bucket.set(index, entry);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resurrect(long clusterPosition, OClusterPositionMapBucket.PositionEntry entry, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = clusterPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES + 1L;
        int index = (int)(clusterPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
        long lastPage = this.getLastPage(atomicOperation);
        if (pageIndex > lastPage) {
            throw new OClusterPositionMapException("Passed in cluster position " + clusterPosition + " is outside of range of cluster-position map", this);
        }
        OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
        try {
            OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, false);
            bucket.resurrect(index, entry);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClusterPositionMapBucket.PositionEntry get(long clusterPosition, int pageCount, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = clusterPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES + 1L;
        int index = (int)(clusterPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
        long lastPage = this.getLastPage(atomicOperation);
        if (pageIndex > lastPage) {
            return null;
        }
        pageCount = (int)Math.min(lastPage - pageIndex + 1L, (long)pageCount);
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, pageCount);
        try {
            OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, false);
            OClusterPositionMapBucket.PositionEntry positionEntry = bucket.get(index);
            return positionEntry;
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long clusterPosition, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = clusterPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES + 1L;
        int index = (int)(clusterPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
        OCacheEntry cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
        try {
            OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, false);
            bucket.remove(index);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        }
    }

    long[] higherPositions(long clusterPosition, OAtomicOperation atomicOperation) throws IOException {
        if (clusterPosition == Long.MAX_VALUE) {
            return OCommonConst.EMPTY_LONG_ARRAY;
        }
        return this.ceilingPositions(clusterPosition + 1L, atomicOperation);
    }

    OClusterPositionEntry[] higherPositionsEntries(long clusterPosition, OAtomicOperation atomicOperation) throws IOException {
        if (clusterPosition == Long.MAX_VALUE) {
            return new OClusterPositionEntry[0];
        }
        long realPosition = clusterPosition < 0L ? 0L : clusterPosition + 1L;
        long pageIndex = realPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES + 1L;
        int index = (int)(realPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
        long lastPage = this.getLastPage(atomicOperation);
        if (pageIndex > lastPage) {
            return new OClusterPositionEntry[0];
        }
        OClusterPositionEntry[] result = null;
        do {
            OCacheEntry cacheEntry;
            OClusterPositionMapBucket bucket;
            int resultSize;
            if ((resultSize = (bucket = new OClusterPositionMapBucket(cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, 1), false)).getSize() - index) <= 0) {
                this.releasePageFromRead(atomicOperation, cacheEntry);
                ++pageIndex;
                index = 0;
                continue;
            }
            int entriesCount = 0;
            long startIndex = cacheEntry.getPageIndex() * (long)OClusterPositionMapBucket.MAX_ENTRIES + (long)index;
            result = new OClusterPositionEntry[resultSize];
            for (int i = 0; i < resultSize; ++i) {
                if (!bucket.exists(i + index)) continue;
                OClusterPositionMapBucket.PositionEntry val = bucket.get(i + index);
                assert (val != null);
                result[entriesCount] = new OClusterPositionEntry(startIndex + (long)i, val.getPageIndex(), val.getRecordPosition());
                ++entriesCount;
            }
            if (entriesCount == 0) {
                result = null;
                ++pageIndex;
                index = 0;
            } else {
                result = Arrays.copyOf(result, entriesCount);
            }
            this.releasePageFromRead(atomicOperation, cacheEntry);
        } while (result == null && pageIndex <= lastPage);
        if (result == null) {
            result = new OClusterPositionEntry[]{};
        }
        return result;
    }

    long[] ceilingPositions(long clusterPosition, OAtomicOperation atomicOperation) throws IOException {
        if (clusterPosition < 0L) {
            clusterPosition = 0L;
        }
        long pageIndex = clusterPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES + 1L;
        int index = (int)(clusterPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
        long lastPage = this.getLastPage(atomicOperation);
        if (pageIndex > lastPage) {
            return OCommonConst.EMPTY_LONG_ARRAY;
        }
        long[] result = null;
        do {
            OCacheEntry cacheEntry;
            OClusterPositionMapBucket bucket;
            int resultSize;
            if ((resultSize = (bucket = new OClusterPositionMapBucket(cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, 1), false)).getSize() - index) <= 0) {
                this.releasePageFromRead(atomicOperation, cacheEntry);
                ++pageIndex;
                index = 0;
                continue;
            }
            int entriesCount = 0;
            long startIndex = cacheEntry.getPageIndex() * (long)OClusterPositionMapBucket.MAX_ENTRIES + (long)index;
            result = new long[resultSize];
            for (int i = 0; i < resultSize; ++i) {
                if (!bucket.exists(i + index)) continue;
                result[entriesCount] = startIndex + (long)i - (long)OClusterPositionMapBucket.MAX_ENTRIES;
                ++entriesCount;
            }
            if (entriesCount == 0) {
                result = null;
                ++pageIndex;
                index = 0;
            } else {
                result = Arrays.copyOf(result, entriesCount);
            }
            this.releasePageFromRead(atomicOperation, cacheEntry);
        } while (result == null && pageIndex <= lastPage);
        if (result == null) {
            result = OCommonConst.EMPTY_LONG_ARRAY;
        }
        return result;
    }

    long[] lowerPositions(long clusterPosition, OAtomicOperation atomicOperation) throws IOException {
        if (clusterPosition == 0L) {
            return OCommonConst.EMPTY_LONG_ARRAY;
        }
        return this.floorPositions(clusterPosition - 1L, atomicOperation);
    }

    long[] floorPositions(long clusterPosition, OAtomicOperation atomicOperation) throws IOException {
        long[] result;
        if (clusterPosition < 0L) {
            return OCommonConst.EMPTY_LONG_ARRAY;
        }
        long pageIndex = clusterPosition / (long)OClusterPositionMapBucket.MAX_ENTRIES + 1L;
        int index = (int)(clusterPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
        long lastPage = this.getLastPage(atomicOperation);
        if (pageIndex > lastPage) {
            pageIndex = lastPage;
            index = Integer.MIN_VALUE;
        }
        if (pageIndex < 0L) {
            return OCommonConst.EMPTY_LONG_ARRAY;
        }
        do {
            OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, 1);
            OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, false);
            if (index == Integer.MIN_VALUE) {
                index = bucket.getSize() - 1;
            }
            int resultSize = index + 1;
            int entriesCount = 0;
            long startPosition = cacheEntry.getPageIndex() * (long)OClusterPositionMapBucket.MAX_ENTRIES;
            result = new long[resultSize];
            for (int i = 0; i < resultSize; ++i) {
                if (!bucket.exists(i)) continue;
                result[entriesCount] = startPosition + (long)i - (long)OClusterPositionMapBucket.MAX_ENTRIES;
                ++entriesCount;
            }
            if (entriesCount == 0) {
                result = null;
                --pageIndex;
                index = Integer.MIN_VALUE;
            } else {
                result = Arrays.copyOf(result, entriesCount);
            }
            this.releasePageFromRead(atomicOperation, cacheEntry);
        } while (result == null && pageIndex >= 0L);
        if (result == null) {
            result = OCommonConst.EMPTY_LONG_ARRAY;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getFirstPosition(OAtomicOperation atomicOperation) throws IOException {
        long lastPage = this.getLastPage(atomicOperation);
        for (long pageIndex = 1L; pageIndex <= lastPage; ++pageIndex) {
            OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, 1);
            try {
                OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, false);
                int bucketSize = bucket.getSize();
                for (int index = 0; index < bucketSize; ++index) {
                    if (!bucket.exists(index)) continue;
                    long l = pageIndex * (long)OClusterPositionMapBucket.MAX_ENTRIES + (long)index - (long)OClusterPositionMapBucket.MAX_ENTRIES;
                    return l;
                }
                continue;
            }
            finally {
                this.releasePageFromRead(atomicOperation, cacheEntry);
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getStatus(long clusterPosition, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = (clusterPosition + (long)OClusterPositionMapBucket.MAX_ENTRIES) / (long)OClusterPositionMapBucket.MAX_ENTRIES;
        int index = (int)(clusterPosition % (long)OClusterPositionMapBucket.MAX_ENTRIES);
        long lastPage = this.getLastPage(atomicOperation);
        if (pageIndex > lastPage) {
            return 0;
        }
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, 1);
        try {
            OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, false);
            byte by = bucket.getStatus(index);
            return by;
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastPosition(OAtomicOperation atomicOperation) throws IOException {
        long lastPage;
        for (long pageIndex = lastPage = this.getLastPage(atomicOperation); pageIndex >= 1L; --pageIndex) {
            OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, 1);
            try {
                OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, false);
                int bucketSize = bucket.getSize();
                for (int index = bucketSize - 1; index >= 0; --index) {
                    if (!bucket.exists(index)) continue;
                    long l = pageIndex * (long)OClusterPositionMapBucket.MAX_ENTRIES + (long)index - (long)OClusterPositionMapBucket.MAX_ENTRIES;
                    return l;
                }
                continue;
            }
            finally {
                this.releasePageFromRead(atomicOperation, cacheEntry);
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNextPosition(OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = this.getLastPage(atomicOperation);
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false, 1);
        try {
            OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry, false);
            int bucketSize = bucket.getSize();
            long l = pageIndex * (long)OClusterPositionMapBucket.MAX_ENTRIES + (long)bucketSize;
            return l;
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    public long getFileId() {
        return this.fileId;
    }

    void replaceFileId(long newFileId) {
        this.fileId = newFileId;
    }

    public static final class OClusterPositionEntry {
        private final long position;
        private final long page;
        private final int offset;

        OClusterPositionEntry(long position, long page, int offset) {
            this.position = position;
            this.page = page;
            this.offset = offset;
        }

        public long getPosition() {
            return this.position;
        }

        public long getPage() {
            return this.page;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

