/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.exception.OTooBigIndexKeyException;
import com.orientechnologies.orient.core.index.OAlwaysGreaterKey;
import com.orientechnologies.orient.core.index.OAlwaysLessKey;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.OIndexUpdateAction;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.iterator.OEmptyMapEntryIterator;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.index.sbtree.local.ONullBucket;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OSBTreeBucket;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OSBTreeException;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OSBTreeValue;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OSBTreeValuePage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class OSBTree<K, V>
extends ODurableComponent {
    private static final int MAX_KEY_SIZE = OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger();
    private static final int MAX_EMBEDDED_VALUE_SIZE = OGlobalConfiguration.SBTREE_MAX_EMBEDDED_VALUE_SIZE.getValueAsInteger();
    private static final OAlwaysLessKey ALWAYS_LESS_KEY = new OAlwaysLessKey();
    private static final OAlwaysGreaterKey ALWAYS_GREATER_KEY = new OAlwaysGreaterKey();
    private static final int MAX_PATH_LENGTH = OGlobalConfiguration.SBTREE_MAX_DEPTH.getValueAsInteger();
    private static final long ROOT_INDEX = 0L;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private final String nullFileExtension;
    private long fileId;
    private long nullBucketFileId = -1L;
    private int keySize;
    private OBinarySerializer<K> keySerializer;
    private OType[] keyTypes;
    private OBinarySerializer<V> valueSerializer;
    private boolean nullPointerSupport;
    private final AtomicLong bonsayFileId = new AtomicLong(0L);
    private OEncryption encryption;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTree(String name, String dataFileExtension, String nullFileExtension, OAbstractPaginatedStorage storage) {
        super(storage, name, dataFileExtension, name + dataFileExtension);
        this.acquireExclusiveLock();
        try {
            this.nullFileExtension = nullFileExtension;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OType[] keyTypes, int keySize, boolean nullPointerSupport, OEncryption encryption) throws IOException {
        assert (keySerializer != null);
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(false);
        try {
            this.acquireExclusiveLock();
            try {
                this.keySize = keySize;
                this.keyTypes = keyTypes != null ? Arrays.copyOf(keyTypes, keyTypes.length) : null;
                this.encryption = encryption;
                this.keySerializer = keySerializer;
                this.valueSerializer = valueSerializer;
                this.nullPointerSupport = nullPointerSupport;
                this.fileId = this.addFile(atomicOperation, this.getFullName());
                if (nullPointerSupport) {
                    this.nullBucketFileId = this.addFile(atomicOperation, this.getName() + this.nullFileExtension);
                }
                OCacheEntry rootCacheEntry = this.addPage(atomicOperation, this.fileId);
                try {
                    OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, true, keySerializer, keyTypes, valueSerializer, encryption);
                    rootBucket.setTreeSize(0L);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, rootCacheEntry);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    public boolean isNullPointerSupport() {
        this.acquireSharedLock();
        try {
            boolean bl = this.nullPointerSupport;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * Exception decompiling
     */
    public V get(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 25[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void put(K key, V value) throws IOException {
        this.put(key, value, null);
    }

    public boolean validatedPut(K key, V value, OBaseIndexEngine.Validator<K, V> validator) throws IOException {
        return this.put(key, value, validator);
    }

    private boolean put(K key, V value, OBaseIndexEngine.Validator<K, V> validator) throws IOException {
        return this.update(key, (x, bonsayFileId) -> OIndexUpdateAction.changed(value), validator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean update(K key, OIndexKeyUpdater<V> updater, OBaseIndexEngine.Validator<K, V> validator) throws IOException {
        rollback = false;
        atomicOperation = this.startAtomicOperation(true);
        try {
            block43: {
                block45: {
                    block42: {
                        block41: {
                            block39: {
                                block40: {
                                    this.acquireExclusiveLock();
                                    this.checkNullSupport(key);
                                    if (key == null) ** GOTO lbl95
                                    key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
                                    serializedKey = this.keySerializer.serializeNativeAsWhole(key, (Object[])this.keyTypes);
                                    if (this.keySize > OSBTree.MAX_KEY_SIZE) {
                                        throw new OTooBigIndexKeyException("Key size is more than allowed, operation was canceled. Current key size " + this.keySize + ", allowed  " + OSBTree.MAX_KEY_SIZE, this.getName());
                                    }
                                    bucketSearchResult = this.findBucket(key, atomicOperation);
                                    keyBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, bucketSearchResult.getLastPathItem(), false, true);
                                    keyBucket = new OSBTreeBucket<K, V>(keyBucketCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
                                    oldRawValue = BucketSearchResult.access$000(bucketSearchResult) > -1 ? keyBucket.getRawValue(BucketSearchResult.access$000(bucketSearchResult)) : null;
                                    oldValue = oldRawValue == null ? null : (V)this.valueSerializer.deserializeNativeObject(oldRawValue, 0);
                                    updatedValue = updater.update(oldValue, this.bonsayFileId);
                                    if (!updatedValue.isChange()) ** GOTO lbl87
                                    value = updatedValue.getValue();
                                    if (validator == null) ** GOTO lbl46
                                    failure = true;
                                    ignored = false;
                                    result = validator.validate(key, oldValue, value);
                                    if (result != OBaseIndexEngine.Validator.IGNORE) break block39;
                                    ignored = true;
                                    failure = false;
                                    var17_30 = false;
                                    if (!failure && !ignored) break block40;
                                    this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                                }
                                this.releaseExclusiveLock();
                                return var17_30;
                            }
                            value = result;
                            failure = false;
                            break block41;
                            {
                                catch (Throwable var18_33) {
                                    throw var18_33;
                                }
                            }
                            finally {
                                if (failure || ignored) {
                                    this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                                }
                            }
                        }
                        valueSize = this.valueSerializer.getObjectSize(value, new Object[0]);
                        serializeValue = new byte[valueSize];
                        this.valueSerializer.serializeNativeObject(value, serializeValue, 0, new Object[0]);
                        if (this.encryption == null) {
                            rawKey = serializedKey;
                        } else {
                            encryptedKey = this.encryption.encrypt(serializedKey);
                            rawKey = new byte[4 + encryptedKey.length];
                            OIntegerSerializer.INSTANCE.serializeNative(encryptedKey.length, rawKey, 0, new Object[0]);
                            System.arraycopy(encryptedKey, 0, rawKey, 4, encryptedKey.length);
                        }
                        v0 = createLinkToTheValue = valueSize > OSBTree.MAX_EMBEDDED_VALUE_SIZE;
                        if (!OSBTree.$assertionsDisabled && createLinkToTheValue) {
                            throw new AssertionError();
                        }
                        if (BucketSearchResult.access$000(bucketSearchResult) < 0) ** GOTO lbl73
                        if (oldRawValue.length != serializeValue.length) break block42;
                        keyBucket.updateValue(BucketSearchResult.access$000(bucketSearchResult), serializeValue, oldRawValue);
                        this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                        var20_36 = true;
                        this.releaseExclusiveLock();
                        return var20_36;
                    }
                    keyBucket.remove(BucketSearchResult.access$000(bucketSearchResult), rawKey, oldRawValue);
                    insertionIndex = BucketSearchResult.access$000(bucketSearchResult);
                    sizeDiff = 0;
                    break block45;
lbl73:
                    // 1 sources

                    insertionIndex = -BucketSearchResult.access$000(bucketSearchResult) - 1;
                    sizeDiff = 1;
                }
                while (!keyBucket.addLeafEntry(insertionIndex, rawKey, serializeValue)) {
                    this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                    bucketSearchResult = this.splitBucket(BucketSearchResult.access$100(bucketSearchResult), insertionIndex, key, atomicOperation);
                    insertionIndex = BucketSearchResult.access$000(bucketSearchResult);
                    keyBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, bucketSearchResult.getLastPathItem(), false, true);
                    keyBucket = new OSBTreeBucket<K, V>(keyBucketCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
                }
                this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                if (sizeDiff != 0) {
                    this.updateSize(sizeDiff, atomicOperation);
                }
                ** GOTO lbl141
lbl87:
                // 1 sources

                if (updatedValue.isRemove()) {
                    this.removeKey(atomicOperation, bucketSearchResult);
                    this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                } else if (updatedValue.isNothing()) {
                    this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                }
                ** GOTO lbl141
lbl95:
                // 1 sources

                isNew = false;
                if (this.getFilledUpTo(atomicOperation, this.nullBucketFileId) == 0L) {
                    cacheEntry = this.addPage(atomicOperation, this.nullBucketFileId);
                    isNew = true;
                } else {
                    cacheEntry = this.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
                }
                sizeDiff = 0;
                nullBucket = new ONullBucket<Object>(cacheEntry, this.valueSerializer, isNew);
                oldValue = nullBucket.getValue();
                oldValueValue = oldValue == null ? null : (V)this.readValue(oldValue, atomicOperation);
                updatedValue = updater.update(oldValueValue, this.bonsayFileId);
                if (!updatedValue.isChange()) ** GOTO lbl127
                value = updatedValue.getValue();
                valueSize = this.valueSerializer.getObjectSize(value, new Object[0]);
                createLinkToTheValue = valueSize > OSBTree.MAX_EMBEDDED_VALUE_SIZE;
                valueLink = -1L;
                if (createLinkToTheValue) {
                    valueLink = this.createLinkToTheValue(value, atomicOperation);
                }
                treeValue = new OSBTreeValue<Object>(createLinkToTheValue, valueLink, (createLinkToTheValue != false ? null : value));
                if (validator == null || (result = validator.validate(null, oldValueValue, value)) != OBaseIndexEngine.Validator.IGNORE) break block43;
                var20_37 = false;
                this.releasePageFromWrite(atomicOperation, cacheEntry);
                this.releaseExclusiveLock();
                return var20_37;
            }
            try {
                block44: {
                    if (oldValue != null) {
                        sizeDiff = -1;
                    }
                    nullBucket.setValue(treeValue);
                    break block44;
lbl127:
                    // 1 sources

                    if (updatedValue.isRemove()) {
                        this.removeNullBucket(atomicOperation);
                    } else if (updatedValue.isNothing()) {
                        // empty if block
                    }
                    break block44;
                    {
                        catch (Throwable var21_40) {
                            throw var21_40;
                        }
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, cacheEntry);
                    }
                }
                this.updateSize(++sizeDiff, atomicOperation);
lbl141:
                // 4 sources

                cacheEntry = true;
            }
            catch (Throwable var22_41) {
                try {
                    this.releaseExclusiveLock();
                    throw var22_41;
                }
                catch (Exception e) {
                    rollback = true;
                    throw e;
                }
            }
            this.releaseExclusiveLock();
            return cacheEntry;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    public void close(boolean flush) {
        this.acquireExclusiveLock();
        try {
            this.readCache.closeFile(this.fileId, flush, this.writeCache);
            if (this.nullPointerSupport) {
                this.readCache.closeFile(this.nullBucketFileId, flush, this.writeCache);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(true);
        try {
            this.acquireExclusiveLock();
            try {
                OCacheEntry cacheEntry;
                this.truncateFile(atomicOperation, this.fileId);
                if (this.nullPointerSupport) {
                    this.truncateFile(atomicOperation, this.nullBucketFileId);
                }
                if ((cacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true)) == null) {
                    cacheEntry = this.addPage(atomicOperation, this.fileId);
                }
                try {
                    OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(cacheEntry, true, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
                    rootBucket.setTreeSize(0L);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, cacheEntry);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    public void delete() throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(false);
        try {
            this.acquireExclusiveLock();
            try {
                this.deleteFile(atomicOperation, this.fileId);
                if (this.nullPointerSupport) {
                    this.deleteFile(atomicOperation, this.nullBucketFileId);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWithoutLoad() throws IOException {
        boolean rollback = false;
        OAtomicOperation atomicOperation = this.startAtomicOperation(false);
        try {
            this.acquireExclusiveLock();
            try {
                if (this.isFileExists(atomicOperation, this.getFullName())) {
                    long fileId = this.openFile(atomicOperation, this.getFullName());
                    this.deleteFile(atomicOperation, fileId);
                }
                if (this.isFileExists(atomicOperation, this.getName() + this.nullFileExtension)) {
                    long nullFileId = this.openFile(atomicOperation, this.getName() + this.nullFileExtension);
                    this.deleteFile(atomicOperation, nullFileId);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        catch (Exception e) {
            rollback = true;
            throw e;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    public void load(String name, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OType[] keyTypes, int keySize, boolean nullPointerSupport, OEncryption encryption) {
        this.acquireExclusiveLock();
        try {
            this.keySize = keySize;
            this.keyTypes = keyTypes != null ? Arrays.copyOf(keyTypes, keyTypes.length) : null;
            this.encryption = encryption;
            this.nullPointerSupport = nullPointerSupport;
            OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
            this.fileId = this.openFile(atomicOperation, this.getFullName());
            if (nullPointerSupport) {
                this.nullBucketFileId = this.openFile(atomicOperation, name + this.nullFileExtension);
            }
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
        }
        catch (IOException e) {
            throw OException.wrapException(new OSBTreeException("Exception during loading of sbtree " + name, this), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Exception decompiling
     */
    public long size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public V remove(K key) throws IOException {
        rollback = false;
        atomicOperation = this.startAtomicOperation(true);
        try {
            block13: {
                block12: {
                    this.acquireExclusiveLock();
                    try {
                        if (key == null) ** GOTO lbl26
                        bucketSearchResult = this.findBucket(key = this.keySerializer.preprocess(key, (Object[])this.keyTypes), atomicOperation);
                        if (BucketSearchResult.access$000(bucketSearchResult) >= 0) break block12;
                        var6_6 = null;
                    }
                    catch (Throwable var7_9) {
                        try {
                            this.releaseExclusiveLock();
                            throw var7_9;
                        }
                        catch (Exception e) {
                            rollback = true;
                            throw e;
                        }
                    }
                    this.releaseExclusiveLock();
                    return var6_6;
                }
                removedValue = this.valueSerializer.deserializeNativeObject(this.removeKey(atomicOperation, bucketSearchResult), 0);
                ** GOTO lbl33
lbl26:
                // 1 sources

                if (this.getFilledUpTo(atomicOperation, this.nullBucketFileId) != 0L) break block13;
                var5_5 = null;
                this.releaseExclusiveLock();
                return var5_5;
            }
            removedValue = this.removeNullBucket(atomicOperation);
lbl33:
            // 2 sources

            var5_4 = removedValue;
            this.releaseExclusiveLock();
            return var5_4;
        }
        finally {
            this.endAtomicOperation(rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V removeNullBucket(OAtomicOperation atomicOperation) throws IOException {
        V removedValue;
        OCacheEntry nullCacheEntry = this.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
        try {
            ONullBucket<V> nullBucket = new ONullBucket<V>(nullCacheEntry, this.valueSerializer, false);
            OSBTreeValue<V> treeValue = nullBucket.getValue();
            if (treeValue != null) {
                removedValue = this.readValue(treeValue, atomicOperation);
                nullBucket.removeValue();
            } else {
                removedValue = null;
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, nullCacheEntry);
        }
        if (removedValue != null) {
            this.updateSize(-1L, atomicOperation);
        }
        return removedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] removeKey(OAtomicOperation atomicOperation, BucketSearchResult bucketSearchResult) throws IOException {
        byte[] removedValue;
        OCacheEntry keyBucketCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, bucketSearchResult.getLastPathItem(), false, true);
        try {
            OSBTreeBucket<K, V> keyBucket = new OSBTreeBucket<K, V>(keyBucketCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
            removedValue = keyBucket.getRawValue(bucketSearchResult.itemIndex);
            keyBucket.remove(bucketSearchResult.itemIndex, null, removedValue);
            this.updateSize(-1L, atomicOperation);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
        }
        return removedValue;
    }

    public OSBTreeCursor<K, V> iterateEntriesMinor(K key, boolean inclusive, boolean ascSortOrder) {
        if (!ascSortOrder) {
            return this.iterateEntriesMinorDesc(key, inclusive);
        }
        return this.iterateEntriesMinorAsc(key, inclusive);
    }

    public OSBTreeCursor<K, V> iterateEntriesMajor(K key, boolean inclusive, boolean ascSortOrder) {
        if (ascSortOrder) {
            return this.iterateEntriesMajorAsc(key, inclusive);
        }
        return this.iterateEntriesMajorDesc(key, inclusive);
    }

    /*
     * Exception decompiling
     */
    public K firstKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public K lastKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTreeKeyCursor<K> keyCursor() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            BucketSearchResult searchResult;
            block10: {
                OSBTreeKeyCursor<Object> oSBTreeKeyCursor;
                this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    searchResult = this.firstItem(atomicOperation);
                    if (searchResult != null) break block10;
                    oSBTreeKeyCursor = prefetchSize -> null;
                }
                catch (Throwable throwable) {
                    try {
                        this.releaseSharedLock();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw OException.wrapException(new OSBTreeException("Error during finding first key in sbtree [" + this.getName() + "]", this), e);
                    }
                }
                this.releaseSharedLock();
                return oSBTreeKeyCursor;
            }
            OSBTreeFullKeyCursor oSBTreeFullKeyCursor = new OSBTreeFullKeyCursor(searchResult.getLastPathItem());
            this.releaseSharedLock();
            return oSBTreeFullKeyCursor;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    public OSBTreeCursor<K, V> iterateEntriesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, boolean ascSortOrder) {
        if (ascSortOrder) {
            return this.iterateEntriesBetweenAscOrder(keyFrom, fromInclusive, keyTo, toInclusive);
        }
        return this.iterateEntriesBetweenDescOrder(keyFrom, fromInclusive, keyTo, toInclusive);
    }

    public void flush() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            this.acquireSharedLock();
            try {
                this.writeCache.flush();
            }
            finally {
                this.releaseSharedLock();
            }
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    public void acquireAtomicExclusiveLock() {
        this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(this);
    }

    private void checkNullSupport(K key) {
        if (key == null && !this.nullPointerSupport) {
            throw new OSBTreeException("Null keys are not supported.", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createLinkToTheValue(V value, OAtomicOperation atomicOperation) throws IOException {
        byte[] serializeValue = new byte[this.valueSerializer.getObjectSize(value, new Object[0])];
        this.valueSerializer.serializeNativeObject(value, serializeValue, 0, new Object[0]);
        int amountOfPages = OSBTreeValuePage.calculateAmountOfPage(serializeValue.length);
        int position = 0;
        long freeListPageIndex = this.allocateValuePageFromFreeList(atomicOperation);
        OCacheEntry cacheEntry = freeListPageIndex < 0L ? this.addPage(atomicOperation, this.fileId) : this.loadPageForWrite(atomicOperation, this.fileId, freeListPageIndex, false, true);
        long valueLink = cacheEntry.getPageIndex();
        try {
            OSBTreeValuePage valuePage = new OSBTreeValuePage(cacheEntry, freeListPageIndex >= 0L);
            position = valuePage.fillBinaryContent(serializeValue, position);
            valuePage.setNextFreeListPage(-1L);
            valuePage.setNextPage(-1L);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        }
        long prevPage = valueLink;
        for (int i = 1; i < amountOfPages; ++i) {
            freeListPageIndex = this.allocateValuePageFromFreeList(atomicOperation);
            cacheEntry = freeListPageIndex < 0L ? this.addPage(atomicOperation, this.fileId) : this.loadPageForWrite(atomicOperation, this.fileId, freeListPageIndex, false, true);
            try {
                OSBTreeValuePage valuePage = new OSBTreeValuePage(cacheEntry, freeListPageIndex >= 0L);
                position = valuePage.fillBinaryContent(serializeValue, position);
                valuePage.setNextFreeListPage(-1L);
                valuePage.setNextPage(-1L);
            }
            finally {
                this.releasePageFromWrite(atomicOperation, cacheEntry);
            }
            OCacheEntry prevPageCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, prevPage, false, true);
            try {
                OSBTreeValuePage valuePage = new OSBTreeValuePage(prevPageCacheEntry, freeListPageIndex >= 0L);
                valuePage.setNextPage(cacheEntry.getPageIndex());
            }
            finally {
                this.releasePageFromWrite(atomicOperation, prevPageCacheEntry);
            }
            prevPage = cacheEntry.getPageIndex();
        }
        return valueLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateValuePageFromFreeList(OAtomicOperation atomicOperation) throws IOException {
        long freeListFirstIndex;
        OSBTreeBucket<K, V> rootBucket;
        OCacheEntry rootCacheEntry = this.loadPageForRead(atomicOperation, this.fileId, 0L, false);
        assert (rootCacheEntry != null);
        try {
            rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
            freeListFirstIndex = rootBucket.getValuesFreeListFirstIndex();
        }
        finally {
            this.releasePageFromRead(atomicOperation, rootCacheEntry);
        }
        if (freeListFirstIndex >= 0L) {
            OCacheEntry freePageEntry = this.loadPageForWrite(atomicOperation, this.fileId, freeListFirstIndex, false, true);
            try {
                OSBTreeValuePage valuePage = new OSBTreeValuePage(freePageEntry, false);
                long nextFreeListIndex = valuePage.getNextFreeListPage();
                rootCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
                rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
                try {
                    rootBucket.setValuesFreeListFirstIndex(nextFreeListIndex);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, rootCacheEntry);
                }
                valuePage.setNextFreeListPage(-1L);
            }
            finally {
                this.releasePageFromWrite(atomicOperation, freePageEntry);
            }
            return freePageEntry.getPageIndex();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSize(long diffSize, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rootCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
            rootBucket.setTreeSize(rootBucket.getTreeSize() + diffSize);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rootCacheEntry);
        }
    }

    private OSBTreeCursor<K, V> iterateEntriesMinorDesc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMinorDesc(key, inclusive);
        return new OSBTreeCursorBackward(null, key, false, inclusive);
    }

    private OSBTreeCursor<K, V> iterateEntriesMinorAsc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMinorAsc(key, inclusive);
        return new OSBTreeCursorForward(null, key, false, inclusive);
    }

    private K enhanceCompositeKeyMinorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMinorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private OSBTreeCursor<K, V> iterateEntriesMajorAsc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMajorAsc(key, inclusive);
        return new OSBTreeCursorForward(key, null, inclusive, false);
    }

    private OSBTreeCursor<K, V> iterateEntriesMajorDesc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMajorDesc(key, inclusive);
        return new OSBTreeCursorBackward(key, null, inclusive, false);
    }

    private K enhanceCompositeKeyMajorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMajorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult firstItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 0L;
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
        int itemIndex = 0;
        try {
            OSBTreeBucket<K, V> bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (bucket.isEmpty() || itemIndex > bucket.size()) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = pagePathItemUnit.itemIndex + 1;
                    } else {
                        OSBTreeBucket.SBTreeEntry<K, V> entry;
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        if (itemIndex < bucket.size()) {
                            entry = bucket.getEntry(itemIndex);
                            bucketIndex = entry.leftChild;
                        } else {
                            entry = bucket.getEntry(itemIndex - 1);
                            bucketIndex = entry.rightChild;
                        }
                        itemIndex = 0;
                    }
                } else if (bucket.isEmpty()) {
                    if (path.isEmpty()) {
                        pagePathItemUnit = null;
                        return pagePathItemUnit;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = pagePathItemUnit.itemIndex + 1;
                } else {
                    ArrayList<Long> resultPath = new ArrayList<Long>(path.size() + 1);
                    Object object = path.iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            resultPath.add(bucketIndex);
                            object = new BucketSearchResult(0, resultPath);
                            return object;
                        }
                        PagePathItemUnit pathItemUnit = (PagePathItemUnit)object.next();
                        resultPath.add(pathItemUnit.pageIndex);
                    }
                }
                this.releasePageFromRead(atomicOperation, cacheEntry);
                cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
                bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
            }
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult lastItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 0L;
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
        OSBTreeBucket<K, V> bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
        int itemIndex = bucket.size() - 1;
        try {
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (itemIndex < -1) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = pagePathItemUnit.itemIndex - 1;
                    } else {
                        OSBTreeBucket.SBTreeEntry<K, V> entry;
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        if (itemIndex > -1) {
                            entry = bucket.getEntry(itemIndex);
                            bucketIndex = entry.rightChild;
                        } else {
                            entry = bucket.getEntry(0);
                            bucketIndex = entry.leftChild;
                        }
                        itemIndex = OSBTreeBucket.MAX_PAGE_SIZE_BYTES + 1;
                    }
                } else if (bucket.isEmpty()) {
                    if (path.isEmpty()) {
                        pagePathItemUnit = null;
                        return pagePathItemUnit;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = pagePathItemUnit.itemIndex - 1;
                } else {
                    ArrayList<Long> resultPath = new ArrayList<Long>(path.size() + 1);
                    Object object = path.iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            resultPath.add(bucketIndex);
                            object = new BucketSearchResult(bucket.size() - 1, resultPath);
                            return object;
                        }
                        PagePathItemUnit pathItemUnit = (PagePathItemUnit)object.next();
                        resultPath.add(pathItemUnit.pageIndex);
                    }
                }
                this.releasePageFromRead(atomicOperation, cacheEntry);
                cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
                bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
                if (itemIndex != OSBTreeBucket.MAX_PAGE_SIZE_BYTES + 1) continue;
                itemIndex = bucket.size() - 1;
            }
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    private OSBTreeCursor<K, V> iterateEntriesBetweenAscOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive) {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenAsc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenAsc(keyTo, toInclusive);
        return new OSBTreeCursorForward(keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private OSBTreeCursor<K, V> iterateEntriesBetweenDescOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive) {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenDesc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenDesc(keyTo, toInclusive);
        return new OSBTreeCursorBackward(keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private K enhanceToCompositeKeyBetweenAsc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenAsc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    private K enhanceToCompositeKeyBetweenDesc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenDesc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitBucket(List<Long> path, int keyIndex, K keyToInsert, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = path.get(path.size() - 1);
        OCacheEntry bucketEntry = this.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
        try {
            int startRightIndex;
            OSBTreeBucket<K, V> bucketToSplit = new OSBTreeBucket<K, V>(bucketEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
            boolean splitLeaf = bucketToSplit.isLeaf();
            int bucketSize = bucketToSplit.size();
            int indexToSplit = bucketSize >>> 1;
            K separationKey = bucketToSplit.getKey(indexToSplit);
            ArrayList<byte[]> rightEntries = new ArrayList<byte[]>(indexToSplit);
            for (int i = startRightIndex = splitLeaf ? indexToSplit : indexToSplit + 1; i < bucketSize; ++i) {
                rightEntries.add(bucketToSplit.getRawEntry(i));
            }
            if (pageIndex != 0L) {
                BucketSearchResult bucketSearchResult = this.splitNonRootBucket(path, keyIndex, keyToInsert, pageIndex, bucketToSplit, splitLeaf, indexToSplit, separationKey, rightEntries, atomicOperation);
                return bucketSearchResult;
            }
            BucketSearchResult bucketSearchResult = this.splitRootBucket(path, keyIndex, keyToInsert, bucketEntry, bucketToSplit, splitLeaf, indexToSplit, separationKey, rightEntries, atomicOperation);
            return bucketSearchResult;
        }
        finally {
            this.releasePageFromWrite(atomicOperation, bucketEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitNonRootBucket(List<Long> path, int keyIndex, K keyToInsert, long pageIndex, OSBTreeBucket<K, V> bucketToSplit, boolean splitLeaf, int indexToSplit, K separationKey, List<byte[]> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rightBucketEntry = this.addPage(atomicOperation, this.fileId);
        try {
            OSBTreeBucket<K, V> newRightBucket = new OSBTreeBucket<K, V>(rightBucketEntry, splitLeaf, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
            newRightBucket.addAll(rightEntries);
            bucketToSplit.shrink(indexToSplit);
            if (splitLeaf) {
                long rightSiblingPageIndex = bucketToSplit.getRightSibling();
                newRightBucket.setRightSibling(rightSiblingPageIndex);
                newRightBucket.setLeftSibling(pageIndex);
                bucketToSplit.setRightSibling(rightBucketEntry.getPageIndex());
                if (rightSiblingPageIndex >= 0L) {
                    OCacheEntry rightSiblingBucketEntry = this.loadPageForWrite(atomicOperation, this.fileId, rightSiblingPageIndex, false, true);
                    OSBTreeBucket<K, V> rightSiblingBucket = new OSBTreeBucket<K, V>(rightSiblingBucketEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
                    try {
                        rightSiblingBucket.setLeftSibling(rightBucketEntry.getPageIndex());
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, rightSiblingBucketEntry);
                    }
                }
            }
            long parentIndex = path.get(path.size() - 2);
            OCacheEntry parentCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, parentIndex, false, true);
            try {
                OSBTreeBucket parentBucket = new OSBTreeBucket(parentCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
                OSBTreeBucket.SBTreeEntry parentEntry = new OSBTreeBucket.SBTreeEntry(pageIndex, rightBucketEntry.getPageIndex(), separationKey, null);
                int insertionIndex = parentBucket.find(separationKey);
                assert (insertionIndex < 0);
                insertionIndex = -insertionIndex - 1;
                while (!parentBucket.addEntry(insertionIndex, parentEntry, true)) {
                    this.releasePageFromWrite(atomicOperation, parentCacheEntry);
                    BucketSearchResult bucketSearchResult = this.splitBucket(path.subList(0, path.size() - 1), insertionIndex, separationKey, atomicOperation);
                    parentIndex = bucketSearchResult.getLastPathItem();
                    parentCacheEntry = this.loadPageForWrite(atomicOperation, this.fileId, parentIndex, false, true);
                    insertionIndex = bucketSearchResult.itemIndex;
                    parentBucket = new OSBTreeBucket<K, V>(parentCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
                }
            }
            finally {
                this.releasePageFromWrite(atomicOperation, parentCacheEntry);
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rightBucketEntry);
        }
        ArrayList<Long> resultPath = new ArrayList<Long>(path.subList(0, path.size() - 1));
        if (this.comparator.compare(keyToInsert, separationKey) < 0) {
            resultPath.add(pageIndex);
            return new BucketSearchResult(keyIndex, resultPath);
        }
        resultPath.add(rightBucketEntry.getPageIndex());
        if (splitLeaf) {
            return new BucketSearchResult(keyIndex - indexToSplit, resultPath);
        }
        resultPath.add(rightBucketEntry.getPageIndex());
        return new BucketSearchResult(keyIndex - indexToSplit - 1, resultPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitRootBucket(List<Long> path, int keyIndex, K keyToInsert, OCacheEntry bucketEntry, OSBTreeBucket<K, V> bucketToSplit, boolean splitLeaf, int indexToSplit, K separationKey, List<byte[]> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        long freeListPage = bucketToSplit.getValuesFreeListFirstIndex();
        long treeSize = bucketToSplit.getTreeSize();
        ArrayList<byte[]> leftEntries = new ArrayList<byte[]>(indexToSplit);
        for (int i = 0; i < indexToSplit; ++i) {
            leftEntries.add(bucketToSplit.getRawEntry(i));
        }
        OCacheEntry leftBucketEntry = this.addPage(atomicOperation, this.fileId);
        OCacheEntry rightBucketEntry = this.addPage(atomicOperation, this.fileId);
        try {
            OSBTreeBucket<K, V> newLeftBucket = new OSBTreeBucket<K, V>(leftBucketEntry, splitLeaf, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
            newLeftBucket.addAll(leftEntries);
            if (splitLeaf) {
                newLeftBucket.setRightSibling(rightBucketEntry.getPageIndex());
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, leftBucketEntry);
        }
        try {
            OSBTreeBucket<K, V> newRightBucket = new OSBTreeBucket<K, V>(rightBucketEntry, splitLeaf, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
            newRightBucket.addAll(rightEntries);
            if (splitLeaf) {
                newRightBucket.setLeftSibling(leftBucketEntry.getPageIndex());
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rightBucketEntry);
        }
        bucketToSplit = new OSBTreeBucket<K, V>(bucketEntry, false, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
        bucketToSplit.setTreeSize(treeSize);
        bucketToSplit.setValuesFreeListFirstIndex(freeListPage);
        bucketToSplit.addEntry(0, new OSBTreeBucket.SBTreeEntry(leftBucketEntry.getPageIndex(), rightBucketEntry.getPageIndex(), separationKey, null), true);
        ArrayList<Long> resultPath = new ArrayList<Long>(path.subList(0, path.size() - 1));
        if (this.comparator.compare(keyToInsert, separationKey) < 0) {
            resultPath.add(leftBucketEntry.getPageIndex());
            return new BucketSearchResult(keyIndex, resultPath);
        }
        resultPath.add(rightBucketEntry.getPageIndex());
        if (splitLeaf) {
            return new BucketSearchResult(keyIndex - indexToSplit, resultPath);
        }
        return new BucketSearchResult(keyIndex - indexToSplit - 1, resultPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult findBucket(K key, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = 0L;
        ArrayList<Long> path = new ArrayList<Long>(8);
        while (true) {
            OSBTreeBucket.SBTreeEntry<K, V> entry;
            if (path.size() > MAX_PATH_LENGTH) {
                throw new OSBTreeException("We reached max level of depth of SBTree but still found nothing, seems like tree is in corrupted state. You should rebuild index related to given query.", this);
            }
            path.add(pageIndex);
            OCacheEntry bucketEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
            try {
                int insertionIndex;
                OSBTreeBucket<K, V> keyBucket = new OSBTreeBucket<K, V>(bucketEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.encryption);
                int index = keyBucket.find(key);
                if (keyBucket.isLeaf()) {
                    BucketSearchResult bucketSearchResult = new BucketSearchResult(index, path);
                    return bucketSearchResult;
                }
                entry = index >= 0 ? keyBucket.getEntry(index) : ((insertionIndex = -index - 1) >= keyBucket.size() ? keyBucket.getEntry(insertionIndex - 1) : keyBucket.getEntry(insertionIndex));
            }
            finally {
                this.releasePageFromRead(atomicOperation, bucketEntry);
            }
            if (this.comparator.compare(key, entry.key) >= 0) {
                pageIndex = entry.rightChild;
                continue;
            }
            pageIndex = entry.leftChild;
        }
    }

    private K enhanceCompositeKey(K key, PartialSearchMode partialSearchMode) {
        if (!(key instanceof OCompositeKey)) {
            return key;
        }
        OCompositeKey compositeKey = (OCompositeKey)key;
        if (this.keySize != 1 && compositeKey.getKeys().size() != this.keySize && !partialSearchMode.equals((Object)PartialSearchMode.NONE)) {
            OCompositeKey fullKey = new OCompositeKey(compositeKey);
            int itemsToAdd = this.keySize - fullKey.getKeys().size();
            Comparable<Comparable<?>> keyItem = partialSearchMode.equals((Object)PartialSearchMode.HIGHEST_BOUNDARY) ? ALWAYS_GREATER_KEY : ALWAYS_LESS_KEY;
            for (int i = 0; i < itemsToAdd; ++i) {
                fullKey.addKey(keyItem);
            }
            return (K)fullKey;
        }
        return key;
    }

    private V readValue(OSBTreeValue<V> sbTreeValue, OAtomicOperation atomicOperation) throws IOException {
        if (!sbTreeValue.isLink()) {
            return sbTreeValue.getValue();
        }
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, sbTreeValue.getLink(), false);
        OSBTreeValuePage valuePage = new OSBTreeValuePage(cacheEntry, false);
        int totalSize = valuePage.getSize();
        int currentSize = 0;
        byte[] value = new byte[totalSize];
        while (currentSize < totalSize) {
            currentSize = valuePage.readBinaryContent(value, currentSize);
            long nextPage = valuePage.getNextPage();
            if (nextPage < 0L) continue;
            this.releasePageFromRead(atomicOperation, cacheEntry);
            cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, nextPage, false);
            valuePage = new OSBTreeValuePage(cacheEntry, false);
        }
        this.releasePageFromRead(atomicOperation, cacheEntry);
        return this.valueSerializer.deserializeNativeObject(value, 0);
    }

    private Map.Entry<K, V> convertToMapEntry(OSBTreeBucket.SBTreeEntry<K, V> treeEntry, OAtomicOperation atomicOperation) throws IOException {
        final Object key = treeEntry.key;
        final Object value = this.readValue(treeEntry.value, atomicOperation);
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }

            @Override
            public V setValue(V value2) {
                throw new UnsupportedOperationException("setValue");
            }
        };
    }

    private final class OSBTreeCursorBackward
    implements OSBTreeCursor<K, V> {
        private final K fromKey;
        private K toKey;
        private final boolean fromKeyInclusive;
        private boolean toKeyInclusive;
        private final List<Map.Entry<K, V>> dataCache = new ArrayList();
        private Iterator<Map.Entry<K, V>> dataCacheIterator = OEmptyMapEntryIterator.INSTANCE;

        private OSBTreeCursorBackward(K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            if (toKey == null) {
                this.toKeyInclusive = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next(int prefetchSize) {
            if (this.dataCacheIterator == null) {
                return null;
            }
            if (this.dataCacheIterator.hasNext()) {
                Map.Entry entry = this.dataCacheIterator.next();
                this.toKey = entry.getKey();
                this.toKeyInclusive = false;
                return entry;
            }
            this.dataCache.clear();
            if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            }
            OSBTree.this.atomicOperationsManager.acquireReadLock(OSBTree.this);
            try {
                OSBTree.this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    BucketSearchResult bucketSearchResult = this.toKey != null ? OSBTree.this.findBucket(this.toKey, atomicOperation) : OSBTree.this.lastItem(atomicOperation);
                    if (bucketSearchResult == null) {
                        this.dataCacheIterator = null;
                        Map.Entry entry = null;
                        return entry;
                    }
                    long pageIndex = bucketSearchResult.getLastPathItem();
                    int itemIndex = bucketSearchResult.itemIndex >= 0 ? (this.toKeyInclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex - 1) : -bucketSearchResult.itemIndex - 2;
                    while (this.dataCache.size() < prefetchSize) {
                        if (pageIndex == -1L) {
                            break;
                        }
                        OCacheEntry cacheEntry = OSBTree.this.loadPageForRead(atomicOperation, OSBTree.this.fileId, pageIndex, false);
                        try {
                            OSBTreeBucket bucket = new OSBTreeBucket(cacheEntry, OSBTree.this.keySerializer, OSBTree.this.keyTypes, OSBTree.this.valueSerializer, OSBTree.this.encryption);
                            if (itemIndex >= bucket.size()) {
                                itemIndex = bucket.size() - 1;
                            }
                            if (itemIndex < 0) {
                                pageIndex = bucket.getLeftSibling();
                                itemIndex = Integer.MAX_VALUE;
                                continue;
                            }
                            Map.Entry entry = OSBTree.this.convertToMapEntry(bucket.getEntry(itemIndex), atomicOperation);
                            --itemIndex;
                            if (this.toKey != null && (!this.toKeyInclusive ? OSBTree.this.comparator.compare(entry.getKey(), this.toKey) >= 0 : OSBTree.this.comparator.compare(entry.getKey(), this.toKey) > 0)) continue;
                            if (this.fromKey == null || !(this.fromKeyInclusive ? OSBTree.this.comparator.compare(entry.getKey(), this.fromKey) < 0 : OSBTree.this.comparator.compare(entry.getKey(), this.fromKey) <= 0)) {
                                this.dataCache.add(entry);
                                continue;
                            }
                            break;
                        }
                        finally {
                            OSBTree.this.releasePageFromRead(atomicOperation, cacheEntry);
                        }
                    }
                }
                finally {
                    OSBTree.this.releaseSharedLock();
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new OSBTreeException("Error during element iteration", OSBTree.this), e);
            }
            finally {
                OSBTree.this.atomicOperationsManager.releaseReadLock(OSBTree.this);
            }
            if (this.dataCache.isEmpty()) {
                this.dataCacheIterator = null;
                return null;
            }
            this.dataCacheIterator = this.dataCache.iterator();
            Map.Entry entry = this.dataCacheIterator.next();
            this.toKey = entry.getKey();
            this.toKeyInclusive = false;
            return entry;
        }
    }

    private final class OSBTreeCursorForward
    implements OSBTreeCursor<K, V> {
        private K fromKey;
        private final K toKey;
        private boolean fromKeyInclusive;
        private final boolean toKeyInclusive;
        private final List<Map.Entry<K, V>> dataCache = new ArrayList();
        private Iterator<Map.Entry<K, V>> dataCacheIterator = OEmptyMapEntryIterator.INSTANCE;

        private OSBTreeCursorForward(K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            if (fromKey == null) {
                this.fromKeyInclusive = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next(int prefetchSize) {
            if (this.dataCacheIterator == null) {
                return null;
            }
            if (this.dataCacheIterator.hasNext()) {
                Map.Entry entry = this.dataCacheIterator.next();
                this.fromKey = entry.getKey();
                this.fromKeyInclusive = false;
                return entry;
            }
            this.dataCache.clear();
            if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            }
            if (prefetchSize == 0) {
                prefetchSize = 1;
            }
            OSBTree.this.atomicOperationsManager.acquireReadLock(OSBTree.this);
            try {
                OSBTree.this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    BucketSearchResult bucketSearchResult = this.fromKey != null ? OSBTree.this.findBucket(this.fromKey, atomicOperation) : OSBTree.this.firstItem(atomicOperation);
                    if (bucketSearchResult == null) {
                        this.dataCacheIterator = null;
                        Map.Entry entry = null;
                        return entry;
                    }
                    long pageIndex = bucketSearchResult.getLastPathItem();
                    int itemIndex = bucketSearchResult.itemIndex >= 0 ? (this.fromKeyInclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex + 1) : -bucketSearchResult.itemIndex - 1;
                    while (this.dataCache.size() < prefetchSize) {
                        if (pageIndex == -1L) {
                            break;
                        }
                        OCacheEntry cacheEntry = OSBTree.this.loadPageForRead(atomicOperation, OSBTree.this.fileId, pageIndex, false);
                        try {
                            OSBTreeBucket bucket = new OSBTreeBucket(cacheEntry, OSBTree.this.keySerializer, OSBTree.this.keyTypes, OSBTree.this.valueSerializer, OSBTree.this.encryption);
                            if (itemIndex >= bucket.size()) {
                                pageIndex = bucket.getRightSibling();
                                itemIndex = 0;
                                continue;
                            }
                            Map.Entry entry = OSBTree.this.convertToMapEntry(bucket.getEntry(itemIndex), atomicOperation);
                            ++itemIndex;
                            if (this.fromKey != null && (!this.fromKeyInclusive ? OSBTree.this.comparator.compare(entry.getKey(), this.fromKey) <= 0 : OSBTree.this.comparator.compare(entry.getKey(), this.fromKey) < 0)) continue;
                            if (this.toKey == null || !(this.toKeyInclusive ? OSBTree.this.comparator.compare(entry.getKey(), this.toKey) > 0 : OSBTree.this.comparator.compare(entry.getKey(), this.toKey) >= 0)) {
                                this.dataCache.add(entry);
                                continue;
                            }
                            break;
                        }
                        finally {
                            OSBTree.this.releasePageFromRead(atomicOperation, cacheEntry);
                        }
                    }
                }
                finally {
                    OSBTree.this.releaseSharedLock();
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new OSBTreeException("Error during element iteration", OSBTree.this), e);
            }
            finally {
                OSBTree.this.atomicOperationsManager.releaseReadLock(OSBTree.this);
            }
            if (this.dataCache.isEmpty()) {
                this.dataCacheIterator = null;
                return null;
            }
            this.dataCacheIterator = this.dataCache.iterator();
            Map.Entry entry = this.dataCacheIterator.next();
            this.fromKey = entry.getKey();
            this.fromKeyInclusive = false;
            return entry;
        }
    }

    public class OSBTreeFullKeyCursor
    implements OSBTreeKeyCursor<K> {
        private long pageIndex;
        private int itemIndex;
        private List<K> keysCache = new ArrayList();
        private Iterator<K> keysIterator = new OEmptyIterator();

        OSBTreeFullKeyCursor(long startPageIndex) {
            this.pageIndex = startPageIndex;
            this.itemIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K next(int prefetchSize) {
            if (this.keysIterator == null) {
                return null;
            }
            if (this.keysIterator.hasNext()) {
                return this.keysIterator.next();
            }
            this.keysCache.clear();
            if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            }
            if (prefetchSize == 0) {
                prefetchSize = 1;
            }
            OSBTree.this.atomicOperationsManager.acquireReadLock(OSBTree.this);
            try {
                OSBTree.this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    while (this.keysCache.size() < prefetchSize) {
                        if (this.pageIndex == -1L) {
                            break;
                        }
                        if (this.pageIndex >= OSBTree.this.getFilledUpTo(atomicOperation, OSBTree.this.fileId)) {
                            this.pageIndex = -1L;
                            break;
                        }
                        OCacheEntry cacheEntry = OSBTree.this.loadPageForRead(atomicOperation, OSBTree.this.fileId, this.pageIndex, false);
                        try {
                            OSBTreeBucket bucket = new OSBTreeBucket(cacheEntry, OSBTree.this.keySerializer, OSBTree.this.keyTypes, OSBTree.this.valueSerializer, OSBTree.this.encryption);
                            if (this.itemIndex >= bucket.size()) {
                                this.pageIndex = bucket.getRightSibling();
                                this.itemIndex = 0;
                                continue;
                            }
                            Map.Entry entry = OSBTree.this.convertToMapEntry(bucket.getEntry(this.itemIndex), atomicOperation);
                            ++this.itemIndex;
                            this.keysCache.add(entry.getKey());
                        }
                        finally {
                            OSBTree.this.releasePageFromRead(atomicOperation, cacheEntry);
                        }
                    }
                }
                finally {
                    OSBTree.this.releaseSharedLock();
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new OSBTreeException("Error during element iteration", OSBTree.this), e);
            }
            finally {
                OSBTree.this.atomicOperationsManager.releaseReadLock(OSBTree.this);
            }
            if (this.keysCache.isEmpty()) {
                this.keysCache = null;
                return null;
            }
            this.keysIterator = this.keysCache.iterator();
            return this.keysIterator.next();
        }
    }

    private static final class PagePathItemUnit {
        private final long pageIndex;
        private final int itemIndex;

        private PagePathItemUnit(long pageIndex, int itemIndex) {
            this.pageIndex = pageIndex;
            this.itemIndex = itemIndex;
        }
    }

    private static class BucketSearchResult {
        private final int itemIndex;
        private final ArrayList<Long> path;

        private BucketSearchResult(int itemIndex, ArrayList<Long> path) {
            this.itemIndex = itemIndex;
            this.path = path;
        }

        long getLastPathItem() {
            return this.path.get(this.path.size() - 1);
        }

        static /* synthetic */ ArrayList access$100(BucketSearchResult x0) {
            return x0.path;
        }
    }

    public static interface OSBTreeKeyCursor<K> {
        public K next(int var1);
    }

    public static interface OSBTreeCursor<K, V> {
        public Map.Entry<K, V> next(int var1);
    }

    private static enum PartialSearchMode {
        NONE,
        HIGHEST_BOUNDARY,
        LOWEST_BOUNDARY;

    }
}

