/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.config;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class OServerConfigurationLoaderXml {
    private Class<? extends OServerConfiguration> rootClass;
    private JAXBContext context;
    private InputStream inputStream;
    private File file;
    private long fileLastModified = -1L;

    public OServerConfigurationLoaderXml(Class<? extends OServerConfiguration> iRootClass, InputStream iInputStream) {
        this.rootClass = iRootClass;
        this.inputStream = iInputStream;
    }

    public OServerConfigurationLoaderXml(Class<? extends OServerConfiguration> iRootClass, File iFile) {
        this.rootClass = iRootClass;
        this.file = iFile;
    }

    public OServerConfiguration load() throws IOException {
        try {
            OServerConfiguration obj;
            if (this.file != null) {
                String current;
                this.fileLastModified = this.file.lastModified();
                String path = OFileUtils.getPath(this.file.getAbsolutePath());
                if (path.startsWith(current = OFileUtils.getPath(new File("").getAbsolutePath()))) {
                    path = path.substring(current.length() + 1);
                }
                OLogManager.instance().info((Object)this, "Loading configuration from: %s...", path);
            } else {
                OLogManager.instance().info((Object)this, "Loading configuration from input stream", new Object[0]);
            }
            this.context = JAXBContext.newInstance(this.rootClass);
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            unmarshaller.setSchema(null);
            if (this.file != null) {
                if (!this.file.exists()) {
                    OLogManager.instance().error(this, "Server configuration file not found: %s", null, this.file);
                    return this.rootClass.getConstructor(OServerConfigurationLoaderXml.class).newInstance(this);
                }
                obj = this.rootClass.cast(unmarshaller.unmarshal(this.file));
                obj.location = this.file.getAbsolutePath();
            } else {
                obj = this.rootClass.cast(unmarshaller.unmarshal(this.inputStream));
                obj.location = "memory";
            }
            if (obj.properties != null) {
                for (OServerEntryConfiguration prop : obj.properties) {
                    try {
                        OGlobalConfiguration config = OGlobalConfiguration.findByKey(prop.name);
                        if (config == null) continue;
                        config.setValue(prop.value);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            return obj;
        }
        catch (Exception e) {
            OLogManager.instance().error(this, "Invalid syntax. Below an example of how it should be:", e, new Object[0]);
            try {
                this.context = JAXBContext.newInstance(this.rootClass);
                Marshaller marshaller = this.context.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                OServerConfiguration example = this.rootClass.getConstructor(OServerConfigurationLoaderXml.class).newInstance(this);
                marshaller.marshal((Object)example, System.out);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException(e);
        }
    }

    public void save(OServerConfiguration iRootObject) throws IOException {
        if (this.file != null) {
            try {
                this.context = JAXBContext.newInstance(this.rootClass);
                Marshaller marshaller = this.context.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                marshaller.marshal((Object)iRootObject, new FileWriter(this.file));
                this.fileLastModified = this.file.lastModified();
            }
            catch (JAXBException e) {
                throw new IOException(e);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean checkForAutoReloading() {
        if (this.file != null) {
            return this.file.lastModified() > this.fileLastModified;
        }
        return false;
    }
}

