/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.common.util.OPatternConst;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.io.IOException;
import java.util.Date;

public class OServerCommandGetFileDownload
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|fileDownload/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String fileName;
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: fileDownload/<database>/rid/[/<fileName>][/<fileType>].");
        String string = fileName = urlParts.length > 3 ? this.encodeResponseText(urlParts[3]) : "unknown";
        String fileType = urlParts.length > 5 ? this.encodeResponseText(urlParts[4]) + '/' + this.encodeResponseText(urlParts[5]) : (urlParts.length > 4 ? this.encodeResponseText(urlParts[4]) : "");
        String rid = urlParts[2];
        iRequest.data.commandInfo = "Download";
        iRequest.data.commandDetail = rid;
        try (ODatabaseDocumentInternal db = this.getProfiledDatabaseInstance(iRequest);){
            ORecordAbstract response = (ORecordAbstract)db.load(new ORecordId(rid));
            if (response != null) {
                if (response instanceof OBlob) {
                    this.sendORecordBinaryFileContent(iRequest, iResponse, 200, "OK", fileType, (OBlob)((Object)response), fileName);
                } else if (response instanceof ODocument) {
                    for (OProperty prop : ODocumentInternal.getImmutableSchemaClass((ODocument)response).properties()) {
                        if (!prop.getType().equals((Object)OType.BINARY)) continue;
                        this.sendBinaryFieldFileContent(iRequest, iResponse, 200, "OK", fileType, (byte[])((ODocument)response).field(prop.getName()), fileName);
                    }
                } else {
                    iResponse.send(405, "Record requested is not a file nor has a readable schema", "text/plain", "Record requested is not a file nor has a readable schema", null);
                }
            } else {
                iResponse.send(405, "Record requested not exists", "text/plain", "Record requestes not exists", null);
            }
        }
        return false;
    }

    protected void sendORecordBinaryFileContent(OHttpRequest iRequest, OHttpResponse iResponse, int iCode, String iReason, String iContentType, OBlob record, String iFileName) throws IOException {
        iResponse.writeStatus(iCode, iReason);
        iResponse.writeHeaders(iContentType);
        iResponse.writeLine("Content-Disposition: attachment; filename=" + iFileName);
        iResponse.writeLine("Date: " + new Date());
        iResponse.writeLine("Content-Length: " + record.getSize());
        iResponse.writeLine(null);
        record.toOutputStream(iResponse.getOutputStream());
        iResponse.flush();
    }

    protected void sendBinaryFieldFileContent(OHttpRequest iRequest, OHttpResponse iResponse, int iCode, String iReason, String iContentType, byte[] record, String iFileName) throws IOException {
        iResponse.writeStatus(iCode, iReason);
        iResponse.writeHeaders(iContentType);
        iResponse.writeLine("Content-Disposition: attachment; filename=" + iFileName);
        iResponse.writeLine("Date: " + new Date());
        iResponse.writeLine("Content-Length: " + record.length);
        iResponse.writeLine(null);
        iResponse.getOutputStream().write(record);
        iResponse.flush();
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    private String encodeResponseText(String iText) {
        iText = OPatternConst.PATTERN_SINGLE_SPACE.matcher(iText).replaceAll("%20");
        iText = OPatternConst.PATTERN_AMP.matcher(iText).replaceAll("%26");
        return iText;
    }
}

