/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.patch;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;

public class OServerCommandPatchDocument
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"PATCH|document/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 2, "Syntax error: document/<database>[/<record-id>]");
        iRequest.data.commandInfo = "Edit Document";
        try (ODatabaseDocumentInternal db = null;){
            ORecordId recordId;
            db = this.getProfiledDatabaseInstance(iRequest);
            if (urlParts.length > 2) {
                int parametersPos = urlParts[2].indexOf(63);
                String rid = parametersPos > -1 ? urlParts[2].substring(0, parametersPos) : urlParts[2];
                recordId = new ORecordId(rid);
                if (!recordId.isValid()) {
                    throw new IllegalArgumentException("Invalid Record ID in request: " + recordId);
                }
            } else {
                recordId = new ORecordId();
            }
            ODocument doc = new ODocument();
            doc.fromJSON(iRequest.content);
            if (iRequest.ifMatch != null) {
                ORecordInternal.setVersion(doc, Integer.parseInt(iRequest.ifMatch));
            }
            if (!recordId.isValid()) {
                recordId = (ORecordId)doc.getIdentity();
            } else {
                ORecordInternal.setIdentity(doc, recordId);
            }
            if (!recordId.isValid()) {
                throw new IllegalArgumentException("Invalid Record ID in request: " + recordId);
            }
            ODocument currentDocument = (ODocument)db.load(recordId);
            if (currentDocument == null) {
                iResponse.send(404, "Not Found", "text/plain", "Record " + recordId + " was not found.", null);
                boolean rid = false;
                return rid;
            }
            boolean partialUpdateMode = true;
            currentDocument.merge(doc, partialUpdateMode, false);
            ORecordInternal.setVersion(currentDocument, doc.getVersion());
            currentDocument.save();
            iResponse.send(200, "OK", "text/plain", currentDocument.toJSON(), "ETag: " + doc.getVersion());
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

