/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.data.com.google.common.collect;

import com.arcadeanalytics.data.com.google.common.annotations.GwtCompatible;
import com.arcadeanalytics.data.com.google.common.collect.UnmodifiableIterator;
import com.arcadeanalytics.data.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.NoSuchElementException;

@GwtCompatible
public abstract class AbstractSequentialIterator<T>
extends UnmodifiableIterator<T> {
    private @Nullable T nextOrNull;

    protected AbstractSequentialIterator(@Nullable T firstOrNull) {
        this.nextOrNull = firstOrNull;
    }

    protected abstract @Nullable T computeNext(T var1);

    @Override
    public final boolean hasNext() {
        return this.nextOrNull != null;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            T t = this.nextOrNull;
            return t;
        }
        finally {
            this.nextOrNull = this.computeNext(this.nextOrNull);
        }
    }
}

